(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   1061297,      18336]
NotebookOptionsPosition[   1059089,      18270]
NotebookOutlinePosition[   1059681,      18291]
CellTagsIndexPosition[   1059638,      18288]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["", "Text",
 CellChangeTimes->{{3.8505675482933645`*^9, 3.8505675511099663`*^9}}],

Cell["", "Text",
 CellChangeTimes->{{3.8505674817413397`*^9, 3.850567491054656*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"N0", "=", 
   RowBox[{"10", "^", "3"}]}], ";", 
  RowBox[{"EV", "=", "0"}], ";", 
  RowBox[{"kT", "=", "0.026"}], ";", 
  RowBox[{"Rs", "=", "0.1"}], ";", 
  RowBox[{"L", "=", 
   RowBox[{"10", "^", 
    RowBox[{"-", "5"}]}]}], ";", 
  RowBox[{"f", "=", "0.5"}], ";", " ", 
  RowBox[{"\[Theta]", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Tau]e", "=", "0.5"}], ";", 
  RowBox[{"\[Tau]d", "=", "0.1"}], ";", " ", 
  RowBox[{"uv0", "=", 
   RowBox[{"-", "0.1"}]}], ";", 
  RowBox[{"uv1", "=", 
   RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Aeq", "[", "u_", "]"}], ":=", 
  RowBox[{
   RowBox[{"2", "/", "3"}], "N0", " ", 
   RowBox[{"Abs", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
     RowBox[{"3", "/", "2"}]], "  ", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cmu", "[", "u_", "]"}], ":=", 
  RowBox[{
   RowBox[{"N0", " ", "/", "kT"}], " ", 
   RowBox[{"Abs", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
     RowBox[{"1", "/", "2"}]], "  ", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Idc", "[", "u_", "]"}], ":=", 
   RowBox[{
    RowBox[{"-", "\[Theta]"}], " ", 
    RowBox[{"L", "/", "\[Tau]e"}], " ", 
    RowBox[{"(", 
     RowBox[{"Aeq", "[", "u", "]"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Idc", "[", 
  RowBox[{"-", "1"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Aeq", "[", 
    RowBox[{"-", "1"}], "]"}], "/", "N0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"io1", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"uv", ",", 
       RowBox[{"Idc", "[", "uv", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"uv", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "10000"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\(u\), \(g\)]\) (V)\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(d\)]\) (\[Mu]A)\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
        ",", "\"\<\>\""}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "0.5"}], ",", "0", ",", "0.5", ",", "1", ",", "2", ",",
           "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", 
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], "}"}],
         ",", "None", ",", "None"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Gray"}], "}"}], 
       "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"io1", ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "uv1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"BaseStyle", "->", 
     RowBox[{"{", 
      RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"io2", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"uv", ",", 
        RowBox[{
         RowBox[{"Aeq", "[", "uv", "]"}], "/", "100000"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"uv", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "10"}], ",", "10000"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SubscriptBox[\(u\), \(g\)]\) (V)\>\"", ",", 
           RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SuperscriptBox[\(10\), \(-6\)]\) Z\>\"", ",", 
           RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
         ",", "\"\<\>\""}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "0.5"}], ",", "0", ",", "0.5", ",", "1", ",", "2", 
           ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4"}], ",", 
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
          "}"}], ",", "None", ",", "None"}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Magenta"}], 
         "}"}], "}"}]}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"io2", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "uv1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "->", 
    RowBox[{"{", 
     RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8390646611298313`*^9, 3.839064663549252*^9}, {
   3.8390651628201227`*^9, 3.8390651698744855`*^9}, {3.8390671245340233`*^9, 
   3.839067253968177*^9}, {3.8390672908692884`*^9, 3.8390673435588245`*^9}, {
   3.839067444277615*^9, 3.8390674530816755`*^9}, {3.839067483223913*^9, 
   3.8390676448632746`*^9}, {3.839067792030848*^9, 3.8390679296503277`*^9}, {
   3.839068035965031*^9, 3.8390681198292847`*^9}, {3.8390709139116144`*^9, 
   3.8390709421089935`*^9}, {3.83907099038449*^9, 3.8390709930117693`*^9}, {
   3.839071053413534*^9, 3.839071065617492*^9}, {3.839071142245447*^9, 
   3.8390712315177836`*^9}, {3.839071262559967*^9, 3.8390713000871944`*^9}, {
   3.8390714971122246`*^9, 3.839071517359198*^9}, {3.8390715485300074`*^9, 
   3.8390716200472517`*^9}, {3.8390716672806673`*^9, 3.839071782347397*^9}, {
   3.839071837937226*^9, 3.839071939311781*^9}, {3.839072168081314*^9, 
   3.839072168581891*^9}, {3.8390723168444653`*^9, 3.8390724465495067`*^9}, {
   3.8390724871236815`*^9, 3.839072628537404*^9}, {3.8390726857581015`*^9, 
   3.83907270608572*^9}, {3.8390728526632924`*^9, 3.8390730714112225`*^9}, {
   3.839082271666379*^9, 3.8390823055073657`*^9}, {3.839082353119522*^9, 
   3.839082449840514*^9}, {3.8390839765348864`*^9, 3.839084057466158*^9}, {
   3.8390840878065057`*^9, 3.8390841778809776`*^9}, {3.8390842363292522`*^9, 
   3.8390842982497163`*^9}, 3.83908433029414*^9, {3.8390843708346243`*^9, 
   3.8390844315092807`*^9}, 3.839084462612833*^9, {3.8390845298830824`*^9, 
   3.839084537171591*^9}, {3.8390846234607463`*^9, 3.839084639769829*^9}, {
   3.839085385972989*^9, 3.8390853976007433`*^9}, {3.8390854555897675`*^9, 
   3.839085524444199*^9}, {3.839085565738154*^9, 3.8390855920819826`*^9}, {
   3.8390863447286386`*^9, 3.839086474045252*^9}, {3.839086860852067*^9, 
   3.839086874816577*^9}, {3.839087637034748*^9, 3.8390876843714943`*^9}, 
   3.83908780285631*^9, 3.8390878367914057`*^9, {3.839088015231053*^9, 
   3.8390880802460375`*^9}, {3.839088241208177*^9, 3.839088251058446*^9}, 
   3.839088396382834*^9, 3.8391182307918463`*^9, {3.839118379381566*^9, 
   3.8391183868618546`*^9}, {3.839118542781612*^9, 3.839118576690755*^9}, {
   3.839119230679368*^9, 3.8391192435152392`*^9}, {3.8391193005384474`*^9, 
   3.839119322077612*^9}, {3.8391197370496492`*^9, 3.839119744561663*^9}, {
   3.839119780647091*^9, 3.8391198576053133`*^9}, {3.83913747847266*^9, 
   3.839137485481214*^9}, {3.8391375587687283`*^9, 3.8391375797199593`*^9}, {
   3.8391376276780567`*^9, 3.8391376620779104`*^9}, {3.83913835785732*^9, 
   3.839138374216883*^9}, 3.8391384110040264`*^9, {3.8391384624942074`*^9, 
   3.839138462879356*^9}, {3.8391385170099597`*^9, 3.839138536349577*^9}, {
   3.839139183554804*^9, 3.8391391930138044`*^9}, {3.8391393033973885`*^9, 
   3.8391393043613095`*^9}, 3.839139359067504*^9, 3.839139436240513*^9, {
   3.8392078031308994`*^9, 3.8392078143543434`*^9}, {3.8392078889566584`*^9, 
   3.83920790820275*^9}, {3.839208054761527*^9, 3.839208093399903*^9}, {
   3.8392084092575808`*^9, 3.8392084620514746`*^9}, 3.839208533536579*^9, {
   3.8392086070037084`*^9, 3.8392086083290124`*^9}, 3.8392086479255266`*^9, {
   3.8392225965883913`*^9, 3.8392226283136573`*^9}, {3.8392226646362276`*^9, 
   3.8392227421040397`*^9}, 3.8392227767756677`*^9, {3.8392228326927814`*^9, 
   3.839222892911393*^9}, 3.8392230743763013`*^9, {3.839223141092394*^9, 
   3.839223141783134*^9}, 3.839223177642132*^9, {3.8392232273840017`*^9, 
   3.8392232854596047`*^9}, {3.8392233573873816`*^9, 3.839223398790718*^9}, {
   3.8392234505961695`*^9, 3.839223507183962*^9}, {3.839223811017748*^9, 
   3.8392239510950837`*^9}, {3.8392240167007127`*^9, 3.839224025275307*^9}, {
   3.8392241057509785`*^9, 3.839224157437503*^9}, {3.839224200897134*^9, 
   3.8392242487597456`*^9}, {3.839224294917468*^9, 3.839224296013791*^9}, {
   3.8392243639841394`*^9, 3.8392243950383773`*^9}, 3.839224442185709*^9, {
   3.8392245129185476`*^9, 3.8392245373577056`*^9}, {3.8392245776385975`*^9, 
   3.839224740679908*^9}, {3.8392248367057567`*^9, 3.839224838004247*^9}, {
   3.8392249023255987`*^9, 3.8392249329681873`*^9}, 3.8392250078513308`*^9, {
   3.8392250461420965`*^9, 3.8392250567765236`*^9}, {3.8392250892690206`*^9, 
   3.839225128234888*^9}, {3.839225292837965*^9, 3.8392253052980237`*^9}, {
   3.839225374465659*^9, 3.839225378163327*^9}, {3.8392366608564453`*^9, 
   3.839236691352835*^9}, {3.839236736346908*^9, 3.8392367461057377`*^9}, {
   3.8392368452896976`*^9, 3.8392369245276327`*^9}, {3.8392369586763678`*^9, 
   3.839236989556669*^9}, {3.8392370210310707`*^9, 3.839237025639107*^9}, {
   3.8392370611832547`*^9, 3.839237143422812*^9}, {3.839237229917989*^9, 
   3.839237306453603*^9}, {3.8392373387206373`*^9, 3.839237342820054*^9}, {
   3.839237447098841*^9, 3.8392375543643665`*^9}, {3.8392411494009237`*^9, 
   3.839241171431179*^9}, {3.83924120627816*^9, 3.8392412247291117`*^9}, 
   3.8392412792201967`*^9, 3.8392413874247665`*^9, {3.8392415172512045`*^9, 
   3.8392415791894693`*^9}, {3.839241632182249*^9, 3.8392416472548246`*^9}, 
   3.8392418101230965`*^9, {3.839242047805271*^9, 3.8392420951804295`*^9}, {
   3.8392421670049934`*^9, 3.8392422247577305`*^9}, {3.8392422574679546`*^9, 
   3.8392422587095203`*^9}, {3.839242291908*^9, 3.8392425704347763`*^9}, {
   3.8392426617662134`*^9, 3.8392426717163734`*^9}, 3.839242785862258*^9, {
   3.839246817917405*^9, 3.8392468269690895`*^9}, {3.839246889891876*^9, 
   3.839246924816616*^9}, {3.839309996677757*^9, 3.839310018708186*^9}, {
   3.839310845764266*^9, 3.839310880859878*^9}, {3.839310926113166*^9, 
   3.839310949193386*^9}, {3.8393110019361973`*^9, 3.8393110308399534`*^9}, {
   3.8393270934512377`*^9, 3.839327332415727*^9}, {3.839327370226597*^9, 
   3.839327451303669*^9}, {3.8393275031436253`*^9, 3.8393275194960613`*^9}, {
   3.839327586008069*^9, 3.8393276948310633`*^9}, {3.8393278034898295`*^9, 
   3.8393278068680096`*^9}, {3.8393278450424776`*^9, 
   3.8393278797618237`*^9}, {3.8393289610021143`*^9, 3.839328976754302*^9}, {
   3.8393294967878103`*^9, 3.839329617607455*^9}, 3.8393297021511583`*^9, {
   3.839329736764967*^9, 3.83932973839811*^9}, {3.839329841358012*^9, 
   3.839329850076448*^9}, {3.8393298856244183`*^9, 3.83932990739045*^9}, {
   3.839330200791801*^9, 3.839330209464896*^9}, 3.83933026862875*^9, {
   3.8393304947792683`*^9, 3.839330614321838*^9}, {3.839330707456501*^9, 
   3.8393307223587484`*^9}, {3.8393307586469154`*^9, 3.839330774655125*^9}, {
   3.8393308208469334`*^9, 3.8393308254369345`*^9}, {3.83933092079788*^9, 
   3.8393310148602314`*^9}, {3.8393311745075006`*^9, 
   3.8393311994275675`*^9}, {3.8393312620131807`*^9, 
   3.8393312886598005`*^9}, {3.83933158528376*^9, 3.8393316720258255`*^9}, 
   3.8393317188850336`*^9, {3.8393317973728094`*^9, 3.8393319397094903`*^9}, 
   3.8393320294844685`*^9, {3.8393325727147913`*^9, 3.8393326007437224`*^9}, {
   3.839332643937569*^9, 3.8393326886712303`*^9}, {3.839332884251463*^9, 
   3.8393328849388123`*^9}, {3.8393329498885293`*^9, 3.839332954368989*^9}, 
   3.839332984548478*^9, {3.839333161836732*^9, 3.839333179429063*^9}, {
   3.839333212168277*^9, 3.8393332158859396`*^9}, {3.839333299885914*^9, 
   3.839333320058819*^9}, {3.8393333662749724`*^9, 3.839333389618166*^9}, 
   3.8393335815372777`*^9, {3.8393336646381135`*^9, 3.839333690640252*^9}, {
   3.839333816187891*^9, 3.839333852596138*^9}, {3.839333913143673*^9, 
   3.839333960953573*^9}, {3.8393340547869487`*^9, 3.839334137419753*^9}, {
   3.839420765475212*^9, 3.839420767706482*^9}, {3.839420800720344*^9, 
   3.83942080814257*^9}, {3.839420930166752*^9, 3.839420954611184*^9}, 
   3.839421093306271*^9, {3.839421249787591*^9, 3.8394213460868835`*^9}, {
   3.839421400152422*^9, 3.8394214417353144`*^9}, {3.839421483648677*^9, 
   3.839421580608614*^9}, 3.839421616079374*^9, 3.839422181142932*^9, {
   3.8394224472930202`*^9, 3.839422448371497*^9}, {3.8394225405886507`*^9, 
   3.839422541885687*^9}, {3.8394225839963813`*^9, 3.83942258751882*^9}, 
   3.8394239784679832`*^9, {3.8394240190394516`*^9, 3.8394240194005165`*^9}, {
   3.839481241680246*^9, 3.8394812636526537`*^9}, {3.8394813033197775`*^9, 
   3.839481343020226*^9}, {3.8394813886318493`*^9, 3.83948138904453*^9}, {
   3.8394814470082235`*^9, 3.8394815138762083`*^9}, {3.839484145142799*^9, 
   3.8394841575703464`*^9}, {3.8394842427712455`*^9, 
   3.8394842456191454`*^9}, {3.8394844396674995`*^9, 
   3.8394844660440836`*^9}, {3.8394845806487627`*^9, 3.83948460808449*^9}, {
   3.8394847191879005`*^9, 3.839484719920673*^9}, {3.8394847985864277`*^9, 
   3.8394847999498053`*^9}, {3.839485522225484*^9, 3.8394858614478054`*^9}, {
   3.8394858968609977`*^9, 3.8394858979280567`*^9}, {3.83950394022218*^9, 
   3.839504016595684*^9}, {3.839504079022719*^9, 3.8395041716366367`*^9}, {
   3.8395042475063295`*^9, 3.83950424807436*^9}, {3.8395043044033585`*^9, 
   3.8395043325148754`*^9}, {3.839504403912784*^9, 3.839504405955762*^9}, {
   3.839504461254238*^9, 3.8395044954062967`*^9}, {3.839504572085556*^9, 
   3.8395046258331623`*^9}, {3.839504718095887*^9, 3.839504733043982*^9}, {
   3.839504792704324*^9, 3.8395048214714227`*^9}, {3.8395048602645364`*^9, 
   3.839504871422516*^9}, {3.83950521161292*^9, 3.8395052235501237`*^9}, {
   3.839505255990897*^9, 3.8395052773582516`*^9}, {3.839505321851119*^9, 
   3.839505332451271*^9}, {3.8395054257374*^9, 3.8395054385582395`*^9}, 
   3.839505580972617*^9, {3.8395057025144815`*^9, 3.8395057031788645`*^9}, {
   3.8395057369934807`*^9, 3.8395057373979363`*^9}, {3.839505772294227*^9, 
   3.839505778367197*^9}, {3.83950673092721*^9, 3.8395067795192204`*^9}, {
   3.8395084122279215`*^9, 3.8395084138977666`*^9}, {3.839508448233049*^9, 
   3.8395084493422976`*^9}, {3.839508499051385*^9, 3.8395085344200335`*^9}, 
   3.8395086207285233`*^9, {3.8395086973952723`*^9, 3.8395086978689127`*^9}, {
   3.8395089696790757`*^9, 3.839509039224576*^9}, {3.8395100524490423`*^9, 
   3.839510053723009*^9}, {3.839511493807127*^9, 3.8395115089839754`*^9}, {
   3.8395115931589155`*^9, 3.839511633911852*^9}, {3.839511664551564*^9, 
   3.8395117021779413`*^9}, {3.839511738662855*^9, 3.8395117683886237`*^9}, {
   3.8395840465025244`*^9, 3.8395840478719764`*^9}, {3.8395842326636224`*^9, 
   3.8395842405526743`*^9}, {3.8395844072352886`*^9, 3.839584438590257*^9}, {
   3.839584539157859*^9, 3.839584558647271*^9}, {3.8395846133789663`*^9, 
   3.83958465811094*^9}, {3.839584785836444*^9, 3.839584807986281*^9}, 
   3.839586726652771*^9, {3.8395867995416994`*^9, 3.8395868420413933`*^9}, 
   3.83958688638865*^9, {3.839587244941451*^9, 3.83958726487414*^9}, {
   3.83958774293878*^9, 3.8395877838602095`*^9}, 3.839587828597546*^9, {
   3.839587879706158*^9, 3.8395879135449758`*^9}, {3.839587955043039*^9, 
   3.8395879642045746`*^9}, {3.8395880048781385`*^9, 3.839588051406326*^9}, {
   3.8395880883490973`*^9, 3.8395881594520197`*^9}, {3.8395882347911615`*^9, 
   3.8395883226336384`*^9}, 3.8395883559509153`*^9, 3.839588415451826*^9, {
   3.8395884902783833`*^9, 3.8395885216082554`*^9}, {3.8395941073926105`*^9, 
   3.8395942227438965`*^9}, 3.839595304916483*^9, {3.8395954862576475`*^9, 
   3.83959557521957*^9}, {3.839595607221432*^9, 3.8395956076140194`*^9}, {
   3.839595660820343*^9, 3.839595661835729*^9}, {3.839604650775865*^9, 
   3.8396046640054827`*^9}, {3.839604708532463*^9, 3.8396047629301977`*^9}, {
   3.839604795558606*^9, 3.839604808947177*^9}, {3.839604852056878*^9, 
   3.8396048690185547`*^9}, {3.839642088079403*^9, 3.839642141004441*^9}, {
   3.8396422800918975`*^9, 3.8396423077286944`*^9}, {3.8396424143783884`*^9, 
   3.8396424152236857`*^9}, {3.8396426095904264`*^9, 
   3.8396426100591545`*^9}, {3.8396426843268356`*^9, 3.8396426912164164`*^9}, 
   3.8396427676568155`*^9, {3.8396428549330425`*^9, 3.8396429650459213`*^9}, 
   3.839643049962629*^9, {3.839643091872772*^9, 3.8396431410841303`*^9}, 
   3.839643491656567*^9, {3.839643550041149*^9, 3.839643610060313*^9}, {
   3.8396436783391447`*^9, 3.8396437059963512`*^9}, {3.8396437389632745`*^9, 
   3.8396437448257093`*^9}, {3.839643793497415*^9, 3.8396438275668716`*^9}, {
   3.839643978745996*^9, 3.8396439798436737`*^9}, {3.839644021519642*^9, 
   3.8396440428152156`*^9}, {3.8396441695399504`*^9, 
   3.8396441971715937`*^9}, {3.839644230142295*^9, 3.8396442469945946`*^9}, {
   3.839644284692358*^9, 3.8396442961501245`*^9}, {3.8396443434969287`*^9, 
   3.8396443583914576`*^9}, {3.8396448346105194`*^9, 3.839644913123821*^9}, {
   3.8396555898716025`*^9, 3.839655650012109*^9}, {3.8396556822310605`*^9, 
   3.839655771771843*^9}, {3.839655952479162*^9, 3.8396559541084647`*^9}, 
   3.839656003389371*^9, {3.8396560347174463`*^9, 3.839656116850046*^9}, {
   3.8396562422855325`*^9, 3.8396562713341274`*^9}, 3.8396563271846943`*^9, {
   3.8396565529884825`*^9, 3.839656667985509*^9}, {3.8396568526250334`*^9, 
   3.839656873162519*^9}, {3.8396570321068354`*^9, 3.8396570367161813`*^9}, {
   3.8396571621919303`*^9, 3.839657193340761*^9}, {3.839657225174745*^9, 
   3.8396572442512493`*^9}, {3.8396572932236905`*^9, 3.8396572940165*^9}, 
   3.8396574072631903`*^9, {3.8396575476060143`*^9, 3.8396575682943974`*^9}, {
   3.839664138921971*^9, 3.839664156869915*^9}, 3.839664243007531*^9, {
   3.839669622125418*^9, 3.839669647884663*^9}, {3.839670002387182*^9, 
   3.839670025487237*^9}, {3.8396700586539392`*^9, 3.8396701085420904`*^9}, {
   3.8396766028729286`*^9, 3.839676603372811*^9}, {3.839676649783103*^9, 
   3.8396766681979322`*^9}, {3.839723206211033*^9, 3.839723252419324*^9}, {
   3.8397243192805915`*^9, 3.8397243622670403`*^9}, {3.839724526690404*^9, 
   3.8397245565593586`*^9}, 3.839724591814554*^9, {3.8397246526353917`*^9, 
   3.8397246677187424`*^9}, {3.839724698665658*^9, 3.8397248461537275`*^9}, {
   3.839724910156172*^9, 3.839724969029936*^9}, {3.839725029399225*^9, 
   3.839725070375955*^9}, {3.8397257491640964`*^9, 3.8397258148584566`*^9}, {
   3.839726205531111*^9, 3.839726226304987*^9}, {3.839726314389023*^9, 
   3.8397264887181263`*^9}, {3.8397266355093994`*^9, 
   3.8397266356472826`*^9}, {3.839727069639051*^9, 3.83972707062368*^9}, {
   3.8397274615058823`*^9, 3.839727481527841*^9}, {3.83972755827617*^9, 
   3.8397275594724007`*^9}, {3.839727857737072*^9, 3.83972788618902*^9}, 
   3.8397281801577473`*^9, {3.839741406815917*^9, 3.839741648719699*^9}, 
   3.839741694966459*^9, {3.8397417738301263`*^9, 3.8397417740488653`*^9}, 
   3.839742014559319*^9, {3.8397421882027674`*^9, 3.839742188943444*^9}, {
   3.8397589658528605`*^9, 3.83975903164762*^9}, {3.839759582024466*^9, 
   3.8397596437148447`*^9}, {3.8397597378135786`*^9, 3.839759770277839*^9}, {
   3.839760042248042*^9, 3.8397600434337606`*^9}, {3.839760792865179*^9, 
   3.839760817913896*^9}, {3.8397655048182044`*^9, 3.839765505036851*^9}, {
   3.839765649791177*^9, 3.839765680039174*^9}, {3.839765730951825*^9, 
   3.8397657438209515`*^9}, {3.8397658325268707`*^9, 3.839765870890603*^9}, {
   3.8397695336031294`*^9, 3.8397695785421767`*^9}, 3.839769610638837*^9, {
   3.839769642999297*^9, 3.8397696900062704`*^9}, {3.8397697294324865`*^9, 
   3.839769753667972*^9}, 3.839770624201335*^9, {3.8399858643515997`*^9, 
   3.839985870106961*^9}, {3.8399859073530426`*^9, 3.83998590778368*^9}, {
   3.839986665758301*^9, 3.839986671600184*^9}, {3.840015477117873*^9, 
   3.840015532633871*^9}, {3.840262190474472*^9, 3.8402621922160215`*^9}, {
   3.8402622512898836`*^9, 3.8402623158498154`*^9}, {3.840262346847395*^9, 
   3.840262361938197*^9}, {3.8402624446884875`*^9, 3.840262497278998*^9}, {
   3.8402625593196363`*^9, 3.840262562846277*^9}, {3.840262654524027*^9, 
   3.8402626673364897`*^9}, {3.8402800661176753`*^9, 3.840280138278593*^9}, {
   3.840280177703832*^9, 3.840280189480773*^9}, {3.8402802324576406`*^9, 
   3.8402802331825943`*^9}, {3.8402812754975386`*^9, 3.840281326464582*^9}, 
   3.8402813946519136`*^9, {3.84028186111417*^9, 3.8402818954912634`*^9}, {
   3.8402819964993353`*^9, 3.8402819971437144`*^9}, {3.840330466229367*^9, 
   3.8403304972505484`*^9}, 3.8403305401374164`*^9, 3.840330628649666*^9, {
   3.8403306672934227`*^9, 3.8403306802026963`*^9}, {3.8403307193320885`*^9, 
   3.840330758272279*^9}, 3.8403307967908325`*^9, 3.8403308358680725`*^9, {
   3.840330872410847*^9, 3.8403308786837*^9}, {3.8403309221453967`*^9, 
   3.840330944340696*^9}, 3.840330989285677*^9, {3.840331109810131*^9, 
   3.840331153164013*^9}, {3.840331431580937*^9, 3.8403314406879196`*^9}, {
   3.8403317789283185`*^9, 3.840331780542934*^9}, {3.840331813886128*^9, 
   3.8403318320633073`*^9}, {3.8403318821336937`*^9, 
   3.8403318897950106`*^9}, {3.8403319357741313`*^9, 
   3.8403319411825953`*^9}, {3.8403320129500637`*^9, 
   3.8403321277278547`*^9}, {3.840332221075777*^9, 3.8403322212632327`*^9}, {
   3.8404162792747984`*^9, 3.8404162803058043`*^9}, {3.840416344690134*^9, 
   3.8404163448306866`*^9}, {3.8404178626090136`*^9, 3.840417925824424*^9}, {
   3.8404191918191233`*^9, 3.84041920226635*^9}, {3.840419242024495*^9, 
   3.8404192617321796`*^9}, {3.8404194389428053`*^9, 3.840419462557069*^9}, {
   3.840453834266838*^9, 3.8404538447517056`*^9}, 3.840453909614043*^9, {
   3.8404539683635793`*^9, 3.8404539905838337`*^9}, 3.8404540272985306`*^9, {
   3.840454156166298*^9, 3.840454205291971*^9}, {3.840454240247527*^9, 
   3.8404542540157146`*^9}, {3.8404543237333283`*^9, 
   3.8404543404928937`*^9}, {3.8404544521143074`*^9, 
   3.8404544541302176`*^9}, {3.840454485008524*^9, 3.8404544958331428`*^9}, {
   3.840454535970628*^9, 3.840454551137659*^9}, {3.840500625089159*^9, 
   3.840500656940725*^9}, {3.840500695345143*^9, 3.8405006960523067`*^9}, {
   3.8405010969852047`*^9, 3.840501112587641*^9}, {3.840501150634077*^9, 
   3.8405011611522417`*^9}, {3.8405026446645527`*^9, 3.84050265267775*^9}, 
   3.8405026878215275`*^9, 3.8405027886745453`*^9, {3.8405028323157024`*^9, 
   3.8405028521056433`*^9}, {3.840508597751215*^9, 3.8405086042448597`*^9}, {
   3.8405086361734276`*^9, 3.840508697640854*^9}, {3.84530515034306*^9, 
   3.8453051663199177`*^9}, 3.845305197884505*^9, {3.8454792808354254`*^9, 
   3.8454794150956697`*^9}, {3.845479722113243*^9, 3.8454797915964413`*^9}, {
   3.845514873929638*^9, 3.8455149337268724`*^9}, {3.8455149684706416`*^9, 
   3.8455149695080223`*^9}, {3.8455153275220933`*^9, 3.845515328229957*^9}, {
   3.845515395675539*^9, 3.845515401297691*^9}, {3.845515515853771*^9, 
   3.845515576447665*^9}, {3.845515612558851*^9, 3.845515632979537*^9}, {
   3.845515680153039*^9, 3.8455159262376585`*^9}, {3.845516112061887*^9, 
   3.8455161465263453`*^9}, {3.845516193085106*^9, 3.845516229178423*^9}, {
   3.8455163351689043`*^9, 3.845516585318216*^9}, {3.8455166177397394`*^9, 
   3.845516714733508*^9}, {3.845516771645197*^9, 3.8455167731827154`*^9}, {
   3.845516818729296*^9, 3.84551695860878*^9}, {3.845516994711903*^9, 
   3.845517026462266*^9}, 3.845517092145789*^9, {3.845517135366593*^9, 
   3.845517155446496*^9}, {3.845517186534149*^9, 3.8455171937276707`*^9}, {
   3.845517227012909*^9, 3.8455172279061613`*^9}, {3.8455173234132085`*^9, 
   3.8455173514857492`*^9}, {3.845517423730919*^9, 3.8455174243493695`*^9}, {
   3.8455174624069753`*^9, 3.845517465100626*^9}, 3.845517507705373*^9, 
   3.8455175508535676`*^9, {3.8455176264044795`*^9, 3.8455176334075813`*^9}, {
   3.8455313319229393`*^9, 3.845531509940443*^9}, 3.8455315849840965`*^9, {
   3.8455317016782956`*^9, 3.845531738966821*^9}, {3.845531778451456*^9, 
   3.845531779386674*^9}, {3.8456415428113813`*^9, 3.845641735457308*^9}, {
   3.8456420427094593`*^9, 3.8456420444008894`*^9}, {3.8456420953927226`*^9, 
   3.845642095827136*^9}, {3.8456421305858717`*^9, 3.8456422084386454`*^9}, 
   3.8456422719473834`*^9, {3.8456424654126687`*^9, 3.8456424685516415`*^9}, {
   3.8456425391271963`*^9, 3.845642581942461*^9}, {3.8456426396045694`*^9, 
   3.845642806094469*^9}, {3.845642836196087*^9, 3.845642900922883*^9}, {
   3.845642970285206*^9, 3.8456430181273146`*^9}, {3.8456430708546114`*^9, 
   3.845643125882959*^9}, {3.845643178575968*^9, 3.845643257358486*^9}, {
   3.8456433623862553`*^9, 3.8456433771042914`*^9}, {3.8456434590863156`*^9, 
   3.8456434937160645`*^9}, 3.845643545927831*^9, {3.845643600156926*^9, 
   3.845643618570978*^9}, {3.8456436644300175`*^9, 3.84564366503797*^9}, {
   3.845643702197648*^9, 3.8456437461979747`*^9}, 3.8456439574887114`*^9, {
   3.846069818172841*^9, 3.846069849642768*^9}, {3.8460699136765876`*^9, 
   3.846069914209477*^9}, {3.8460699599440656`*^9, 3.8460700314146757`*^9}, {
   3.846070076753316*^9, 3.846070077439046*^9}, {3.846070157661101*^9, 
   3.8460701937707815`*^9}, {3.846070258127372*^9, 3.846070370035694*^9}, 
   3.8460704231130123`*^9, {3.846070456017062*^9, 3.8460704588184586`*^9}, {
   3.8460710172041235`*^9, 3.846071021582673*^9}, {3.846071106666136*^9, 
   3.8460711227728405`*^9}, {3.846071236516765*^9, 3.8460712690613956`*^9}, {
   3.846071302508814*^9, 3.8460713286265783`*^9}, {3.846071391711331*^9, 
   3.8460713919222136`*^9}, {3.8460717432565613`*^9, 3.846071846163582*^9}, {
   3.8460718796339417`*^9, 3.8460718981181345`*^9}, {3.8460719281852317`*^9, 
   3.8460719602156863`*^9}, {3.8460725487311463`*^9, 
   3.8460727277222366`*^9}, {3.8460727966336946`*^9, 
   3.8460727999447126`*^9}, {3.8460728715731387`*^9, 3.846072900231036*^9}, 
   3.8460729488995743`*^9, 3.846073094187673*^9, {3.846073124968068*^9, 
   3.846073143649494*^9}, {3.846073291437569*^9, 3.846073320871194*^9}, {
   3.8460733513356*^9, 3.8460733827836275`*^9}, {3.8460734213260293`*^9, 
   3.846073547913215*^9}, {3.8460735888598585`*^9, 3.8460735948494663`*^9}, {
   3.8460736630482445`*^9, 3.84607366906472*^9}, {3.846073769039547*^9, 
   3.8460738022300262`*^9}, {3.8460738788770266`*^9, 
   3.8460738952181954`*^9}, {3.846073949966679*^9, 3.8460739569065495`*^9}, {
   3.846074029073464*^9, 3.8460740346596146`*^9}, {3.846074102104647*^9, 
   3.8460741324118767`*^9}, {3.8460741949049115`*^9, 3.846074222593691*^9}, {
   3.8460742841895127`*^9, 3.846074340763191*^9}, {3.846160732253354*^9, 
   3.8461607332481594`*^9}, 3.846161492762432*^9, {3.846161780897497*^9, 
   3.846161788138113*^9}, {3.8461618293598766`*^9, 3.846161858226082*^9}, {
   3.8461618966585674`*^9, 3.846161969794857*^9}, 3.846162102689354*^9, {
   3.8461621668466263`*^9, 3.846162180355235*^9}, {3.8461622164826603`*^9, 
   3.8461622355856447`*^9}, {3.846162281065609*^9, 3.8461624985309367`*^9}, 
   3.8461626621493115`*^9, 3.846162697816634*^9, {3.8461627342864695`*^9, 
   3.8461627345822268`*^9}, {3.8461628166006966`*^9, 3.8461628174265194`*^9}, 
   3.846162849529516*^9, 3.846163042718745*^9, {3.8461630926561747`*^9, 
   3.8461631014520173`*^9}, 3.846164675187914*^9, {3.8461653709571285`*^9, 
   3.8461653939322076`*^9}, {3.846239297565034*^9, 3.846239321709072*^9}, {
   3.8462393704866405`*^9, 3.846239378462596*^9}, 3.8462394463604927`*^9, {
   3.846239908200873*^9, 3.846240041118046*^9}, {3.8462400979595313`*^9, 
   3.8462402075029526`*^9}, {3.846240330599819*^9, 3.846240332116249*^9}, {
   3.846240396409835*^9, 3.846240426609739*^9}, {3.8462404635946035`*^9, 
   3.846240479194495*^9}, {3.846240547126852*^9, 3.8462406007711906`*^9}, {
   3.846240672984129*^9, 3.8462406735655537`*^9}, {3.846240715451014*^9, 
   3.846240727662325*^9}, {3.8462408398048706`*^9, 3.8462408550133176`*^9}, {
   3.846240906219432*^9, 3.8462409845731764`*^9}, {3.8462415426024213`*^9, 
   3.846241600241384*^9}, {3.8462416533016524`*^9, 3.8462416824345474`*^9}, {
   3.846241871443136*^9, 3.846241889026347*^9}, {3.84624196622915*^9, 
   3.846241982209696*^9}, {3.8462420839315395`*^9, 3.8462421106657743`*^9}, {
   3.8462493213059616`*^9, 3.846249371505189*^9}, {3.846249426216957*^9, 
   3.8462494677076874`*^9}, {3.846249549506504*^9, 3.8462495503135986`*^9}, {
   3.8463317012472258`*^9, 3.846331723789422*^9}, 3.846331790148814*^9, {
   3.846331841946804*^9, 3.8463318642788124`*^9}, {3.8463318999649568`*^9, 
   3.84633190085021*^9}, {3.846331970187175*^9, 3.8463319724350276`*^9}, {
   3.846332425994608*^9, 3.8463324267831564`*^9}, {3.8463324853767433`*^9, 
   3.846332505743512*^9}, {3.84633253640195*^9, 3.84633253746087*^9}, 
   3.8463325927468147`*^9, {3.846332664076268*^9, 3.84633267729871*^9}, {
   3.84633282094595*^9, 3.846332866648316*^9}, {3.846332915983061*^9, 
   3.846332964772069*^9}, {3.8463332315659857`*^9, 3.8463332589840655`*^9}, {
   3.8463333159368706`*^9, 3.8463333881232243`*^9}, {3.846333478174964*^9, 
   3.846333507307977*^9}, {3.8463337169753866`*^9, 3.846333752677167*^9}, {
   3.8463337874930525`*^9, 3.8463337938266315`*^9}, {3.84633382889653*^9, 
   3.8463338314544067`*^9}, {3.8463338661347585`*^9, 
   3.8463338671064034`*^9}, {3.8463341029946103`*^9, 3.8463341178046017`*^9}, 
   3.8463344961508446`*^9, {3.846334551477289*^9, 3.8463345669722776`*^9}, {
   3.846334647851037*^9, 3.8463346507709723`*^9}, {3.8463350072556896`*^9, 
   3.846335009531336*^9}, {3.8463350584383993`*^9, 3.8463350832915545`*^9}, 
   3.8463356730391445`*^9, {3.8463357330577507`*^9, 3.846335734677639*^9}, {
   3.8463357713912954`*^9, 3.846335784599365*^9}, {3.846335824451017*^9, 
   3.846335850541898*^9}, {3.8465148279290648`*^9, 3.846514905645626*^9}, {
   3.8465149546536207`*^9, 3.8465149557287645`*^9}, 3.8465150347627506`*^9, 
   3.8465150735123754`*^9, 3.846515133355834*^9, {3.846551496354246*^9, 
   3.8465515199215117`*^9}, {3.8465515514860935`*^9, 3.846551558453719*^9}, {
   3.8465516511605453`*^9, 3.8465516816971188`*^9}, {3.8465517493251767`*^9, 
   3.8465517819787836`*^9}, {3.846551812162984*^9, 3.84655181978378*^9}, {
   3.8469012753631597`*^9, 3.8469014245266294`*^9}, {3.846901477101201*^9, 
   3.846901480891117*^9}, 3.846901533852523*^9, {3.8469015653056993`*^9, 
   3.8469015942691755`*^9}, 3.8469016260053563`*^9, {3.846901664939994*^9, 
   3.8469016657155457`*^9}, {3.846901747509447*^9, 3.8469017503170366`*^9}, {
   3.84690191404624*^9, 3.84690193970901*^9}, 3.846901985149589*^9, {
   3.84690203255608*^9, 3.8469020373058805`*^9}, {3.8469021528510695`*^9, 
   3.84690220430954*^9}, {3.8469022448931456`*^9, 3.8469022504597807`*^9}, {
   3.846902285388745*^9, 3.846902288603936*^9}, {3.8469023384879513`*^9, 
   3.846902371933584*^9}, 3.846902765731144*^9, {3.8469028332433987`*^9, 
   3.8469028443561935`*^9}, 3.8469030843801355`*^9, 3.846903160980903*^9, {
   3.8469032059828815`*^9, 3.8469032390870132`*^9}, {3.84690342310567*^9, 
   3.846903439207902*^9}, {3.8469061580301685`*^9, 3.8469062645476227`*^9}, {
   3.8469065486448135`*^9, 3.846906561548581*^9}, {3.8469067471371455`*^9, 
   3.8469068174896765`*^9}, {3.84690686154051*^9, 3.8469068684523077`*^9}, {
   3.8497527618146653`*^9, 3.8497527676380615`*^9}, {3.8497528414079475`*^9, 
   3.849752843454638*^9}, {3.8497530625145917`*^9, 3.849753063032662*^9}, {
   3.8497530971084747`*^9, 3.8497531011988783`*^9}, {3.8497532258666143`*^9, 
   3.849753345755213*^9}, {3.849753924288494*^9, 3.849753985952464*^9}, {
   3.849754069460248*^9, 3.849754087001464*^9}, {3.849754259204835*^9, 
   3.849754268999332*^9}, {3.8497554284565487`*^9, 3.8497554930272894`*^9}, {
   3.849755685279069*^9, 3.8497556896240177`*^9}, {3.8497558773614607`*^9, 
   3.849755877843891*^9}, {3.8497559807269473`*^9, 3.8497560211165953`*^9}, 
   3.850443650520732*^9, {3.8504438404083548`*^9, 3.8504441120345283`*^9}, {
   3.850444156664489*^9, 3.850444280967318*^9}, {3.850444354744196*^9, 
   3.85044463643923*^9}, {3.8504447256702757`*^9, 3.8504447980665684`*^9}, {
   3.8505274395909743`*^9, 3.8505274411181674`*^9}, {3.8505275310510144`*^9, 
   3.8505276349685197`*^9}, {3.850527665564816*^9, 3.850527741150744*^9}, {
   3.850528010969228*^9, 3.8505280914370484`*^9}, {3.850528341539154*^9, 
   3.8505283435766478`*^9}, {3.850528399268195*^9, 3.850528452926201*^9}, {
   3.850528511901552*^9, 3.850528524032834*^9}, {3.8505286008142643`*^9, 
   3.8505286255862675`*^9}, {3.850528657292616*^9, 3.8505287485299587`*^9}, {
   3.850528791091945*^9, 3.8505287912193995`*^9}, {3.8505289892778673`*^9, 
   3.8505290093703814`*^9}, {3.8505291179397283`*^9, 3.850529246368305*^9}, {
   3.8505292847200036`*^9, 3.8505293531238484`*^9}, {3.85052942526715*^9, 
   3.8505295026053452`*^9}, {3.850529652810694*^9, 3.85052969888447*^9}, {
   3.8505297570230837`*^9, 3.8505297793908668`*^9}, {3.8505298130474796`*^9, 
   3.85052982372943*^9}, 3.850529903643921*^9, {3.8505299339680395`*^9, 
   3.850529938523468*^9}, {3.850533467746894*^9, 3.850533696587976*^9}, {
   3.8505337523084393`*^9, 3.8505340100220647`*^9}, {3.850534073301394*^9, 
   3.8505341115212436`*^9}, {3.8505341448690495`*^9, 3.850534244609003*^9}, {
   3.8505342773409953`*^9, 3.850534317485276*^9}, {3.850534376818581*^9, 
   3.8505345375059347`*^9}, 3.8505345895823593`*^9, {3.850534712936541*^9, 
   3.850534853983102*^9}, {3.85053489565536*^9, 3.85053490800423*^9}, {
   3.850535011630887*^9, 3.850535069369616*^9}, {3.8505609789941187`*^9, 
   3.8505609796472797`*^9}, {3.850561024378234*^9, 3.8505611077291512`*^9}, {
   3.8505611554662695`*^9, 3.8505611900834045`*^9}, {3.8505612604815354`*^9, 
   3.850561307036023*^9}, 3.8505614161973686`*^9, {3.850561489892841*^9, 
   3.8505614904828854`*^9}, 3.850561540476676*^9, {3.850566961415826*^9, 
   3.85056699607444*^9}, {3.8505670465401917`*^9, 3.850567067268143*^9}, {
   3.850567124561453*^9, 3.8505671481746936`*^9}, {3.8505671891195374`*^9, 
   3.850567192972233*^9}, {3.8505672404233675`*^9, 3.850567272319547*^9}, {
   3.8505673802869396`*^9, 3.850567388289441*^9}, {3.850567420051065*^9, 
   3.8505674379775977`*^9}, {3.850568113924102*^9, 3.850568121245113*^9}, {
   3.8505681786419373`*^9, 3.8505682190225987`*^9}, {3.8505682742836356`*^9, 
   3.8505682972999997`*^9}, {3.850568330443387*^9, 3.8505683415549088`*^9}, {
   3.850568377492758*^9, 3.850568403154665*^9}, {3.850568837097434*^9, 
   3.850568946787299*^9}, {3.8505691453292117`*^9, 3.850569195539899*^9}, {
   3.8505692859376397`*^9, 3.8505693669331837`*^9}, {3.8505693974289236`*^9, 
   3.8505695475039663`*^9}, {3.8505696079724298`*^9, 
   3.8505696221275873`*^9}, {3.8505697874854712`*^9, 
   3.8505698175396166`*^9}, {3.850569868969412*^9, 3.8505698726296372`*^9}, {
   3.850569905926787*^9, 3.8505699809036593`*^9}, {3.850570015920215*^9, 
   3.85057008172045*^9}, {3.850785556912866*^9, 3.850785616614393*^9}, {
   3.8507856606466494`*^9, 3.850785723209618*^9}, {3.8507857656066175`*^9, 
   3.850785880874487*^9}, {3.850785924508508*^9, 3.850785937300992*^9}, {
   3.8507859750545197`*^9, 3.8507859968100834`*^9}, {3.850786077342246*^9, 
   3.8507860848236823`*^9}, {3.8507861340867023`*^9, 3.8507861374599075`*^9}, 
   3.850786227982345*^9, {3.8507862859910107`*^9, 3.8507863008387175`*^9}, {
   3.850786368316942*^9, 3.850786374976062*^9}, {3.850786423270744*^9, 
   3.850786423425295*^9}, {3.8507865491264324`*^9, 3.850786595976322*^9}, {
   3.850786636570469*^9, 3.850786709325587*^9}, {3.850786743990263*^9, 
   3.8507868015086374`*^9}, {3.8507870134211025`*^9, 
   3.8507870176048164`*^9}, {3.850787059141889*^9, 3.8507870650224657`*^9}, {
   3.850787111878257*^9, 3.850787113157389*^9}, {3.8507887599989805`*^9, 
   3.850788841851822*^9}, {3.850788913491912*^9, 3.8507890311085014`*^9}, {
   3.8507890809695005`*^9, 3.8507890902738066`*^9}, {3.8507891921970196`*^9, 
   3.8507891973037043`*^9}, {3.8507892279462795`*^9, 3.850789249495205*^9}, {
   3.850791412876636*^9, 3.8507914130273633`*^9}, {3.8507915155633483`*^9, 
   3.8507915162424593`*^9}, {3.850827343188859*^9, 3.850827375432101*^9}, {
   3.8508274109868975`*^9, 3.8508274369062905`*^9}, {3.8508274890786314`*^9, 
   3.8508274894138756`*^9}, {3.8508275695516253`*^9, 3.850827569788695*^9}, 
   3.8508276711587315`*^9, {3.8508277166165743`*^9, 3.8508277728386536`*^9}, {
   3.8508278475513325`*^9, 3.8508278753498926`*^9}, {3.8508279408872223`*^9, 
   3.85082794118405*^9}, {3.850827981298354*^9, 3.850828056921221*^9}, {
   3.850828494113824*^9, 3.850828495039543*^9}, {3.85082856023905*^9, 
   3.850828575017256*^9}, {3.850828628892047*^9, 3.850828696248144*^9}, 
   3.8508287630158415`*^9, {3.8508293694951773`*^9, 3.850829372071825*^9}, {
   3.8508294221130056`*^9, 3.8508294474505587`*^9}, {3.8508295136154523`*^9, 
   3.850829546786518*^9}, {3.8508307551495695`*^9, 3.850830755305548*^9}, {
   3.850830846425475*^9, 3.8508308469949007`*^9}, {3.8508328226756153`*^9, 
   3.8508328956454206`*^9}, {3.8515151599360895`*^9, 
   3.8515151854097323`*^9}, {3.851515227511881*^9, 3.8515152691971846`*^9}, {
   3.8517376565999703`*^9, 3.851737660729647*^9}, {3.8517376993937993`*^9, 
   3.851737854226467*^9}, {3.8517379030659018`*^9, 3.851737963592141*^9}, {
   3.8517380004040184`*^9, 3.851738156849004*^9}, {3.8517381881441555`*^9, 
   3.8517383547150526`*^9}, {3.851738403578961*^9, 3.8517384750343685`*^9}, {
   3.8517386329884996`*^9, 3.8517387036807384`*^9}, {3.8517387496128297`*^9, 
   3.8517391066461697`*^9}, 3.851739167106615*^9, {3.851739199324179*^9, 
   3.8517392033202653`*^9}, {3.851739306865944*^9, 3.8517396012506447`*^9}, {
   3.8517396478337793`*^9, 3.851739717012961*^9}, {3.851739779861041*^9, 
   3.8517398251446857`*^9}, {3.8517401674121*^9, 3.85174023031291*^9}, {
   3.8517403822763968`*^9, 3.8517405215277195`*^9}, {3.8517405598035936`*^9, 
   3.8517405807347307`*^9}, 3.8517406111741548`*^9, {3.852771815388609*^9, 
   3.852771815826337*^9}, {3.852771938933034*^9, 3.852772015527173*^9}, {
   3.8527720455326405`*^9, 3.852772051655347*^9}, {3.852772112575083*^9, 
   3.85277216712604*^9}, {3.8527722639917727`*^9, 3.8527723193930345`*^9}, {
   3.8527723507994275`*^9, 3.8527724886441803`*^9}, 3.852772518958836*^9, {
   3.8527726690962496`*^9, 3.8527726724595623`*^9}, {3.852772785224839*^9, 
   3.852772814059412*^9}, {3.8527728536940055`*^9, 3.8527728543197746`*^9}, 
   3.8527728940919833`*^9, {3.8527729250196114`*^9, 3.8527729905347033`*^9}, {
   3.8527730490675783`*^9, 3.8527730529881525`*^9}, {3.852773399558672*^9, 
   3.852773411256092*^9}, {3.852773459331044*^9, 3.852773480723246*^9}, {
   3.8527735251577444`*^9, 3.8527735647772226`*^9}, {3.85277372440212*^9, 
   3.852773727144375*^9}, {3.8528731960002193`*^9, 3.8528733256878357`*^9}, {
   3.852873387704274*^9, 3.852873409884766*^9}, {3.8528734508562613`*^9, 
   3.8528734515817213`*^9}, {3.8528734901873713`*^9, 3.852873528186962*^9}, {
   3.8528735614708843`*^9, 3.8528735812376013`*^9}, {3.8528736531146784`*^9, 
   3.852873677620881*^9}, {3.8528801200331235`*^9, 3.852880146194016*^9}, {
   3.853140879673688*^9, 3.8531409143592653`*^9}, {3.8531409625201416`*^9, 
   3.8531410288764524`*^9}, {3.8531410590292354`*^9, 
   3.8531411087537766`*^9}, {3.906960081539485*^9, 3.9069602331152077`*^9}, {
   3.9069603433707557`*^9, 3.906960532270595*^9}, {3.9069608107416534`*^9, 
   3.906960894501176*^9}, 3.906976975428384*^9, 3.9069784461360517`*^9, {
   3.9069784939955707`*^9, 3.906978495519633*^9}, {3.906979520056976*^9, 
   3.906979527909192*^9}, {3.9070299969708767`*^9, 3.9070299973647575`*^9}, 
   3.9070302622793455`*^9, {3.907031054878291*^9, 3.907031101672268*^9}, {
   3.907031132657627*^9, 3.907031137965227*^9}, {3.907031258015709*^9, 
   3.907031258244317*^9}, 3.907060462885079*^9, {3.9070616210919228`*^9, 
   3.9070617379829817`*^9}, {3.9070618359373693`*^9, 
   3.9070618491419787`*^9}, {3.9072168098312087`*^9, 
   3.9072168879034996`*^9}, {3.9072169598535347`*^9, 
   3.9072169971857233`*^9}, {3.9072170607219973`*^9, 3.907217066892645*^9}, {
   3.9076577595519457`*^9, 3.9076578173877373`*^9}, {3.9076578614233837`*^9, 
   3.907657894347175*^9}, {3.9076579602806206`*^9, 3.9076579846181087`*^9}, {
   3.9076596607447786`*^9, 3.9076596756372747`*^9}, 3.910745605690302*^9, {
   3.91074584911373*^9, 3.9107458926127214`*^9}, 3.910745941790287*^9, {
   3.910745986223607*^9, 3.910746063719597*^9}, {3.910747810729528*^9, 
   3.9107478791523943`*^9}, {3.9107479317978497`*^9, 
   3.9107479806408787`*^9}, {3.9107480256793222`*^9, 3.910748109579584*^9}, {
   3.91086543516223*^9, 3.9108654503446293`*^9}, {3.910865504589961*^9, 
   3.9108657401174555`*^9}, {3.91086584568825*^9, 3.910865852120024*^9}, 
   3.910865926383168*^9, 3.9108659744156675`*^9, 3.91086605745315*^9, {
   3.9108661771273518`*^9, 3.9108661799860926`*^9}, {3.9108662518520503`*^9, 
   3.9108662615334487`*^9}, 3.9108663396346254`*^9, {3.910866427961111*^9, 
   3.9108664324625444`*^9}, {3.910866648483549*^9, 3.910866665466797*^9}, {
   3.9108666978412094`*^9, 3.910866759019273*^9}, 3.9108668342632604`*^9, {
   3.9108668671138697`*^9, 3.910866882442206*^9}, {3.9108669792404804`*^9, 
   3.9108671430224776`*^9}, {3.9108671931495285`*^9, 3.910867227668786*^9}, {
   3.9108672957548175`*^9, 3.9108672974319744`*^9}, {3.910867368016037*^9, 
   3.910867368944265*^9}, 3.910867400227538*^9, {3.911008255763074*^9, 
   3.911008275926586*^9}, 3.9110083690822363`*^9, {3.9110084055565042`*^9, 
   3.9110084252803555`*^9}, 3.911008491161389*^9, {3.911008696240383*^9, 
   3.911008714321493*^9}, {3.9110088966274376`*^9, 3.911008900951162*^9}, {
   3.9110089635273657`*^9, 3.9110089783297873`*^9}, {3.911009014769552*^9, 
   3.9110090198434143`*^9}, {3.9110092308436937`*^9, 3.911009360495569*^9}, {
   3.9110093990206623`*^9, 3.9110094532567844`*^9}, {3.911009498630669*^9, 
   3.9110095367569847`*^9}, {3.9110095712912645`*^9, 
   3.9110096330820303`*^9}, {3.9110096653864827`*^9, 3.911009822963343*^9}, {
   3.911009859719963*^9, 3.911009866575224*^9}, {3.911009967367282*^9, 
   3.9110099850429783`*^9}, {3.911010028843105*^9, 3.9110101503231063`*^9}, {
   3.911010193179899*^9, 3.911010257505966*^9}, 3.911010335859486*^9, {
   3.911010401075186*^9, 3.911010457367464*^9}, 3.911010499750472*^9, {
   3.9110401234863586`*^9, 3.911040300892739*^9}, {3.9110403386146345`*^9, 
   3.911040544742799*^9}, {3.9110405856611333`*^9, 3.911040600084425*^9}, {
   3.9110409430788774`*^9, 3.9110409865360575`*^9}, {3.9110412680876427`*^9, 
   3.911041429298622*^9}, {3.911041589517542*^9, 3.9110416136098943`*^9}, {
   3.9110959319146233`*^9, 3.911096010751473*^9}, {3.9110962776335144`*^9, 
   3.911096301713908*^9}, 3.9178327676610384`*^9, {3.9178328130884504`*^9, 
   3.9178328456511154`*^9}, {3.917832937499711*^9, 3.9178330695028243`*^9}, 
   3.9178331994613113`*^9, {3.917834201606349*^9, 3.917834211402545*^9}, {
   3.9178349805852203`*^9, 3.9178350888355284`*^9}, 3.9178351248033366`*^9, {
   3.917835160201161*^9, 3.9178352273128357`*^9}, 3.9178352741560116`*^9, {
   3.917835325859825*^9, 3.917835435401243*^9}, 3.9178355249872417`*^9, {
   3.9178356172312093`*^9, 3.9178356297356*^9}, {3.91783568545286*^9, 
   3.917835805042737*^9}, {3.9178358887961955`*^9, 3.917835970931384*^9}, {
   3.91783601107827*^9, 3.9178360745421157`*^9}, {3.917844788560877*^9, 
   3.9178448665063515`*^9}, {3.917844935589503*^9, 3.9178449360286317`*^9}, {
   3.917845094652336*^9, 3.91784509570059*^9}, 3.917845690946804*^9, {
   3.917845723937815*^9, 3.9178459895757904`*^9}, {3.917846032574973*^9, 
   3.9178460857258883`*^9}, {3.9178461911986103`*^9, 
   3.9178461944625187`*^9}, {3.9178462448627577`*^9, 3.917846304398095*^9}, 
   3.9178463714845753`*^9, {3.9178464594837284`*^9, 3.917846522233492*^9}, 
   3.917846725964483*^9, 3.917846794000132*^9, {3.9178468549411974`*^9, 
   3.9178469204064703`*^9}, {3.9178469653666945`*^9, 
   3.9178469712282314`*^9}, {3.917847023535391*^9, 3.917847073962528*^9}, {
   3.9178471068232837`*^9, 3.917847107940056*^9}, {3.917847149462328*^9, 
   3.917847282842494*^9}, {3.9182107800334454`*^9, 3.9182108026294394`*^9}, {
   3.918211063533805*^9, 3.9182110707627587`*^9}, 3.9182112365832987`*^9, {
   3.9182118550445185`*^9, 3.918211855445151*^9}, {3.9182119719296093`*^9, 
   3.918212012304086*^9}, {3.918212091665084*^9, 3.9182121098142185`*^9}, 
   3.918212158685156*^9, 3.9182130109841146`*^9, {3.918216789730894*^9, 
   3.9182167972835355`*^9}, {3.9186297917962503`*^9, 
   3.9186297932958975`*^9}, {3.9189072469484725`*^9, 3.918907249475754*^9}, {
   3.9189895736147714`*^9, 3.918989595216329*^9}, {3.918989763192815*^9, 
   3.9189898027417526`*^9}, 3.9189898919476013`*^9, {3.9189915023925023`*^9, 
   3.9189915555929155`*^9}, {3.9189915933735375`*^9, 
   3.9189915945724163`*^9}, {3.918991729867016*^9, 3.9189917451630945`*^9}, {
   3.918991887208146*^9, 3.918991902581184*^9}, 3.919132488473759*^9, {
   3.9191383666888304`*^9, 3.9191383785158653`*^9}, {3.91916388381071*^9, 
   3.9191638870508723`*^9}, 3.9191639478074884`*^9, {3.919163980430376*^9, 
   3.919163981486286*^9}, {3.9191654395378447`*^9, 3.919165443624833*^9}, {
   3.920028965239792*^9, 3.9200289957363143`*^9}, 3.920029295060505*^9, {
   3.9200294752547865`*^9, 3.920029486109942*^9}, 3.9200296762833786`*^9, 
   3.920029986166423*^9, {3.9200754288884797`*^9, 3.9200754732116117`*^9}, {
   3.920076841722273*^9, 3.920076848769417*^9}, {3.920077131503725*^9, 
   3.9200771321513805`*^9}, {3.9200782220004253`*^9, 3.9200782278357*^9}, {
   3.9200783994302464`*^9, 3.9200784014416103`*^9}}],

Cell[BoxData[
 RowBox[{"-", "3.180377809979704`"}]], "Output",
 CellChangeTimes->{{3.920075450110453*^9, 3.920075473912918*^9}, 
   3.9200768497898245`*^9, 3.920077135780057*^9, 3.920078229053866*^9, 
   3.92007840379284*^9, 3.92011650589214*^9}],

Cell[BoxData["159.0188904989852`"], "Output",
 CellChangeTimes->{{3.920075450110453*^9, 3.920075473912918*^9}, 
   3.9200768497898245`*^9, 3.920077135780057*^9, 3.920078229053866*^9, 
   3.92007840379284*^9, 3.9201165058959694`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJw1lnk0lXsfxTmc8xgaVMZkTpnipFAZnoebLrm55TbImykSB6EcZQqZIplC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     "]]}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{-1., 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{0, -1}, {-3, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.920075450110453*^9, 3.920075473912918*^9}, 
   3.9200768497898245`*^9, 3.920077135780057*^9, 3.920078229053866*^9, 
   3.92007840379284*^9, 3.9201165061107054`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJw1lnk01fsaxtlsP0NJmRN7I0JOg5LK8H45KXJyymmQkyQqNkKZh5Aos4TM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     "]]}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{-1., 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SuperscriptBox[\\(10\\), \\(-6\\)]\\) Z\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{0, -1}, {0, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.920075450110453*^9, 3.920075473912918*^9}, 
   3.9200768497898245`*^9, 3.920077135780057*^9, 3.920078229053866*^9, 
   3.92007840379284*^9, 3.92011650613651*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJw1lnk01fsaxtlsP0NJmRN7I0JOg5LK8H45KXJyymmQkyQqNkKZh5Aos4TM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      "]]}}, InsetBox[
    StyleBox[
     TagBox[
      RowBox[{
       StyleBox["A",
        FontSize->12], 
       StyleBox[
        RowBox[{
         StyleBox[" ",
          FontSize->12], " "}]]}],
      "RawBoxes"],
     FontFamily->"Arial",
     FontSize->10,
     Background->GrayLevel[1.]], {-0.5976027397260282, 0.8062622309197645}, {
    Left, Baseline},
    Alignment->{Left, Top}]},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{-1., 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SuperscriptBox[\\(10\\), \\(-6\\)]\\) Z\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{43., 25.}, {55., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1., 0.}, {0., 2.}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.920075477572524*^9, 3.9200754888410854`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJw1lnk0lXsfxTmc8xgaVMZkTpnipFAZnoebLrm55TbImykSB6EcZQqZIplC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      "]]}}, InsetBox[
    RowBox[{"\[Theta]", "=", 
     RowBox[{"+", "1"}]}], {-0.215547703180212, 2.15194346289753}, {
    Left, Baseline},
    Alignment->{Left, Top}]},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{-1., 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{52., 25.}, {55., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1., 0.}, {-3., 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.9200299940006213`*^9, 3.9200300017687206`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJw1lnk41esexdlsP0ODypjMKVPsFCrD9+Wko5ycchrkGhIVGyFDxpAps4Rk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      "]]}}, InsetBox[
    RowBox[{"\[Theta]", "=", 
     RowBox[{"-", "1"}]}], {-0.2773851590106008, 2.2428066633013635`}, {
    Left, Baseline},
    Alignment->{Left, Top}]},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{-1., 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{52., 25.}, {55., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1., 0.}, {-3., 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.9200297003645983`*^9, 3.920029720313575*^9}, 
   3.9200299898634715`*^9}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Theta]", "=", 
     RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"V0", "=", 
     RowBox[{"-", "0.5"}]}], ";", 
    RowBox[{"DV", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t0", "=", "0.5"}], ";", 
    RowBox[{"tfin", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Tau]e", "=", "0.5"}], ";", 
    RowBox[{"\[Tau]d", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Iin", "=", 
     RowBox[{"Idc", "[", "V0", "]"}]}], ";", 
    RowBox[{"Ifin", "=", 
     RowBox[{
      RowBox[{"Idc", "[", "V0", "]"}], "+", 
      RowBox[{"\[Theta]", " ", 
       RowBox[{"cmu", "[", "V0", "]"}], " ", 
       RowBox[{"L", " ", "/", "\[Tau]e"}], " ", "DV"}]}]}], ";", 
    RowBox[{"I0", "=", 
     RowBox[{
      RowBox[{"Idc", "[", "V0", "]"}], "+", 
      RowBox[{
       RowBox[{"cmu", "[", "V0", "]"}], " ", "f", " ", 
       RowBox[{"L", " ", "/", "\[Tau]d"}], " ", "DV"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"as1", "=", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tt", ",", 
         RowBox[{
          RowBox[{"Idc", "[", "V0", "]"}], "+", 
          RowBox[{
           RowBox[{"cmu", "[", "V0", "]"}], " ", "L", "  ", "DV", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", "/", "\[Tau]d"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Theta]", " ", "/", "\[Tau]e"}], "-", 
                RowBox[{"f", "/", "\[Tau]d"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{"tt", "-", "t0"}], ")"}]}], "/", "\[Tau]d"}], 
                 "]"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tt", ",", "t0", ",", "tfin"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<t (ms)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(d\)]\) (\[Mu]A)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", 
            RowBox[{"-", "2"}], ",", 
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "0.5"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", 
            RowBox[{"-", "3"}], ",", 
            RowBox[{"-", "2"}], ",", 
            RowBox[{"-", "1.5"}], ",", 
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "0.5"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
           "}"}], ",", "None", ",", "None"}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue"}], "}"}],
          "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fg1", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "Iin"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t0", ",", "Iin"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";", 
    RowBox[{"fg4", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"t0", ",", 
             RowBox[{"Idc", "[", "V0", "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t0", ",", "I0"}], " ", "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";", 
    RowBox[{"fg2", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Brown", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"t0", ",", "Ifin"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"tfin", ",", "Ifin"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fg3", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Brown", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"t0", ",", "Iin"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t0", ",", "Ifin"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"as1", ",", "fg1", ",", "fg2", ",", "fg3", ",", "fg4", ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "tfin"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2.5"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"BaseStyle", "->", 
      RowBox[{"{", 
       RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8390646611298313`*^9, 3.839064663549252*^9}, {
   3.8390651628201227`*^9, 3.8390651698744855`*^9}, {3.8390671245340233`*^9, 
   3.839067253968177*^9}, {3.8390672908692884`*^9, 3.8390673435588245`*^9}, {
   3.839067444277615*^9, 3.8390674530816755`*^9}, {3.839067483223913*^9, 
   3.8390676448632746`*^9}, {3.839067792030848*^9, 3.8390679296503277`*^9}, {
   3.839068035965031*^9, 3.8390681198292847`*^9}, {3.8390709139116144`*^9, 
   3.8390709421089935`*^9}, {3.83907099038449*^9, 3.8390709930117693`*^9}, {
   3.839071053413534*^9, 3.839071065617492*^9}, {3.839071142245447*^9, 
   3.8390712315177836`*^9}, {3.839071262559967*^9, 3.8390713000871944`*^9}, {
   3.8390714971122246`*^9, 3.839071517359198*^9}, {3.8390715485300074`*^9, 
   3.8390716200472517`*^9}, {3.8390716672806673`*^9, 3.839071782347397*^9}, {
   3.839071837937226*^9, 3.839071939311781*^9}, {3.839072168081314*^9, 
   3.839072168581891*^9}, {3.8390723168444653`*^9, 3.8390724465495067`*^9}, {
   3.8390724871236815`*^9, 3.839072628537404*^9}, {3.8390726857581015`*^9, 
   3.83907270608572*^9}, {3.8390728526632924`*^9, 3.8390730714112225`*^9}, {
   3.839082271666379*^9, 3.8390823055073657`*^9}, {3.839082353119522*^9, 
   3.839082449840514*^9}, {3.8390839765348864`*^9, 3.839084057466158*^9}, {
   3.8390840878065057`*^9, 3.8390841778809776`*^9}, {3.8390842363292522`*^9, 
   3.8390842982497163`*^9}, 3.83908433029414*^9, {3.8390843708346243`*^9, 
   3.8390844315092807`*^9}, 3.839084462612833*^9, {3.8390845298830824`*^9, 
   3.839084537171591*^9}, {3.8390846234607463`*^9, 3.839084639769829*^9}, {
   3.839085385972989*^9, 3.8390853976007433`*^9}, {3.8390854555897675`*^9, 
   3.839085524444199*^9}, {3.839085565738154*^9, 3.8390855920819826`*^9}, {
   3.8390863447286386`*^9, 3.839086474045252*^9}, {3.839086860852067*^9, 
   3.839086874816577*^9}, {3.839087637034748*^9, 3.8390876843714943`*^9}, 
   3.83908780285631*^9, 3.8390878367914057`*^9, {3.839088015231053*^9, 
   3.8390880802460375`*^9}, {3.839088241208177*^9, 3.839088251058446*^9}, 
   3.839088396382834*^9, 3.8391182307918463`*^9, {3.839118379381566*^9, 
   3.8391183868618546`*^9}, {3.839118542781612*^9, 3.839118576690755*^9}, {
   3.839119230679368*^9, 3.8391192435152392`*^9}, {3.8391193005384474`*^9, 
   3.839119322077612*^9}, {3.8391197370496492`*^9, 3.839119744561663*^9}, {
   3.839119780647091*^9, 3.8391198576053133`*^9}, {3.83913747847266*^9, 
   3.839137485481214*^9}, {3.8391375587687283`*^9, 3.8391375797199593`*^9}, {
   3.8391376276780567`*^9, 3.8391376620779104`*^9}, {3.83913835785732*^9, 
   3.839138374216883*^9}, 3.8391384110040264`*^9, {3.8391384624942074`*^9, 
   3.839138462879356*^9}, {3.8391385170099597`*^9, 3.839138536349577*^9}, {
   3.839139183554804*^9, 3.8391391930138044`*^9}, {3.8391393033973885`*^9, 
   3.8391393043613095`*^9}, 3.839139359067504*^9, 3.839139436240513*^9, {
   3.8392078031308994`*^9, 3.8392078143543434`*^9}, {3.8392078889566584`*^9, 
   3.83920790820275*^9}, {3.839208054761527*^9, 3.839208093399903*^9}, {
   3.8392084092575808`*^9, 3.8392084620514746`*^9}, 3.839208533536579*^9, {
   3.8392086070037084`*^9, 3.8392086083290124`*^9}, 3.8392086479255266`*^9, {
   3.8392225965883913`*^9, 3.8392226283136573`*^9}, {3.8392226646362276`*^9, 
   3.8392227421040397`*^9}, 3.8392227767756677`*^9, {3.8392228326927814`*^9, 
   3.839222892911393*^9}, 3.8392230743763013`*^9, {3.839223141092394*^9, 
   3.839223141783134*^9}, 3.839223177642132*^9, {3.8392232273840017`*^9, 
   3.8392232854596047`*^9}, {3.8392233573873816`*^9, 3.839223398790718*^9}, {
   3.8392234505961695`*^9, 3.839223507183962*^9}, {3.839223811017748*^9, 
   3.8392239510950837`*^9}, {3.8392240167007127`*^9, 3.839224025275307*^9}, {
   3.8392241057509785`*^9, 3.839224157437503*^9}, {3.839224200897134*^9, 
   3.8392242487597456`*^9}, {3.839224294917468*^9, 3.839224296013791*^9}, {
   3.8392243639841394`*^9, 3.8392243950383773`*^9}, 3.839224442185709*^9, {
   3.8392245129185476`*^9, 3.8392245373577056`*^9}, {3.8392245776385975`*^9, 
   3.839224740679908*^9}, {3.8392248367057567`*^9, 3.839224838004247*^9}, {
   3.8392249023255987`*^9, 3.8392249329681873`*^9}, 3.8392250078513308`*^9, {
   3.8392250461420965`*^9, 3.8392250567765236`*^9}, {3.8392250892690206`*^9, 
   3.839225128234888*^9}, {3.839225292837965*^9, 3.8392253052980237`*^9}, {
   3.839225374465659*^9, 3.839225378163327*^9}, {3.8392366608564453`*^9, 
   3.839236691352835*^9}, {3.839236736346908*^9, 3.8392367461057377`*^9}, {
   3.8392368452896976`*^9, 3.8392369245276327`*^9}, {3.8392369586763678`*^9, 
   3.839236989556669*^9}, {3.8392370210310707`*^9, 3.839237025639107*^9}, {
   3.8392370611832547`*^9, 3.839237143422812*^9}, {3.839237229917989*^9, 
   3.839237306453603*^9}, {3.8392373387206373`*^9, 3.839237342820054*^9}, {
   3.839237447098841*^9, 3.8392375543643665`*^9}, {3.8392411494009237`*^9, 
   3.839241171431179*^9}, {3.83924120627816*^9, 3.8392412247291117`*^9}, 
   3.8392412792201967`*^9, 3.8392413874247665`*^9, {3.8392415172512045`*^9, 
   3.8392415791894693`*^9}, {3.839241632182249*^9, 3.8392416472548246`*^9}, 
   3.8392418101230965`*^9, {3.839242047805271*^9, 3.8392420951804295`*^9}, {
   3.8392421670049934`*^9, 3.8392422247577305`*^9}, {3.8392422574679546`*^9, 
   3.8392422587095203`*^9}, {3.839242291908*^9, 3.8392425704347763`*^9}, {
   3.8392426617662134`*^9, 3.8392426717163734`*^9}, 3.839242785862258*^9, {
   3.839246817917405*^9, 3.8392468269690895`*^9}, {3.839246889891876*^9, 
   3.839246924816616*^9}, {3.839309996677757*^9, 3.839310018708186*^9}, {
   3.839310845764266*^9, 3.839310880859878*^9}, {3.839310926113166*^9, 
   3.839310949193386*^9}, {3.8393110019361973`*^9, 3.8393110308399534`*^9}, {
   3.8393270934512377`*^9, 3.839327332415727*^9}, {3.839327370226597*^9, 
   3.839327451303669*^9}, {3.8393275031436253`*^9, 3.8393275194960613`*^9}, {
   3.839327586008069*^9, 3.8393276948310633`*^9}, {3.8393278034898295`*^9, 
   3.8393278068680096`*^9}, {3.8393278450424776`*^9, 
   3.8393278797618237`*^9}, {3.8393289610021143`*^9, 3.839328976754302*^9}, {
   3.8393294967878103`*^9, 3.839329617607455*^9}, 3.8393297021511583`*^9, {
   3.839329736764967*^9, 3.83932973839811*^9}, {3.839329841358012*^9, 
   3.839329850076448*^9}, {3.8393298856244183`*^9, 3.83932990739045*^9}, {
   3.839330200791801*^9, 3.839330209464896*^9}, 3.83933026862875*^9, {
   3.8393304947792683`*^9, 3.839330614321838*^9}, {3.839330707456501*^9, 
   3.8393307223587484`*^9}, {3.8393307586469154`*^9, 3.839330774655125*^9}, {
   3.8393308208469334`*^9, 3.8393308254369345`*^9}, {3.83933092079788*^9, 
   3.8393310148602314`*^9}, {3.8393311745075006`*^9, 
   3.8393311994275675`*^9}, {3.8393312620131807`*^9, 
   3.8393312886598005`*^9}, {3.83933158528376*^9, 3.8393316720258255`*^9}, 
   3.8393317188850336`*^9, {3.8393317973728094`*^9, 3.8393319397094903`*^9}, 
   3.8393320294844685`*^9, {3.8393325727147913`*^9, 3.8393326007437224`*^9}, {
   3.839332643937569*^9, 3.8393326886712303`*^9}, {3.839332884251463*^9, 
   3.8393328849388123`*^9}, {3.8393329498885293`*^9, 3.839332954368989*^9}, 
   3.839332984548478*^9, {3.839333161836732*^9, 3.839333179429063*^9}, {
   3.839333212168277*^9, 3.8393332158859396`*^9}, {3.839333299885914*^9, 
   3.839333320058819*^9}, {3.8393333662749724`*^9, 3.839333389618166*^9}, 
   3.8393335815372777`*^9, {3.8393336646381135`*^9, 3.839333690640252*^9}, {
   3.839333816187891*^9, 3.839333852596138*^9}, {3.839333913143673*^9, 
   3.839333960953573*^9}, {3.8393340547869487`*^9, 3.839334137419753*^9}, {
   3.839420765475212*^9, 3.839420767706482*^9}, {3.839420800720344*^9, 
   3.83942080814257*^9}, {3.839420930166752*^9, 3.839420954611184*^9}, 
   3.839421093306271*^9, {3.839421249787591*^9, 3.8394213460868835`*^9}, {
   3.839421400152422*^9, 3.8394214417353144`*^9}, {3.839421483648677*^9, 
   3.839421580608614*^9}, 3.839421616079374*^9, 3.839422181142932*^9, {
   3.8394224472930202`*^9, 3.839422448371497*^9}, {3.8394225405886507`*^9, 
   3.839422541885687*^9}, {3.8394225839963813`*^9, 3.83942258751882*^9}, 
   3.8394239784679832`*^9, {3.8394240190394516`*^9, 3.8394240194005165`*^9}, {
   3.839481241680246*^9, 3.8394812636526537`*^9}, {3.8394813033197775`*^9, 
   3.839481343020226*^9}, {3.8394813886318493`*^9, 3.83948138904453*^9}, {
   3.8394814470082235`*^9, 3.8394815138762083`*^9}, {3.839484145142799*^9, 
   3.8394841575703464`*^9}, {3.8394842427712455`*^9, 
   3.8394842456191454`*^9}, {3.8394844396674995`*^9, 
   3.8394844660440836`*^9}, {3.8394845806487627`*^9, 3.83948460808449*^9}, {
   3.8394847191879005`*^9, 3.839484719920673*^9}, {3.8394847985864277`*^9, 
   3.8394847999498053`*^9}, {3.839485522225484*^9, 3.8394858614478054`*^9}, {
   3.8394858968609977`*^9, 3.8394858979280567`*^9}, {3.83950394022218*^9, 
   3.839504016595684*^9}, {3.839504079022719*^9, 3.8395041716366367`*^9}, {
   3.8395042475063295`*^9, 3.83950424807436*^9}, {3.8395043044033585`*^9, 
   3.8395043325148754`*^9}, {3.839504403912784*^9, 3.839504405955762*^9}, {
   3.839504461254238*^9, 3.8395044954062967`*^9}, {3.839504572085556*^9, 
   3.8395046258331623`*^9}, {3.839504718095887*^9, 3.839504733043982*^9}, {
   3.839504792704324*^9, 3.8395048214714227`*^9}, {3.8395048602645364`*^9, 
   3.839504871422516*^9}, {3.83950521161292*^9, 3.8395052235501237`*^9}, {
   3.839505255990897*^9, 3.8395052773582516`*^9}, {3.839505321851119*^9, 
   3.839505332451271*^9}, {3.8395054257374*^9, 3.8395054385582395`*^9}, 
   3.839505580972617*^9, {3.8395057025144815`*^9, 3.8395057031788645`*^9}, {
   3.8395057369934807`*^9, 3.8395057373979363`*^9}, {3.839505772294227*^9, 
   3.839505778367197*^9}, {3.83950673092721*^9, 3.8395067795192204`*^9}, {
   3.8395084122279215`*^9, 3.8395084138977666`*^9}, {3.839508448233049*^9, 
   3.8395084493422976`*^9}, {3.839508499051385*^9, 3.8395085344200335`*^9}, 
   3.8395086207285233`*^9, {3.8395086973952723`*^9, 3.8395086978689127`*^9}, {
   3.8395089696790757`*^9, 3.839509039224576*^9}, {3.8395100524490423`*^9, 
   3.839510053723009*^9}, {3.839511493807127*^9, 3.8395115089839754`*^9}, {
   3.8395115931589155`*^9, 3.839511633911852*^9}, {3.839511664551564*^9, 
   3.8395117021779413`*^9}, {3.839511738662855*^9, 3.8395117683886237`*^9}, {
   3.8395840465025244`*^9, 3.8395840478719764`*^9}, {3.8395842326636224`*^9, 
   3.8395842405526743`*^9}, {3.8395844072352886`*^9, 3.839584438590257*^9}, {
   3.839584539157859*^9, 3.839584558647271*^9}, {3.8395846133789663`*^9, 
   3.83958465811094*^9}, {3.839584785836444*^9, 3.839584807986281*^9}, 
   3.839586726652771*^9, {3.8395867995416994`*^9, 3.8395868420413933`*^9}, 
   3.83958688638865*^9, {3.839587244941451*^9, 3.83958726487414*^9}, {
   3.83958774293878*^9, 3.8395877838602095`*^9}, 3.839587828597546*^9, {
   3.839587879706158*^9, 3.8395879135449758`*^9}, {3.839587955043039*^9, 
   3.8395879642045746`*^9}, {3.8395880048781385`*^9, 3.839588051406326*^9}, {
   3.8395880883490973`*^9, 3.8395881594520197`*^9}, {3.8395882347911615`*^9, 
   3.8395883226336384`*^9}, 3.8395883559509153`*^9, 3.839588415451826*^9, {
   3.8395884902783833`*^9, 3.8395885216082554`*^9}, {3.8395941073926105`*^9, 
   3.8395942227438965`*^9}, 3.839595304916483*^9, {3.8395954862576475`*^9, 
   3.83959557521957*^9}, {3.839595607221432*^9, 3.8395956076140194`*^9}, {
   3.839595660820343*^9, 3.839595661835729*^9}, {3.839604650775865*^9, 
   3.8396046640054827`*^9}, {3.839604708532463*^9, 3.8396047629301977`*^9}, {
   3.839604795558606*^9, 3.839604808947177*^9}, {3.839604852056878*^9, 
   3.8396048690185547`*^9}, {3.839642088079403*^9, 3.839642141004441*^9}, {
   3.8396422800918975`*^9, 3.8396423077286944`*^9}, {3.8396424143783884`*^9, 
   3.8396424152236857`*^9}, {3.8396426095904264`*^9, 
   3.8396426100591545`*^9}, {3.8396426843268356`*^9, 3.8396426912164164`*^9}, 
   3.8396427676568155`*^9, {3.8396428549330425`*^9, 3.8396429650459213`*^9}, 
   3.839643049962629*^9, {3.839643091872772*^9, 3.8396431410841303`*^9}, 
   3.839643491656567*^9, {3.839643550041149*^9, 3.839643610060313*^9}, {
   3.8396436783391447`*^9, 3.8396437059963512`*^9}, {3.8396437389632745`*^9, 
   3.8396437448257093`*^9}, {3.839643793497415*^9, 3.8396438275668716`*^9}, {
   3.839643978745996*^9, 3.8396439798436737`*^9}, {3.839644021519642*^9, 
   3.8396440428152156`*^9}, {3.8396441695399504`*^9, 
   3.8396441971715937`*^9}, {3.839644230142295*^9, 3.8396442469945946`*^9}, {
   3.839644284692358*^9, 3.8396442961501245`*^9}, {3.8396443434969287`*^9, 
   3.8396443583914576`*^9}, {3.8396448346105194`*^9, 3.839644913123821*^9}, {
   3.8396555898716025`*^9, 3.839655650012109*^9}, {3.8396556822310605`*^9, 
   3.839655771771843*^9}, {3.839655952479162*^9, 3.8396559541084647`*^9}, 
   3.839656003389371*^9, {3.8396560347174463`*^9, 3.839656116850046*^9}, {
   3.8396562422855325`*^9, 3.8396562713341274`*^9}, 3.8396563271846943`*^9, {
   3.8396565529884825`*^9, 3.839656667985509*^9}, {3.8396568526250334`*^9, 
   3.839656873162519*^9}, {3.8396570321068354`*^9, 3.8396570367161813`*^9}, {
   3.8396571621919303`*^9, 3.839657193340761*^9}, {3.839657225174745*^9, 
   3.8396572442512493`*^9}, {3.8396572932236905`*^9, 3.8396572940165*^9}, 
   3.8396574072631903`*^9, {3.8396575476060143`*^9, 3.8396575682943974`*^9}, {
   3.839664138921971*^9, 3.839664156869915*^9}, 3.839664243007531*^9, {
   3.839669622125418*^9, 3.839669647884663*^9}, {3.839670002387182*^9, 
   3.839670025487237*^9}, {3.8396700586539392`*^9, 3.8396701085420904`*^9}, {
   3.8396766028729286`*^9, 3.839676603372811*^9}, {3.839676649783103*^9, 
   3.8396766681979322`*^9}, {3.839723206211033*^9, 3.839723252419324*^9}, {
   3.8397243192805915`*^9, 3.8397243622670403`*^9}, {3.839724526690404*^9, 
   3.8397245565593586`*^9}, 3.839724591814554*^9, {3.8397246526353917`*^9, 
   3.8397246677187424`*^9}, {3.839724698665658*^9, 3.8397248461537275`*^9}, {
   3.839724910156172*^9, 3.839724969029936*^9}, {3.839725029399225*^9, 
   3.839725070375955*^9}, {3.8397257491640964`*^9, 3.8397258148584566`*^9}, {
   3.839726205531111*^9, 3.839726226304987*^9}, {3.839726314389023*^9, 
   3.8397264887181263`*^9}, {3.8397266355093994`*^9, 
   3.8397266356472826`*^9}, {3.839727069639051*^9, 3.83972707062368*^9}, {
   3.8397274615058823`*^9, 3.839727481527841*^9}, {3.83972755827617*^9, 
   3.8397275594724007`*^9}, {3.839727857737072*^9, 3.83972788618902*^9}, 
   3.8397281801577473`*^9, {3.839741406815917*^9, 3.839741648719699*^9}, 
   3.839741694966459*^9, {3.8397417738301263`*^9, 3.8397417740488653`*^9}, 
   3.839742014559319*^9, {3.8397421882027674`*^9, 3.839742188943444*^9}, {
   3.8397589658528605`*^9, 3.83975903164762*^9}, {3.839759582024466*^9, 
   3.8397596437148447`*^9}, {3.8397597378135786`*^9, 3.839759770277839*^9}, {
   3.839760042248042*^9, 3.8397600434337606`*^9}, {3.839760792865179*^9, 
   3.839760817913896*^9}, {3.8397655048182044`*^9, 3.839765505036851*^9}, {
   3.839765649791177*^9, 3.839765680039174*^9}, {3.839765730951825*^9, 
   3.8397657438209515`*^9}, {3.8397658325268707`*^9, 3.839765870890603*^9}, {
   3.8397695336031294`*^9, 3.8397695785421767`*^9}, 3.839769610638837*^9, {
   3.839769642999297*^9, 3.8397696900062704`*^9}, {3.8397697294324865`*^9, 
   3.839769753667972*^9}, 3.839770624201335*^9, {3.8399858643515997`*^9, 
   3.839985870106961*^9}, {3.8399859073530426`*^9, 3.83998590778368*^9}, {
   3.839986665758301*^9, 3.839986671600184*^9}, {3.840015477117873*^9, 
   3.840015532633871*^9}, {3.840262190474472*^9, 3.8402621922160215`*^9}, {
   3.8402622512898836`*^9, 3.8402623158498154`*^9}, {3.840262346847395*^9, 
   3.840262361938197*^9}, {3.8402624446884875`*^9, 3.840262497278998*^9}, {
   3.8402625593196363`*^9, 3.840262562846277*^9}, {3.840262654524027*^9, 
   3.8402626673364897`*^9}, {3.8402800661176753`*^9, 3.840280138278593*^9}, {
   3.840280177703832*^9, 3.840280189480773*^9}, {3.8402802324576406`*^9, 
   3.8402802331825943`*^9}, {3.8402812754975386`*^9, 3.840281326464582*^9}, 
   3.8402813946519136`*^9, {3.84028186111417*^9, 3.8402818954912634`*^9}, {
   3.8402819964993353`*^9, 3.8402819971437144`*^9}, {3.840330466229367*^9, 
   3.8403304972505484`*^9}, 3.8403305401374164`*^9, 3.840330628649666*^9, {
   3.8403306672934227`*^9, 3.8403306802026963`*^9}, {3.8403307193320885`*^9, 
   3.840330758272279*^9}, 3.8403307967908325`*^9, 3.8403308358680725`*^9, {
   3.840330872410847*^9, 3.8403308786837*^9}, {3.8403309221453967`*^9, 
   3.840330944340696*^9}, 3.840330989285677*^9, {3.840331109810131*^9, 
   3.840331153164013*^9}, {3.840331431580937*^9, 3.8403314406879196`*^9}, {
   3.8403317789283185`*^9, 3.840331780542934*^9}, {3.840331813886128*^9, 
   3.8403318320633073`*^9}, {3.8403318821336937`*^9, 
   3.8403318897950106`*^9}, {3.8403319357741313`*^9, 
   3.8403319411825953`*^9}, {3.8403320129500637`*^9, 
   3.8403321277278547`*^9}, {3.840332221075777*^9, 3.8403322212632327`*^9}, {
   3.8404162792747984`*^9, 3.8404162803058043`*^9}, {3.840416344690134*^9, 
   3.8404163448306866`*^9}, {3.8404178626090136`*^9, 3.840417925824424*^9}, {
   3.8404191918191233`*^9, 3.84041920226635*^9}, {3.840419242024495*^9, 
   3.8404192617321796`*^9}, {3.8404194389428053`*^9, 3.840419462557069*^9}, {
   3.840453834266838*^9, 3.8404538447517056`*^9}, 3.840453909614043*^9, {
   3.8404539683635793`*^9, 3.8404539905838337`*^9}, 3.8404540272985306`*^9, {
   3.840454156166298*^9, 3.840454205291971*^9}, {3.840454240247527*^9, 
   3.8404542540157146`*^9}, {3.8404543237333283`*^9, 
   3.8404543404928937`*^9}, {3.8404544521143074`*^9, 
   3.8404544541302176`*^9}, {3.840454485008524*^9, 3.8404544958331428`*^9}, {
   3.840454535970628*^9, 3.840454551137659*^9}, {3.840500625089159*^9, 
   3.840500656940725*^9}, {3.840500695345143*^9, 3.8405006960523067`*^9}, {
   3.8405010969852047`*^9, 3.840501112587641*^9}, {3.840501150634077*^9, 
   3.8405011611522417`*^9}, {3.8405026446645527`*^9, 3.84050265267775*^9}, 
   3.8405026878215275`*^9, 3.8405027886745453`*^9, {3.8405028323157024`*^9, 
   3.8405028521056433`*^9}, {3.840508597751215*^9, 3.8405086042448597`*^9}, {
   3.8405086361734276`*^9, 3.840508697640854*^9}, {3.84530515034306*^9, 
   3.8453051663199177`*^9}, 3.845305197884505*^9, {3.8454792808354254`*^9, 
   3.8454794150956697`*^9}, {3.845479722113243*^9, 3.8454797915964413`*^9}, {
   3.845514873929638*^9, 3.8455149337268724`*^9}, {3.8455149684706416`*^9, 
   3.8455149695080223`*^9}, {3.8455153275220933`*^9, 3.845515328229957*^9}, {
   3.845515395675539*^9, 3.845515401297691*^9}, {3.845515515853771*^9, 
   3.845515576447665*^9}, {3.845515612558851*^9, 3.845515632979537*^9}, {
   3.845515680153039*^9, 3.8455159262376585`*^9}, {3.845516112061887*^9, 
   3.8455161465263453`*^9}, {3.845516193085106*^9, 3.845516229178423*^9}, {
   3.8455163351689043`*^9, 3.845516585318216*^9}, {3.8455166177397394`*^9, 
   3.845516714733508*^9}, {3.845516771645197*^9, 3.8455167731827154`*^9}, {
   3.845516818729296*^9, 3.84551695860878*^9}, {3.845516994711903*^9, 
   3.845517026462266*^9}, 3.845517092145789*^9, {3.845517135366593*^9, 
   3.845517155446496*^9}, {3.845517186534149*^9, 3.8455171937276707`*^9}, {
   3.845517227012909*^9, 3.8455172279061613`*^9}, {3.8455173234132085`*^9, 
   3.8455173514857492`*^9}, {3.845517423730919*^9, 3.8455174243493695`*^9}, {
   3.8455174624069753`*^9, 3.845517465100626*^9}, 3.845517507705373*^9, 
   3.8455175508535676`*^9, {3.8455176264044795`*^9, 3.8455176334075813`*^9}, {
   3.8455313319229393`*^9, 3.845531509940443*^9}, 3.8455315849840965`*^9, {
   3.8455317016782956`*^9, 3.845531738966821*^9}, {3.845531778451456*^9, 
   3.845531779386674*^9}, {3.8456415428113813`*^9, 3.845641735457308*^9}, {
   3.8456420427094593`*^9, 3.8456420444008894`*^9}, {3.8456420953927226`*^9, 
   3.845642095827136*^9}, {3.8456421305858717`*^9, 3.8456422084386454`*^9}, 
   3.8456422719473834`*^9, {3.8456424654126687`*^9, 3.8456424685516415`*^9}, {
   3.8456425391271963`*^9, 3.845642581942461*^9}, {3.8456426396045694`*^9, 
   3.845642806094469*^9}, {3.845642836196087*^9, 3.845642900922883*^9}, {
   3.845642970285206*^9, 3.8456430181273146`*^9}, {3.8456430708546114`*^9, 
   3.845643125882959*^9}, {3.845643178575968*^9, 3.845643257358486*^9}, {
   3.8456433623862553`*^9, 3.8456433771042914`*^9}, {3.8456434590863156`*^9, 
   3.8456434937160645`*^9}, 3.845643545927831*^9, {3.845643600156926*^9, 
   3.845643618570978*^9}, {3.8456436644300175`*^9, 3.84564366503797*^9}, {
   3.845643702197648*^9, 3.8456437461979747`*^9}, 3.8456439574887114`*^9, {
   3.846069818172841*^9, 3.846069849642768*^9}, {3.8460699136765876`*^9, 
   3.846069914209477*^9}, {3.8460699599440656`*^9, 3.8460700314146757`*^9}, {
   3.846070076753316*^9, 3.846070077439046*^9}, {3.846070157661101*^9, 
   3.8460701937707815`*^9}, {3.846070258127372*^9, 3.846070370035694*^9}, 
   3.8460704231130123`*^9, {3.846070456017062*^9, 3.8460704588184586`*^9}, {
   3.8460710172041235`*^9, 3.846071021582673*^9}, {3.846071106666136*^9, 
   3.8460711227728405`*^9}, {3.846071236516765*^9, 3.8460712690613956`*^9}, {
   3.846071302508814*^9, 3.8460713286265783`*^9}, {3.846071391711331*^9, 
   3.8460713919222136`*^9}, {3.8460717432565613`*^9, 3.846071846163582*^9}, {
   3.8460718796339417`*^9, 3.8460718981181345`*^9}, {3.8460719281852317`*^9, 
   3.8460719602156863`*^9}, {3.8460725487311463`*^9, 
   3.8460727277222366`*^9}, {3.8460727966336946`*^9, 
   3.8460727999447126`*^9}, {3.8460728715731387`*^9, 3.846072900231036*^9}, 
   3.8460729488995743`*^9, 3.846073094187673*^9, {3.846073124968068*^9, 
   3.846073143649494*^9}, {3.846073291437569*^9, 3.846073320871194*^9}, {
   3.8460733513356*^9, 3.8460733827836275`*^9}, {3.8460734213260293`*^9, 
   3.846073547913215*^9}, {3.8460735888598585`*^9, 3.8460735948494663`*^9}, {
   3.8460736630482445`*^9, 3.84607366906472*^9}, {3.846073769039547*^9, 
   3.8460738022300262`*^9}, {3.8460738788770266`*^9, 
   3.8460738952181954`*^9}, {3.846073949966679*^9, 3.8460739569065495`*^9}, {
   3.846074029073464*^9, 3.8460740346596146`*^9}, {3.846074102104647*^9, 
   3.8460741324118767`*^9}, {3.8460741949049115`*^9, 3.846074222593691*^9}, {
   3.8460742841895127`*^9, 3.846074340763191*^9}, {3.846160732253354*^9, 
   3.8461607332481594`*^9}, 3.846161492762432*^9, {3.846161780897497*^9, 
   3.846161788138113*^9}, {3.8461618293598766`*^9, 3.846161858226082*^9}, {
   3.8461618966585674`*^9, 3.846161969794857*^9}, 3.846162102689354*^9, {
   3.8461621668466263`*^9, 3.846162180355235*^9}, {3.8461622164826603`*^9, 
   3.8461622355856447`*^9}, {3.846162281065609*^9, 3.8461624985309367`*^9}, 
   3.8461626621493115`*^9, 3.846162697816634*^9, {3.8461627342864695`*^9, 
   3.8461627345822268`*^9}, {3.8461628166006966`*^9, 3.8461628174265194`*^9}, 
   3.846162849529516*^9, 3.846163042718745*^9, {3.8461630926561747`*^9, 
   3.8461631014520173`*^9}, 3.846164675187914*^9, {3.8461653709571285`*^9, 
   3.8461653939322076`*^9}, {3.846239297565034*^9, 3.846239321709072*^9}, {
   3.8462393704866405`*^9, 3.846239378462596*^9}, 3.8462394463604927`*^9, {
   3.846239908200873*^9, 3.846240041118046*^9}, {3.8462400979595313`*^9, 
   3.8462402075029526`*^9}, {3.846240330599819*^9, 3.846240332116249*^9}, {
   3.846240396409835*^9, 3.846240426609739*^9}, {3.8462404635946035`*^9, 
   3.846240479194495*^9}, {3.846240547126852*^9, 3.8462406007711906`*^9}, {
   3.846240672984129*^9, 3.8462406735655537`*^9}, {3.846240715451014*^9, 
   3.846240727662325*^9}, {3.8462408398048706`*^9, 3.8462408550133176`*^9}, {
   3.846240906219432*^9, 3.8462409845731764`*^9}, {3.8462415426024213`*^9, 
   3.846241600241384*^9}, {3.8462416533016524`*^9, 3.8462416824345474`*^9}, {
   3.846241871443136*^9, 3.846241889026347*^9}, {3.84624196622915*^9, 
   3.846241982209696*^9}, {3.8462420839315395`*^9, 3.8462421106657743`*^9}, {
   3.8462493213059616`*^9, 3.846249371505189*^9}, {3.846249426216957*^9, 
   3.8462494677076874`*^9}, {3.846249549506504*^9, 3.8462495503135986`*^9}, {
   3.8463317012472258`*^9, 3.846331723789422*^9}, 3.846331790148814*^9, {
   3.846331841946804*^9, 3.8463318642788124`*^9}, {3.8463318999649568`*^9, 
   3.84633190085021*^9}, {3.846331970187175*^9, 3.8463319724350276`*^9}, {
   3.846332425994608*^9, 3.8463324267831564`*^9}, {3.8463324853767433`*^9, 
   3.846332505743512*^9}, {3.84633253640195*^9, 3.84633253746087*^9}, 
   3.8463325927468147`*^9, {3.846332664076268*^9, 3.84633267729871*^9}, {
   3.84633282094595*^9, 3.846332866648316*^9}, {3.846332915983061*^9, 
   3.846332964772069*^9}, {3.8463332315659857`*^9, 3.8463332589840655`*^9}, {
   3.8463333159368706`*^9, 3.8463333881232243`*^9}, {3.846333478174964*^9, 
   3.846333507307977*^9}, {3.8463337169753866`*^9, 3.846333752677167*^9}, {
   3.8463337874930525`*^9, 3.8463337938266315`*^9}, {3.84633382889653*^9, 
   3.8463338314544067`*^9}, {3.8463338661347585`*^9, 
   3.8463338671064034`*^9}, {3.8463341029946103`*^9, 3.8463341178046017`*^9}, 
   3.8463344961508446`*^9, {3.846334551477289*^9, 3.8463345669722776`*^9}, {
   3.846334647851037*^9, 3.8463346507709723`*^9}, {3.8463350072556896`*^9, 
   3.846335009531336*^9}, {3.8463350584383993`*^9, 3.8463350832915545`*^9}, 
   3.8463356730391445`*^9, {3.8463357330577507`*^9, 3.846335734677639*^9}, {
   3.8463357713912954`*^9, 3.846335784599365*^9}, {3.846335824451017*^9, 
   3.846335850541898*^9}, {3.8465148279290648`*^9, 3.846514905645626*^9}, {
   3.8465149546536207`*^9, 3.8465149557287645`*^9}, 3.8465150347627506`*^9, 
   3.8465150735123754`*^9, 3.846515133355834*^9, {3.846551496354246*^9, 
   3.8465515199215117`*^9}, {3.8465515514860935`*^9, 3.846551558453719*^9}, {
   3.8465516511605453`*^9, 3.8465516816971188`*^9}, {3.8465517493251767`*^9, 
   3.8465517819787836`*^9}, {3.846551812162984*^9, 3.84655181978378*^9}, {
   3.8469012753631597`*^9, 3.8469014245266294`*^9}, {3.846901477101201*^9, 
   3.846901480891117*^9}, 3.846901533852523*^9, {3.8469015653056993`*^9, 
   3.8469015942691755`*^9}, 3.8469016260053563`*^9, {3.846901664939994*^9, 
   3.8469016657155457`*^9}, {3.846901747509447*^9, 3.8469017503170366`*^9}, {
   3.84690191404624*^9, 3.84690193970901*^9}, 3.846901985149589*^9, {
   3.84690203255608*^9, 3.8469020373058805`*^9}, {3.8469021528510695`*^9, 
   3.84690220430954*^9}, {3.8469022448931456`*^9, 3.8469022504597807`*^9}, {
   3.846902285388745*^9, 3.846902288603936*^9}, {3.8469023384879513`*^9, 
   3.846902371933584*^9}, 3.846902765731144*^9, {3.8469028332433987`*^9, 
   3.8469028443561935`*^9}, 3.8469030843801355`*^9, 3.846903160980903*^9, {
   3.8469032059828815`*^9, 3.8469032390870132`*^9}, {3.84690342310567*^9, 
   3.846903439207902*^9}, {3.8469061580301685`*^9, 3.8469062645476227`*^9}, {
   3.8469065486448135`*^9, 3.846906561548581*^9}, {3.8469067471371455`*^9, 
   3.8469068174896765`*^9}, {3.84690686154051*^9, 3.8469068684523077`*^9}, {
   3.8497527618146653`*^9, 3.8497527676380615`*^9}, {3.8497528414079475`*^9, 
   3.849752843454638*^9}, {3.8497530625145917`*^9, 3.849753063032662*^9}, {
   3.8497530971084747`*^9, 3.8497531011988783`*^9}, {3.8497532258666143`*^9, 
   3.849753345755213*^9}, {3.849753924288494*^9, 3.849753985952464*^9}, {
   3.849754069460248*^9, 3.849754087001464*^9}, {3.849754259204835*^9, 
   3.849754268999332*^9}, {3.8497554284565487`*^9, 3.8497554930272894`*^9}, {
   3.849755685279069*^9, 3.8497556896240177`*^9}, {3.8497558773614607`*^9, 
   3.849755877843891*^9}, {3.8497559807269473`*^9, 3.8497560211165953`*^9}, 
   3.850443650520732*^9, {3.8504438404083548`*^9, 3.8504441120345283`*^9}, {
   3.850444156664489*^9, 3.850444280967318*^9}, {3.850444354744196*^9, 
   3.85044463643923*^9}, {3.8504447256702757`*^9, 3.8504447980665684`*^9}, {
   3.8505274395909743`*^9, 3.8505274411181674`*^9}, {3.8505275310510144`*^9, 
   3.8505276349685197`*^9}, {3.850527665564816*^9, 3.850527741150744*^9}, {
   3.850528010969228*^9, 3.8505280914370484`*^9}, {3.850528341539154*^9, 
   3.8505283435766478`*^9}, {3.850528399268195*^9, 3.850528452926201*^9}, {
   3.850528511901552*^9, 3.850528524032834*^9}, {3.8505286008142643`*^9, 
   3.8505286255862675`*^9}, {3.850528657292616*^9, 3.8505287485299587`*^9}, {
   3.850528791091945*^9, 3.8505287912193995`*^9}, {3.8505289892778673`*^9, 
   3.8505290093703814`*^9}, {3.8505291179397283`*^9, 3.850529246368305*^9}, {
   3.8505292847200036`*^9, 3.8505293531238484`*^9}, {3.85052942526715*^9, 
   3.8505295026053452`*^9}, {3.850529652810694*^9, 3.85052969888447*^9}, {
   3.8505297570230837`*^9, 3.8505297793908668`*^9}, {3.8505298130474796`*^9, 
   3.85052982372943*^9}, 3.850529903643921*^9, {3.8505299339680395`*^9, 
   3.850529938523468*^9}, {3.850533467746894*^9, 3.850533696587976*^9}, {
   3.8505337523084393`*^9, 3.8505340100220647`*^9}, {3.850534073301394*^9, 
   3.8505341115212436`*^9}, {3.8505341448690495`*^9, 3.850534244609003*^9}, {
   3.8505342773409953`*^9, 3.850534317485276*^9}, {3.850534376818581*^9, 
   3.8505345375059347`*^9}, 3.8505345895823593`*^9, {3.850534712936541*^9, 
   3.850534853983102*^9}, {3.85053489565536*^9, 3.85053490800423*^9}, {
   3.850535011630887*^9, 3.850535069369616*^9}, {3.8505609789941187`*^9, 
   3.8505609796472797`*^9}, {3.850561024378234*^9, 3.8505611077291512`*^9}, {
   3.8505611554662695`*^9, 3.8505611900834045`*^9}, {3.8505612604815354`*^9, 
   3.850561307036023*^9}, 3.8505614161973686`*^9, {3.850561489892841*^9, 
   3.8505614904828854`*^9}, 3.850561540476676*^9, {3.850566961415826*^9, 
   3.85056699607444*^9}, {3.8505670465401917`*^9, 3.850567067268143*^9}, {
   3.850567124561453*^9, 3.8505671481746936`*^9}, {3.8505671891195374`*^9, 
   3.850567192972233*^9}, {3.8505672404233675`*^9, 3.850567272319547*^9}, {
   3.8505673802869396`*^9, 3.850567388289441*^9}, {3.850567420051065*^9, 
   3.8505674379775977`*^9}, {3.850568113924102*^9, 3.850568121245113*^9}, {
   3.8505681786419373`*^9, 3.8505682190225987`*^9}, {3.8505682742836356`*^9, 
   3.8505682972999997`*^9}, {3.850568330443387*^9, 3.8505683415549088`*^9}, {
   3.850568377492758*^9, 3.850568403154665*^9}, {3.850568837097434*^9, 
   3.850568946787299*^9}, {3.8505691453292117`*^9, 3.850569195539899*^9}, {
   3.8505692859376397`*^9, 3.8505693669331837`*^9}, {3.8505693974289236`*^9, 
   3.8505695475039663`*^9}, {3.8505696079724298`*^9, 
   3.8505696221275873`*^9}, {3.8505697874854712`*^9, 
   3.8505698175396166`*^9}, {3.850569868969412*^9, 3.8505698726296372`*^9}, {
   3.850569905926787*^9, 3.8505699809036593`*^9}, {3.850570015920215*^9, 
   3.85057008172045*^9}, {3.850785556912866*^9, 3.850785616614393*^9}, {
   3.8507856606466494`*^9, 3.850785723209618*^9}, {3.8507857656066175`*^9, 
   3.850785880874487*^9}, {3.850785924508508*^9, 3.850785937300992*^9}, {
   3.8507859750545197`*^9, 3.8507859968100834`*^9}, {3.850786077342246*^9, 
   3.8507860848236823`*^9}, {3.8507861340867023`*^9, 3.8507861374599075`*^9}, 
   3.850786227982345*^9, {3.8507862859910107`*^9, 3.8507863008387175`*^9}, {
   3.850786368316942*^9, 3.850786374976062*^9}, {3.850786423270744*^9, 
   3.850786423425295*^9}, {3.8507865491264324`*^9, 3.850786595976322*^9}, {
   3.850786636570469*^9, 3.850786709325587*^9}, {3.850786743990263*^9, 
   3.8507868015086374`*^9}, {3.8507870134211025`*^9, 
   3.8507870176048164`*^9}, {3.850787059141889*^9, 3.8507870650224657`*^9}, {
   3.850787111878257*^9, 3.850787113157389*^9}, {3.8507887599989805`*^9, 
   3.850788841851822*^9}, {3.850788913491912*^9, 3.8507890311085014`*^9}, {
   3.8507890809695005`*^9, 3.8507890902738066`*^9}, {3.8507891921970196`*^9, 
   3.8507891973037043`*^9}, {3.8507892279462795`*^9, 3.850789249495205*^9}, {
   3.850791412876636*^9, 3.8507914130273633`*^9}, {3.8507915155633483`*^9, 
   3.8507915162424593`*^9}, {3.850827343188859*^9, 3.850827375432101*^9}, {
   3.8508274109868975`*^9, 3.8508274369062905`*^9}, {3.8508274890786314`*^9, 
   3.8508274894138756`*^9}, {3.8508275695516253`*^9, 3.850827569788695*^9}, 
   3.8508276711587315`*^9, {3.8508277166165743`*^9, 3.8508277728386536`*^9}, {
   3.8508278475513325`*^9, 3.8508278753498926`*^9}, {3.8508279408872223`*^9, 
   3.85082794118405*^9}, {3.850827981298354*^9, 3.850828056921221*^9}, {
   3.850828494113824*^9, 3.850828495039543*^9}, {3.85082856023905*^9, 
   3.850828575017256*^9}, {3.850828628892047*^9, 3.850828696248144*^9}, 
   3.8508287630158415`*^9, {3.8508293694951773`*^9, 3.850829372071825*^9}, {
   3.8508294221130056`*^9, 3.8508294474505587`*^9}, {3.8508295136154523`*^9, 
   3.850829546786518*^9}, {3.8508307551495695`*^9, 3.850830755305548*^9}, {
   3.850830846425475*^9, 3.8508308469949007`*^9}, {3.8508328226756153`*^9, 
   3.8508328956454206`*^9}, {3.8515151599360895`*^9, 
   3.8515151854097323`*^9}, {3.851515227511881*^9, 3.8515152691971846`*^9}, {
   3.8517376565999703`*^9, 3.851737660729647*^9}, {3.8517376993937993`*^9, 
   3.851737854226467*^9}, {3.8517379030659018`*^9, 3.851737963592141*^9}, {
   3.8517380004040184`*^9, 3.851738156849004*^9}, {3.8517381881441555`*^9, 
   3.8517383547150526`*^9}, {3.851738403578961*^9, 3.8517384750343685`*^9}, {
   3.8517386329884996`*^9, 3.8517387036807384`*^9}, {3.8517387496128297`*^9, 
   3.8517391066461697`*^9}, 3.851739167106615*^9, {3.851739199324179*^9, 
   3.8517392033202653`*^9}, {3.851739306865944*^9, 3.8517396012506447`*^9}, {
   3.8517396478337793`*^9, 3.851739717012961*^9}, {3.851739779861041*^9, 
   3.8517398251446857`*^9}, {3.8517401674121*^9, 3.85174023031291*^9}, {
   3.8517403822763968`*^9, 3.8517405215277195`*^9}, {3.8517405598035936`*^9, 
   3.8517405807347307`*^9}, 3.8517406111741548`*^9, {3.852771815388609*^9, 
   3.852771815826337*^9}, {3.852771938933034*^9, 3.852772015527173*^9}, {
   3.8527720455326405`*^9, 3.852772051655347*^9}, {3.852772112575083*^9, 
   3.85277216712604*^9}, {3.8527722639917727`*^9, 3.8527723193930345`*^9}, {
   3.8527723507994275`*^9, 3.8527724886441803`*^9}, 3.852772518958836*^9, {
   3.8527726690962496`*^9, 3.8527726724595623`*^9}, {3.852772785224839*^9, 
   3.852772814059412*^9}, {3.8527728536940055`*^9, 3.8527728543197746`*^9}, 
   3.8527728940919833`*^9, {3.8527729250196114`*^9, 3.8527729905347033`*^9}, {
   3.8527730490675783`*^9, 3.8527730529881525`*^9}, {3.852773399558672*^9, 
   3.852773411256092*^9}, {3.852773459331044*^9, 3.852773480723246*^9}, {
   3.8527735251577444`*^9, 3.8527735647772226`*^9}, {3.85277372440212*^9, 
   3.852773727144375*^9}, {3.8528731960002193`*^9, 3.8528733256878357`*^9}, {
   3.852873387704274*^9, 3.852873409884766*^9}, {3.8528734508562613`*^9, 
   3.8528734515817213`*^9}, {3.8528734901873713`*^9, 3.852873528186962*^9}, {
   3.8528735614708843`*^9, 3.8528735812376013`*^9}, {3.8528736531146784`*^9, 
   3.852873677620881*^9}, {3.8528801200331235`*^9, 3.852880146194016*^9}, {
   3.853140879673688*^9, 3.8531409143592653`*^9}, {3.8531409625201416`*^9, 
   3.8531410288764524`*^9}, {3.8531410590292354`*^9, 
   3.8531411087537766`*^9}, {3.906960081539485*^9, 3.9069602331152077`*^9}, {
   3.9069603433707557`*^9, 3.906960532270595*^9}, {3.9069608107416534`*^9, 
   3.906960894501176*^9}, 3.906976975428384*^9, 3.9069784461360517`*^9, {
   3.9069784939955707`*^9, 3.906978495519633*^9}, {3.906979520056976*^9, 
   3.906979527909192*^9}, {3.9070299969708767`*^9, 3.9070299973647575`*^9}, 
   3.9070302622793455`*^9, {3.907031054878291*^9, 3.907031101672268*^9}, {
   3.907031132657627*^9, 3.907031137965227*^9}, {3.907031258015709*^9, 
   3.907031258244317*^9}, 3.907060462885079*^9, {3.9070616210919228`*^9, 
   3.9070617379829817`*^9}, {3.9070618359373693`*^9, 
   3.9070618491419787`*^9}, {3.9072168098312087`*^9, 
   3.9072168879034996`*^9}, {3.9072169598535347`*^9, 
   3.9072169971857233`*^9}, {3.9072170607219973`*^9, 3.907217066892645*^9}, {
   3.9076577595519457`*^9, 3.9076578173877373`*^9}, {3.9076578614233837`*^9, 
   3.907657894347175*^9}, {3.9076579602806206`*^9, 3.9076579846181087`*^9}, {
   3.9076596607447786`*^9, 3.9076596756372747`*^9}, 3.910745605690302*^9, {
   3.91074584911373*^9, 3.9107458926127214`*^9}, 3.910745941790287*^9, {
   3.910745986223607*^9, 3.910746063719597*^9}, {3.910747810729528*^9, 
   3.9107478791523943`*^9}, {3.9107479317978497`*^9, 
   3.9107479806408787`*^9}, {3.9107480256793222`*^9, 3.910748109579584*^9}, {
   3.91086543516223*^9, 3.9108654503446293`*^9}, {3.910865504589961*^9, 
   3.9108657401174555`*^9}, {3.91086584568825*^9, 3.910865852120024*^9}, 
   3.910865926383168*^9, 3.9108659744156675`*^9, 3.91086605745315*^9, {
   3.9108661771273518`*^9, 3.9108661799860926`*^9}, {3.9108662518520503`*^9, 
   3.9108662615334487`*^9}, 3.9108663396346254`*^9, {3.910866427961111*^9, 
   3.9108664324625444`*^9}, {3.910866648483549*^9, 3.910866665466797*^9}, {
   3.9108666978412094`*^9, 3.910866759019273*^9}, 3.9108668342632604`*^9, {
   3.9108668671138697`*^9, 3.910866882442206*^9}, {3.9108669792404804`*^9, 
   3.9108671430224776`*^9}, {3.9108671931495285`*^9, 3.910867227668786*^9}, {
   3.9108672957548175`*^9, 3.9108672974319744`*^9}, {3.910867368016037*^9, 
   3.910867368944265*^9}, 3.910867400227538*^9, {3.911008255763074*^9, 
   3.911008275926586*^9}, 3.9110083690822363`*^9, {3.9110084055565042`*^9, 
   3.9110084252803555`*^9}, 3.911008491161389*^9, {3.911008696240383*^9, 
   3.911008714321493*^9}, {3.9110088966274376`*^9, 3.911008900951162*^9}, {
   3.9110089635273657`*^9, 3.9110089783297873`*^9}, {3.911009014769552*^9, 
   3.9110090198434143`*^9}, {3.9110092308436937`*^9, 3.911009360495569*^9}, {
   3.9110093990206623`*^9, 3.9110094532567844`*^9}, {3.911009498630669*^9, 
   3.9110095367569847`*^9}, {3.9110095712912645`*^9, 
   3.9110096330820303`*^9}, {3.9110096653864827`*^9, 3.911009822963343*^9}, {
   3.911009859719963*^9, 3.911009866575224*^9}, {3.911009967367282*^9, 
   3.9110099850429783`*^9}, {3.911010028843105*^9, 3.9110101503231063`*^9}, {
   3.911010193179899*^9, 3.911010257505966*^9}, 3.911010335859486*^9, {
   3.911010401075186*^9, 3.911010457367464*^9}, 3.911010499750472*^9, {
   3.9110401234863586`*^9, 3.911040300892739*^9}, {3.9110403386146345`*^9, 
   3.911040544742799*^9}, {3.9110405856611333`*^9, 3.911040600084425*^9}, {
   3.9110409430788774`*^9, 3.9110409865360575`*^9}, {3.9110412680876427`*^9, 
   3.911041429298622*^9}, {3.911041589517542*^9, 3.9110416136098943`*^9}, {
   3.9110959319146233`*^9, 3.911096010751473*^9}, {3.9110962776335144`*^9, 
   3.911096327516655*^9}, {3.9110963649569387`*^9, 3.9110963792243595`*^9}, {
   3.917832590471942*^9, 3.91783259261812*^9}, {3.9178326929319906`*^9, 
   3.9178327503678517`*^9}, 3.9178328067760944`*^9, 3.917832854468274*^9, 
   3.917832888754475*^9, {3.917833107460365*^9, 3.917833108831243*^9}, {
   3.9178331620730915`*^9, 3.9178331825416665`*^9}, {3.9178332252920213`*^9, 
   3.917833227229144*^9}, 3.917833258961728*^9, {3.9178333424246206`*^9, 
   3.9178333517396064`*^9}, {3.917833444344221*^9, 3.9178334458517885`*^9}, 
   3.9178335515004683`*^9, {3.917833599553218*^9, 3.917833650004278*^9}, {
   3.917833691644823*^9, 3.917833692505719*^9}, {3.917834112622341*^9, 
   3.9178341280855384`*^9}, 3.917834171255001*^9, 3.9178342309758744`*^9, {
   3.917834295930198*^9, 3.917834298629716*^9}, 3.9178343890259485`*^9, 
   3.9178344550738645`*^9, {3.9178345592764263`*^9, 3.9178345765383854`*^9}, {
   3.9178349428335857`*^9, 3.917834957888749*^9}, {3.917835043598898*^9, 
   3.9178350499497914`*^9}, {3.917835648701893*^9, 3.9178356700048037`*^9}, {
   3.917835827590342*^9, 3.91783583779432*^9}, {3.917844702487713*^9, 
   3.9178447470333223`*^9}, {3.9178449064646893`*^9, 
   3.9178449159801645`*^9}, {3.9178449692656164`*^9, 
   3.9178450755686426`*^9}, {3.9178451261178627`*^9, 3.917845128031886*^9}, {
   3.91784611797869*^9, 3.917846150421515*^9}, {3.9178462178470125`*^9, 
   3.9178462188160224`*^9}, {3.9178463821131353`*^9, 3.917846404318012*^9}, {
   3.9178464868957653`*^9, 3.9178464974362345`*^9}, {3.9178466391768084`*^9, 
   3.917846660518054*^9}, {3.917846705713427*^9, 3.9178467398525267`*^9}, 
   3.9178467833607264`*^9, {3.917846824928237*^9, 3.9178468336706343`*^9}, {
   3.91784692713665*^9, 3.917846948232817*^9}, {3.917846984842763*^9, 
   3.9178470161506443`*^9}, {3.9182108415687127`*^9, 3.918210908004079*^9}, {
   3.9182109498407817`*^9, 3.9182111444301233`*^9}, {3.918211191133893*^9, 
   3.918211195152011*^9}, {3.9182112453708096`*^9, 3.9182112703404927`*^9}, {
   3.9182113141345406`*^9, 3.918211343884912*^9}, {3.918211377206615*^9, 
   3.9182113996989174`*^9}, {3.9182114444718027`*^9, 
   3.9182115011709948`*^9}, {3.918211554509279*^9, 3.9182118434838734`*^9}, {
   3.9182118844163384`*^9, 3.9182119340516095`*^9}, {3.918212144079294*^9, 
   3.9182121453109922`*^9}, {3.918212191518219*^9, 3.91821223630976*^9}, {
   3.918212271191306*^9, 3.9182122977139473`*^9}, {3.9182124886652174`*^9, 
   3.918212489073351*^9}, {3.918212590532064*^9, 3.9182127270755053`*^9}, {
   3.9182138417460346`*^9, 3.9182139048646154`*^9}, {3.9182146908437347`*^9, 
   3.9182149077374396`*^9}, {3.9182177073263197`*^9, 3.918217717322076*^9}, {
   3.918539524636157*^9, 3.918539527782719*^9}, {3.9185395590332627`*^9, 
   3.9185395632362785`*^9}, {3.9186078331321692`*^9, 3.918607833645181*^9}, {
   3.918607914428753*^9, 3.9186079207039227`*^9}, {3.9186084852881613`*^9, 
   3.91860866989282*^9}, {3.918608722991639*^9, 3.9186087765113287`*^9}, {
   3.9186088123606386`*^9, 3.918608816529477*^9}, {3.9186088543395295`*^9, 
   3.918608860108692*^9}, {3.918608891204424*^9, 3.9186088963485513`*^9}, {
   3.9186089310751266`*^9, 3.9186090347918806`*^9}, {3.9186143563438616`*^9, 
   3.9186143574276853`*^9}, 3.918629848595114*^9, 3.918629908583782*^9, {
   3.918629950660674*^9, 3.918629985878424*^9}, {3.918630102038577*^9, 
   3.9186301233091154`*^9}, {3.9186370529831204`*^9, 3.918637098446494*^9}, 
   3.918637239748101*^9, {3.918651032493411*^9, 3.9186510332241592`*^9}, 
   3.9186515711132927`*^9, {3.918651749050099*^9, 3.918651754020139*^9}, {
   3.918886175722066*^9, 3.918886277623564*^9}, {3.9188863475025697`*^9, 
   3.918886364944297*^9}, {3.9188864102911024`*^9, 3.9188864635769587`*^9}, {
   3.9188865129434056`*^9, 3.9188865210164766`*^9}, {3.9188866817537713`*^9, 
   3.918886797226532*^9}, {3.9188868431977205`*^9, 3.918886919954407*^9}, {
   3.918887501661186*^9, 3.9188875433729973`*^9}, 3.9189724260868464`*^9, {
   3.9189725984848385`*^9, 3.9189726144967713`*^9}, {3.9189894213903303`*^9, 
   3.918989440727315*^9}, {3.918991567575023*^9, 3.91899169221841*^9}, {
   3.918991756575407*^9, 3.918991764621538*^9}, {3.918991846575403*^9, 
   3.9189918651751175`*^9}, {3.918991923261159*^9, 3.918991943354218*^9}, {
   3.9189920897360425`*^9, 3.918992100937796*^9}, {3.919132509132023*^9, 
   3.9191325807306795`*^9}, {3.9191384189341793`*^9, 
   3.9191384486538267`*^9}, {3.9191623361135154`*^9, 3.919162375557169*^9}, {
   3.9191624544827147`*^9, 3.9191624952186127`*^9}, 3.9191625478255367`*^9, {
   3.9191638974162483`*^9, 3.9191638992562428`*^9}, 3.9191639333571525`*^9, {
   3.9191639680525956`*^9, 3.9191640136868615`*^9}, {3.919164047986966*^9, 
   3.919164056050922*^9}, 3.9191641210748734`*^9, 3.919211912165566*^9, {
   3.9192121282288237`*^9, 3.9192121298433332`*^9}, {3.920029118247701*^9, 
   3.920029146477833*^9}, {3.9200292003467803`*^9, 3.9200292482703037`*^9}, {
   3.9200292884372916`*^9, 3.92002931143719*^9}, {3.9200295509623346`*^9, 
   3.920029574123387*^9}, 3.9200299364606*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl1H0w1HkcB3DPX+ch9OBGUmHdXMtJSmxt+/nqga08XdFN13F6IpnQZiTt
KAp1x1iPlcOltHUpJMnD5DrMecpWK4+RxVK/fbJr2/UQ6343fWbe857XH+9/
P7bHog+c1NHS0vIl839/PQF4RrvZxj1WgnNf1Ly3gQBS79cerytTQnD58OdM
EwEEHfFdsfiXEup/aSDWWQlgKwPXpXCVEFsX1w2uAsgsDLUp/FMJBEvKvXRC
ANNpXhuHs5TAnxj0XWoTQFYs/2VFnBLudj77Q5M1Ck+eBxIcTyVM6Zle7toz
DkbxtNqe7ml4t9bcuGFICMB3MW46Nw1BzDCbx5GTkNGfM+psPQ2XRoLjo9d8
Aku39ETtfxSw8yfthIBKAkLiqVGmLAU8onu1aIeJIVnfhcezVcDTTR/ynq+Q
wqGcvIjl/XIIRHbL0ktlsPd9KPXqDTn43bsSftNRDmettyl7guTAcPexTlDL
4aPe3MbANXJYDGhcHvJCAb0tHncKeVPAsU1ypuZNw799KKXg2BREj90qSglR
Qn5uJ8NIbwrsftbd1O7xGXJ/OLhReFcGpYctDc3MVKAqN6pK2y8D1t5LrsJe
FZyv8H/vqJHCSrlHUkmFGpLPuHREVUhBJ41pL7swA2go+XTiaSm0vHtA2AXN
At9X1neWIoWgh1XKw05zsNOKZr1KKAHXmOU/rlfNATWm6VZDmQTGJU18Hm8e
xjxKjp9mSUBwuP2+ScEXON6R/e12LIFHfhde+hxdABN3mwi1hQR85i8sxtIW
IdH9TvbAmBg88t9kOOlqwLKNPX2rTgyzn87vfDWsgQyrufmyTDGkNbdti6pe
gtxKVydKhBhcW92b/RlauMQgmH3KWwxG1zZfHHqohW/H3JxZ6SAGQ8/BIRdz
beyo4ZkiJAbpi6DQ1HPa+GASpz5ALAJ6/pzKf0Qbu+Sxl1a9FsGTMKbb6C4d
HHIlVRBSIwJO9t+pk5U6OBscauhFIsirGU16aqmLx8MbN2xPE0FycX9xUoIu
jmdacRUsEQyMznQ1T+ri0CRB+b4QERyyaeJ27dfDH9QnG918RLCjujprf50e
PtMc+HsPTQTGZuziDoo+Lrao/Eb5vQiWjsoCLa6Tjln2mLpaBMHm121eqfRx
g8D6xXpjEYzV8DL9jhhgw17NhGqRAD9bwp7faICLm0rm3yoIoHx07GinIkzr
Fg7EThCw/p7V6uuZCIflSJ+WDBKQznii2peF8IKMMswiPdPHfGuSg7D34NYV
u0nzjOKvcfIRFu4eujc5QAA7pld9owjhT2MdJ5xI92/P6eaWIdzm8p1XfR8B
HL5JRksrwgGdiYkj7whYiCw9ldqOcC1lD72KdLg+fTezE+HfDM8bpJBmeER+
6eQh7Mwze0klLSlqj+juQXitTU1rXDcBzIhUr7FxhB3cRhws+ARU66y1K51A
WL2j9YHwLQHrCp8tnvxI7muF7rWk1TxhNSFCeLagKuFX0qVbdtkrFAgzr9Kz
y98QYM4b1FQpEaazWXHJpC+GswZjVQjXbGoOO0T6QEFJ1uwswtz0+5Ga1wQ0
bqadqZ9HeDVny2U+6Q1db5jsBYTNTV/f5pLODTtFYWgQ7qo+15VA+uv/MsSJ
tHUG/qT/A5I5aow=
      "]]}}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0, 1.124433358085935}, {0.5, 1.124433358085935}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, 0.7871033506601545}, {3, 0.7871033506601545}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, 1.124433358085935}, {0.5, 0.7871033506601545}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0.5, 1.124433358085935}, {0.5, 1.2298489854064913`}}]}, {
    InsetBox[
     RowBox[{"\[Theta]", "=", 
      RowBox[{"-", "1"}]}], {2.387755102040816, 2.1623474786740093`}, {
     Left, Baseline},
     Alignment->{Left, Top}], {InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         StyleBox[
          SubscriptBox["\[Tau]", "d"],
          FontSize->12], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.8",
           FontSize->12], 
          StyleBox[" ",
           FontSize->12], 
          StyleBox["ms",
           FontSize->12], " "}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[1.]], {2.152607709750566, 1.6836194795378447`}, {
      Left, Baseline},
      Alignment->{Left, Top}], InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         StyleBox[
          SubscriptBox["\[Tau]", "e"],
          FontSize->12], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.5",
           FontSize->12], 
          StyleBox["  ",
           FontSize->12], 
          StyleBox["ms",
           FontSize->12], " "}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[1.]], {2.163718820861676, 1.9365079365079345`}, {
      Left, Baseline},
      Alignment->{Left, Top}]}}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"t (ms)\"", FontSize -> 20, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1.5, 
      FormBox[
       RowBox[{"-", "1.5`"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{41., 25.}, {51., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{0., 3.}, {0., 2.5}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.920029946524295*^9, 3.920029959939825*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2nk4VN8bAPCxlyQkUSq0IUlCtHhvhSJ7CEmRpFKksiUhITshe2TNFlJC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      "]]}}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0, 1.124433358085935}, {0.5, 1.124433358085935}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, 0.7871033506601545}, {3, 0.7871033506601545}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, 1.124433358085935}, {0.5, 0.7871033506601545}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0.5, 1.124433358085935}, {0.5, 1.9677583766503859`}}]}, InsetBox[
    RowBox[{"\[Theta]", "=", 
     RowBox[{"-", "1"}]}], {2.4693877551020402`, 2.135568513119534}, {
    Left, Baseline},
    Alignment->{Left, Top}], {InsetBox[
     StyleBox[
      TagBox[
       RowBox[{
        StyleBox[
         SubscriptBox["\[Tau]", "d"],
         FontSize->12], 
        StyleBox["=",
         FontSize->12], 
        StyleBox[" ",
         FontSize->12], 
        RowBox[{
         StyleBox["0.1",
          FontSize->12], 
         StyleBox["  ",
          FontSize->12], 
         StyleBox["ms",
          FontSize->12], " "}]}],
       "RawBoxes"],
      FontFamily->"Arial",
      FontSize->10,
      Background->GrayLevel[1.]], {2.23424036281179, 1.6568405139833695`}, {
     Left, Baseline},
     Alignment->{Left, Top}], InsetBox[
     StyleBox[
      TagBox[
       RowBox[{
        StyleBox[
         SubscriptBox["\[Tau]", "e"],
         FontSize->12], 
        StyleBox["=",
         FontSize->12], 
        StyleBox[" ",
         FontSize->12], 
        RowBox[{
         StyleBox["0.5",
          FontSize->12], 
         StyleBox["  ",
          FontSize->12], 
         StyleBox["ms",
          FontSize->12], " "}]}],
       "RawBoxes"],
      FontFamily->"Arial",
      FontSize->10,
      Background->GrayLevel[
       1.]], {2.2453514739229004`, 1.9097289709534593`}, {Left, Baseline},
     Alignment->{Left, Top}]}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"t (ms)\"", FontSize -> 20, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1.5, 
      FormBox[
       RowBox[{"-", "1.5`"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{41., 25.}, {51., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{0., 3.}, {0., 2.5}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.9200297337847767`*^9, 3.9200297560712543`*^9}}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Theta]", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"V0", "=", 
     RowBox[{"-", "0.5"}]}], ";", 
    RowBox[{"DV", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t0", "=", "0.5"}], ";", 
    RowBox[{"tfin", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Tau]e", "=", "0.5"}], ";", 
    RowBox[{"\[Tau]d", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Iin", "=", 
     RowBox[{"Idc", "[", "V0", "]"}]}], ";", 
    RowBox[{"Ifin", "=", 
     RowBox[{
      RowBox[{"Idc", "[", "V0", "]"}], "+", 
      RowBox[{"\[Theta]", " ", 
       RowBox[{"cmu", "[", "V0", "]"}], " ", 
       RowBox[{"L", " ", "/", "\[Tau]e"}], " ", "DV"}]}]}], ";", 
    RowBox[{"I0", "=", 
     RowBox[{
      RowBox[{"Idc", "[", "V0", "]"}], "+", 
      RowBox[{
       RowBox[{"cmu", "[", "V0", "]"}], " ", "f", " ", 
       RowBox[{"L", " ", "/", "\[Tau]d"}], " ", "DV"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"as1", "=", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tt", ",", 
         RowBox[{
          RowBox[{"Idc", "[", "V0", "]"}], "+", 
          RowBox[{
           RowBox[{"cmu", "[", "V0", "]"}], " ", "L", "  ", "DV", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", "/", "\[Tau]d"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Theta]", " ", "/", "\[Tau]e"}], "-", 
                RowBox[{"f", "/", "\[Tau]d"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{"tt", "-", "t0"}], ")"}]}], "/", "\[Tau]d"}], 
                 "]"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tt", ",", "t0", ",", "tfin"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<t (ms)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(d\)]\) (\[Mu]A)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", 
            RowBox[{"-", "2"}], ",", 
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "0.5"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", 
            RowBox[{"-", "3"}], ",", 
            RowBox[{"-", "2"}], ",", 
            RowBox[{"-", "1.5"}], ",", 
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "0.5"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
           "}"}], ",", "None", ",", "None"}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue"}], "}"}],
          "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fg1", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "Iin"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t0", ",", "Iin"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";", 
    RowBox[{"fg4", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"t0", ",", 
             RowBox[{"Idc", "[", "V0", "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t0", ",", "I0"}], " ", "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";", 
    RowBox[{"fg2", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Brown", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"t0", ",", "Ifin"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"tfin", ",", "Ifin"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fg3", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Brown", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"t0", ",", "Iin"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t0", ",", "Ifin"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"as1", ",", "fg1", ",", "fg2", ",", "fg3", ",", "fg4", ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "tfin"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1.5"}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"BaseStyle", "->", 
      RowBox[{"{", 
       RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8390646611298313`*^9, 3.839064663549252*^9}, {
   3.8390651628201227`*^9, 3.8390651698744855`*^9}, {3.8390671245340233`*^9, 
   3.839067253968177*^9}, {3.8390672908692884`*^9, 3.8390673435588245`*^9}, {
   3.839067444277615*^9, 3.8390674530816755`*^9}, {3.839067483223913*^9, 
   3.8390676448632746`*^9}, {3.839067792030848*^9, 3.8390679296503277`*^9}, {
   3.839068035965031*^9, 3.8390681198292847`*^9}, {3.8390709139116144`*^9, 
   3.8390709421089935`*^9}, {3.83907099038449*^9, 3.8390709930117693`*^9}, {
   3.839071053413534*^9, 3.839071065617492*^9}, {3.839071142245447*^9, 
   3.8390712315177836`*^9}, {3.839071262559967*^9, 3.8390713000871944`*^9}, {
   3.8390714971122246`*^9, 3.839071517359198*^9}, {3.8390715485300074`*^9, 
   3.8390716200472517`*^9}, {3.8390716672806673`*^9, 3.839071782347397*^9}, {
   3.839071837937226*^9, 3.839071939311781*^9}, {3.839072168081314*^9, 
   3.839072168581891*^9}, {3.8390723168444653`*^9, 3.8390724465495067`*^9}, {
   3.8390724871236815`*^9, 3.839072628537404*^9}, {3.8390726857581015`*^9, 
   3.83907270608572*^9}, {3.8390728526632924`*^9, 3.8390730714112225`*^9}, {
   3.839082271666379*^9, 3.8390823055073657`*^9}, {3.839082353119522*^9, 
   3.839082449840514*^9}, {3.8390839765348864`*^9, 3.839084057466158*^9}, {
   3.8390840878065057`*^9, 3.8390841778809776`*^9}, {3.8390842363292522`*^9, 
   3.8390842982497163`*^9}, 3.83908433029414*^9, {3.8390843708346243`*^9, 
   3.8390844315092807`*^9}, 3.839084462612833*^9, {3.8390845298830824`*^9, 
   3.839084537171591*^9}, {3.8390846234607463`*^9, 3.839084639769829*^9}, {
   3.839085385972989*^9, 3.8390853976007433`*^9}, {3.8390854555897675`*^9, 
   3.839085524444199*^9}, {3.839085565738154*^9, 3.8390855920819826`*^9}, {
   3.8390863447286386`*^9, 3.839086474045252*^9}, {3.839086860852067*^9, 
   3.839086874816577*^9}, {3.839087637034748*^9, 3.8390876843714943`*^9}, 
   3.83908780285631*^9, 3.8390878367914057`*^9, {3.839088015231053*^9, 
   3.8390880802460375`*^9}, {3.839088241208177*^9, 3.839088251058446*^9}, 
   3.839088396382834*^9, 3.8391182307918463`*^9, {3.839118379381566*^9, 
   3.8391183868618546`*^9}, {3.839118542781612*^9, 3.839118576690755*^9}, {
   3.839119230679368*^9, 3.8391192435152392`*^9}, {3.8391193005384474`*^9, 
   3.839119322077612*^9}, {3.8391197370496492`*^9, 3.839119744561663*^9}, {
   3.839119780647091*^9, 3.8391198576053133`*^9}, {3.83913747847266*^9, 
   3.839137485481214*^9}, {3.8391375587687283`*^9, 3.8391375797199593`*^9}, {
   3.8391376276780567`*^9, 3.8391376620779104`*^9}, {3.83913835785732*^9, 
   3.839138374216883*^9}, 3.8391384110040264`*^9, {3.8391384624942074`*^9, 
   3.839138462879356*^9}, {3.8391385170099597`*^9, 3.839138536349577*^9}, {
   3.839139183554804*^9, 3.8391391930138044`*^9}, {3.8391393033973885`*^9, 
   3.8391393043613095`*^9}, 3.839139359067504*^9, 3.839139436240513*^9, {
   3.8392078031308994`*^9, 3.8392078143543434`*^9}, {3.8392078889566584`*^9, 
   3.83920790820275*^9}, {3.839208054761527*^9, 3.839208093399903*^9}, {
   3.8392084092575808`*^9, 3.8392084620514746`*^9}, 3.839208533536579*^9, {
   3.8392086070037084`*^9, 3.8392086083290124`*^9}, 3.8392086479255266`*^9, {
   3.8392225965883913`*^9, 3.8392226283136573`*^9}, {3.8392226646362276`*^9, 
   3.8392227421040397`*^9}, 3.8392227767756677`*^9, {3.8392228326927814`*^9, 
   3.839222892911393*^9}, 3.8392230743763013`*^9, {3.839223141092394*^9, 
   3.839223141783134*^9}, 3.839223177642132*^9, {3.8392232273840017`*^9, 
   3.8392232854596047`*^9}, {3.8392233573873816`*^9, 3.839223398790718*^9}, {
   3.8392234505961695`*^9, 3.839223507183962*^9}, {3.839223811017748*^9, 
   3.8392239510950837`*^9}, {3.8392240167007127`*^9, 3.839224025275307*^9}, {
   3.8392241057509785`*^9, 3.839224157437503*^9}, {3.839224200897134*^9, 
   3.8392242487597456`*^9}, {3.839224294917468*^9, 3.839224296013791*^9}, {
   3.8392243639841394`*^9, 3.8392243950383773`*^9}, 3.839224442185709*^9, {
   3.8392245129185476`*^9, 3.8392245373577056`*^9}, {3.8392245776385975`*^9, 
   3.839224740679908*^9}, {3.8392248367057567`*^9, 3.839224838004247*^9}, {
   3.8392249023255987`*^9, 3.8392249329681873`*^9}, 3.8392250078513308`*^9, {
   3.8392250461420965`*^9, 3.8392250567765236`*^9}, {3.8392250892690206`*^9, 
   3.839225128234888*^9}, {3.839225292837965*^9, 3.8392253052980237`*^9}, {
   3.839225374465659*^9, 3.839225378163327*^9}, {3.8392366608564453`*^9, 
   3.839236691352835*^9}, {3.839236736346908*^9, 3.8392367461057377`*^9}, {
   3.8392368452896976`*^9, 3.8392369245276327`*^9}, {3.8392369586763678`*^9, 
   3.839236989556669*^9}, {3.8392370210310707`*^9, 3.839237025639107*^9}, {
   3.8392370611832547`*^9, 3.839237143422812*^9}, {3.839237229917989*^9, 
   3.839237306453603*^9}, {3.8392373387206373`*^9, 3.839237342820054*^9}, {
   3.839237447098841*^9, 3.8392375543643665`*^9}, {3.8392411494009237`*^9, 
   3.839241171431179*^9}, {3.83924120627816*^9, 3.8392412247291117`*^9}, 
   3.8392412792201967`*^9, 3.8392413874247665`*^9, {3.8392415172512045`*^9, 
   3.8392415791894693`*^9}, {3.839241632182249*^9, 3.8392416472548246`*^9}, 
   3.8392418101230965`*^9, {3.839242047805271*^9, 3.8392420951804295`*^9}, {
   3.8392421670049934`*^9, 3.8392422247577305`*^9}, {3.8392422574679546`*^9, 
   3.8392422587095203`*^9}, {3.839242291908*^9, 3.8392425704347763`*^9}, {
   3.8392426617662134`*^9, 3.8392426717163734`*^9}, 3.839242785862258*^9, {
   3.839246817917405*^9, 3.8392468269690895`*^9}, {3.839246889891876*^9, 
   3.839246924816616*^9}, {3.839309996677757*^9, 3.839310018708186*^9}, {
   3.839310845764266*^9, 3.839310880859878*^9}, {3.839310926113166*^9, 
   3.839310949193386*^9}, {3.8393110019361973`*^9, 3.8393110308399534`*^9}, {
   3.8393270934512377`*^9, 3.839327332415727*^9}, {3.839327370226597*^9, 
   3.839327451303669*^9}, {3.8393275031436253`*^9, 3.8393275194960613`*^9}, {
   3.839327586008069*^9, 3.8393276948310633`*^9}, {3.8393278034898295`*^9, 
   3.8393278068680096`*^9}, {3.8393278450424776`*^9, 
   3.8393278797618237`*^9}, {3.8393289610021143`*^9, 3.839328976754302*^9}, {
   3.8393294967878103`*^9, 3.839329617607455*^9}, 3.8393297021511583`*^9, {
   3.839329736764967*^9, 3.83932973839811*^9}, {3.839329841358012*^9, 
   3.839329850076448*^9}, {3.8393298856244183`*^9, 3.83932990739045*^9}, {
   3.839330200791801*^9, 3.839330209464896*^9}, 3.83933026862875*^9, {
   3.8393304947792683`*^9, 3.839330614321838*^9}, {3.839330707456501*^9, 
   3.8393307223587484`*^9}, {3.8393307586469154`*^9, 3.839330774655125*^9}, {
   3.8393308208469334`*^9, 3.8393308254369345`*^9}, {3.83933092079788*^9, 
   3.8393310148602314`*^9}, {3.8393311745075006`*^9, 
   3.8393311994275675`*^9}, {3.8393312620131807`*^9, 
   3.8393312886598005`*^9}, {3.83933158528376*^9, 3.8393316720258255`*^9}, 
   3.8393317188850336`*^9, {3.8393317973728094`*^9, 3.8393319397094903`*^9}, 
   3.8393320294844685`*^9, {3.8393325727147913`*^9, 3.8393326007437224`*^9}, {
   3.839332643937569*^9, 3.8393326886712303`*^9}, {3.839332884251463*^9, 
   3.8393328849388123`*^9}, {3.8393329498885293`*^9, 3.839332954368989*^9}, 
   3.839332984548478*^9, {3.839333161836732*^9, 3.839333179429063*^9}, {
   3.839333212168277*^9, 3.8393332158859396`*^9}, {3.839333299885914*^9, 
   3.839333320058819*^9}, {3.8393333662749724`*^9, 3.839333389618166*^9}, 
   3.8393335815372777`*^9, {3.8393336646381135`*^9, 3.839333690640252*^9}, {
   3.839333816187891*^9, 3.839333852596138*^9}, {3.839333913143673*^9, 
   3.839333960953573*^9}, {3.8393340547869487`*^9, 3.839334137419753*^9}, {
   3.839420765475212*^9, 3.839420767706482*^9}, {3.839420800720344*^9, 
   3.83942080814257*^9}, {3.839420930166752*^9, 3.839420954611184*^9}, 
   3.839421093306271*^9, {3.839421249787591*^9, 3.8394213460868835`*^9}, {
   3.839421400152422*^9, 3.8394214417353144`*^9}, {3.839421483648677*^9, 
   3.839421580608614*^9}, 3.839421616079374*^9, 3.839422181142932*^9, {
   3.8394224472930202`*^9, 3.839422448371497*^9}, {3.8394225405886507`*^9, 
   3.839422541885687*^9}, {3.8394225839963813`*^9, 3.83942258751882*^9}, 
   3.8394239784679832`*^9, {3.8394240190394516`*^9, 3.8394240194005165`*^9}, {
   3.839481241680246*^9, 3.8394812636526537`*^9}, {3.8394813033197775`*^9, 
   3.839481343020226*^9}, {3.8394813886318493`*^9, 3.83948138904453*^9}, {
   3.8394814470082235`*^9, 3.8394815138762083`*^9}, {3.839484145142799*^9, 
   3.8394841575703464`*^9}, {3.8394842427712455`*^9, 
   3.8394842456191454`*^9}, {3.8394844396674995`*^9, 
   3.8394844660440836`*^9}, {3.8394845806487627`*^9, 3.83948460808449*^9}, {
   3.8394847191879005`*^9, 3.839484719920673*^9}, {3.8394847985864277`*^9, 
   3.8394847999498053`*^9}, {3.839485522225484*^9, 3.8394858614478054`*^9}, {
   3.8394858968609977`*^9, 3.8394858979280567`*^9}, {3.83950394022218*^9, 
   3.839504016595684*^9}, {3.839504079022719*^9, 3.8395041716366367`*^9}, {
   3.8395042475063295`*^9, 3.83950424807436*^9}, {3.8395043044033585`*^9, 
   3.8395043325148754`*^9}, {3.839504403912784*^9, 3.839504405955762*^9}, {
   3.839504461254238*^9, 3.8395044954062967`*^9}, {3.839504572085556*^9, 
   3.8395046258331623`*^9}, {3.839504718095887*^9, 3.839504733043982*^9}, {
   3.839504792704324*^9, 3.8395048214714227`*^9}, {3.8395048602645364`*^9, 
   3.839504871422516*^9}, {3.83950521161292*^9, 3.8395052235501237`*^9}, {
   3.839505255990897*^9, 3.8395052773582516`*^9}, {3.839505321851119*^9, 
   3.839505332451271*^9}, {3.8395054257374*^9, 3.8395054385582395`*^9}, 
   3.839505580972617*^9, {3.8395057025144815`*^9, 3.8395057031788645`*^9}, {
   3.8395057369934807`*^9, 3.8395057373979363`*^9}, {3.839505772294227*^9, 
   3.839505778367197*^9}, {3.83950673092721*^9, 3.8395067795192204`*^9}, {
   3.8395084122279215`*^9, 3.8395084138977666`*^9}, {3.839508448233049*^9, 
   3.8395084493422976`*^9}, {3.839508499051385*^9, 3.8395085344200335`*^9}, 
   3.8395086207285233`*^9, {3.8395086973952723`*^9, 3.8395086978689127`*^9}, {
   3.8395089696790757`*^9, 3.839509039224576*^9}, {3.8395100524490423`*^9, 
   3.839510053723009*^9}, {3.839511493807127*^9, 3.8395115089839754`*^9}, {
   3.8395115931589155`*^9, 3.839511633911852*^9}, {3.839511664551564*^9, 
   3.8395117021779413`*^9}, {3.839511738662855*^9, 3.8395117683886237`*^9}, {
   3.8395840465025244`*^9, 3.8395840478719764`*^9}, {3.8395842326636224`*^9, 
   3.8395842405526743`*^9}, {3.8395844072352886`*^9, 3.839584438590257*^9}, {
   3.839584539157859*^9, 3.839584558647271*^9}, {3.8395846133789663`*^9, 
   3.83958465811094*^9}, {3.839584785836444*^9, 3.839584807986281*^9}, 
   3.839586726652771*^9, {3.8395867995416994`*^9, 3.8395868420413933`*^9}, 
   3.83958688638865*^9, {3.839587244941451*^9, 3.83958726487414*^9}, {
   3.83958774293878*^9, 3.8395877838602095`*^9}, 3.839587828597546*^9, {
   3.839587879706158*^9, 3.8395879135449758`*^9}, {3.839587955043039*^9, 
   3.8395879642045746`*^9}, {3.8395880048781385`*^9, 3.839588051406326*^9}, {
   3.8395880883490973`*^9, 3.8395881594520197`*^9}, {3.8395882347911615`*^9, 
   3.8395883226336384`*^9}, 3.8395883559509153`*^9, 3.839588415451826*^9, {
   3.8395884902783833`*^9, 3.8395885216082554`*^9}, {3.8395941073926105`*^9, 
   3.8395942227438965`*^9}, 3.839595304916483*^9, {3.8395954862576475`*^9, 
   3.83959557521957*^9}, {3.839595607221432*^9, 3.8395956076140194`*^9}, {
   3.839595660820343*^9, 3.839595661835729*^9}, {3.839604650775865*^9, 
   3.8396046640054827`*^9}, {3.839604708532463*^9, 3.8396047629301977`*^9}, {
   3.839604795558606*^9, 3.839604808947177*^9}, {3.839604852056878*^9, 
   3.8396048690185547`*^9}, {3.839642088079403*^9, 3.839642141004441*^9}, {
   3.8396422800918975`*^9, 3.8396423077286944`*^9}, {3.8396424143783884`*^9, 
   3.8396424152236857`*^9}, {3.8396426095904264`*^9, 
   3.8396426100591545`*^9}, {3.8396426843268356`*^9, 3.8396426912164164`*^9}, 
   3.8396427676568155`*^9, {3.8396428549330425`*^9, 3.8396429650459213`*^9}, 
   3.839643049962629*^9, {3.839643091872772*^9, 3.8396431410841303`*^9}, 
   3.839643491656567*^9, {3.839643550041149*^9, 3.839643610060313*^9}, {
   3.8396436783391447`*^9, 3.8396437059963512`*^9}, {3.8396437389632745`*^9, 
   3.8396437448257093`*^9}, {3.839643793497415*^9, 3.8396438275668716`*^9}, {
   3.839643978745996*^9, 3.8396439798436737`*^9}, {3.839644021519642*^9, 
   3.8396440428152156`*^9}, {3.8396441695399504`*^9, 
   3.8396441971715937`*^9}, {3.839644230142295*^9, 3.8396442469945946`*^9}, {
   3.839644284692358*^9, 3.8396442961501245`*^9}, {3.8396443434969287`*^9, 
   3.8396443583914576`*^9}, {3.8396448346105194`*^9, 3.839644913123821*^9}, {
   3.8396555898716025`*^9, 3.839655650012109*^9}, {3.8396556822310605`*^9, 
   3.839655771771843*^9}, {3.839655952479162*^9, 3.8396559541084647`*^9}, 
   3.839656003389371*^9, {3.8396560347174463`*^9, 3.839656116850046*^9}, {
   3.8396562422855325`*^9, 3.8396562713341274`*^9}, 3.8396563271846943`*^9, {
   3.8396565529884825`*^9, 3.839656667985509*^9}, {3.8396568526250334`*^9, 
   3.839656873162519*^9}, {3.8396570321068354`*^9, 3.8396570367161813`*^9}, {
   3.8396571621919303`*^9, 3.839657193340761*^9}, {3.839657225174745*^9, 
   3.8396572442512493`*^9}, {3.8396572932236905`*^9, 3.8396572940165*^9}, 
   3.8396574072631903`*^9, {3.8396575476060143`*^9, 3.8396575682943974`*^9}, {
   3.839664138921971*^9, 3.839664156869915*^9}, 3.839664243007531*^9, {
   3.839669622125418*^9, 3.839669647884663*^9}, {3.839670002387182*^9, 
   3.839670025487237*^9}, {3.8396700586539392`*^9, 3.8396701085420904`*^9}, {
   3.8396766028729286`*^9, 3.839676603372811*^9}, {3.839676649783103*^9, 
   3.8396766681979322`*^9}, {3.839723206211033*^9, 3.839723252419324*^9}, {
   3.8397243192805915`*^9, 3.8397243622670403`*^9}, {3.839724526690404*^9, 
   3.8397245565593586`*^9}, 3.839724591814554*^9, {3.8397246526353917`*^9, 
   3.8397246677187424`*^9}, {3.839724698665658*^9, 3.8397248461537275`*^9}, {
   3.839724910156172*^9, 3.839724969029936*^9}, {3.839725029399225*^9, 
   3.839725070375955*^9}, {3.8397257491640964`*^9, 3.8397258148584566`*^9}, {
   3.839726205531111*^9, 3.839726226304987*^9}, {3.839726314389023*^9, 
   3.8397264887181263`*^9}, {3.8397266355093994`*^9, 
   3.8397266356472826`*^9}, {3.839727069639051*^9, 3.83972707062368*^9}, {
   3.8397274615058823`*^9, 3.839727481527841*^9}, {3.83972755827617*^9, 
   3.8397275594724007`*^9}, {3.839727857737072*^9, 3.83972788618902*^9}, 
   3.8397281801577473`*^9, {3.839741406815917*^9, 3.839741648719699*^9}, 
   3.839741694966459*^9, {3.8397417738301263`*^9, 3.8397417740488653`*^9}, 
   3.839742014559319*^9, {3.8397421882027674`*^9, 3.839742188943444*^9}, {
   3.8397589658528605`*^9, 3.83975903164762*^9}, {3.839759582024466*^9, 
   3.8397596437148447`*^9}, {3.8397597378135786`*^9, 3.839759770277839*^9}, {
   3.839760042248042*^9, 3.8397600434337606`*^9}, {3.839760792865179*^9, 
   3.839760817913896*^9}, {3.8397655048182044`*^9, 3.839765505036851*^9}, {
   3.839765649791177*^9, 3.839765680039174*^9}, {3.839765730951825*^9, 
   3.8397657438209515`*^9}, {3.8397658325268707`*^9, 3.839765870890603*^9}, {
   3.8397695336031294`*^9, 3.8397695785421767`*^9}, 3.839769610638837*^9, {
   3.839769642999297*^9, 3.8397696900062704`*^9}, {3.8397697294324865`*^9, 
   3.839769753667972*^9}, 3.839770624201335*^9, {3.8399858643515997`*^9, 
   3.839985870106961*^9}, {3.8399859073530426`*^9, 3.83998590778368*^9}, {
   3.839986665758301*^9, 3.839986671600184*^9}, {3.840015477117873*^9, 
   3.840015532633871*^9}, {3.840262190474472*^9, 3.8402621922160215`*^9}, {
   3.8402622512898836`*^9, 3.8402623158498154`*^9}, {3.840262346847395*^9, 
   3.840262361938197*^9}, {3.8402624446884875`*^9, 3.840262497278998*^9}, {
   3.8402625593196363`*^9, 3.840262562846277*^9}, {3.840262654524027*^9, 
   3.8402626673364897`*^9}, {3.8402800661176753`*^9, 3.840280138278593*^9}, {
   3.840280177703832*^9, 3.840280189480773*^9}, {3.8402802324576406`*^9, 
   3.8402802331825943`*^9}, {3.8402812754975386`*^9, 3.840281326464582*^9}, 
   3.8402813946519136`*^9, {3.84028186111417*^9, 3.8402818954912634`*^9}, {
   3.8402819964993353`*^9, 3.8402819971437144`*^9}, {3.840330466229367*^9, 
   3.8403304972505484`*^9}, 3.8403305401374164`*^9, 3.840330628649666*^9, {
   3.8403306672934227`*^9, 3.8403306802026963`*^9}, {3.8403307193320885`*^9, 
   3.840330758272279*^9}, 3.8403307967908325`*^9, 3.8403308358680725`*^9, {
   3.840330872410847*^9, 3.8403308786837*^9}, {3.8403309221453967`*^9, 
   3.840330944340696*^9}, 3.840330989285677*^9, {3.840331109810131*^9, 
   3.840331153164013*^9}, {3.840331431580937*^9, 3.8403314406879196`*^9}, {
   3.8403317789283185`*^9, 3.840331780542934*^9}, {3.840331813886128*^9, 
   3.8403318320633073`*^9}, {3.8403318821336937`*^9, 
   3.8403318897950106`*^9}, {3.8403319357741313`*^9, 
   3.8403319411825953`*^9}, {3.8403320129500637`*^9, 
   3.8403321277278547`*^9}, {3.840332221075777*^9, 3.8403322212632327`*^9}, {
   3.8404162792747984`*^9, 3.8404162803058043`*^9}, {3.840416344690134*^9, 
   3.8404163448306866`*^9}, {3.8404178626090136`*^9, 3.840417925824424*^9}, {
   3.8404191918191233`*^9, 3.84041920226635*^9}, {3.840419242024495*^9, 
   3.8404192617321796`*^9}, {3.8404194389428053`*^9, 3.840419462557069*^9}, {
   3.840453834266838*^9, 3.8404538447517056`*^9}, 3.840453909614043*^9, {
   3.8404539683635793`*^9, 3.8404539905838337`*^9}, 3.8404540272985306`*^9, {
   3.840454156166298*^9, 3.840454205291971*^9}, {3.840454240247527*^9, 
   3.8404542540157146`*^9}, {3.8404543237333283`*^9, 
   3.8404543404928937`*^9}, {3.8404544521143074`*^9, 
   3.8404544541302176`*^9}, {3.840454485008524*^9, 3.8404544958331428`*^9}, {
   3.840454535970628*^9, 3.840454551137659*^9}, {3.840500625089159*^9, 
   3.840500656940725*^9}, {3.840500695345143*^9, 3.8405006960523067`*^9}, {
   3.8405010969852047`*^9, 3.840501112587641*^9}, {3.840501150634077*^9, 
   3.8405011611522417`*^9}, {3.8405026446645527`*^9, 3.84050265267775*^9}, 
   3.8405026878215275`*^9, 3.8405027886745453`*^9, {3.8405028323157024`*^9, 
   3.8405028521056433`*^9}, {3.840508597751215*^9, 3.8405086042448597`*^9}, {
   3.8405086361734276`*^9, 3.840508697640854*^9}, {3.84530515034306*^9, 
   3.8453051663199177`*^9}, 3.845305197884505*^9, {3.8454792808354254`*^9, 
   3.8454794150956697`*^9}, {3.845479722113243*^9, 3.8454797915964413`*^9}, {
   3.845514873929638*^9, 3.8455149337268724`*^9}, {3.8455149684706416`*^9, 
   3.8455149695080223`*^9}, {3.8455153275220933`*^9, 3.845515328229957*^9}, {
   3.845515395675539*^9, 3.845515401297691*^9}, {3.845515515853771*^9, 
   3.845515576447665*^9}, {3.845515612558851*^9, 3.845515632979537*^9}, {
   3.845515680153039*^9, 3.8455159262376585`*^9}, {3.845516112061887*^9, 
   3.8455161465263453`*^9}, {3.845516193085106*^9, 3.845516229178423*^9}, {
   3.8455163351689043`*^9, 3.845516585318216*^9}, {3.8455166177397394`*^9, 
   3.845516714733508*^9}, {3.845516771645197*^9, 3.8455167731827154`*^9}, {
   3.845516818729296*^9, 3.84551695860878*^9}, {3.845516994711903*^9, 
   3.845517026462266*^9}, 3.845517092145789*^9, {3.845517135366593*^9, 
   3.845517155446496*^9}, {3.845517186534149*^9, 3.8455171937276707`*^9}, {
   3.845517227012909*^9, 3.8455172279061613`*^9}, {3.8455173234132085`*^9, 
   3.8455173514857492`*^9}, {3.845517423730919*^9, 3.8455174243493695`*^9}, {
   3.8455174624069753`*^9, 3.845517465100626*^9}, 3.845517507705373*^9, 
   3.8455175508535676`*^9, {3.8455176264044795`*^9, 3.8455176334075813`*^9}, {
   3.8455313319229393`*^9, 3.845531509940443*^9}, 3.8455315849840965`*^9, {
   3.8455317016782956`*^9, 3.845531738966821*^9}, {3.845531778451456*^9, 
   3.845531779386674*^9}, {3.8456415428113813`*^9, 3.845641735457308*^9}, {
   3.8456420427094593`*^9, 3.8456420444008894`*^9}, {3.8456420953927226`*^9, 
   3.845642095827136*^9}, {3.8456421305858717`*^9, 3.8456422084386454`*^9}, 
   3.8456422719473834`*^9, {3.8456424654126687`*^9, 3.8456424685516415`*^9}, {
   3.8456425391271963`*^9, 3.845642581942461*^9}, {3.8456426396045694`*^9, 
   3.845642806094469*^9}, {3.845642836196087*^9, 3.845642900922883*^9}, {
   3.845642970285206*^9, 3.8456430181273146`*^9}, {3.8456430708546114`*^9, 
   3.845643125882959*^9}, {3.845643178575968*^9, 3.845643257358486*^9}, {
   3.8456433623862553`*^9, 3.8456433771042914`*^9}, {3.8456434590863156`*^9, 
   3.8456434937160645`*^9}, 3.845643545927831*^9, {3.845643600156926*^9, 
   3.845643618570978*^9}, {3.8456436644300175`*^9, 3.84564366503797*^9}, {
   3.845643702197648*^9, 3.8456437461979747`*^9}, 3.8456439574887114`*^9, {
   3.846069818172841*^9, 3.846069849642768*^9}, {3.8460699136765876`*^9, 
   3.846069914209477*^9}, {3.8460699599440656`*^9, 3.8460700314146757`*^9}, {
   3.846070076753316*^9, 3.846070077439046*^9}, {3.846070157661101*^9, 
   3.8460701937707815`*^9}, {3.846070258127372*^9, 3.846070370035694*^9}, 
   3.8460704231130123`*^9, {3.846070456017062*^9, 3.8460704588184586`*^9}, {
   3.8460710172041235`*^9, 3.846071021582673*^9}, {3.846071106666136*^9, 
   3.8460711227728405`*^9}, {3.846071236516765*^9, 3.8460712690613956`*^9}, {
   3.846071302508814*^9, 3.8460713286265783`*^9}, {3.846071391711331*^9, 
   3.8460713919222136`*^9}, {3.8460717432565613`*^9, 3.846071846163582*^9}, {
   3.8460718796339417`*^9, 3.8460718981181345`*^9}, {3.8460719281852317`*^9, 
   3.8460719602156863`*^9}, {3.8460725487311463`*^9, 
   3.8460727277222366`*^9}, {3.8460727966336946`*^9, 
   3.8460727999447126`*^9}, {3.8460728715731387`*^9, 3.846072900231036*^9}, 
   3.8460729488995743`*^9, 3.846073094187673*^9, {3.846073124968068*^9, 
   3.846073143649494*^9}, {3.846073291437569*^9, 3.846073320871194*^9}, {
   3.8460733513356*^9, 3.8460733827836275`*^9}, {3.8460734213260293`*^9, 
   3.846073547913215*^9}, {3.8460735888598585`*^9, 3.8460735948494663`*^9}, {
   3.8460736630482445`*^9, 3.84607366906472*^9}, {3.846073769039547*^9, 
   3.8460738022300262`*^9}, {3.8460738788770266`*^9, 
   3.8460738952181954`*^9}, {3.846073949966679*^9, 3.8460739569065495`*^9}, {
   3.846074029073464*^9, 3.8460740346596146`*^9}, {3.846074102104647*^9, 
   3.8460741324118767`*^9}, {3.8460741949049115`*^9, 3.846074222593691*^9}, {
   3.8460742841895127`*^9, 3.846074340763191*^9}, {3.846160732253354*^9, 
   3.8461607332481594`*^9}, 3.846161492762432*^9, {3.846161780897497*^9, 
   3.846161788138113*^9}, {3.8461618293598766`*^9, 3.846161858226082*^9}, {
   3.8461618966585674`*^9, 3.846161969794857*^9}, 3.846162102689354*^9, {
   3.8461621668466263`*^9, 3.846162180355235*^9}, {3.8461622164826603`*^9, 
   3.8461622355856447`*^9}, {3.846162281065609*^9, 3.8461624985309367`*^9}, 
   3.8461626621493115`*^9, 3.846162697816634*^9, {3.8461627342864695`*^9, 
   3.8461627345822268`*^9}, {3.8461628166006966`*^9, 3.8461628174265194`*^9}, 
   3.846162849529516*^9, 3.846163042718745*^9, {3.8461630926561747`*^9, 
   3.8461631014520173`*^9}, 3.846164675187914*^9, {3.8461653709571285`*^9, 
   3.8461653939322076`*^9}, {3.846239297565034*^9, 3.846239321709072*^9}, {
   3.8462393704866405`*^9, 3.846239378462596*^9}, 3.8462394463604927`*^9, {
   3.846239908200873*^9, 3.846240041118046*^9}, {3.8462400979595313`*^9, 
   3.8462402075029526`*^9}, {3.846240330599819*^9, 3.846240332116249*^9}, {
   3.846240396409835*^9, 3.846240426609739*^9}, {3.8462404635946035`*^9, 
   3.846240479194495*^9}, {3.846240547126852*^9, 3.8462406007711906`*^9}, {
   3.846240672984129*^9, 3.8462406735655537`*^9}, {3.846240715451014*^9, 
   3.846240727662325*^9}, {3.8462408398048706`*^9, 3.8462408550133176`*^9}, {
   3.846240906219432*^9, 3.8462409845731764`*^9}, {3.8462415426024213`*^9, 
   3.846241600241384*^9}, {3.8462416533016524`*^9, 3.8462416824345474`*^9}, {
   3.846241871443136*^9, 3.846241889026347*^9}, {3.84624196622915*^9, 
   3.846241982209696*^9}, {3.8462420839315395`*^9, 3.8462421106657743`*^9}, {
   3.8462493213059616`*^9, 3.846249371505189*^9}, {3.846249426216957*^9, 
   3.8462494677076874`*^9}, {3.846249549506504*^9, 3.8462495503135986`*^9}, {
   3.8463317012472258`*^9, 3.846331723789422*^9}, 3.846331790148814*^9, {
   3.846331841946804*^9, 3.8463318642788124`*^9}, {3.8463318999649568`*^9, 
   3.84633190085021*^9}, {3.846331970187175*^9, 3.8463319724350276`*^9}, {
   3.846332425994608*^9, 3.8463324267831564`*^9}, {3.8463324853767433`*^9, 
   3.846332505743512*^9}, {3.84633253640195*^9, 3.84633253746087*^9}, 
   3.8463325927468147`*^9, {3.846332664076268*^9, 3.84633267729871*^9}, {
   3.84633282094595*^9, 3.846332866648316*^9}, {3.846332915983061*^9, 
   3.846332964772069*^9}, {3.8463332315659857`*^9, 3.8463332589840655`*^9}, {
   3.8463333159368706`*^9, 3.8463333881232243`*^9}, {3.846333478174964*^9, 
   3.846333507307977*^9}, {3.8463337169753866`*^9, 3.846333752677167*^9}, {
   3.8463337874930525`*^9, 3.8463337938266315`*^9}, {3.84633382889653*^9, 
   3.8463338314544067`*^9}, {3.8463338661347585`*^9, 
   3.8463338671064034`*^9}, {3.8463341029946103`*^9, 3.8463341178046017`*^9}, 
   3.8463344961508446`*^9, {3.846334551477289*^9, 3.8463345669722776`*^9}, {
   3.846334647851037*^9, 3.8463346507709723`*^9}, {3.8463350072556896`*^9, 
   3.846335009531336*^9}, {3.8463350584383993`*^9, 3.8463350832915545`*^9}, 
   3.8463356730391445`*^9, {3.8463357330577507`*^9, 3.846335734677639*^9}, {
   3.8463357713912954`*^9, 3.846335784599365*^9}, {3.846335824451017*^9, 
   3.846335850541898*^9}, {3.8465148279290648`*^9, 3.846514905645626*^9}, {
   3.8465149546536207`*^9, 3.8465149557287645`*^9}, 3.8465150347627506`*^9, 
   3.8465150735123754`*^9, 3.846515133355834*^9, {3.846551496354246*^9, 
   3.8465515199215117`*^9}, {3.8465515514860935`*^9, 3.846551558453719*^9}, {
   3.8465516511605453`*^9, 3.8465516816971188`*^9}, {3.8465517493251767`*^9, 
   3.8465517819787836`*^9}, {3.846551812162984*^9, 3.84655181978378*^9}, {
   3.8469012753631597`*^9, 3.8469014245266294`*^9}, {3.846901477101201*^9, 
   3.846901480891117*^9}, 3.846901533852523*^9, {3.8469015653056993`*^9, 
   3.8469015942691755`*^9}, 3.8469016260053563`*^9, {3.846901664939994*^9, 
   3.8469016657155457`*^9}, {3.846901747509447*^9, 3.8469017503170366`*^9}, {
   3.84690191404624*^9, 3.84690193970901*^9}, 3.846901985149589*^9, {
   3.84690203255608*^9, 3.8469020373058805`*^9}, {3.8469021528510695`*^9, 
   3.84690220430954*^9}, {3.8469022448931456`*^9, 3.8469022504597807`*^9}, {
   3.846902285388745*^9, 3.846902288603936*^9}, {3.8469023384879513`*^9, 
   3.846902371933584*^9}, 3.846902765731144*^9, {3.8469028332433987`*^9, 
   3.8469028443561935`*^9}, 3.8469030843801355`*^9, 3.846903160980903*^9, {
   3.8469032059828815`*^9, 3.8469032390870132`*^9}, {3.84690342310567*^9, 
   3.846903439207902*^9}, {3.8469061580301685`*^9, 3.8469062645476227`*^9}, {
   3.8469065486448135`*^9, 3.846906561548581*^9}, {3.8469067471371455`*^9, 
   3.8469068174896765`*^9}, {3.84690686154051*^9, 3.8469068684523077`*^9}, {
   3.8497527618146653`*^9, 3.8497527676380615`*^9}, {3.8497528414079475`*^9, 
   3.849752843454638*^9}, {3.8497530625145917`*^9, 3.849753063032662*^9}, {
   3.8497530971084747`*^9, 3.8497531011988783`*^9}, {3.8497532258666143`*^9, 
   3.849753345755213*^9}, {3.849753924288494*^9, 3.849753985952464*^9}, {
   3.849754069460248*^9, 3.849754087001464*^9}, {3.849754259204835*^9, 
   3.849754268999332*^9}, {3.8497554284565487`*^9, 3.8497554930272894`*^9}, {
   3.849755685279069*^9, 3.8497556896240177`*^9}, {3.8497558773614607`*^9, 
   3.849755877843891*^9}, {3.8497559807269473`*^9, 3.8497560211165953`*^9}, 
   3.850443650520732*^9, {3.8504438404083548`*^9, 3.8504441120345283`*^9}, {
   3.850444156664489*^9, 3.850444280967318*^9}, {3.850444354744196*^9, 
   3.85044463643923*^9}, {3.8504447256702757`*^9, 3.8504447980665684`*^9}, {
   3.8505274395909743`*^9, 3.8505274411181674`*^9}, {3.8505275310510144`*^9, 
   3.8505276349685197`*^9}, {3.850527665564816*^9, 3.850527741150744*^9}, {
   3.850528010969228*^9, 3.8505280914370484`*^9}, {3.850528341539154*^9, 
   3.8505283435766478`*^9}, {3.850528399268195*^9, 3.850528452926201*^9}, {
   3.850528511901552*^9, 3.850528524032834*^9}, {3.8505286008142643`*^9, 
   3.8505286255862675`*^9}, {3.850528657292616*^9, 3.8505287485299587`*^9}, {
   3.850528791091945*^9, 3.8505287912193995`*^9}, {3.8505289892778673`*^9, 
   3.8505290093703814`*^9}, {3.8505291179397283`*^9, 3.850529246368305*^9}, {
   3.8505292847200036`*^9, 3.8505293531238484`*^9}, {3.85052942526715*^9, 
   3.8505295026053452`*^9}, {3.850529652810694*^9, 3.85052969888447*^9}, {
   3.8505297570230837`*^9, 3.8505297793908668`*^9}, {3.8505298130474796`*^9, 
   3.85052982372943*^9}, 3.850529903643921*^9, {3.8505299339680395`*^9, 
   3.850529938523468*^9}, {3.850533467746894*^9, 3.850533696587976*^9}, {
   3.8505337523084393`*^9, 3.8505340100220647`*^9}, {3.850534073301394*^9, 
   3.8505341115212436`*^9}, {3.8505341448690495`*^9, 3.850534244609003*^9}, {
   3.8505342773409953`*^9, 3.850534317485276*^9}, {3.850534376818581*^9, 
   3.8505345375059347`*^9}, 3.8505345895823593`*^9, {3.850534712936541*^9, 
   3.850534853983102*^9}, {3.85053489565536*^9, 3.85053490800423*^9}, {
   3.850535011630887*^9, 3.850535069369616*^9}, {3.8505609789941187`*^9, 
   3.8505609796472797`*^9}, {3.850561024378234*^9, 3.8505611077291512`*^9}, {
   3.8505611554662695`*^9, 3.8505611900834045`*^9}, {3.8505612604815354`*^9, 
   3.850561307036023*^9}, 3.8505614161973686`*^9, {3.850561489892841*^9, 
   3.8505614904828854`*^9}, 3.850561540476676*^9, {3.850566961415826*^9, 
   3.85056699607444*^9}, {3.8505670465401917`*^9, 3.850567067268143*^9}, {
   3.850567124561453*^9, 3.8505671481746936`*^9}, {3.8505671891195374`*^9, 
   3.850567192972233*^9}, {3.8505672404233675`*^9, 3.850567272319547*^9}, {
   3.8505673802869396`*^9, 3.850567388289441*^9}, {3.850567420051065*^9, 
   3.8505674379775977`*^9}, {3.850568113924102*^9, 3.850568121245113*^9}, {
   3.8505681786419373`*^9, 3.8505682190225987`*^9}, {3.8505682742836356`*^9, 
   3.8505682972999997`*^9}, {3.850568330443387*^9, 3.8505683415549088`*^9}, {
   3.850568377492758*^9, 3.850568403154665*^9}, {3.850568837097434*^9, 
   3.850568946787299*^9}, {3.8505691453292117`*^9, 3.850569195539899*^9}, {
   3.8505692859376397`*^9, 3.8505693669331837`*^9}, {3.8505693974289236`*^9, 
   3.8505695475039663`*^9}, {3.8505696079724298`*^9, 
   3.8505696221275873`*^9}, {3.8505697874854712`*^9, 
   3.8505698175396166`*^9}, {3.850569868969412*^9, 3.8505698726296372`*^9}, {
   3.850569905926787*^9, 3.8505699809036593`*^9}, {3.850570015920215*^9, 
   3.85057008172045*^9}, {3.850785556912866*^9, 3.850785616614393*^9}, {
   3.8507856606466494`*^9, 3.850785723209618*^9}, {3.8507857656066175`*^9, 
   3.850785880874487*^9}, {3.850785924508508*^9, 3.850785937300992*^9}, {
   3.8507859750545197`*^9, 3.8507859968100834`*^9}, {3.850786077342246*^9, 
   3.8507860848236823`*^9}, {3.8507861340867023`*^9, 3.8507861374599075`*^9}, 
   3.850786227982345*^9, {3.8507862859910107`*^9, 3.8507863008387175`*^9}, {
   3.850786368316942*^9, 3.850786374976062*^9}, {3.850786423270744*^9, 
   3.850786423425295*^9}, {3.8507865491264324`*^9, 3.850786595976322*^9}, {
   3.850786636570469*^9, 3.850786709325587*^9}, {3.850786743990263*^9, 
   3.8507868015086374`*^9}, {3.8507870134211025`*^9, 
   3.8507870176048164`*^9}, {3.850787059141889*^9, 3.8507870650224657`*^9}, {
   3.850787111878257*^9, 3.850787113157389*^9}, {3.8507887599989805`*^9, 
   3.850788841851822*^9}, {3.850788913491912*^9, 3.8507890311085014`*^9}, {
   3.8507890809695005`*^9, 3.8507890902738066`*^9}, {3.8507891921970196`*^9, 
   3.8507891973037043`*^9}, {3.8507892279462795`*^9, 3.850789249495205*^9}, {
   3.850791412876636*^9, 3.8507914130273633`*^9}, {3.8507915155633483`*^9, 
   3.8507915162424593`*^9}, {3.850827343188859*^9, 3.850827375432101*^9}, {
   3.8508274109868975`*^9, 3.8508274369062905`*^9}, {3.8508274890786314`*^9, 
   3.8508274894138756`*^9}, {3.8508275695516253`*^9, 3.850827569788695*^9}, 
   3.8508276711587315`*^9, {3.8508277166165743`*^9, 3.8508277728386536`*^9}, {
   3.8508278475513325`*^9, 3.8508278753498926`*^9}, {3.8508279408872223`*^9, 
   3.85082794118405*^9}, {3.850827981298354*^9, 3.850828056921221*^9}, {
   3.850828494113824*^9, 3.850828495039543*^9}, {3.85082856023905*^9, 
   3.850828575017256*^9}, {3.850828628892047*^9, 3.850828696248144*^9}, 
   3.8508287630158415`*^9, {3.8508293694951773`*^9, 3.850829372071825*^9}, {
   3.8508294221130056`*^9, 3.8508294474505587`*^9}, {3.8508295136154523`*^9, 
   3.850829546786518*^9}, {3.8508307551495695`*^9, 3.850830755305548*^9}, {
   3.850830846425475*^9, 3.8508308469949007`*^9}, {3.8508328226756153`*^9, 
   3.8508328956454206`*^9}, {3.8515151599360895`*^9, 
   3.8515151854097323`*^9}, {3.851515227511881*^9, 3.8515152691971846`*^9}, {
   3.8517376565999703`*^9, 3.851737660729647*^9}, {3.8517376993937993`*^9, 
   3.851737854226467*^9}, {3.8517379030659018`*^9, 3.851737963592141*^9}, {
   3.8517380004040184`*^9, 3.851738156849004*^9}, {3.8517381881441555`*^9, 
   3.8517383547150526`*^9}, {3.851738403578961*^9, 3.8517384750343685`*^9}, {
   3.8517386329884996`*^9, 3.8517387036807384`*^9}, {3.8517387496128297`*^9, 
   3.8517391066461697`*^9}, 3.851739167106615*^9, {3.851739199324179*^9, 
   3.8517392033202653`*^9}, {3.851739306865944*^9, 3.8517396012506447`*^9}, {
   3.8517396478337793`*^9, 3.851739717012961*^9}, {3.851739779861041*^9, 
   3.8517398251446857`*^9}, {3.8517401674121*^9, 3.85174023031291*^9}, {
   3.8517403822763968`*^9, 3.8517405215277195`*^9}, {3.8517405598035936`*^9, 
   3.8517405807347307`*^9}, 3.8517406111741548`*^9, {3.852771815388609*^9, 
   3.852771815826337*^9}, {3.852771938933034*^9, 3.852772015527173*^9}, {
   3.8527720455326405`*^9, 3.852772051655347*^9}, {3.852772112575083*^9, 
   3.85277216712604*^9}, {3.8527722639917727`*^9, 3.8527723193930345`*^9}, {
   3.8527723507994275`*^9, 3.8527724886441803`*^9}, 3.852772518958836*^9, {
   3.8527726690962496`*^9, 3.8527726724595623`*^9}, {3.852772785224839*^9, 
   3.852772814059412*^9}, {3.8527728536940055`*^9, 3.8527728543197746`*^9}, 
   3.8527728940919833`*^9, {3.8527729250196114`*^9, 3.8527729905347033`*^9}, {
   3.8527730490675783`*^9, 3.8527730529881525`*^9}, {3.852773399558672*^9, 
   3.852773411256092*^9}, {3.852773459331044*^9, 3.852773480723246*^9}, {
   3.8527735251577444`*^9, 3.8527735647772226`*^9}, {3.85277372440212*^9, 
   3.852773727144375*^9}, {3.8528731960002193`*^9, 3.8528733256878357`*^9}, {
   3.852873387704274*^9, 3.852873409884766*^9}, {3.8528734508562613`*^9, 
   3.8528734515817213`*^9}, {3.8528734901873713`*^9, 3.852873528186962*^9}, {
   3.8528735614708843`*^9, 3.8528735812376013`*^9}, {3.8528736531146784`*^9, 
   3.852873677620881*^9}, {3.8528801200331235`*^9, 3.852880146194016*^9}, {
   3.853140879673688*^9, 3.8531409143592653`*^9}, {3.8531409625201416`*^9, 
   3.8531410288764524`*^9}, {3.8531410590292354`*^9, 
   3.8531411087537766`*^9}, {3.906960081539485*^9, 3.9069602331152077`*^9}, {
   3.9069603433707557`*^9, 3.906960532270595*^9}, {3.9069608107416534`*^9, 
   3.906960894501176*^9}, 3.906976975428384*^9, 3.9069784461360517`*^9, {
   3.9069784939955707`*^9, 3.906978495519633*^9}, {3.906979520056976*^9, 
   3.906979527909192*^9}, {3.9070299969708767`*^9, 3.9070299973647575`*^9}, 
   3.9070302622793455`*^9, {3.907031054878291*^9, 3.907031101672268*^9}, {
   3.907031132657627*^9, 3.907031137965227*^9}, {3.907031258015709*^9, 
   3.907031258244317*^9}, 3.907060462885079*^9, {3.9070616210919228`*^9, 
   3.9070617379829817`*^9}, {3.9070618359373693`*^9, 
   3.9070618491419787`*^9}, {3.9072168098312087`*^9, 
   3.9072168879034996`*^9}, {3.9072169598535347`*^9, 
   3.9072169971857233`*^9}, {3.9072170607219973`*^9, 3.907217066892645*^9}, {
   3.9076577595519457`*^9, 3.9076578173877373`*^9}, {3.9076578614233837`*^9, 
   3.907657894347175*^9}, {3.9076579602806206`*^9, 3.9076579846181087`*^9}, {
   3.9076596607447786`*^9, 3.9076596756372747`*^9}, 3.910745605690302*^9, {
   3.91074584911373*^9, 3.9107458926127214`*^9}, 3.910745941790287*^9, {
   3.910745986223607*^9, 3.910746063719597*^9}, {3.910747810729528*^9, 
   3.9107478791523943`*^9}, {3.9107479317978497`*^9, 
   3.9107479806408787`*^9}, {3.9107480256793222`*^9, 3.910748109579584*^9}, {
   3.91086543516223*^9, 3.9108654503446293`*^9}, {3.910865504589961*^9, 
   3.9108657401174555`*^9}, {3.91086584568825*^9, 3.910865852120024*^9}, 
   3.910865926383168*^9, 3.9108659744156675`*^9, 3.91086605745315*^9, {
   3.9108661771273518`*^9, 3.9108661799860926`*^9}, {3.9108662518520503`*^9, 
   3.9108662615334487`*^9}, 3.9108663396346254`*^9, {3.910866427961111*^9, 
   3.9108664324625444`*^9}, {3.910866648483549*^9, 3.910866665466797*^9}, {
   3.9108666978412094`*^9, 3.910866759019273*^9}, 3.9108668342632604`*^9, {
   3.9108668671138697`*^9, 3.910866882442206*^9}, {3.9108669792404804`*^9, 
   3.9108671430224776`*^9}, {3.9108671931495285`*^9, 3.910867227668786*^9}, {
   3.9108672957548175`*^9, 3.9108672974319744`*^9}, {3.910867368016037*^9, 
   3.910867368944265*^9}, 3.910867400227538*^9, {3.911008255763074*^9, 
   3.911008275926586*^9}, 3.9110083690822363`*^9, {3.9110084055565042`*^9, 
   3.9110084252803555`*^9}, 3.911008491161389*^9, {3.911008696240383*^9, 
   3.911008714321493*^9}, {3.9110088966274376`*^9, 3.911008900951162*^9}, {
   3.9110089635273657`*^9, 3.9110089783297873`*^9}, {3.911009014769552*^9, 
   3.9110090198434143`*^9}, {3.9110092308436937`*^9, 3.911009360495569*^9}, {
   3.9110093990206623`*^9, 3.9110094532567844`*^9}, {3.911009498630669*^9, 
   3.9110095367569847`*^9}, {3.9110095712912645`*^9, 
   3.9110096330820303`*^9}, {3.9110096653864827`*^9, 3.911009822963343*^9}, {
   3.911009859719963*^9, 3.911009866575224*^9}, {3.911009967367282*^9, 
   3.9110099850429783`*^9}, {3.911010028843105*^9, 3.9110101503231063`*^9}, {
   3.911010193179899*^9, 3.911010257505966*^9}, 3.911010335859486*^9, {
   3.911010401075186*^9, 3.911010457367464*^9}, 3.911010499750472*^9, {
   3.9110401234863586`*^9, 3.911040300892739*^9}, {3.9110403386146345`*^9, 
   3.911040544742799*^9}, {3.9110405856611333`*^9, 3.911040600084425*^9}, {
   3.9110409430788774`*^9, 3.9110409865360575`*^9}, {3.9110412680876427`*^9, 
   3.911041429298622*^9}, {3.911041589517542*^9, 3.9110416136098943`*^9}, {
   3.9110959319146233`*^9, 3.911096010751473*^9}, {3.9110962776335144`*^9, 
   3.911096327516655*^9}, {3.9110963649569387`*^9, 3.9110963792243595`*^9}, {
   3.917832590471942*^9, 3.91783259261812*^9}, {3.9178326929319906`*^9, 
   3.9178327503678517`*^9}, 3.9178328067760944`*^9, 3.917832854468274*^9, 
   3.917832888754475*^9, {3.917833107460365*^9, 3.917833108831243*^9}, {
   3.9178331620730915`*^9, 3.9178331825416665`*^9}, {3.9178332252920213`*^9, 
   3.917833227229144*^9}, 3.917833258961728*^9, {3.9178333424246206`*^9, 
   3.9178333517396064`*^9}, {3.917833444344221*^9, 3.9178334458517885`*^9}, 
   3.9178335515004683`*^9, {3.917833599553218*^9, 3.917833650004278*^9}, {
   3.917833691644823*^9, 3.917833692505719*^9}, {3.917834112622341*^9, 
   3.9178341280855384`*^9}, 3.917834171255001*^9, 3.9178342309758744`*^9, {
   3.917834295930198*^9, 3.917834298629716*^9}, 3.9178343890259485`*^9, 
   3.9178344550738645`*^9, {3.9178345592764263`*^9, 3.9178345765383854`*^9}, {
   3.9178349428335857`*^9, 3.917834957888749*^9}, {3.917835043598898*^9, 
   3.9178350499497914`*^9}, {3.917835648701893*^9, 3.9178356700048037`*^9}, {
   3.917835827590342*^9, 3.91783583779432*^9}, {3.917844702487713*^9, 
   3.9178447470333223`*^9}, {3.9178449064646893`*^9, 
   3.9178449159801645`*^9}, {3.9178449692656164`*^9, 
   3.9178450755686426`*^9}, {3.9178451261178627`*^9, 3.917845128031886*^9}, {
   3.91784611797869*^9, 3.917846150421515*^9}, {3.9178462178470125`*^9, 
   3.9178462188160224`*^9}, {3.9178463821131353`*^9, 3.917846404318012*^9}, {
   3.9178464868957653`*^9, 3.9178464974362345`*^9}, {3.9178466391768084`*^9, 
   3.917846660518054*^9}, {3.917846705713427*^9, 3.9178467398525267`*^9}, 
   3.9178467833607264`*^9, {3.917846824928237*^9, 3.9178468336706343`*^9}, {
   3.91784692713665*^9, 3.917846948232817*^9}, {3.917846984842763*^9, 
   3.9178470161506443`*^9}, {3.9182108415687127`*^9, 3.918210908004079*^9}, {
   3.9182109498407817`*^9, 3.9182111444301233`*^9}, {3.918211191133893*^9, 
   3.918211195152011*^9}, {3.9182112453708096`*^9, 3.9182112703404927`*^9}, {
   3.9182113141345406`*^9, 3.918211343884912*^9}, {3.918211377206615*^9, 
   3.9182113996989174`*^9}, {3.9182114444718027`*^9, 
   3.9182115011709948`*^9}, {3.918211554509279*^9, 3.9182118434838734`*^9}, {
   3.9182118844163384`*^9, 3.9182119340516095`*^9}, {3.918212144079294*^9, 
   3.9182121453109922`*^9}, {3.918212191518219*^9, 3.91821223630976*^9}, {
   3.918212271191306*^9, 3.9182122977139473`*^9}, {3.9182124886652174`*^9, 
   3.918212489073351*^9}, {3.918212590532064*^9, 3.9182127270755053`*^9}, {
   3.9182138417460346`*^9, 3.9182139048646154`*^9}, {3.9182146908437347`*^9, 
   3.9182149077374396`*^9}, {3.9182177073263197`*^9, 3.918217717322076*^9}, {
   3.918539524636157*^9, 3.918539527782719*^9}, {3.9185395590332627`*^9, 
   3.9185395632362785`*^9}, {3.9186078331321692`*^9, 3.918607833645181*^9}, {
   3.918607914428753*^9, 3.9186079207039227`*^9}, {3.9186084852881613`*^9, 
   3.91860866989282*^9}, {3.918608722991639*^9, 3.9186087765113287`*^9}, {
   3.9186088123606386`*^9, 3.918608816529477*^9}, {3.9186088543395295`*^9, 
   3.918608860108692*^9}, {3.918608891204424*^9, 3.9186088963485513`*^9}, {
   3.9186089310751266`*^9, 3.9186090347918806`*^9}, {3.9186143563438616`*^9, 
   3.9186143574276853`*^9}, 3.918629848595114*^9, 3.918629908583782*^9, {
   3.918629950660674*^9, 3.918629985878424*^9}, {3.918630102038577*^9, 
   3.9186301233091154`*^9}, {3.9186370529831204`*^9, 3.918637098446494*^9}, 
   3.918637239748101*^9, {3.918651032493411*^9, 3.9186510332241592`*^9}, 
   3.9186515711132927`*^9, {3.918651749050099*^9, 3.918651754020139*^9}, {
   3.918886175722066*^9, 3.918886277623564*^9}, {3.9188863475025697`*^9, 
   3.918886364944297*^9}, {3.9188864102911024`*^9, 3.9188864635769587`*^9}, {
   3.9188865129434056`*^9, 3.9188865210164766`*^9}, {3.9188866817537713`*^9, 
   3.918886797226532*^9}, {3.9188868431977205`*^9, 3.918886919954407*^9}, {
   3.918887501661186*^9, 3.9188875433729973`*^9}, 3.9189724260868464`*^9, {
   3.9189725984848385`*^9, 3.9189726144967713`*^9}, {3.9189894213903303`*^9, 
   3.918989440727315*^9}, {3.918991567575023*^9, 3.91899169221841*^9}, {
   3.918991756575407*^9, 3.918991764621538*^9}, {3.918991846575403*^9, 
   3.9189918651751175`*^9}, {3.918991923261159*^9, 3.918991943354218*^9}, {
   3.9189920897360425`*^9, 3.918992100937796*^9}, {3.919132509132023*^9, 
   3.9191325807306795`*^9}, {3.9191384189341793`*^9, 
   3.9191384486538267`*^9}, {3.9191623361135154`*^9, 3.919162375557169*^9}, {
   3.9191624544827147`*^9, 3.9191624952186127`*^9}, 3.9191625478255367`*^9, {
   3.9191638974162483`*^9, 3.9191638992562428`*^9}, 3.9191639333571525`*^9, {
   3.9191639680525956`*^9, 3.9191640136868615`*^9}, {3.919164047986966*^9, 
   3.919164056050922*^9}, 3.9191641210748734`*^9, 3.919211912165566*^9, {
   3.9192121282288237`*^9, 3.9192121298433332`*^9}, {3.920029118247701*^9, 
   3.920029146477833*^9}, {3.9200292003467803`*^9, 3.9200292482703037`*^9}, {
   3.9200292884372916`*^9, 3.92002931143719*^9}, {3.9200295509623346`*^9, 
   3.9200296116735344`*^9}, {3.9200300376648436`*^9, 3.9200300438906517`*^9}, 
   3.9200301108599806`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl1GlQk2cQB/BAhDcqCFWaSvEERouiw6EVEfM8gkKK3IpWFEZRDgcFi9hy
OCogwbQqIAUqqBWI2AaPgFHEa62h5Y6KQSRECXL55iIUEw4h9O24Mzs7v087
ux/+SyMTQqKMaTSaP9X/z88lR8sH3bn9/lpY3RE/4WNKOVqQP+mnhfBbbz/m
mMmRUYJPxzzKD/Y8JBdby1EJs2yml68Wkmp/fIVc5IhgZ1jzvLVAJqorTh6Q
o22ix51HkBba+qX+0w1yZOUalLbGWQvlzXdLDHk9KL9yv8++L7UwNMP8VOuW
XhTSzBe01gyBZJHl7IeyPrTgUWnTsm1DEMqOXngzbgA9Z0917dZr4GR3eHLC
gg8oQ2q9srdIA547jVKDBCTiNzOuOm7RwA0P7zqjaCWKZN6stxlWwx3ndwU1
89ToAEeaIStXw3bCds5ZngbdnyPx27BXDQHXMmN+W6lFmuDI2EM2amCt87NJ
1WtRxJSkZFW3CqaCnsyNeDyM6txNw0uvqyB3afrqFQX/ovL06DHzBBUkvL94
OStiBN1axUzM2qgC2zC6c6PbR8RVNoV/M1sFvF1MhoWFDjkM9HC7ZUpI/O6k
S99rHZqfF2MdJlSCldYtvfS2Hglq7pfZ/KIE42y2nSZlFF0VdqDpaCXUSf4g
bUPHUDLgaX9PJYTyq0d2OY6jljCvbUVLlOByZG7wEt046rtRbjOProRe1bM2
sXgC7YnrsjPvV4B8V+N1s+JP6CXnRLGoSQE3AlKe+u2bRGsjFqDsagX4TaRM
Ja2fQpbezvzOiwpwK3xxzpFuQCEjt+NZpxUw9uEnz5a3BsQWvJH7xCsgW9Tg
Hi+cRmVi18XWYQpwqV8nCmTRcG51Df8wWwGzzrimyfg0HFIbdCvxWwUwNkll
TpZGuOV7J65wmQLUj0P3co4a4fENo8ec5ivAo3BcF9hthJ3cG4iYmQqoimav
7fEyxlInQ1vSJAm5F4AzIDDGpDPjrO8QCQX3etLvMOl4M5POE/WSkHHlzZX0
VDo2a09zt+skobNntFU0QMep0vNvg8Uk7Fj4rKJ16wwseCZZ3VlHwkahMG9r
7Qxc1Wdltf4hCbMtjl9psjfBvbJzH/ZWkzC9T7P9C64JtlJU/F7GJyHckruw
RWeCk58fmPqrjIT398Q5AbtNsT5QFCgrISFgKWnX9sQUa89fCDtVQIL94Mqm
xhUELpQYDpvmkLDkmvXX3BwCW6xaIw/jknCWVaXzzSOwt2PwTk/Kox3sl2b5
BJ7f4tDuQFk8K/lMbiGBGT+b9o+dIeH4kdf6ossE7o90Dy2i/GZD/quKSgI/
CtAea8+m/tNmdq6unsAn8tsrd3BImIzjxXIaCcwc6dKzKMeYeGxmNxN4uHk/
ezllllvcp2YxgZ/+rTWMZpGgutx48FU7gX0/tdZepMw+yPF+30vguVaMqHen
SRAaL7Ll9VP7uoK+qqe8+NLdqahBAh/6x/D8NmW9uE9IKgjsRcvcnk6Zt8bL
bniYwBdok3/aU7YUSw3VIwRu6PDIMaecFpMoTdIROKRdkqrPJCGkuDRvbIy6
P4Ae1UD5iev6ww8mCDwYWLi/irJD6wv28UkCO2alxBZT/jU61p5lIHCES+XR
TMqf84uBf7jkkHWI8n+xyo0e
      "]]}}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0, -1.124433358085935}, {0.5, -1.124433358085935}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, -0.7871033506601545}, {3, -0.7871033506601545}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, -1.124433358085935}, {0.5, -0.7871033506601545}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0.5, -1.124433358085935}, {0.5, -1.0190177307653785`}}]}, {
    InsetBox[
     RowBox[{"\[Theta]", "=", 
      RowBox[{"+", "1"}]}], {2.3851473922902513`, -0.21698520678112354`}, {
     Left, Baseline},
     Alignment->{Left, Top}], {InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         StyleBox[
          SubscriptBox["\[Tau]", "d"],
          FontSize->12], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.8",
           FontSize->12], 
          StyleBox[" ",
           FontSize->12], 
          StyleBox["ms",
           FontSize->12], " "}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[1.]], {2.172222222222224, -0.5131735233776054}, {
      Left, Baseline},
      Alignment->{Left, Top}], InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         StyleBox[
          SubscriptBox["\[Tau]", "e"],
          FontSize->12], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.5",
           FontSize->12], 
          StyleBox["  ",
           FontSize->12], 
          StyleBox["ms",
           FontSize->12], " "}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[
        1.]], {2.172222222222223, -0.36345966958211884`}, {Left, Baseline},
      Alignment->{Left, Top}]}}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"t (ms)\"", FontSize -> 20, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1.5, 
      FormBox[
       RowBox[{"-", "1.5`"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{65., 25.}, {51., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{0., 3.}, {-1.5, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.9200301278623557`*^9, 3.9200301390384083`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2nk0lN0fAPAJWVokvIVUljaSpBIq36mEFCGEFJXkleJVCZXsS5SlkpCl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      "]]}}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0, -1.124433358085935}, {0.5, -1.124433358085935}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, -0.7871033506601545}, {3, -0.7871033506601545}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, -1.124433358085935}, {0.5, -0.7871033506601545}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0.5, -1.124433358085935}, {0.5, -0.28110833952148384`}}]}, {
    InsetBox[
     RowBox[{"\[Theta]", "=", 
      RowBox[{"+", "1"}]}], {2.3795918367346953`, -0.18127092106683707`}, {
     Left, Baseline},
     Alignment->{Left, Top}], {InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         StyleBox[
          SubscriptBox["\[Tau]", "d"],
          FontSize->12], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.1",
           FontSize->12], 
          StyleBox[" ",
           FontSize->12], 
          StyleBox["ms",
           FontSize->12], " "}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[1.]], {2.166666666666668, -0.4774592376633189}, {
      Left, Baseline},
      Alignment->{Left, Top}], InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         StyleBox[
          SubscriptBox["\[Tau]", "e"],
          FontSize->12], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.5",
           FontSize->12], 
          StyleBox["  ",
           FontSize->12], 
          StyleBox["ms",
           FontSize->12], " "}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[
        1.]], {2.166666666666667, -0.32774538386783236`}, {Left, Baseline},
      Alignment->{Left, Top}]}}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"t (ms)\"", FontSize -> 20, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1.5, 
      FormBox[
       RowBox[{"-", "1.5`"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{65., 25.}, {51., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{0., 3.}, {-1.5, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.920030069649638*^9, 3.9200300877670536`*^9}}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Theta]", "=", 
     RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"V0", "=", 
     RowBox[{"-", "0.5"}]}], ";", 
    RowBox[{"DV", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t0", "=", "0.5"}], ";", 
    RowBox[{"tfin", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Tau]e", "=", "0.5"}], ";", 
    RowBox[{"\[Tau]d", "=", "0.05"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Iin", "=", 
     RowBox[{"Idc", "[", "V0", "]"}]}], ";", 
    RowBox[{"Ifin", "=", 
     RowBox[{
      RowBox[{"Idc", "[", "V0", "]"}], "+", 
      RowBox[{"\[Theta]", " ", 
       RowBox[{"cmu", "[", "V0", "]"}], " ", 
       RowBox[{"L", " ", "/", "\[Tau]e"}], " ", "DV"}]}]}], ";", 
    RowBox[{"I0", "=", 
     RowBox[{
      RowBox[{"Idc", "[", "V0", "]"}], "+", 
      RowBox[{
       RowBox[{"cmu", "[", "V0", "]"}], " ", "f", " ", 
       RowBox[{"L", " ", "/", "\[Tau]d"}], " ", "DV"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ui1", "=", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tt", ",", 
         RowBox[{
          RowBox[{"Idc", "[", "V0", "]"}], "+", 
          RowBox[{
           RowBox[{"cmu", "[", "V0", "]"}], " ", "L", "  ", "DV", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", "/", "\[Tau]d"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Theta]", " ", "/", "\[Tau]e"}], "-", 
                RowBox[{"f", "/", "\[Tau]d"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{"tt", "-", "t0"}], ")"}]}], "/", "\[Tau]d"}], 
                 "]"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tt", ",", "t0", ",", "tfin"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<t (ms)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(d\)]\) (\[Mu]A)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", 
            RowBox[{"-", "2"}], ",", 
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "0.5"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", 
            RowBox[{"-", "3"}], ",", 
            RowBox[{"-", "2"}], ",", 
            RowBox[{"-", "1.5"}], ",", 
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "0.5"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
           "}"}], ",", "None", ",", "None"}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue"}], "}"}],
          "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fg1", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "Iin"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t0", ",", "Iin"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";", 
    RowBox[{"fg4", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"t0", ",", 
             RowBox[{"Idc", "[", "V0", "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t0", ",", "I0"}], " ", "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";", 
    RowBox[{"fg2", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Brown", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"t0", ",", "Ifin"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"tfin", ",", "Ifin"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fg3", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Brown", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"t0", ",", "Iin"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t0", ",", "Ifin"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Tau]d", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ui2", "=", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tt", ",", 
         RowBox[{
          RowBox[{"Idc", "[", "V0", "]"}], "+", 
          RowBox[{
           RowBox[{"cmu", "[", "V0", "]"}], " ", "L", "  ", "DV", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", "/", "\[Tau]d"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Theta]", " ", "/", "\[Tau]e"}], "-", 
                RowBox[{"f", "/", "\[Tau]d"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{"tt", "-", "t0"}], ")"}]}], "/", "\[Tau]d"}], 
                 "]"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tt", ",", "t0", ",", "tfin"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<t (ms)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(d\)]\) (\[Mu]A)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", 
            RowBox[{"-", "2"}], ",", 
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "0.5"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", 
            RowBox[{"-", "3"}], ",", 
            RowBox[{"-", "2"}], ",", 
            RowBox[{"-", "1.5"}], ",", 
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "0.5"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
           "}"}], ",", "None", ",", "None"}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Green"}], 
          "}"}], "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Tau]d", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ui3", "=", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tt", ",", 
         RowBox[{
          RowBox[{"Idc", "[", "V0", "]"}], "+", 
          RowBox[{
           RowBox[{"cmu", "[", "V0", "]"}], " ", "L", "  ", "DV", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", "/", "\[Tau]d"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Theta]", " ", "/", "\[Tau]e"}], "-", 
                RowBox[{"f", "/", "\[Tau]d"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{"tt", "-", "t0"}], ")"}]}], "/", "\[Tau]d"}], 
                 "]"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tt", ",", "t0", ",", "tfin"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<t (ms)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(d\)]\) (\[Mu]A)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", 
            RowBox[{"-", "2"}], ",", 
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "0.5"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", 
            RowBox[{"-", "3"}], ",", 
            RowBox[{"-", "2"}], ",", 
            RowBox[{"-", "1.5"}], ",", 
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "0.5"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
           "}"}], ",", "None", ",", "None"}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Orange"}], 
          "}"}], "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
    "ui3", ",", "ui2", ",", "ui1", ",", "fg1", ",", "fg2", ",", "fg3", ",", 
     "fg4", ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "tfin"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"BaseStyle", "->", 
      RowBox[{"{", 
       RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8390646611298313`*^9, 3.839064663549252*^9}, {
   3.8390651628201227`*^9, 3.8390651698744855`*^9}, {3.8390671245340233`*^9, 
   3.839067253968177*^9}, {3.8390672908692884`*^9, 3.8390673435588245`*^9}, {
   3.839067444277615*^9, 3.8390674530816755`*^9}, {3.839067483223913*^9, 
   3.8390676448632746`*^9}, {3.839067792030848*^9, 3.8390679296503277`*^9}, {
   3.839068035965031*^9, 3.8390681198292847`*^9}, {3.8390709139116144`*^9, 
   3.8390709421089935`*^9}, {3.83907099038449*^9, 3.8390709930117693`*^9}, {
   3.839071053413534*^9, 3.839071065617492*^9}, {3.839071142245447*^9, 
   3.8390712315177836`*^9}, {3.839071262559967*^9, 3.8390713000871944`*^9}, {
   3.8390714971122246`*^9, 3.839071517359198*^9}, {3.8390715485300074`*^9, 
   3.8390716200472517`*^9}, {3.8390716672806673`*^9, 3.839071782347397*^9}, {
   3.839071837937226*^9, 3.839071939311781*^9}, {3.839072168081314*^9, 
   3.839072168581891*^9}, {3.8390723168444653`*^9, 3.8390724465495067`*^9}, {
   3.8390724871236815`*^9, 3.839072628537404*^9}, {3.8390726857581015`*^9, 
   3.83907270608572*^9}, {3.8390728526632924`*^9, 3.8390730714112225`*^9}, {
   3.839082271666379*^9, 3.8390823055073657`*^9}, {3.839082353119522*^9, 
   3.839082449840514*^9}, {3.8390839765348864`*^9, 3.839084057466158*^9}, {
   3.8390840878065057`*^9, 3.8390841778809776`*^9}, {3.8390842363292522`*^9, 
   3.8390842982497163`*^9}, 3.83908433029414*^9, {3.8390843708346243`*^9, 
   3.8390844315092807`*^9}, 3.839084462612833*^9, {3.8390845298830824`*^9, 
   3.839084537171591*^9}, {3.8390846234607463`*^9, 3.839084639769829*^9}, {
   3.839085385972989*^9, 3.8390853976007433`*^9}, {3.8390854555897675`*^9, 
   3.839085524444199*^9}, {3.839085565738154*^9, 3.8390855920819826`*^9}, {
   3.8390863447286386`*^9, 3.839086474045252*^9}, {3.839086860852067*^9, 
   3.839086874816577*^9}, {3.839087637034748*^9, 3.8390876843714943`*^9}, 
   3.83908780285631*^9, 3.8390878367914057`*^9, {3.839088015231053*^9, 
   3.8390880802460375`*^9}, {3.839088241208177*^9, 3.839088251058446*^9}, 
   3.839088396382834*^9, 3.8391182307918463`*^9, {3.839118379381566*^9, 
   3.8391183868618546`*^9}, {3.839118542781612*^9, 3.839118576690755*^9}, {
   3.839119230679368*^9, 3.8391192435152392`*^9}, {3.8391193005384474`*^9, 
   3.839119322077612*^9}, {3.8391197370496492`*^9, 3.839119744561663*^9}, {
   3.839119780647091*^9, 3.8391198576053133`*^9}, {3.83913747847266*^9, 
   3.839137485481214*^9}, {3.8391375587687283`*^9, 3.8391375797199593`*^9}, {
   3.8391376276780567`*^9, 3.8391376620779104`*^9}, {3.83913835785732*^9, 
   3.839138374216883*^9}, 3.8391384110040264`*^9, {3.8391384624942074`*^9, 
   3.839138462879356*^9}, {3.8391385170099597`*^9, 3.839138536349577*^9}, {
   3.839139183554804*^9, 3.8391391930138044`*^9}, {3.8391393033973885`*^9, 
   3.8391393043613095`*^9}, 3.839139359067504*^9, 3.839139436240513*^9, {
   3.8392078031308994`*^9, 3.8392078143543434`*^9}, {3.8392078889566584`*^9, 
   3.83920790820275*^9}, {3.839208054761527*^9, 3.839208093399903*^9}, {
   3.8392084092575808`*^9, 3.8392084620514746`*^9}, 3.839208533536579*^9, {
   3.8392086070037084`*^9, 3.8392086083290124`*^9}, 3.8392086479255266`*^9, {
   3.8392225965883913`*^9, 3.8392226283136573`*^9}, {3.8392226646362276`*^9, 
   3.8392227421040397`*^9}, 3.8392227767756677`*^9, {3.8392228326927814`*^9, 
   3.839222892911393*^9}, 3.8392230743763013`*^9, {3.839223141092394*^9, 
   3.839223141783134*^9}, 3.839223177642132*^9, {3.8392232273840017`*^9, 
   3.8392232854596047`*^9}, {3.8392233573873816`*^9, 3.839223398790718*^9}, {
   3.8392234505961695`*^9, 3.839223507183962*^9}, {3.839223811017748*^9, 
   3.8392239510950837`*^9}, {3.8392240167007127`*^9, 3.839224025275307*^9}, {
   3.8392241057509785`*^9, 3.839224157437503*^9}, {3.839224200897134*^9, 
   3.8392242487597456`*^9}, {3.839224294917468*^9, 3.839224296013791*^9}, {
   3.8392243639841394`*^9, 3.8392243950383773`*^9}, 3.839224442185709*^9, {
   3.8392245129185476`*^9, 3.8392245373577056`*^9}, {3.8392245776385975`*^9, 
   3.839224740679908*^9}, {3.8392248367057567`*^9, 3.839224838004247*^9}, {
   3.8392249023255987`*^9, 3.8392249329681873`*^9}, 3.8392250078513308`*^9, {
   3.8392250461420965`*^9, 3.8392250567765236`*^9}, {3.8392250892690206`*^9, 
   3.839225128234888*^9}, {3.839225292837965*^9, 3.8392253052980237`*^9}, {
   3.839225374465659*^9, 3.839225378163327*^9}, {3.8392366608564453`*^9, 
   3.839236691352835*^9}, {3.839236736346908*^9, 3.8392367461057377`*^9}, {
   3.8392368452896976`*^9, 3.8392369245276327`*^9}, {3.8392369586763678`*^9, 
   3.839236989556669*^9}, {3.8392370210310707`*^9, 3.839237025639107*^9}, {
   3.8392370611832547`*^9, 3.839237143422812*^9}, {3.839237229917989*^9, 
   3.839237306453603*^9}, {3.8392373387206373`*^9, 3.839237342820054*^9}, {
   3.839237447098841*^9, 3.8392375543643665`*^9}, {3.8392411494009237`*^9, 
   3.839241171431179*^9}, {3.83924120627816*^9, 3.8392412247291117`*^9}, 
   3.8392412792201967`*^9, 3.8392413874247665`*^9, {3.8392415172512045`*^9, 
   3.8392415791894693`*^9}, {3.839241632182249*^9, 3.8392416472548246`*^9}, 
   3.8392418101230965`*^9, {3.839242047805271*^9, 3.8392420951804295`*^9}, {
   3.8392421670049934`*^9, 3.8392422247577305`*^9}, {3.8392422574679546`*^9, 
   3.8392422587095203`*^9}, {3.839242291908*^9, 3.8392425704347763`*^9}, {
   3.8392426617662134`*^9, 3.8392426717163734`*^9}, 3.839242785862258*^9, {
   3.839246817917405*^9, 3.8392468269690895`*^9}, {3.839246889891876*^9, 
   3.839246924816616*^9}, {3.839309996677757*^9, 3.839310018708186*^9}, {
   3.839310845764266*^9, 3.839310880859878*^9}, {3.839310926113166*^9, 
   3.839310949193386*^9}, {3.8393110019361973`*^9, 3.8393110308399534`*^9}, {
   3.8393270934512377`*^9, 3.839327332415727*^9}, {3.839327370226597*^9, 
   3.839327451303669*^9}, {3.8393275031436253`*^9, 3.8393275194960613`*^9}, {
   3.839327586008069*^9, 3.8393276948310633`*^9}, {3.8393278034898295`*^9, 
   3.8393278068680096`*^9}, {3.8393278450424776`*^9, 
   3.8393278797618237`*^9}, {3.8393289610021143`*^9, 3.839328976754302*^9}, {
   3.8393294967878103`*^9, 3.839329617607455*^9}, 3.8393297021511583`*^9, {
   3.839329736764967*^9, 3.83932973839811*^9}, {3.839329841358012*^9, 
   3.839329850076448*^9}, {3.8393298856244183`*^9, 3.83932990739045*^9}, {
   3.839330200791801*^9, 3.839330209464896*^9}, 3.83933026862875*^9, {
   3.8393304947792683`*^9, 3.839330614321838*^9}, {3.839330707456501*^9, 
   3.8393307223587484`*^9}, {3.8393307586469154`*^9, 3.839330774655125*^9}, {
   3.8393308208469334`*^9, 3.8393308254369345`*^9}, {3.83933092079788*^9, 
   3.8393310148602314`*^9}, {3.8393311745075006`*^9, 
   3.8393311994275675`*^9}, {3.8393312620131807`*^9, 
   3.8393312886598005`*^9}, {3.83933158528376*^9, 3.8393316720258255`*^9}, 
   3.8393317188850336`*^9, {3.8393317973728094`*^9, 3.8393319397094903`*^9}, 
   3.8393320294844685`*^9, {3.8393325727147913`*^9, 3.8393326007437224`*^9}, {
   3.839332643937569*^9, 3.8393326886712303`*^9}, {3.839332884251463*^9, 
   3.8393328849388123`*^9}, {3.8393329498885293`*^9, 3.839332954368989*^9}, 
   3.839332984548478*^9, {3.839333161836732*^9, 3.839333179429063*^9}, {
   3.839333212168277*^9, 3.8393332158859396`*^9}, {3.839333299885914*^9, 
   3.839333320058819*^9}, {3.8393333662749724`*^9, 3.839333389618166*^9}, 
   3.8393335815372777`*^9, {3.8393336646381135`*^9, 3.839333690640252*^9}, {
   3.839333816187891*^9, 3.839333852596138*^9}, {3.839333913143673*^9, 
   3.839333960953573*^9}, {3.8393340547869487`*^9, 3.839334137419753*^9}, {
   3.839420765475212*^9, 3.839420767706482*^9}, {3.839420800720344*^9, 
   3.83942080814257*^9}, {3.839420930166752*^9, 3.839420954611184*^9}, 
   3.839421093306271*^9, {3.839421249787591*^9, 3.8394213460868835`*^9}, {
   3.839421400152422*^9, 3.8394214417353144`*^9}, {3.839421483648677*^9, 
   3.839421580608614*^9}, 3.839421616079374*^9, 3.839422181142932*^9, {
   3.8394224472930202`*^9, 3.839422448371497*^9}, {3.8394225405886507`*^9, 
   3.839422541885687*^9}, {3.8394225839963813`*^9, 3.83942258751882*^9}, 
   3.8394239784679832`*^9, {3.8394240190394516`*^9, 3.8394240194005165`*^9}, {
   3.839481241680246*^9, 3.8394812636526537`*^9}, {3.8394813033197775`*^9, 
   3.839481343020226*^9}, {3.8394813886318493`*^9, 3.83948138904453*^9}, {
   3.8394814470082235`*^9, 3.8394815138762083`*^9}, {3.839484145142799*^9, 
   3.8394841575703464`*^9}, {3.8394842427712455`*^9, 
   3.8394842456191454`*^9}, {3.8394844396674995`*^9, 
   3.8394844660440836`*^9}, {3.8394845806487627`*^9, 3.83948460808449*^9}, {
   3.8394847191879005`*^9, 3.839484719920673*^9}, {3.8394847985864277`*^9, 
   3.8394847999498053`*^9}, {3.839485522225484*^9, 3.8394858614478054`*^9}, {
   3.8394858968609977`*^9, 3.8394858979280567`*^9}, {3.83950394022218*^9, 
   3.839504016595684*^9}, {3.839504079022719*^9, 3.8395041716366367`*^9}, {
   3.8395042475063295`*^9, 3.83950424807436*^9}, {3.8395043044033585`*^9, 
   3.8395043325148754`*^9}, {3.839504403912784*^9, 3.839504405955762*^9}, {
   3.839504461254238*^9, 3.8395044954062967`*^9}, {3.839504572085556*^9, 
   3.8395046258331623`*^9}, {3.839504718095887*^9, 3.839504733043982*^9}, {
   3.839504792704324*^9, 3.8395048214714227`*^9}, {3.8395048602645364`*^9, 
   3.839504871422516*^9}, {3.83950521161292*^9, 3.8395052235501237`*^9}, {
   3.839505255990897*^9, 3.8395052773582516`*^9}, {3.839505321851119*^9, 
   3.839505332451271*^9}, {3.8395054257374*^9, 3.8395054385582395`*^9}, 
   3.839505580972617*^9, {3.8395057025144815`*^9, 3.8395057031788645`*^9}, {
   3.8395057369934807`*^9, 3.8395057373979363`*^9}, {3.839505772294227*^9, 
   3.839505778367197*^9}, {3.83950673092721*^9, 3.8395067795192204`*^9}, {
   3.8395084122279215`*^9, 3.8395084138977666`*^9}, {3.839508448233049*^9, 
   3.8395084493422976`*^9}, {3.839508499051385*^9, 3.8395085344200335`*^9}, 
   3.8395086207285233`*^9, {3.8395086973952723`*^9, 3.8395086978689127`*^9}, {
   3.8395089696790757`*^9, 3.839509039224576*^9}, {3.8395100524490423`*^9, 
   3.839510053723009*^9}, {3.839511493807127*^9, 3.8395115089839754`*^9}, {
   3.8395115931589155`*^9, 3.839511633911852*^9}, {3.839511664551564*^9, 
   3.8395117021779413`*^9}, {3.839511738662855*^9, 3.8395117683886237`*^9}, {
   3.8395840465025244`*^9, 3.8395840478719764`*^9}, {3.8395842326636224`*^9, 
   3.8395842405526743`*^9}, {3.8395844072352886`*^9, 3.839584438590257*^9}, {
   3.839584539157859*^9, 3.839584558647271*^9}, {3.8395846133789663`*^9, 
   3.83958465811094*^9}, {3.839584785836444*^9, 3.839584807986281*^9}, 
   3.839586726652771*^9, {3.8395867995416994`*^9, 3.8395868420413933`*^9}, 
   3.83958688638865*^9, {3.839587244941451*^9, 3.83958726487414*^9}, {
   3.83958774293878*^9, 3.8395877838602095`*^9}, 3.839587828597546*^9, {
   3.839587879706158*^9, 3.8395879135449758`*^9}, {3.839587955043039*^9, 
   3.8395879642045746`*^9}, {3.8395880048781385`*^9, 3.839588051406326*^9}, {
   3.8395880883490973`*^9, 3.8395881594520197`*^9}, {3.8395882347911615`*^9, 
   3.8395883226336384`*^9}, 3.8395883559509153`*^9, 3.839588415451826*^9, {
   3.8395884902783833`*^9, 3.8395885216082554`*^9}, {3.8395941073926105`*^9, 
   3.8395942227438965`*^9}, 3.839595304916483*^9, {3.8395954862576475`*^9, 
   3.83959557521957*^9}, {3.839595607221432*^9, 3.8395956076140194`*^9}, {
   3.839595660820343*^9, 3.839595661835729*^9}, {3.839604650775865*^9, 
   3.8396046640054827`*^9}, {3.839604708532463*^9, 3.8396047629301977`*^9}, {
   3.839604795558606*^9, 3.839604808947177*^9}, {3.839604852056878*^9, 
   3.8396048690185547`*^9}, {3.839642088079403*^9, 3.839642141004441*^9}, {
   3.8396422800918975`*^9, 3.8396423077286944`*^9}, {3.8396424143783884`*^9, 
   3.8396424152236857`*^9}, {3.8396426095904264`*^9, 
   3.8396426100591545`*^9}, {3.8396426843268356`*^9, 3.8396426912164164`*^9}, 
   3.8396427676568155`*^9, {3.8396428549330425`*^9, 3.8396429650459213`*^9}, 
   3.839643049962629*^9, {3.839643091872772*^9, 3.8396431410841303`*^9}, 
   3.839643491656567*^9, {3.839643550041149*^9, 3.839643610060313*^9}, {
   3.8396436783391447`*^9, 3.8396437059963512`*^9}, {3.8396437389632745`*^9, 
   3.8396437448257093`*^9}, {3.839643793497415*^9, 3.8396438275668716`*^9}, {
   3.839643978745996*^9, 3.8396439798436737`*^9}, {3.839644021519642*^9, 
   3.8396440428152156`*^9}, {3.8396441695399504`*^9, 
   3.8396441971715937`*^9}, {3.839644230142295*^9, 3.8396442469945946`*^9}, {
   3.839644284692358*^9, 3.8396442961501245`*^9}, {3.8396443434969287`*^9, 
   3.8396443583914576`*^9}, {3.8396448346105194`*^9, 3.839644913123821*^9}, {
   3.8396555898716025`*^9, 3.839655650012109*^9}, {3.8396556822310605`*^9, 
   3.839655771771843*^9}, {3.839655952479162*^9, 3.8396559541084647`*^9}, 
   3.839656003389371*^9, {3.8396560347174463`*^9, 3.839656116850046*^9}, {
   3.8396562422855325`*^9, 3.8396562713341274`*^9}, 3.8396563271846943`*^9, {
   3.8396565529884825`*^9, 3.839656667985509*^9}, {3.8396568526250334`*^9, 
   3.839656873162519*^9}, {3.8396570321068354`*^9, 3.8396570367161813`*^9}, {
   3.8396571621919303`*^9, 3.839657193340761*^9}, {3.839657225174745*^9, 
   3.8396572442512493`*^9}, {3.8396572932236905`*^9, 3.8396572940165*^9}, 
   3.8396574072631903`*^9, {3.8396575476060143`*^9, 3.8396575682943974`*^9}, {
   3.839664138921971*^9, 3.839664156869915*^9}, 3.839664243007531*^9, {
   3.839669622125418*^9, 3.839669647884663*^9}, {3.839670002387182*^9, 
   3.839670025487237*^9}, {3.8396700586539392`*^9, 3.8396701085420904`*^9}, {
   3.8396766028729286`*^9, 3.839676603372811*^9}, {3.839676649783103*^9, 
   3.8396766681979322`*^9}, {3.839723206211033*^9, 3.839723252419324*^9}, {
   3.8397243192805915`*^9, 3.8397243622670403`*^9}, {3.839724526690404*^9, 
   3.8397245565593586`*^9}, 3.839724591814554*^9, {3.8397246526353917`*^9, 
   3.8397246677187424`*^9}, {3.839724698665658*^9, 3.8397248461537275`*^9}, {
   3.839724910156172*^9, 3.839724969029936*^9}, {3.839725029399225*^9, 
   3.839725070375955*^9}, {3.8397257491640964`*^9, 3.8397258148584566`*^9}, {
   3.839726205531111*^9, 3.839726226304987*^9}, {3.839726314389023*^9, 
   3.8397264887181263`*^9}, {3.8397266355093994`*^9, 
   3.8397266356472826`*^9}, {3.839727069639051*^9, 3.83972707062368*^9}, {
   3.8397274615058823`*^9, 3.839727481527841*^9}, {3.83972755827617*^9, 
   3.8397275594724007`*^9}, {3.839727857737072*^9, 3.83972788618902*^9}, 
   3.8397281801577473`*^9, {3.839741406815917*^9, 3.839741648719699*^9}, 
   3.839741694966459*^9, {3.8397417738301263`*^9, 3.8397417740488653`*^9}, 
   3.839742014559319*^9, {3.8397421882027674`*^9, 3.839742188943444*^9}, {
   3.8397589658528605`*^9, 3.83975903164762*^9}, {3.839759582024466*^9, 
   3.8397596437148447`*^9}, {3.8397597378135786`*^9, 3.839759770277839*^9}, {
   3.839760042248042*^9, 3.8397600434337606`*^9}, {3.839760792865179*^9, 
   3.839760817913896*^9}, {3.8397655048182044`*^9, 3.839765505036851*^9}, {
   3.839765649791177*^9, 3.839765680039174*^9}, {3.839765730951825*^9, 
   3.8397657438209515`*^9}, {3.8397658325268707`*^9, 3.839765870890603*^9}, {
   3.8397695336031294`*^9, 3.8397695785421767`*^9}, 3.839769610638837*^9, {
   3.839769642999297*^9, 3.8397696900062704`*^9}, {3.8397697294324865`*^9, 
   3.839769753667972*^9}, 3.839770624201335*^9, {3.8399858643515997`*^9, 
   3.839985870106961*^9}, {3.8399859073530426`*^9, 3.83998590778368*^9}, {
   3.839986665758301*^9, 3.839986671600184*^9}, {3.840015477117873*^9, 
   3.840015532633871*^9}, {3.840262190474472*^9, 3.8402621922160215`*^9}, {
   3.8402622512898836`*^9, 3.8402623158498154`*^9}, {3.840262346847395*^9, 
   3.840262361938197*^9}, {3.8402624446884875`*^9, 3.840262497278998*^9}, {
   3.8402625593196363`*^9, 3.840262562846277*^9}, {3.840262654524027*^9, 
   3.8402626673364897`*^9}, {3.8402800661176753`*^9, 3.840280138278593*^9}, {
   3.840280177703832*^9, 3.840280189480773*^9}, {3.8402802324576406`*^9, 
   3.8402802331825943`*^9}, {3.8402812754975386`*^9, 3.840281326464582*^9}, 
   3.8402813946519136`*^9, {3.84028186111417*^9, 3.8402818954912634`*^9}, {
   3.8402819964993353`*^9, 3.8402819971437144`*^9}, {3.840330466229367*^9, 
   3.8403304972505484`*^9}, 3.8403305401374164`*^9, 3.840330628649666*^9, {
   3.8403306672934227`*^9, 3.8403306802026963`*^9}, {3.8403307193320885`*^9, 
   3.840330758272279*^9}, 3.8403307967908325`*^9, 3.8403308358680725`*^9, {
   3.840330872410847*^9, 3.8403308786837*^9}, {3.8403309221453967`*^9, 
   3.840330944340696*^9}, 3.840330989285677*^9, {3.840331109810131*^9, 
   3.840331153164013*^9}, {3.840331431580937*^9, 3.8403314406879196`*^9}, {
   3.8403317789283185`*^9, 3.840331780542934*^9}, {3.840331813886128*^9, 
   3.8403318320633073`*^9}, {3.8403318821336937`*^9, 
   3.8403318897950106`*^9}, {3.8403319357741313`*^9, 
   3.8403319411825953`*^9}, {3.8403320129500637`*^9, 
   3.8403321277278547`*^9}, {3.840332221075777*^9, 3.8403322212632327`*^9}, {
   3.8404162792747984`*^9, 3.8404162803058043`*^9}, {3.840416344690134*^9, 
   3.8404163448306866`*^9}, {3.8404178626090136`*^9, 3.840417925824424*^9}, {
   3.8404191918191233`*^9, 3.84041920226635*^9}, {3.840419242024495*^9, 
   3.8404192617321796`*^9}, {3.8404194389428053`*^9, 3.840419462557069*^9}, {
   3.840453834266838*^9, 3.8404538447517056`*^9}, 3.840453909614043*^9, {
   3.8404539683635793`*^9, 3.8404539905838337`*^9}, 3.8404540272985306`*^9, {
   3.840454156166298*^9, 3.840454205291971*^9}, {3.840454240247527*^9, 
   3.8404542540157146`*^9}, {3.8404543237333283`*^9, 
   3.8404543404928937`*^9}, {3.8404544521143074`*^9, 
   3.8404544541302176`*^9}, {3.840454485008524*^9, 3.8404544958331428`*^9}, {
   3.840454535970628*^9, 3.840454551137659*^9}, {3.840500625089159*^9, 
   3.840500656940725*^9}, {3.840500695345143*^9, 3.8405006960523067`*^9}, {
   3.8405010969852047`*^9, 3.840501112587641*^9}, {3.840501150634077*^9, 
   3.8405011611522417`*^9}, {3.8405026446645527`*^9, 3.84050265267775*^9}, 
   3.8405026878215275`*^9, 3.8405027886745453`*^9, {3.8405028323157024`*^9, 
   3.8405028521056433`*^9}, {3.840508597751215*^9, 3.8405086042448597`*^9}, {
   3.8405086361734276`*^9, 3.840508697640854*^9}, {3.84530515034306*^9, 
   3.8453051663199177`*^9}, 3.845305197884505*^9, {3.8454792808354254`*^9, 
   3.8454794150956697`*^9}, {3.845479722113243*^9, 3.8454797915964413`*^9}, {
   3.845514873929638*^9, 3.8455149337268724`*^9}, {3.8455149684706416`*^9, 
   3.8455149695080223`*^9}, {3.8455153275220933`*^9, 3.845515328229957*^9}, {
   3.845515395675539*^9, 3.845515401297691*^9}, {3.845515515853771*^9, 
   3.845515576447665*^9}, {3.845515612558851*^9, 3.845515632979537*^9}, {
   3.845515680153039*^9, 3.8455159262376585`*^9}, {3.845516112061887*^9, 
   3.8455161465263453`*^9}, {3.845516193085106*^9, 3.845516229178423*^9}, {
   3.8455163351689043`*^9, 3.845516585318216*^9}, {3.8455166177397394`*^9, 
   3.845516714733508*^9}, {3.845516771645197*^9, 3.8455167731827154`*^9}, {
   3.845516818729296*^9, 3.84551695860878*^9}, {3.845516994711903*^9, 
   3.845517026462266*^9}, 3.845517092145789*^9, {3.845517135366593*^9, 
   3.845517155446496*^9}, {3.845517186534149*^9, 3.8455171937276707`*^9}, {
   3.845517227012909*^9, 3.8455172279061613`*^9}, {3.8455173234132085`*^9, 
   3.8455173514857492`*^9}, {3.845517423730919*^9, 3.8455174243493695`*^9}, {
   3.8455174624069753`*^9, 3.845517465100626*^9}, 3.845517507705373*^9, 
   3.8455175508535676`*^9, {3.8455176264044795`*^9, 3.8455176334075813`*^9}, {
   3.8455313319229393`*^9, 3.845531509940443*^9}, 3.8455315849840965`*^9, {
   3.8455317016782956`*^9, 3.845531738966821*^9}, {3.845531778451456*^9, 
   3.845531779386674*^9}, {3.8456415428113813`*^9, 3.845641735457308*^9}, {
   3.8456420427094593`*^9, 3.8456420444008894`*^9}, {3.8456420953927226`*^9, 
   3.845642095827136*^9}, {3.8456421305858717`*^9, 3.8456422084386454`*^9}, 
   3.8456422719473834`*^9, {3.8456424654126687`*^9, 3.8456424685516415`*^9}, {
   3.8456425391271963`*^9, 3.845642581942461*^9}, {3.8456426396045694`*^9, 
   3.845642806094469*^9}, {3.845642836196087*^9, 3.845642900922883*^9}, {
   3.845642970285206*^9, 3.8456430181273146`*^9}, {3.8456430708546114`*^9, 
   3.845643125882959*^9}, {3.845643178575968*^9, 3.845643257358486*^9}, {
   3.8456433623862553`*^9, 3.8456433771042914`*^9}, {3.8456434590863156`*^9, 
   3.8456434937160645`*^9}, 3.845643545927831*^9, {3.845643600156926*^9, 
   3.845643618570978*^9}, {3.8456436644300175`*^9, 3.84564366503797*^9}, {
   3.845643702197648*^9, 3.8456437461979747`*^9}, 3.8456439574887114`*^9, {
   3.846069818172841*^9, 3.846069849642768*^9}, {3.8460699136765876`*^9, 
   3.846069914209477*^9}, {3.8460699599440656`*^9, 3.8460700314146757`*^9}, {
   3.846070076753316*^9, 3.846070077439046*^9}, {3.846070157661101*^9, 
   3.8460701937707815`*^9}, {3.846070258127372*^9, 3.846070370035694*^9}, 
   3.8460704231130123`*^9, {3.846070456017062*^9, 3.8460704588184586`*^9}, {
   3.8460710172041235`*^9, 3.846071021582673*^9}, {3.846071106666136*^9, 
   3.8460711227728405`*^9}, {3.846071236516765*^9, 3.8460712690613956`*^9}, {
   3.846071302508814*^9, 3.8460713286265783`*^9}, {3.846071391711331*^9, 
   3.8460713919222136`*^9}, {3.8460717432565613`*^9, 3.846071846163582*^9}, {
   3.8460718796339417`*^9, 3.8460718981181345`*^9}, {3.8460719281852317`*^9, 
   3.8460719602156863`*^9}, {3.8460725487311463`*^9, 
   3.8460727277222366`*^9}, {3.8460727966336946`*^9, 
   3.8460727999447126`*^9}, {3.8460728715731387`*^9, 3.846072900231036*^9}, 
   3.8460729488995743`*^9, 3.846073094187673*^9, {3.846073124968068*^9, 
   3.846073143649494*^9}, {3.846073291437569*^9, 3.846073320871194*^9}, {
   3.8460733513356*^9, 3.8460733827836275`*^9}, {3.8460734213260293`*^9, 
   3.846073547913215*^9}, {3.8460735888598585`*^9, 3.8460735948494663`*^9}, {
   3.8460736630482445`*^9, 3.84607366906472*^9}, {3.846073769039547*^9, 
   3.8460738022300262`*^9}, {3.8460738788770266`*^9, 
   3.8460738952181954`*^9}, {3.846073949966679*^9, 3.8460739569065495`*^9}, {
   3.846074029073464*^9, 3.8460740346596146`*^9}, {3.846074102104647*^9, 
   3.8460741324118767`*^9}, {3.8460741949049115`*^9, 3.846074222593691*^9}, {
   3.8460742841895127`*^9, 3.846074340763191*^9}, {3.846160732253354*^9, 
   3.8461607332481594`*^9}, 3.846161492762432*^9, {3.846161780897497*^9, 
   3.846161788138113*^9}, {3.8461618293598766`*^9, 3.846161858226082*^9}, {
   3.8461618966585674`*^9, 3.846161969794857*^9}, 3.846162102689354*^9, {
   3.8461621668466263`*^9, 3.846162180355235*^9}, {3.8461622164826603`*^9, 
   3.8461622355856447`*^9}, {3.846162281065609*^9, 3.8461624985309367`*^9}, 
   3.8461626621493115`*^9, 3.846162697816634*^9, {3.8461627342864695`*^9, 
   3.8461627345822268`*^9}, {3.8461628166006966`*^9, 3.8461628174265194`*^9}, 
   3.846162849529516*^9, 3.846163042718745*^9, {3.8461630926561747`*^9, 
   3.8461631014520173`*^9}, 3.846164675187914*^9, {3.8461653709571285`*^9, 
   3.8461653939322076`*^9}, {3.846239297565034*^9, 3.846239321709072*^9}, {
   3.8462393704866405`*^9, 3.846239378462596*^9}, 3.8462394463604927`*^9, {
   3.846239908200873*^9, 3.846240041118046*^9}, {3.8462400979595313`*^9, 
   3.8462402075029526`*^9}, {3.846240330599819*^9, 3.846240332116249*^9}, {
   3.846240396409835*^9, 3.846240426609739*^9}, {3.8462404635946035`*^9, 
   3.846240479194495*^9}, {3.846240547126852*^9, 3.8462406007711906`*^9}, {
   3.846240672984129*^9, 3.8462406735655537`*^9}, {3.846240715451014*^9, 
   3.846240727662325*^9}, {3.8462408398048706`*^9, 3.8462408550133176`*^9}, {
   3.846240906219432*^9, 3.8462409845731764`*^9}, {3.8462415426024213`*^9, 
   3.846241600241384*^9}, {3.8462416533016524`*^9, 3.8462416824345474`*^9}, {
   3.846241871443136*^9, 3.846241889026347*^9}, {3.84624196622915*^9, 
   3.846241982209696*^9}, {3.8462420839315395`*^9, 3.8462421106657743`*^9}, {
   3.8462493213059616`*^9, 3.846249371505189*^9}, {3.846249426216957*^9, 
   3.8462494677076874`*^9}, {3.846249549506504*^9, 3.8462495503135986`*^9}, {
   3.8463317012472258`*^9, 3.846331723789422*^9}, 3.846331790148814*^9, {
   3.846331841946804*^9, 3.8463318642788124`*^9}, {3.8463318999649568`*^9, 
   3.84633190085021*^9}, {3.846331970187175*^9, 3.8463319724350276`*^9}, {
   3.846332425994608*^9, 3.8463324267831564`*^9}, {3.8463324853767433`*^9, 
   3.846332505743512*^9}, {3.84633253640195*^9, 3.84633253746087*^9}, 
   3.8463325927468147`*^9, {3.846332664076268*^9, 3.84633267729871*^9}, {
   3.84633282094595*^9, 3.846332866648316*^9}, {3.846332915983061*^9, 
   3.846332964772069*^9}, {3.8463332315659857`*^9, 3.8463332589840655`*^9}, {
   3.8463333159368706`*^9, 3.8463333881232243`*^9}, {3.846333478174964*^9, 
   3.846333507307977*^9}, {3.8463337169753866`*^9, 3.846333752677167*^9}, {
   3.8463337874930525`*^9, 3.8463337938266315`*^9}, {3.84633382889653*^9, 
   3.8463338314544067`*^9}, {3.8463338661347585`*^9, 
   3.8463338671064034`*^9}, {3.8463341029946103`*^9, 3.8463341178046017`*^9}, 
   3.8463344961508446`*^9, {3.846334551477289*^9, 3.8463345669722776`*^9}, {
   3.846334647851037*^9, 3.8463346507709723`*^9}, {3.8463350072556896`*^9, 
   3.846335009531336*^9}, {3.8463350584383993`*^9, 3.8463350832915545`*^9}, 
   3.8463356730391445`*^9, {3.8463357330577507`*^9, 3.846335734677639*^9}, {
   3.8463357713912954`*^9, 3.846335784599365*^9}, {3.846335824451017*^9, 
   3.846335850541898*^9}, {3.8465148279290648`*^9, 3.846514905645626*^9}, {
   3.8465149546536207`*^9, 3.8465149557287645`*^9}, 3.8465150347627506`*^9, 
   3.8465150735123754`*^9, 3.846515133355834*^9, {3.846551496354246*^9, 
   3.8465515199215117`*^9}, {3.8465515514860935`*^9, 3.846551558453719*^9}, {
   3.8465516511605453`*^9, 3.8465516816971188`*^9}, {3.8465517493251767`*^9, 
   3.8465517819787836`*^9}, {3.846551812162984*^9, 3.84655181978378*^9}, {
   3.8469012753631597`*^9, 3.8469014245266294`*^9}, {3.846901477101201*^9, 
   3.846901480891117*^9}, 3.846901533852523*^9, {3.8469015653056993`*^9, 
   3.8469015942691755`*^9}, 3.8469016260053563`*^9, {3.846901664939994*^9, 
   3.8469016657155457`*^9}, {3.846901747509447*^9, 3.8469017503170366`*^9}, {
   3.84690191404624*^9, 3.84690193970901*^9}, 3.846901985149589*^9, {
   3.84690203255608*^9, 3.8469020373058805`*^9}, {3.8469021528510695`*^9, 
   3.84690220430954*^9}, {3.8469022448931456`*^9, 3.8469022504597807`*^9}, {
   3.846902285388745*^9, 3.846902288603936*^9}, {3.8469023384879513`*^9, 
   3.846902371933584*^9}, 3.846902765731144*^9, {3.8469028332433987`*^9, 
   3.8469028443561935`*^9}, 3.8469030843801355`*^9, 3.846903160980903*^9, {
   3.8469032059828815`*^9, 3.8469032390870132`*^9}, {3.84690342310567*^9, 
   3.846903439207902*^9}, {3.8469061580301685`*^9, 3.8469062645476227`*^9}, {
   3.8469065486448135`*^9, 3.846906561548581*^9}, {3.8469067471371455`*^9, 
   3.8469068174896765`*^9}, {3.84690686154051*^9, 3.8469068684523077`*^9}, {
   3.8497527618146653`*^9, 3.8497527676380615`*^9}, {3.8497528414079475`*^9, 
   3.849752843454638*^9}, {3.8497530625145917`*^9, 3.849753063032662*^9}, {
   3.8497530971084747`*^9, 3.8497531011988783`*^9}, {3.8497532258666143`*^9, 
   3.849753345755213*^9}, {3.849753924288494*^9, 3.849753985952464*^9}, {
   3.849754069460248*^9, 3.849754087001464*^9}, {3.849754259204835*^9, 
   3.849754268999332*^9}, {3.8497554284565487`*^9, 3.8497554930272894`*^9}, {
   3.849755685279069*^9, 3.8497556896240177`*^9}, {3.8497558773614607`*^9, 
   3.849755877843891*^9}, {3.8497559807269473`*^9, 3.8497560211165953`*^9}, 
   3.850443650520732*^9, {3.8504438404083548`*^9, 3.8504441120345283`*^9}, {
   3.850444156664489*^9, 3.850444280967318*^9}, {3.850444354744196*^9, 
   3.85044463643923*^9}, {3.8504447256702757`*^9, 3.8504447980665684`*^9}, {
   3.8505274395909743`*^9, 3.8505274411181674`*^9}, {3.8505275310510144`*^9, 
   3.8505276349685197`*^9}, {3.850527665564816*^9, 3.850527741150744*^9}, {
   3.850528010969228*^9, 3.8505280914370484`*^9}, {3.850528341539154*^9, 
   3.8505283435766478`*^9}, {3.850528399268195*^9, 3.850528452926201*^9}, {
   3.850528511901552*^9, 3.850528524032834*^9}, {3.8505286008142643`*^9, 
   3.8505286255862675`*^9}, {3.850528657292616*^9, 3.8505287485299587`*^9}, {
   3.850528791091945*^9, 3.8505287912193995`*^9}, {3.8505289892778673`*^9, 
   3.8505290093703814`*^9}, {3.8505291179397283`*^9, 3.850529246368305*^9}, {
   3.8505292847200036`*^9, 3.8505293531238484`*^9}, {3.85052942526715*^9, 
   3.8505295026053452`*^9}, {3.850529652810694*^9, 3.85052969888447*^9}, {
   3.8505297570230837`*^9, 3.8505297793908668`*^9}, {3.8505298130474796`*^9, 
   3.85052982372943*^9}, 3.850529903643921*^9, {3.8505299339680395`*^9, 
   3.850529938523468*^9}, {3.850533467746894*^9, 3.850533696587976*^9}, {
   3.8505337523084393`*^9, 3.8505340100220647`*^9}, {3.850534073301394*^9, 
   3.8505341115212436`*^9}, {3.8505341448690495`*^9, 3.850534244609003*^9}, {
   3.8505342773409953`*^9, 3.850534317485276*^9}, {3.850534376818581*^9, 
   3.8505345375059347`*^9}, 3.8505345895823593`*^9, {3.850534712936541*^9, 
   3.850534853983102*^9}, {3.85053489565536*^9, 3.85053490800423*^9}, {
   3.850535011630887*^9, 3.850535069369616*^9}, {3.8505609789941187`*^9, 
   3.8505609796472797`*^9}, {3.850561024378234*^9, 3.8505611077291512`*^9}, {
   3.8505611554662695`*^9, 3.8505611900834045`*^9}, {3.8505612604815354`*^9, 
   3.850561307036023*^9}, 3.8505614161973686`*^9, {3.850561489892841*^9, 
   3.8505614904828854`*^9}, 3.850561540476676*^9, {3.850566961415826*^9, 
   3.85056699607444*^9}, {3.8505670465401917`*^9, 3.850567067268143*^9}, {
   3.850567124561453*^9, 3.8505671481746936`*^9}, {3.8505671891195374`*^9, 
   3.850567192972233*^9}, {3.8505672404233675`*^9, 3.850567272319547*^9}, {
   3.8505673802869396`*^9, 3.850567388289441*^9}, {3.850567420051065*^9, 
   3.8505674379775977`*^9}, {3.850568113924102*^9, 3.850568121245113*^9}, {
   3.8505681786419373`*^9, 3.8505682190225987`*^9}, {3.8505682742836356`*^9, 
   3.8505682972999997`*^9}, {3.850568330443387*^9, 3.8505683415549088`*^9}, {
   3.850568377492758*^9, 3.850568403154665*^9}, {3.850568837097434*^9, 
   3.850568946787299*^9}, {3.8505691453292117`*^9, 3.850569195539899*^9}, {
   3.8505692859376397`*^9, 3.8505693669331837`*^9}, {3.8505693974289236`*^9, 
   3.8505695475039663`*^9}, {3.8505696079724298`*^9, 
   3.8505696221275873`*^9}, {3.8505697874854712`*^9, 
   3.8505698175396166`*^9}, {3.850569868969412*^9, 3.8505698726296372`*^9}, {
   3.850569905926787*^9, 3.8505699809036593`*^9}, {3.850570015920215*^9, 
   3.85057008172045*^9}, {3.850785556912866*^9, 3.850785616614393*^9}, {
   3.8507856606466494`*^9, 3.850785723209618*^9}, {3.8507857656066175`*^9, 
   3.850785880874487*^9}, {3.850785924508508*^9, 3.850785937300992*^9}, {
   3.8507859750545197`*^9, 3.8507859968100834`*^9}, {3.850786077342246*^9, 
   3.8507860848236823`*^9}, {3.8507861340867023`*^9, 3.8507861374599075`*^9}, 
   3.850786227982345*^9, {3.8507862859910107`*^9, 3.8507863008387175`*^9}, {
   3.850786368316942*^9, 3.850786374976062*^9}, {3.850786423270744*^9, 
   3.850786423425295*^9}, {3.8507865491264324`*^9, 3.850786595976322*^9}, {
   3.850786636570469*^9, 3.850786709325587*^9}, {3.850786743990263*^9, 
   3.8507868015086374`*^9}, {3.8507870134211025`*^9, 
   3.8507870176048164`*^9}, {3.850787059141889*^9, 3.8507870650224657`*^9}, {
   3.850787111878257*^9, 3.850787113157389*^9}, {3.8507887599989805`*^9, 
   3.850788841851822*^9}, {3.850788913491912*^9, 3.8507890311085014`*^9}, {
   3.8507890809695005`*^9, 3.8507890902738066`*^9}, {3.8507891921970196`*^9, 
   3.8507891973037043`*^9}, {3.8507892279462795`*^9, 3.850789249495205*^9}, {
   3.850791412876636*^9, 3.8507914130273633`*^9}, {3.8507915155633483`*^9, 
   3.8507915162424593`*^9}, {3.850827343188859*^9, 3.850827375432101*^9}, {
   3.8508274109868975`*^9, 3.8508274369062905`*^9}, {3.8508274890786314`*^9, 
   3.8508274894138756`*^9}, {3.8508275695516253`*^9, 3.850827569788695*^9}, 
   3.8508276711587315`*^9, {3.8508277166165743`*^9, 3.8508277728386536`*^9}, {
   3.8508278475513325`*^9, 3.8508278753498926`*^9}, {3.8508279408872223`*^9, 
   3.85082794118405*^9}, {3.850827981298354*^9, 3.850828056921221*^9}, {
   3.850828494113824*^9, 3.850828495039543*^9}, {3.85082856023905*^9, 
   3.850828575017256*^9}, {3.850828628892047*^9, 3.850828696248144*^9}, 
   3.8508287630158415`*^9, {3.8508293694951773`*^9, 3.850829372071825*^9}, {
   3.8508294221130056`*^9, 3.8508294474505587`*^9}, {3.8508295136154523`*^9, 
   3.850829546786518*^9}, {3.8508307551495695`*^9, 3.850830755305548*^9}, {
   3.850830846425475*^9, 3.8508308469949007`*^9}, {3.8508328226756153`*^9, 
   3.8508328956454206`*^9}, {3.8515151599360895`*^9, 
   3.8515151854097323`*^9}, {3.851515227511881*^9, 3.8515152691971846`*^9}, {
   3.8517376565999703`*^9, 3.851737660729647*^9}, {3.8517376993937993`*^9, 
   3.851737854226467*^9}, {3.8517379030659018`*^9, 3.851737963592141*^9}, {
   3.8517380004040184`*^9, 3.851738156849004*^9}, {3.8517381881441555`*^9, 
   3.8517383547150526`*^9}, {3.851738403578961*^9, 3.8517384750343685`*^9}, {
   3.8517386329884996`*^9, 3.8517387036807384`*^9}, {3.8517387496128297`*^9, 
   3.8517391066461697`*^9}, 3.851739167106615*^9, {3.851739199324179*^9, 
   3.8517392033202653`*^9}, {3.851739306865944*^9, 3.8517396012506447`*^9}, {
   3.8517396478337793`*^9, 3.851739717012961*^9}, {3.851739779861041*^9, 
   3.8517398251446857`*^9}, {3.8517401674121*^9, 3.85174023031291*^9}, {
   3.8517403822763968`*^9, 3.8517405215277195`*^9}, {3.8517405598035936`*^9, 
   3.8517405807347307`*^9}, 3.8517406111741548`*^9, {3.852771815388609*^9, 
   3.852771815826337*^9}, {3.852771938933034*^9, 3.852772015527173*^9}, {
   3.8527720455326405`*^9, 3.852772051655347*^9}, {3.852772112575083*^9, 
   3.85277216712604*^9}, {3.8527722639917727`*^9, 3.8527723193930345`*^9}, {
   3.8527723507994275`*^9, 3.8527724886441803`*^9}, 3.852772518958836*^9, {
   3.8527726690962496`*^9, 3.8527726724595623`*^9}, {3.852772785224839*^9, 
   3.852772814059412*^9}, {3.8527728536940055`*^9, 3.8527728543197746`*^9}, 
   3.8527728940919833`*^9, {3.8527729250196114`*^9, 3.8527729905347033`*^9}, {
   3.8527730490675783`*^9, 3.8527730529881525`*^9}, {3.852773399558672*^9, 
   3.852773411256092*^9}, {3.852773459331044*^9, 3.852773480723246*^9}, {
   3.8527735251577444`*^9, 3.8527735647772226`*^9}, {3.85277372440212*^9, 
   3.852773727144375*^9}, {3.8528731960002193`*^9, 3.8528733256878357`*^9}, {
   3.852873387704274*^9, 3.852873409884766*^9}, {3.8528734508562613`*^9, 
   3.8528734515817213`*^9}, {3.8528734901873713`*^9, 3.852873528186962*^9}, {
   3.8528735614708843`*^9, 3.8528735812376013`*^9}, {3.8528736531146784`*^9, 
   3.852873677620881*^9}, {3.8528801200331235`*^9, 3.852880146194016*^9}, {
   3.853140879673688*^9, 3.8531409143592653`*^9}, {3.8531409625201416`*^9, 
   3.8531410288764524`*^9}, {3.8531410590292354`*^9, 
   3.8531411087537766`*^9}, {3.906960081539485*^9, 3.9069602331152077`*^9}, {
   3.9069603433707557`*^9, 3.906960532270595*^9}, {3.9069608107416534`*^9, 
   3.906960894501176*^9}, 3.906976975428384*^9, 3.9069784461360517`*^9, {
   3.9069784939955707`*^9, 3.906978495519633*^9}, {3.906979520056976*^9, 
   3.906979527909192*^9}, {3.9070299969708767`*^9, 3.9070299973647575`*^9}, 
   3.9070302622793455`*^9, {3.907031054878291*^9, 3.907031101672268*^9}, {
   3.907031132657627*^9, 3.907031137965227*^9}, {3.907031258015709*^9, 
   3.907031258244317*^9}, 3.907060462885079*^9, {3.9070616210919228`*^9, 
   3.9070617379829817`*^9}, {3.9070618359373693`*^9, 
   3.9070618491419787`*^9}, {3.9072168098312087`*^9, 
   3.9072168879034996`*^9}, {3.9072169598535347`*^9, 
   3.9072169971857233`*^9}, {3.9072170607219973`*^9, 3.907217066892645*^9}, {
   3.9076577595519457`*^9, 3.9076578173877373`*^9}, {3.9076578614233837`*^9, 
   3.907657894347175*^9}, {3.9076579602806206`*^9, 3.9076579846181087`*^9}, {
   3.9076596607447786`*^9, 3.9076596756372747`*^9}, 3.910745605690302*^9, {
   3.91074584911373*^9, 3.9107458926127214`*^9}, 3.910745941790287*^9, {
   3.910745986223607*^9, 3.910746063719597*^9}, {3.910747810729528*^9, 
   3.9107478791523943`*^9}, {3.9107479317978497`*^9, 
   3.9107479806408787`*^9}, {3.9107480256793222`*^9, 3.910748109579584*^9}, {
   3.91086543516223*^9, 3.9108654503446293`*^9}, {3.910865504589961*^9, 
   3.9108657401174555`*^9}, {3.91086584568825*^9, 3.910865852120024*^9}, 
   3.910865926383168*^9, 3.9108659744156675`*^9, 3.91086605745315*^9, {
   3.9108661771273518`*^9, 3.9108661799860926`*^9}, {3.9108662518520503`*^9, 
   3.9108662615334487`*^9}, 3.9108663396346254`*^9, {3.910866427961111*^9, 
   3.9108664324625444`*^9}, {3.910866648483549*^9, 3.910866665466797*^9}, {
   3.9108666978412094`*^9, 3.910866759019273*^9}, 3.9108668342632604`*^9, {
   3.9108668671138697`*^9, 3.910866882442206*^9}, {3.9108669792404804`*^9, 
   3.9108671430224776`*^9}, {3.9108671931495285`*^9, 3.910867227668786*^9}, {
   3.9108672957548175`*^9, 3.9108672974319744`*^9}, {3.910867368016037*^9, 
   3.910867368944265*^9}, 3.910867400227538*^9, {3.911008255763074*^9, 
   3.911008275926586*^9}, 3.9110083690822363`*^9, {3.9110084055565042`*^9, 
   3.9110084252803555`*^9}, 3.911008491161389*^9, {3.911008696240383*^9, 
   3.911008714321493*^9}, {3.9110088966274376`*^9, 3.911008900951162*^9}, {
   3.9110089635273657`*^9, 3.9110089783297873`*^9}, {3.911009014769552*^9, 
   3.9110090198434143`*^9}, {3.9110092308436937`*^9, 3.911009360495569*^9}, {
   3.9110093990206623`*^9, 3.9110094532567844`*^9}, {3.911009498630669*^9, 
   3.9110095367569847`*^9}, {3.9110095712912645`*^9, 
   3.9110096330820303`*^9}, {3.9110096653864827`*^9, 3.911009822963343*^9}, {
   3.911009859719963*^9, 3.911009866575224*^9}, {3.911009967367282*^9, 
   3.9110099850429783`*^9}, {3.911010028843105*^9, 3.9110101503231063`*^9}, {
   3.911010193179899*^9, 3.911010257505966*^9}, 3.911010335859486*^9, {
   3.911010401075186*^9, 3.911010457367464*^9}, 3.911010499750472*^9, {
   3.9110401234863586`*^9, 3.911040300892739*^9}, {3.9110403386146345`*^9, 
   3.911040544742799*^9}, {3.9110405856611333`*^9, 3.911040600084425*^9}, {
   3.9110409430788774`*^9, 3.9110409865360575`*^9}, {3.9110412680876427`*^9, 
   3.911041429298622*^9}, {3.911041589517542*^9, 3.9110416136098943`*^9}, {
   3.9110959319146233`*^9, 3.911096010751473*^9}, {3.9110962776335144`*^9, 
   3.911096327516655*^9}, {3.9110963649569387`*^9, 3.9110963792243595`*^9}, {
   3.917832590471942*^9, 3.91783259261812*^9}, {3.9178326929319906`*^9, 
   3.9178327503678517`*^9}, 3.9178328067760944`*^9, 3.917832854468274*^9, 
   3.917832888754475*^9, {3.917833107460365*^9, 3.917833108831243*^9}, {
   3.9178331620730915`*^9, 3.9178331825416665`*^9}, {3.9178332252920213`*^9, 
   3.917833227229144*^9}, 3.917833258961728*^9, {3.9178333424246206`*^9, 
   3.9178333517396064`*^9}, {3.917833444344221*^9, 3.9178334458517885`*^9}, 
   3.9178335515004683`*^9, {3.917833599553218*^9, 3.917833650004278*^9}, {
   3.917833691644823*^9, 3.917833692505719*^9}, {3.917834112622341*^9, 
   3.9178341280855384`*^9}, 3.917834171255001*^9, 3.9178342309758744`*^9, {
   3.917834295930198*^9, 3.917834298629716*^9}, 3.9178343890259485`*^9, 
   3.9178344550738645`*^9, {3.9178345592764263`*^9, 3.9178345765383854`*^9}, {
   3.9178349428335857`*^9, 3.917834957888749*^9}, {3.917835043598898*^9, 
   3.9178350499497914`*^9}, {3.917835648701893*^9, 3.9178356700048037`*^9}, {
   3.917835827590342*^9, 3.91783583779432*^9}, {3.917844702487713*^9, 
   3.9178447470333223`*^9}, {3.9178449064646893`*^9, 
   3.9178449159801645`*^9}, {3.9178449692656164`*^9, 
   3.9178450755686426`*^9}, {3.9178451261178627`*^9, 3.917845128031886*^9}, {
   3.91784611797869*^9, 3.917846150421515*^9}, {3.9178462178470125`*^9, 
   3.9178462188160224`*^9}, {3.9178463821131353`*^9, 3.917846404318012*^9}, {
   3.9178464868957653`*^9, 3.9178464974362345`*^9}, {3.9178466391768084`*^9, 
   3.917846660518054*^9}, {3.917846705713427*^9, 3.9178467398525267`*^9}, 
   3.9178467833607264`*^9, {3.917846824928237*^9, 3.9178468336706343`*^9}, {
   3.91784692713665*^9, 3.917846948232817*^9}, {3.917846984842763*^9, 
   3.9178470161506443`*^9}, {3.9182108415687127`*^9, 3.918210908004079*^9}, {
   3.9182109498407817`*^9, 3.9182111444301233`*^9}, {3.918211191133893*^9, 
   3.918211195152011*^9}, {3.9182112453708096`*^9, 3.9182112703404927`*^9}, {
   3.9182113141345406`*^9, 3.918211343884912*^9}, {3.918211377206615*^9, 
   3.9182113996989174`*^9}, {3.9182114444718027`*^9, 
   3.9182115011709948`*^9}, {3.918211554509279*^9, 3.9182118434838734`*^9}, {
   3.9182118844163384`*^9, 3.9182119340516095`*^9}, {3.918212144079294*^9, 
   3.9182121453109922`*^9}, {3.918212191518219*^9, 3.91821223630976*^9}, {
   3.918212271191306*^9, 3.9182122977139473`*^9}, {3.9182124886652174`*^9, 
   3.918212489073351*^9}, {3.918212590532064*^9, 3.9182127270755053`*^9}, {
   3.9182138417460346`*^9, 3.9182139048646154`*^9}, {3.9182146908437347`*^9, 
   3.9182149077374396`*^9}, {3.9182177073263197`*^9, 3.918217717322076*^9}, {
   3.918539524636157*^9, 3.918539527782719*^9}, {3.9185395590332627`*^9, 
   3.9185395632362785`*^9}, {3.9186078331321692`*^9, 3.918607833645181*^9}, {
   3.918607914428753*^9, 3.9186079207039227`*^9}, {3.9186084852881613`*^9, 
   3.91860866989282*^9}, {3.918608722991639*^9, 3.9186087765113287`*^9}, {
   3.9186088123606386`*^9, 3.918608816529477*^9}, {3.9186088543395295`*^9, 
   3.918608860108692*^9}, {3.918608891204424*^9, 3.9186088963485513`*^9}, {
   3.9186089310751266`*^9, 3.9186090347918806`*^9}, {3.9186143563438616`*^9, 
   3.9186143574276853`*^9}, 3.918629848595114*^9, 3.918629908583782*^9, {
   3.918629950660674*^9, 3.918629985878424*^9}, {3.918630102038577*^9, 
   3.9186301233091154`*^9}, {3.9186370529831204`*^9, 3.918637098446494*^9}, 
   3.918637239748101*^9, {3.918651032493411*^9, 3.9186510332241592`*^9}, 
   3.9186515711132927`*^9, {3.918651749050099*^9, 3.918651754020139*^9}, {
   3.918886175722066*^9, 3.918886277623564*^9}, {3.9188863475025697`*^9, 
   3.918886364944297*^9}, {3.9188864102911024`*^9, 3.9188864635769587`*^9}, {
   3.9188865129434056`*^9, 3.9188865210164766`*^9}, {3.9188866817537713`*^9, 
   3.918886797226532*^9}, {3.9188868431977205`*^9, 3.918886919954407*^9}, {
   3.918887501661186*^9, 3.9188875433729973`*^9}, 3.9189724260868464`*^9, {
   3.9189725984848385`*^9, 3.9189726144967713`*^9}, {3.9189894213903303`*^9, 
   3.918989440727315*^9}, {3.918991567575023*^9, 3.91899169221841*^9}, {
   3.918991756575407*^9, 3.918991764621538*^9}, {3.918991846575403*^9, 
   3.9189918651751175`*^9}, {3.918991923261159*^9, 3.918991943354218*^9}, {
   3.9189920897360425`*^9, 3.918992100937796*^9}, {3.919132509132023*^9, 
   3.9191325807306795`*^9}, {3.9191384189341793`*^9, 
   3.9191384486538267`*^9}, {3.9191623361135154`*^9, 3.919162375557169*^9}, {
   3.9191624544827147`*^9, 3.9191624952186127`*^9}, 3.9191625478255367`*^9, {
   3.9191638974162483`*^9, 3.9191638992562428`*^9}, 3.9191639333571525`*^9, {
   3.9191639680525956`*^9, 3.9191640136868615`*^9}, {3.919164047986966*^9, 
   3.919164056050922*^9}, 3.9191641210748734`*^9, 3.919211912165566*^9, {
   3.9192121282288237`*^9, 3.9192121298433332`*^9}, {3.920029118247701*^9, 
   3.920029146477833*^9}, {3.9200292003467803`*^9, 3.9200292482703037`*^9}, {
   3.9200292884372916`*^9, 3.92002931143719*^9}, {3.9200295509623346`*^9, 
   3.920029574123387*^9}, 3.9200299364606*^9, {3.920116532053054*^9, 
   3.920116909746909*^9}, {3.9201173200422134`*^9, 3.9201173212943487`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0.5, 0], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl1Hs0lHkYB3DG5bXRUuRsWZXLqdU9al2a5vmVXTs1DIpmqelEoQjtsAlZ
qc3lxDIrspa2tqGWtlymNoo60UrDpKFojjRyKe87M2ZMM4YZY989Pec853s+
fz3nfP94nCIT90RRjIyMAsj9Pz+NBAYuPh9axlLBhv6E2e/MJdDzRKfvCFUB
+9abj4VWEui3qGb/GKKC5gP3J1YslYDiEhrvCVZBctPJXnCXwL31TrYX/FUw
wZFVZx6RwBfuHj2WO1UgGhMHzD+VwOgTzwzaehVcE9z53cAdBn68rD/KVAWT
pgvPdH87AvWbKpo9bk9B33Iby/uDo1DFLqPyDk9BKD3a8e+4cQjKFqQsd5yC
zLfsU4lffoCtsejnmD4l7GQZpwXVTYDPWK2CKFbCTapfu3E0Ad0E715esBIa
Nw+V/GMrgyXnrHubbJUQgjl/ns+TQ/oYy4cYVACz6lxM2VoF5PiKXH/gKYDm
6e+QplHAo0bHF+EcBcwFtS4+2KKE1tDX0eW+CihyytqwpmQK2BzPyAhbBSS+
+63y/EEVxFqztNQXk+AcbrK50+sj0JMis9xSJ4EXZm9hba2Gm97qAdfVk8DZ
lek++koN4SFNd44PycFO4ZV19bYGdtyqYZwslgMlh+4iT50Ghxm1RBckh/a+
GxPOoVpYNfySX2glh9CaBlXYuhmo1Rc+EHfJwP3E4uCV6hnILDnLZV+UwYj0
sUgonIWHud4b1obLQBLWed2qXAe/+NRpC1bJ4CYz9ZF/hB7sCp6GRWik4D+b
OpfsPQerN6aVNLZLwau0p2CdiQHO2Y4JqsqkoP2QsrPrjQEykl8Su+KkkNP2
1CeBPw+7//Xbu3CHFNw7PNsCaUZIU2cZUO4ghQW5HumDNUbILupIp7GaAIsd
4sFNNsaoS9DG6BARIGsJPZSdZIxSEt8s6WsggFo6ow58a4zOZKQwh7gE1EfT
tw77UlDNIimdl0xA0a8Ps8frKOiGrqYrbx8BJXeHsxrtTRA1z034ahsBZy8P
XM5KM0HHiS1/Ec4EvB6e7m4bN0E5V1jdPp8RsM/xcXU3wxT9UVmRwJnCYTuf
z2U0mSK7q448gxgHS+vTl5+5mqFY++fxXz3BYT5CHrIozwyJAopvC+pxYNvk
OXapzRBVqz8wUInDu7vCQuZ+c1T29WLRqnwcmE4TLqJWc1QXcYtyLR0H1/dr
n3WuwdBrv6T88lgcVlYtXZZXiCEWNiXJ3I9DPq1evZuLoeiRIQca6el++gur
YgzlXqBG6cNxEC44lVtUiiEtd7tLKunTJ15pLlVi6PvBOUZSGA4D24p7q2sx
tKmPHxDLwqFIZFXQ3oGhFqWlPnIvDvo43tHsTgwl2OsMzqRjzKjf0AUYevZe
Yz2yBweaV5xOIMRQjI/FgcOkpZWdx3pfYigidlvFkWAc6Mey/d6NYIh5fkvz
sUAc+JTlzrwxDB1qy6hYQ3pFxZ25qPcYkl/7M59g4qARjvIncPKeU1JpPGne
Fl8XpRJD5ubiQE4ADjZCsaFBhSF/Ru0VD9LpMRxxshpDu+Uw/9Efhz3lV7la
LYYaPK+PpZBu9fCOb57F0HhfUrw3abfuHvppPdlXyzRFx8DhYvRRV5oBQ0i+
sfoB6U//ywK5RS1l/UT6PyVhaDk=
      "]]}}, {{}, {}, 
    {RGBColor[0, 1, 0], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2nk4lN8XAPAxM2ZaJEmKylqKUERInFuW7LJmV5J8K0uSLXtI0UIRhZIl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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJxF2Xk0Vd8XAHBTRKYkQoOhlCGZhwb7JXMIlaQipZKkkspYpgzfJAmpJA0k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      "]]}}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0, 1.124433358085935}, {0.5, 1.124433358085935}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, 0.7871033506601545}, {3, 0.7871033506601545}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, 1.124433358085935}, {0.5, 0.7871033506601545}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0.5, 1.124433358085935}, {0.5, 2.811083395214837}}]}, {{InsetBox[
      RowBox[{"\[Theta]", "=", 
       RowBox[{"+", "1"}]}], {2.381292517006804, 2.60144692797754}, {
      Left, Baseline},
      Alignment->{Left, Top}], {InsetBox[
       StyleBox[
        TagBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Tau]", "d"], "=", " ", 
           RowBox[{"1", " ", "ms", " "}]}],
          FontSize->12],
         "RawBoxes"],
        FontFamily->"Arial",
        FontSize->10,
        Background->GrayLevel[
         1.]], {1.8010204081632668`, 1.0516142965122537`}, {Left, Baseline},
       Alignment->{Left, Top}], InsetBox[
       StyleBox[
        TagBox[
         RowBox[{
          StyleBox[
           SubscriptBox["\[Tau]", "e"],
           FontSize->12], 
          StyleBox["=",
           FontSize->12], 
          StyleBox[" ",
           FontSize->12], 
          RowBox[{
           StyleBox["0.5",
            FontSize->12], 
           StyleBox["  ",
            FontSize->12], 
           StyleBox["ms",
            FontSize->12], " "}]}],
         "RawBoxes"],
        FontFamily->"Arial",
        FontSize->10,
        Background->GrayLevel[1.]], {2.158163265306123, 2.352931648850014}, {
       Left, Baseline},
       Alignment->{Left, Top}]}}, InsetBox[
     StyleBox[
      TagBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Tau]", "d"], "=", " ", 
         RowBox[{"0.05", " ", "ms", " "}]}],
        FontSize->12],
       "RawBoxes"],
      FontFamily->"Arial",
      FontSize->10,
      Background->GrayLevel[1.]], {0.5663265306122454, 2.591836734693878}, {
     Left, Baseline},
     Alignment->{Left, Top}], InsetBox[
     StyleBox[
      TagBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Tau]", "d"], "=", " ", 
         RowBox[{"0.2", " ", "ms", " "}]}],
        FontSize->12],
       "RawBoxes"],
      FontFamily->"Arial",
      FontSize->10,
      Background->GrayLevel[1.]], {0.6173469387755106, 1.3090379008746353`}, {
     Left, Baseline},
     Alignment->{Left, Top}]}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"t (ms)\"", FontSize -> 20, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1.5, 
      FormBox[
       RowBox[{"-", "1.5`"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{41., 25.}, {51., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{0., 3.}, {0., 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.9201173336866684`*^9, 3.920117340868878*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl1Hs0lHkYB3DG5bXRUuRsWZXLqdU9al2a5vmVXTs1DIpmqelEoQjtsAlZ
qc3lxDIrspa2tqGWtlymNoo60UrDpKFojjRyKe87M2ZMM4YZY989Pec853s+
fz3nfP94nCIT90RRjIyMAsj9Pz+NBAYuPh9axlLBhv6E2e/MJdDzRKfvCFUB
+9abj4VWEui3qGb/GKKC5gP3J1YslYDiEhrvCVZBctPJXnCXwL31TrYX/FUw
wZFVZx6RwBfuHj2WO1UgGhMHzD+VwOgTzwzaehVcE9z53cAdBn68rD/KVAWT
pgvPdH87AvWbKpo9bk9B33Iby/uDo1DFLqPyDk9BKD3a8e+4cQjKFqQsd5yC
zLfsU4lffoCtsejnmD4l7GQZpwXVTYDPWK2CKFbCTapfu3E0Ad0E715esBIa
Nw+V/GMrgyXnrHubbJUQgjl/ns+TQ/oYy4cYVACz6lxM2VoF5PiKXH/gKYDm
6e+QplHAo0bHF+EcBcwFtS4+2KKE1tDX0eW+CihyytqwpmQK2BzPyAhbBSS+
+63y/EEVxFqztNQXk+AcbrK50+sj0JMis9xSJ4EXZm9hba2Gm97qAdfVk8DZ
lek++koN4SFNd44PycFO4ZV19bYGdtyqYZwslgMlh+4iT50Ghxm1RBckh/a+
GxPOoVpYNfySX2glh9CaBlXYuhmo1Rc+EHfJwP3E4uCV6hnILDnLZV+UwYj0
sUgonIWHud4b1obLQBLWed2qXAe/+NRpC1bJ4CYz9ZF/hB7sCp6GRWik4D+b
OpfsPQerN6aVNLZLwau0p2CdiQHO2Y4JqsqkoP2QsrPrjQEykl8Su+KkkNP2
1CeBPw+7//Xbu3CHFNw7PNsCaUZIU2cZUO4ghQW5HumDNUbILupIp7GaAIsd
4sFNNsaoS9DG6BARIGsJPZSdZIxSEt8s6WsggFo6ow58a4zOZKQwh7gE1EfT
tw77UlDNIimdl0xA0a8Ps8frKOiGrqYrbx8BJXeHsxrtTRA1z034ahsBZy8P
XM5KM0HHiS1/Ec4EvB6e7m4bN0E5V1jdPp8RsM/xcXU3wxT9UVmRwJnCYTuf
z2U0mSK7q448gxgHS+vTl5+5mqFY++fxXz3BYT5CHrIozwyJAopvC+pxYNvk
OXapzRBVqz8wUInDu7vCQuZ+c1T29WLRqnwcmE4TLqJWc1QXcYtyLR0H1/dr
n3WuwdBrv6T88lgcVlYtXZZXiCEWNiXJ3I9DPq1evZuLoeiRIQca6el++gur
YgzlXqBG6cNxEC44lVtUiiEtd7tLKunTJ15pLlVi6PvBOUZSGA4D24p7q2sx
tKmPHxDLwqFIZFXQ3oGhFqWlPnIvDvo43tHsTgwl2OsMzqRjzKjf0AUYevZe
Yz2yBweaV5xOIMRQjI/FgcOkpZWdx3pfYigidlvFkWAc6Mey/d6NYIh5fkvz
sUAc+JTlzrwxDB1qy6hYQ3pFxZ25qPcYkl/7M59g4qARjvIncPKeU1JpPGne
Fl8XpRJD5ubiQE4ADjZCsaFBhSF/Ru0VD9LpMRxxshpDu+Uw/9Efhz3lV7la
LYYaPK+PpZBu9fCOb57F0HhfUrw3abfuHvppPdlXyzRFx8DhYvRRV5oBQ0i+
sfoB6U//ywK5RS1l/UT6PyVhaDk=
      "]]}}, {{}, {}, 
    {RGBColor[0, 1, 0], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2nk4lN8XAPAxM2ZaJEmKylqKUERInFuW7LJmV5J8K0uSLXtI0UIRhZIl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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJxF2Xk0Vd8XAHBTRKYkQoOhlCGZhwb7JXMIlaQipZKkkspYpgzfJAmpJA0k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      "]]}}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0, 1.124433358085935}, {0.5, 1.124433358085935}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, 0.7871033506601545}, {3, 0.7871033506601545}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, 1.124433358085935}, {0.5, 0.7871033506601545}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0.5, 1.124433358085935}, {0.5, 2.811083395214837}}]}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"t (ms)\"", FontSize -> 20, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1.5, 
      FormBox[
       RowBox[{"-", "1.5`"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{41., 25.}, {51., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{0., 3.}, {0., 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.92011697973193*^9, 3.9201170793988276`*^9}, 
   3.9201173306847777`*^9}],

Cell["0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10", "Text",
 CellChangeTimes->{
  3.9189930694115*^9, {3.918993599437173*^9, 3.918993599437173*^9}}],

Cell["0,5,10,15,20,25", "Text",
 CellChangeTimes->{
  3.9189930694115*^9, {3.918993599437173*^9, 3.9189935999960055`*^9}, {
   3.91916560372747*^9, 3.91916560372747*^9}}],

Cell["0,10,20,30,40", "Text",
 CellChangeTimes->{
  3.9189930694115*^9, {3.918993599437173*^9, 3.9189935999960055`*^9}, {
   3.91916560372747*^9, 3.9191656104898868`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Tau]e", "=", "0.5"}], ";", 
    RowBox[{"\[Tau]d", "=", "0.1"}], ";", 
    RowBox[{"V0", "=", 
     RowBox[{"-", "0.7"}]}], ";", 
    RowBox[{"t0", "=", "0.5"}], ";", 
    RowBox[{"tfin", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", "20"}], ";", 
    RowBox[{"DV", "=", "0.02"}], ";", 
    RowBox[{"Vs", "=", "0.1"}], ";", 
    RowBox[{"Dtt", "=", 
     RowBox[{"DV", "/", "Vs"}]}], ";", 
    RowBox[{"tff", "=", 
     RowBox[{"t0", "+", 
      RowBox[{"Dtt", " ", "NN"}]}]}], ";", " ", 
    RowBox[{"Vfin", "=", 
     RowBox[{"V0", "+", 
      RowBox[{"NN", " ", "DV"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"DV", " ", 
    RowBox[{"0.001", "/", 
     RowBox[{"(", 
      RowBox[{"0.001", " ", "Dtt"}], ")"}]}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"tf", "[", "n_", "]"}], ":=", 
     RowBox[{"t0", "+", 
      RowBox[{"n", " ", "Dtt"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Vstep", "[", "n_", "]"}], ":=", 
     RowBox[{"V0", "+", 
      RowBox[{"n", " ", "DV"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IdsA", "[", "0", "]"}], "=", 
     RowBox[{
      RowBox[{"L", "/", "\[Tau]e"}], " ", 
      RowBox[{"(", 
       RowBox[{"Aeq", "[", "V0", "]"}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IdsB", "[", "0", "]"}], "=", 
     RowBox[{
      RowBox[{"L", "/", "\[Tau]e"}], " ", 
      RowBox[{"(", 
       RowBox[{"Aeq", "[", "V0", "]"}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IdsB", "[", "n_", "]"}], ":=", 
     RowBox[{
      RowBox[{"IdsA", "[", "n", "]"}], "-", 
      RowBox[{"L", " ", 
       RowBox[{"cmu", "[", 
        RowBox[{"V0", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", " ", "-", "1"}], ")"}], "DV"}]}], "]"}], "   ", "DV", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", "\[Tau]e"}], "+", 
         RowBox[{"f", "/", "\[Tau]d"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "Dtt"}], "/", " ", "\[Tau]d"}], "]"}]}], ")"}]}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IdsA", "[", "n_", "]"}], ":=", 
     RowBox[{
      RowBox[{"IdsB", "[", 
       RowBox[{"n", "-", "1"}], "]"}], "+", 
      RowBox[{"L", " ", "f", " ", 
       RowBox[{"cmu", "[", 
        RowBox[{"V0", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", " ", "-", "1"}], ")"}], " ", "DV"}]}], "]"}], " ", 
       RowBox[{"DV", "/", "\[Tau]d"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Idd", "[", 
      RowBox[{"n_", ",", "tt_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"IdsB", "[", 
       RowBox[{"n", "-", "1"}], "]"}], "+", 
      RowBox[{"L", " ", "f", " ", 
       RowBox[{"cmu", "[", 
        RowBox[{"V0", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", " ", "-", "1"}], ")"}], " ", "DV"}]}], "]"}], "  ", 
       RowBox[{"DV", "/", "\[Tau]d"}]}], "-", 
      RowBox[{"L", " ", 
       RowBox[{"cmu", "[", 
        RowBox[{"V0", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", " ", "-", "1"}], ")"}], " ", "DV"}]}], "]"}], "   ", 
       "DV", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", "\[Tau]e"}], "+", 
         RowBox[{"f", "/", "\[Tau]d"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{"tt", "-", 
              RowBox[{"tf", "[", 
               RowBox[{"n", "-", "1"}], "]"}]}], ")"}]}], "/", "\[Tau]d"}], 
          "]"}]}], ")"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IdsE", "[", "0", "]"}], "=", 
     RowBox[{"Idc", "[", "V0", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IdsE", "[", "n_", "]"}], ":=", 
     RowBox[{
      RowBox[{"IdsE", "[", 
       RowBox[{"n", "-", "1"}], "]"}], "-", 
      RowBox[{
       RowBox[{"cmu", "[", 
        RowBox[{"V0", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", " ", "-", "1"}], ")"}], " ", "DV"}]}], "]"}], " ", 
       RowBox[{"L", " ", "/", "\[Tau]e"}], " ", "DV"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"io1", "=", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"t0", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"uv", "-", "V0"}], ")"}], "/", "Vs"}]}], ",", 
         RowBox[{"Idc", "[", "uv", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uv", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "10"}], ",", "10000"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(u\), \(g\)]\) (V)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(d\)]\) (\[Mu]A)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "0", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", 
            ",", "7", ",", "8", ",", "9", ",", "10"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", 
            RowBox[{"-", "3"}], ",", 
            RowBox[{"-", "2"}], ",", 
            RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
           "}"}], ",", "None", ",", "None"}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Orange"}], 
          "}"}], "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"bn2", "[", "0", "]"}], "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"IdsA", "[", "0", "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t0", ",", 
             RowBox[{"IdsA", "[", "0", "]"}]}], " ", "}"}]}], "}"}], "]"}]}], 
       "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"vb2", "[", "0", "]"}], "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Brown", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "V0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t0", ",", "V0"}], " ", "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"ii", "=", "1"}], ",", 
     RowBox[{"ii", "<", 
      RowBox[{"NN", "+", "1"}]}], ",", 
     RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"ty", "[", "ii", "]"}], "=", 
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"tt", ",", 
           RowBox[{"Idd", "[", 
            RowBox[{"ii", ",", "tt"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"tt", ",", 
           RowBox[{"tf", "[", 
            RowBox[{"ii", "-", "1"}], "]"}], ",", 
           RowBox[{"tf", "[", "ii", "]"}]}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "tff"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<t (ms)\>\"", ",", 
              RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<\!\(\*SubscriptBox[\(I\), \(d\)]\) (\[Mu]A)\>\"", ",", 
              RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"",
             ",", "\"\<\>\""}], "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", "True"}], ",", 
         RowBox[{"FrameTicks", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
             "0", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", 
              ",", "7", ",", "8", ",", "9", ",", "10"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "4"}], ",", 
              RowBox[{"-", "3"}], ",", 
              RowBox[{"-", "2"}], ",", 
              RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
             "}"}], ",", "None", ",", "None"}], "}"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue"}], 
            "}"}], "}"}]}], ",", 
         RowBox[{"LabelStyle", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
         RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", 
          RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"bn2", "[", "ii", "]"}], "=", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue", ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"tf", "[", 
                RowBox[{"ii", "-", "1"}], "]"}], ",", 
               RowBox[{"IdsB", "[", 
                RowBox[{"ii", "-", "1"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"tf", "[", 
                RowBox[{"ii", "-", "1"}], "]"}], ",", 
               RowBox[{"IdsA", "[", "ii", "]"}]}], " ", "}"}]}], "}"}], 
           "]"}]}], "}"}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"bn3", "[", "ii", "]"}], "=", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Gray", ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"tf", "[", 
                RowBox[{"ii", "-", "1"}], "]"}], ",", 
               RowBox[{"IdsE", "[", 
                RowBox[{"ii", "-", "1"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"tf", "[", 
                RowBox[{"ii", "-", "1"}], "]"}], ",", 
               RowBox[{"IdsE", "[", "ii", "]"}]}], " ", "}"}]}], "}"}], 
           "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"bn4", "[", "ii", "]"}], "=", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Gray", ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"tf", "[", 
                RowBox[{"ii", "-", "1"}], "]"}], ",", 
               RowBox[{"IdsE", "[", "ii", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"tf", "[", "ii", "]"}], ",", 
               RowBox[{"IdsE", "[", "ii", "]"}]}], " ", "}"}]}], "}"}], 
           "]"}]}], "}"}], "]"}]}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"ii", "=", "1"}], ",", 
     RowBox[{"ii", "<", 
      RowBox[{"NN", "+", "1"}]}], ",", 
     RowBox[{"ii", "++"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"vb1", "[", "ii", "]"}], "=", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Brown", ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"tf", "[", 
                RowBox[{"ii", "-", "1"}], "]"}], ",", 
               RowBox[{"Vstep", "[", 
                RowBox[{"ii", "-", "1"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"tf", "[", 
                RowBox[{"ii", "-", "1"}], "]"}], ",", 
               RowBox[{"Vstep", "[", "ii", "]"}]}], " ", "}"}]}], "}"}], 
           "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vb2", "[", "ii", "]"}], "=", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Brown", ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"tf", "[", 
                RowBox[{"ii", "-", "1"}], "]"}], ",", 
               RowBox[{"Vstep", "[", "ii", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"tf", "[", "ii", "]"}], ",", 
               RowBox[{"Vstep", "[", "ii", "]"}]}], " ", "}"}]}], "}"}], 
           "]"}]}], "}"}], "]"}]}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"io1", ",", 
     RowBox[{"Array", "[", 
      RowBox[{"ty", ",", "NN"}], "]"}], ",", 
     RowBox[{"Array", "[", 
      RowBox[{"bn2", ",", "NN"}], "]"}], ",", 
     RowBox[{"Array", "[", 
      RowBox[{"bn3", ",", "NN"}], "]"}], ",", 
     RowBox[{"Array", "[", 
      RowBox[{"bn4", ",", "NN"}], "]"}], ",", 
     RowBox[{"bn2", "[", "0", "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "tff"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2.5"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"BaseStyle", "->", 
      RowBox[{"{", 
       RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"vb1", ",", "NN"}], "]"}], ",", 
     RowBox[{"Array", "[", 
      RowBox[{"vb2", ",", "NN"}], "]"}], ",", 
     RowBox[{"vb2", "[", "0", "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "tff"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.75"}], ",", 
          RowBox[{"-", "0.2"}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<t (ms)\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "16"}]}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<V (V)\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
        ",", "\"\<\>\""}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "0", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",",
           "7", ",", "8", ",", "9", ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.7"}], ",", 
          RowBox[{"-", "0.5"}], ",", 
          RowBox[{"-", "0.3"}]}], "}"}], ",", "None", ",", "None"}], "}"}]}], 
     ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.2"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"90", " ", "4`"}]}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.8390646611298313`*^9, 3.839064663549252*^9}, {
   3.8390651628201227`*^9, 3.8390651698744855`*^9}, {3.8390671245340233`*^9, 
   3.839067253968177*^9}, {3.8390672908692884`*^9, 3.8390673435588245`*^9}, {
   3.839067444277615*^9, 3.8390674530816755`*^9}, {3.839067483223913*^9, 
   3.8390676448632746`*^9}, {3.839067792030848*^9, 3.8390679296503277`*^9}, {
   3.839068035965031*^9, 3.8390681198292847`*^9}, {3.8390709139116144`*^9, 
   3.8390709421089935`*^9}, {3.83907099038449*^9, 3.8390709930117693`*^9}, {
   3.839071053413534*^9, 3.839071065617492*^9}, {3.839071142245447*^9, 
   3.8390712315177836`*^9}, {3.839071262559967*^9, 3.8390713000871944`*^9}, {
   3.8390714971122246`*^9, 3.839071517359198*^9}, {3.8390715485300074`*^9, 
   3.8390716200472517`*^9}, {3.8390716672806673`*^9, 3.839071782347397*^9}, {
   3.839071837937226*^9, 3.839071939311781*^9}, {3.839072168081314*^9, 
   3.839072168581891*^9}, {3.8390723168444653`*^9, 3.8390724465495067`*^9}, {
   3.8390724871236815`*^9, 3.839072628537404*^9}, {3.8390726857581015`*^9, 
   3.83907270608572*^9}, {3.8390728526632924`*^9, 3.8390730714112225`*^9}, {
   3.839082271666379*^9, 3.8390823055073657`*^9}, {3.839082353119522*^9, 
   3.839082449840514*^9}, {3.8390839765348864`*^9, 3.839084057466158*^9}, {
   3.8390840878065057`*^9, 3.8390841778809776`*^9}, {3.8390842363292522`*^9, 
   3.8390842982497163`*^9}, 3.83908433029414*^9, {3.8390843708346243`*^9, 
   3.8390844315092807`*^9}, 3.839084462612833*^9, {3.8390845298830824`*^9, 
   3.839084537171591*^9}, {3.8390846234607463`*^9, 3.839084639769829*^9}, {
   3.839085385972989*^9, 3.8390853976007433`*^9}, {3.8390854555897675`*^9, 
   3.839085524444199*^9}, {3.839085565738154*^9, 3.8390855920819826`*^9}, {
   3.8390863447286386`*^9, 3.839086474045252*^9}, {3.839086860852067*^9, 
   3.839086874816577*^9}, {3.839087637034748*^9, 3.8390876843714943`*^9}, 
   3.83908780285631*^9, 3.8390878367914057`*^9, {3.839088015231053*^9, 
   3.8390880802460375`*^9}, {3.839088241208177*^9, 3.839088251058446*^9}, 
   3.839088396382834*^9, 3.8391182307918463`*^9, {3.839118379381566*^9, 
   3.8391183868618546`*^9}, {3.839118542781612*^9, 3.839118576690755*^9}, {
   3.839119230679368*^9, 3.8391192435152392`*^9}, {3.8391193005384474`*^9, 
   3.839119322077612*^9}, {3.8391197370496492`*^9, 3.839119744561663*^9}, {
   3.839119780647091*^9, 3.8391198576053133`*^9}, {3.83913747847266*^9, 
   3.839137485481214*^9}, {3.8391375587687283`*^9, 3.8391375797199593`*^9}, {
   3.8391376276780567`*^9, 3.8391376620779104`*^9}, {3.83913835785732*^9, 
   3.839138374216883*^9}, 3.8391384110040264`*^9, {3.8391384624942074`*^9, 
   3.839138462879356*^9}, {3.8391385170099597`*^9, 3.839138536349577*^9}, {
   3.839139183554804*^9, 3.8391391930138044`*^9}, {3.8391393033973885`*^9, 
   3.8391393043613095`*^9}, 3.839139359067504*^9, 3.839139436240513*^9, {
   3.8392078031308994`*^9, 3.8392078143543434`*^9}, {3.8392078889566584`*^9, 
   3.83920790820275*^9}, {3.839208054761527*^9, 3.839208093399903*^9}, {
   3.8392084092575808`*^9, 3.8392084620514746`*^9}, 3.839208533536579*^9, {
   3.8392086070037084`*^9, 3.8392086083290124`*^9}, 3.8392086479255266`*^9, {
   3.8392225965883913`*^9, 3.8392226283136573`*^9}, {3.8392226646362276`*^9, 
   3.8392227421040397`*^9}, 3.8392227767756677`*^9, {3.8392228326927814`*^9, 
   3.839222892911393*^9}, 3.8392230743763013`*^9, {3.839223141092394*^9, 
   3.839223141783134*^9}, 3.839223177642132*^9, {3.8392232273840017`*^9, 
   3.8392232854596047`*^9}, {3.8392233573873816`*^9, 3.839223398790718*^9}, {
   3.8392234505961695`*^9, 3.839223507183962*^9}, {3.839223811017748*^9, 
   3.8392239510950837`*^9}, {3.8392240167007127`*^9, 3.839224025275307*^9}, {
   3.8392241057509785`*^9, 3.839224157437503*^9}, {3.839224200897134*^9, 
   3.8392242487597456`*^9}, {3.839224294917468*^9, 3.839224296013791*^9}, {
   3.8392243639841394`*^9, 3.8392243950383773`*^9}, 3.839224442185709*^9, {
   3.8392245129185476`*^9, 3.8392245373577056`*^9}, {3.8392245776385975`*^9, 
   3.839224740679908*^9}, {3.8392248367057567`*^9, 3.839224838004247*^9}, {
   3.8392249023255987`*^9, 3.8392249329681873`*^9}, 3.8392250078513308`*^9, {
   3.8392250461420965`*^9, 3.8392250567765236`*^9}, {3.8392250892690206`*^9, 
   3.839225128234888*^9}, {3.839225292837965*^9, 3.8392253052980237`*^9}, {
   3.839225374465659*^9, 3.839225378163327*^9}, {3.8392366608564453`*^9, 
   3.839236691352835*^9}, {3.839236736346908*^9, 3.8392367461057377`*^9}, {
   3.8392368452896976`*^9, 3.8392369245276327`*^9}, {3.8392369586763678`*^9, 
   3.839236989556669*^9}, {3.8392370210310707`*^9, 3.839237025639107*^9}, {
   3.8392370611832547`*^9, 3.839237143422812*^9}, {3.839237229917989*^9, 
   3.839237306453603*^9}, {3.8392373387206373`*^9, 3.839237342820054*^9}, {
   3.839237447098841*^9, 3.8392375543643665`*^9}, {3.8392411494009237`*^9, 
   3.839241171431179*^9}, {3.83924120627816*^9, 3.8392412247291117`*^9}, 
   3.8392412792201967`*^9, 3.8392413874247665`*^9, {3.8392415172512045`*^9, 
   3.8392415791894693`*^9}, {3.839241632182249*^9, 3.8392416472548246`*^9}, 
   3.8392418101230965`*^9, {3.839242047805271*^9, 3.8392420951804295`*^9}, {
   3.8392421670049934`*^9, 3.8392422247577305`*^9}, {3.8392422574679546`*^9, 
   3.8392422587095203`*^9}, {3.839242291908*^9, 3.8392425704347763`*^9}, {
   3.8392426617662134`*^9, 3.8392426717163734`*^9}, 3.839242785862258*^9, {
   3.839246817917405*^9, 3.8392468269690895`*^9}, {3.839246889891876*^9, 
   3.839246924816616*^9}, {3.839309996677757*^9, 3.839310018708186*^9}, {
   3.839310845764266*^9, 3.839310880859878*^9}, {3.839310926113166*^9, 
   3.839310949193386*^9}, {3.8393110019361973`*^9, 3.8393110308399534`*^9}, {
   3.8393270934512377`*^9, 3.839327332415727*^9}, {3.839327370226597*^9, 
   3.839327451303669*^9}, {3.8393275031436253`*^9, 3.8393275194960613`*^9}, {
   3.839327586008069*^9, 3.8393276948310633`*^9}, {3.8393278034898295`*^9, 
   3.8393278068680096`*^9}, {3.8393278450424776`*^9, 
   3.8393278797618237`*^9}, {3.8393289610021143`*^9, 3.839328976754302*^9}, {
   3.8393294967878103`*^9, 3.839329617607455*^9}, 3.8393297021511583`*^9, {
   3.839329736764967*^9, 3.83932973839811*^9}, {3.839329841358012*^9, 
   3.839329850076448*^9}, {3.8393298856244183`*^9, 3.83932990739045*^9}, {
   3.839330200791801*^9, 3.839330209464896*^9}, 3.83933026862875*^9, {
   3.8393304947792683`*^9, 3.839330614321838*^9}, {3.839330707456501*^9, 
   3.8393307223587484`*^9}, {3.8393307586469154`*^9, 3.839330774655125*^9}, {
   3.8393308208469334`*^9, 3.8393308254369345`*^9}, {3.83933092079788*^9, 
   3.8393310148602314`*^9}, {3.8393311745075006`*^9, 
   3.8393311994275675`*^9}, {3.8393312620131807`*^9, 
   3.8393312886598005`*^9}, {3.83933158528376*^9, 3.8393316720258255`*^9}, 
   3.8393317188850336`*^9, {3.8393317973728094`*^9, 3.8393319397094903`*^9}, 
   3.8393320294844685`*^9, {3.8393325727147913`*^9, 3.8393326007437224`*^9}, {
   3.839332643937569*^9, 3.8393326886712303`*^9}, {3.839332884251463*^9, 
   3.8393328849388123`*^9}, {3.8393329498885293`*^9, 3.839332954368989*^9}, 
   3.839332984548478*^9, {3.839333161836732*^9, 3.839333179429063*^9}, {
   3.839333212168277*^9, 3.8393332158859396`*^9}, {3.839333299885914*^9, 
   3.839333320058819*^9}, {3.8393333662749724`*^9, 3.839333389618166*^9}, 
   3.8393335815372777`*^9, {3.8393336646381135`*^9, 3.839333690640252*^9}, {
   3.839333816187891*^9, 3.839333852596138*^9}, {3.839333913143673*^9, 
   3.839333960953573*^9}, {3.8393340547869487`*^9, 3.839334137419753*^9}, {
   3.839420765475212*^9, 3.839420767706482*^9}, {3.839420800720344*^9, 
   3.83942080814257*^9}, {3.839420930166752*^9, 3.839420954611184*^9}, 
   3.839421093306271*^9, {3.839421249787591*^9, 3.8394213460868835`*^9}, {
   3.839421400152422*^9, 3.8394214417353144`*^9}, {3.839421483648677*^9, 
   3.839421580608614*^9}, 3.839421616079374*^9, 3.839422181142932*^9, {
   3.8394224472930202`*^9, 3.839422448371497*^9}, {3.8394225405886507`*^9, 
   3.839422541885687*^9}, {3.8394225839963813`*^9, 3.83942258751882*^9}, 
   3.8394239784679832`*^9, {3.8394240190394516`*^9, 3.8394240194005165`*^9}, {
   3.839481241680246*^9, 3.8394812636526537`*^9}, {3.8394813033197775`*^9, 
   3.839481343020226*^9}, {3.8394813886318493`*^9, 3.83948138904453*^9}, {
   3.8394814470082235`*^9, 3.8394815138762083`*^9}, {3.839484145142799*^9, 
   3.8394841575703464`*^9}, {3.8394842427712455`*^9, 
   3.8394842456191454`*^9}, {3.8394844396674995`*^9, 
   3.8394844660440836`*^9}, {3.8394845806487627`*^9, 3.83948460808449*^9}, {
   3.8394847191879005`*^9, 3.839484719920673*^9}, {3.8394847985864277`*^9, 
   3.8394847999498053`*^9}, {3.839485522225484*^9, 3.8394858614478054`*^9}, {
   3.8394858968609977`*^9, 3.8394858979280567`*^9}, {3.83950394022218*^9, 
   3.839504016595684*^9}, {3.839504079022719*^9, 3.8395041716366367`*^9}, {
   3.8395042475063295`*^9, 3.83950424807436*^9}, {3.8395043044033585`*^9, 
   3.8395043325148754`*^9}, {3.839504403912784*^9, 3.839504405955762*^9}, {
   3.839504461254238*^9, 3.8395044954062967`*^9}, {3.839504572085556*^9, 
   3.8395046258331623`*^9}, {3.839504718095887*^9, 3.839504733043982*^9}, {
   3.839504792704324*^9, 3.8395048214714227`*^9}, {3.8395048602645364`*^9, 
   3.839504871422516*^9}, {3.83950521161292*^9, 3.8395052235501237`*^9}, {
   3.839505255990897*^9, 3.8395052773582516`*^9}, {3.839505321851119*^9, 
   3.839505332451271*^9}, {3.8395054257374*^9, 3.8395054385582395`*^9}, 
   3.839505580972617*^9, {3.8395057025144815`*^9, 3.8395057031788645`*^9}, {
   3.8395057369934807`*^9, 3.8395057373979363`*^9}, {3.839505772294227*^9, 
   3.839505778367197*^9}, {3.83950673092721*^9, 3.8395067795192204`*^9}, {
   3.8395084122279215`*^9, 3.8395084138977666`*^9}, {3.839508448233049*^9, 
   3.8395084493422976`*^9}, {3.839508499051385*^9, 3.8395085344200335`*^9}, 
   3.8395086207285233`*^9, {3.8395086973952723`*^9, 3.8395086978689127`*^9}, {
   3.8395089696790757`*^9, 3.839509039224576*^9}, {3.8395100524490423`*^9, 
   3.839510053723009*^9}, {3.839511493807127*^9, 3.8395115089839754`*^9}, {
   3.8395115931589155`*^9, 3.839511633911852*^9}, {3.839511664551564*^9, 
   3.8395117021779413`*^9}, {3.839511738662855*^9, 3.8395117683886237`*^9}, {
   3.8395840465025244`*^9, 3.8395840478719764`*^9}, {3.8395842326636224`*^9, 
   3.8395842405526743`*^9}, {3.8395844072352886`*^9, 3.839584438590257*^9}, {
   3.839584539157859*^9, 3.839584558647271*^9}, {3.8395846133789663`*^9, 
   3.83958465811094*^9}, {3.839584785836444*^9, 3.839584807986281*^9}, 
   3.839586726652771*^9, {3.8395867995416994`*^9, 3.8395868420413933`*^9}, 
   3.83958688638865*^9, {3.839587244941451*^9, 3.83958726487414*^9}, {
   3.83958774293878*^9, 3.8395877838602095`*^9}, 3.839587828597546*^9, {
   3.839587879706158*^9, 3.8395879135449758`*^9}, {3.839587955043039*^9, 
   3.8395879642045746`*^9}, {3.8395880048781385`*^9, 3.839588051406326*^9}, {
   3.8395880883490973`*^9, 3.8395881594520197`*^9}, {3.8395882347911615`*^9, 
   3.8395883226336384`*^9}, 3.8395883559509153`*^9, 3.839588415451826*^9, {
   3.8395884902783833`*^9, 3.8395885216082554`*^9}, {3.8395941073926105`*^9, 
   3.8395942227438965`*^9}, 3.839595304916483*^9, {3.8395954862576475`*^9, 
   3.83959557521957*^9}, {3.839595607221432*^9, 3.8395956076140194`*^9}, {
   3.839595660820343*^9, 3.839595661835729*^9}, {3.839604650775865*^9, 
   3.8396046640054827`*^9}, {3.839604708532463*^9, 3.8396047629301977`*^9}, {
   3.839604795558606*^9, 3.839604808947177*^9}, {3.839604852056878*^9, 
   3.8396048690185547`*^9}, {3.839642088079403*^9, 3.839642141004441*^9}, {
   3.8396422800918975`*^9, 3.8396423077286944`*^9}, {3.8396424143783884`*^9, 
   3.8396424152236857`*^9}, {3.8396426095904264`*^9, 
   3.8396426100591545`*^9}, {3.8396426843268356`*^9, 3.8396426912164164`*^9}, 
   3.8396427676568155`*^9, {3.8396428549330425`*^9, 3.8396429650459213`*^9}, 
   3.839643049962629*^9, {3.839643091872772*^9, 3.8396431410841303`*^9}, 
   3.839643491656567*^9, {3.839643550041149*^9, 3.839643610060313*^9}, {
   3.8396436783391447`*^9, 3.8396437059963512`*^9}, {3.8396437389632745`*^9, 
   3.8396437448257093`*^9}, {3.839643793497415*^9, 3.8396438275668716`*^9}, {
   3.839643978745996*^9, 3.8396439798436737`*^9}, {3.839644021519642*^9, 
   3.8396440428152156`*^9}, {3.8396441695399504`*^9, 
   3.8396441971715937`*^9}, {3.839644230142295*^9, 3.8396442469945946`*^9}, {
   3.839644284692358*^9, 3.8396442961501245`*^9}, {3.8396443434969287`*^9, 
   3.8396443583914576`*^9}, {3.8396448346105194`*^9, 3.839644913123821*^9}, {
   3.8396555898716025`*^9, 3.839655650012109*^9}, {3.8396556822310605`*^9, 
   3.839655771771843*^9}, {3.839655952479162*^9, 3.8396559541084647`*^9}, 
   3.839656003389371*^9, {3.8396560347174463`*^9, 3.839656116850046*^9}, {
   3.8396562422855325`*^9, 3.8396562713341274`*^9}, 3.8396563271846943`*^9, {
   3.8396565529884825`*^9, 3.839656667985509*^9}, {3.8396568526250334`*^9, 
   3.839656873162519*^9}, {3.8396570321068354`*^9, 3.8396570367161813`*^9}, {
   3.8396571621919303`*^9, 3.839657193340761*^9}, {3.839657225174745*^9, 
   3.8396572442512493`*^9}, {3.8396572932236905`*^9, 3.8396572940165*^9}, 
   3.8396574072631903`*^9, {3.8396575476060143`*^9, 3.8396575682943974`*^9}, {
   3.839664138921971*^9, 3.839664156869915*^9}, 3.839664243007531*^9, {
   3.839669622125418*^9, 3.839669647884663*^9}, {3.839670002387182*^9, 
   3.839670025487237*^9}, {3.8396700586539392`*^9, 3.8396701085420904`*^9}, {
   3.8396766028729286`*^9, 3.839676603372811*^9}, {3.839676649783103*^9, 
   3.8396766681979322`*^9}, {3.839723206211033*^9, 3.839723252419324*^9}, {
   3.8397243192805915`*^9, 3.8397243622670403`*^9}, {3.839724526690404*^9, 
   3.8397245565593586`*^9}, 3.839724591814554*^9, {3.8397246526353917`*^9, 
   3.8397246677187424`*^9}, {3.839724698665658*^9, 3.8397248461537275`*^9}, {
   3.839724910156172*^9, 3.839724969029936*^9}, {3.839725029399225*^9, 
   3.839725070375955*^9}, {3.8397257491640964`*^9, 3.8397258148584566`*^9}, {
   3.839726205531111*^9, 3.839726226304987*^9}, {3.839726314389023*^9, 
   3.8397264887181263`*^9}, {3.8397266355093994`*^9, 
   3.8397266356472826`*^9}, {3.839727069639051*^9, 3.83972707062368*^9}, {
   3.8397274615058823`*^9, 3.839727481527841*^9}, {3.83972755827617*^9, 
   3.8397275594724007`*^9}, {3.839727857737072*^9, 3.83972788618902*^9}, 
   3.8397281801577473`*^9, {3.839741406815917*^9, 3.839741648719699*^9}, 
   3.839741694966459*^9, {3.8397417738301263`*^9, 3.8397417740488653`*^9}, 
   3.839742014559319*^9, {3.8397421882027674`*^9, 3.839742188943444*^9}, {
   3.8397589658528605`*^9, 3.83975903164762*^9}, {3.839759582024466*^9, 
   3.8397596437148447`*^9}, {3.8397597378135786`*^9, 3.839759770277839*^9}, {
   3.839760042248042*^9, 3.8397600434337606`*^9}, {3.839760792865179*^9, 
   3.839760817913896*^9}, {3.8397655048182044`*^9, 3.839765505036851*^9}, {
   3.839765649791177*^9, 3.839765680039174*^9}, {3.839765730951825*^9, 
   3.8397657438209515`*^9}, {3.8397658325268707`*^9, 3.839765870890603*^9}, {
   3.8397695336031294`*^9, 3.8397695785421767`*^9}, 3.839769610638837*^9, {
   3.839769642999297*^9, 3.8397696900062704`*^9}, {3.8397697294324865`*^9, 
   3.839769753667972*^9}, 3.839770624201335*^9, {3.8399858643515997`*^9, 
   3.839985870106961*^9}, {3.8399859073530426`*^9, 3.83998590778368*^9}, {
   3.839986665758301*^9, 3.839986671600184*^9}, {3.840015477117873*^9, 
   3.840015532633871*^9}, {3.840262190474472*^9, 3.8402621922160215`*^9}, {
   3.8402622512898836`*^9, 3.8402623158498154`*^9}, {3.840262346847395*^9, 
   3.840262361938197*^9}, {3.8402624446884875`*^9, 3.840262497278998*^9}, {
   3.8402625593196363`*^9, 3.840262562846277*^9}, {3.840262654524027*^9, 
   3.8402626673364897`*^9}, {3.8402800661176753`*^9, 3.840280138278593*^9}, {
   3.840280177703832*^9, 3.840280189480773*^9}, {3.8402802324576406`*^9, 
   3.8402802331825943`*^9}, {3.8402812754975386`*^9, 3.840281326464582*^9}, 
   3.8402813946519136`*^9, {3.84028186111417*^9, 3.8402818954912634`*^9}, {
   3.8402819964993353`*^9, 3.8402819971437144`*^9}, {3.840330466229367*^9, 
   3.8403304972505484`*^9}, 3.8403305401374164`*^9, 3.840330628649666*^9, {
   3.8403306672934227`*^9, 3.8403306802026963`*^9}, {3.8403307193320885`*^9, 
   3.840330758272279*^9}, 3.8403307967908325`*^9, 3.8403308358680725`*^9, {
   3.840330872410847*^9, 3.8403308786837*^9}, {3.8403309221453967`*^9, 
   3.840330944340696*^9}, 3.840330989285677*^9, {3.840331109810131*^9, 
   3.840331153164013*^9}, {3.840331431580937*^9, 3.8403314406879196`*^9}, {
   3.8403317789283185`*^9, 3.840331780542934*^9}, {3.840331813886128*^9, 
   3.8403318320633073`*^9}, {3.8403318821336937`*^9, 
   3.8403318897950106`*^9}, {3.8403319357741313`*^9, 
   3.8403319411825953`*^9}, {3.8403320129500637`*^9, 
   3.8403321277278547`*^9}, {3.840332221075777*^9, 3.8403322212632327`*^9}, {
   3.8404162792747984`*^9, 3.8404162803058043`*^9}, {3.840416344690134*^9, 
   3.8404163448306866`*^9}, {3.8404178626090136`*^9, 3.840417925824424*^9}, {
   3.8404191918191233`*^9, 3.84041920226635*^9}, {3.840419242024495*^9, 
   3.8404192617321796`*^9}, {3.8404194389428053`*^9, 3.840419462557069*^9}, {
   3.840453834266838*^9, 3.8404538447517056`*^9}, 3.840453909614043*^9, {
   3.8404539683635793`*^9, 3.8404539905838337`*^9}, 3.8404540272985306`*^9, {
   3.840454156166298*^9, 3.840454205291971*^9}, {3.840454240247527*^9, 
   3.8404542540157146`*^9}, {3.8404543237333283`*^9, 
   3.8404543404928937`*^9}, {3.8404544521143074`*^9, 
   3.8404544541302176`*^9}, {3.840454485008524*^9, 3.8404544958331428`*^9}, {
   3.840454535970628*^9, 3.840454551137659*^9}, {3.840500625089159*^9, 
   3.840500656940725*^9}, {3.840500695345143*^9, 3.8405006960523067`*^9}, {
   3.8405010969852047`*^9, 3.840501112587641*^9}, {3.840501150634077*^9, 
   3.8405011611522417`*^9}, {3.8405026446645527`*^9, 3.84050265267775*^9}, 
   3.8405026878215275`*^9, 3.8405027886745453`*^9, {3.8405028323157024`*^9, 
   3.8405028521056433`*^9}, {3.840508597751215*^9, 3.8405086042448597`*^9}, {
   3.8405086361734276`*^9, 3.840508697640854*^9}, {3.84530515034306*^9, 
   3.8453051663199177`*^9}, 3.845305197884505*^9, {3.8454792808354254`*^9, 
   3.8454794150956697`*^9}, {3.845479722113243*^9, 3.8454797915964413`*^9}, {
   3.845514873929638*^9, 3.8455149337268724`*^9}, {3.8455149684706416`*^9, 
   3.8455149695080223`*^9}, {3.8455153275220933`*^9, 3.845515328229957*^9}, {
   3.845515395675539*^9, 3.845515401297691*^9}, {3.845515515853771*^9, 
   3.845515576447665*^9}, {3.845515612558851*^9, 3.845515632979537*^9}, {
   3.845515680153039*^9, 3.8455159262376585`*^9}, {3.845516112061887*^9, 
   3.8455161465263453`*^9}, {3.845516193085106*^9, 3.845516229178423*^9}, {
   3.8455163351689043`*^9, 3.845516585318216*^9}, {3.8455166177397394`*^9, 
   3.845516714733508*^9}, {3.845516771645197*^9, 3.8455167731827154`*^9}, {
   3.845516818729296*^9, 3.84551695860878*^9}, {3.845516994711903*^9, 
   3.845517026462266*^9}, 3.845517092145789*^9, {3.845517135366593*^9, 
   3.845517155446496*^9}, {3.845517186534149*^9, 3.8455171937276707`*^9}, {
   3.845517227012909*^9, 3.8455172279061613`*^9}, {3.8455173234132085`*^9, 
   3.8455173514857492`*^9}, {3.845517423730919*^9, 3.8455174243493695`*^9}, {
   3.8455174624069753`*^9, 3.845517465100626*^9}, 3.845517507705373*^9, 
   3.8455175508535676`*^9, {3.8455176264044795`*^9, 3.8455176334075813`*^9}, {
   3.8455313319229393`*^9, 3.845531509940443*^9}, 3.8455315849840965`*^9, {
   3.8455317016782956`*^9, 3.845531738966821*^9}, {3.845531778451456*^9, 
   3.845531779386674*^9}, {3.8456415428113813`*^9, 3.845641735457308*^9}, {
   3.8456420427094593`*^9, 3.8456420444008894`*^9}, {3.8456420953927226`*^9, 
   3.845642095827136*^9}, {3.8456421305858717`*^9, 3.8456422084386454`*^9}, 
   3.8456422719473834`*^9, {3.8456424654126687`*^9, 3.8456424685516415`*^9}, {
   3.8456425391271963`*^9, 3.845642581942461*^9}, {3.8456426396045694`*^9, 
   3.845642806094469*^9}, {3.845642836196087*^9, 3.845642900922883*^9}, {
   3.845642970285206*^9, 3.8456430181273146`*^9}, {3.8456430708546114`*^9, 
   3.845643125882959*^9}, {3.845643178575968*^9, 3.845643257358486*^9}, {
   3.8456433623862553`*^9, 3.8456433771042914`*^9}, {3.8456434590863156`*^9, 
   3.8456434937160645`*^9}, 3.845643545927831*^9, {3.845643600156926*^9, 
   3.845643618570978*^9}, {3.8456436644300175`*^9, 3.84564366503797*^9}, {
   3.845643702197648*^9, 3.8456437461979747`*^9}, 3.8456439574887114`*^9, {
   3.846069818172841*^9, 3.846069849642768*^9}, {3.8460699136765876`*^9, 
   3.846069914209477*^9}, {3.8460699599440656`*^9, 3.8460700314146757`*^9}, {
   3.846070076753316*^9, 3.846070077439046*^9}, {3.846070157661101*^9, 
   3.8460701937707815`*^9}, {3.846070258127372*^9, 3.846070370035694*^9}, 
   3.8460704231130123`*^9, {3.846070456017062*^9, 3.8460704588184586`*^9}, {
   3.8460710172041235`*^9, 3.846071021582673*^9}, {3.846071106666136*^9, 
   3.8460711227728405`*^9}, {3.846071236516765*^9, 3.8460712690613956`*^9}, {
   3.846071302508814*^9, 3.8460713286265783`*^9}, {3.846071391711331*^9, 
   3.8460713919222136`*^9}, {3.8460717432565613`*^9, 3.846071846163582*^9}, {
   3.8460718796339417`*^9, 3.8460718981181345`*^9}, {3.8460719281852317`*^9, 
   3.8460719602156863`*^9}, {3.8460725487311463`*^9, 
   3.8460727277222366`*^9}, {3.8460727966336946`*^9, 
   3.8460727999447126`*^9}, {3.8460728715731387`*^9, 3.846072900231036*^9}, 
   3.8460729488995743`*^9, 3.846073094187673*^9, {3.846073124968068*^9, 
   3.846073143649494*^9}, {3.846073291437569*^9, 3.846073320871194*^9}, {
   3.8460733513356*^9, 3.8460733827836275`*^9}, {3.8460734213260293`*^9, 
   3.846073547913215*^9}, {3.8460735888598585`*^9, 3.8460735948494663`*^9}, {
   3.8460736630482445`*^9, 3.84607366906472*^9}, {3.846073769039547*^9, 
   3.8460738022300262`*^9}, {3.8460738788770266`*^9, 
   3.8460738952181954`*^9}, {3.846073949966679*^9, 3.8460739569065495`*^9}, {
   3.846074029073464*^9, 3.8460740346596146`*^9}, {3.846074102104647*^9, 
   3.8460741324118767`*^9}, {3.8460741949049115`*^9, 3.846074222593691*^9}, {
   3.8460742841895127`*^9, 3.846074340763191*^9}, {3.846160732253354*^9, 
   3.8461607332481594`*^9}, 3.846161492762432*^9, {3.846161780897497*^9, 
   3.846161788138113*^9}, {3.8461618293598766`*^9, 3.846161858226082*^9}, {
   3.8461618966585674`*^9, 3.846161969794857*^9}, 3.846162102689354*^9, {
   3.8461621668466263`*^9, 3.846162180355235*^9}, {3.8461622164826603`*^9, 
   3.8461622355856447`*^9}, {3.846162281065609*^9, 3.8461624985309367`*^9}, 
   3.8461626621493115`*^9, 3.846162697816634*^9, {3.8461627342864695`*^9, 
   3.8461627345822268`*^9}, {3.8461628166006966`*^9, 3.8461628174265194`*^9}, 
   3.846162849529516*^9, 3.846163042718745*^9, {3.8461630926561747`*^9, 
   3.8461631014520173`*^9}, 3.846164675187914*^9, {3.8461653709571285`*^9, 
   3.8461653939322076`*^9}, {3.846239297565034*^9, 3.846239321709072*^9}, {
   3.8462393704866405`*^9, 3.846239378462596*^9}, 3.8462394463604927`*^9, {
   3.846239908200873*^9, 3.846240041118046*^9}, {3.8462400979595313`*^9, 
   3.8462402075029526`*^9}, {3.846240330599819*^9, 3.846240332116249*^9}, {
   3.846240396409835*^9, 3.846240426609739*^9}, {3.8462404635946035`*^9, 
   3.846240479194495*^9}, {3.846240547126852*^9, 3.8462406007711906`*^9}, {
   3.846240672984129*^9, 3.8462406735655537`*^9}, {3.846240715451014*^9, 
   3.846240727662325*^9}, {3.8462408398048706`*^9, 3.8462408550133176`*^9}, {
   3.846240906219432*^9, 3.8462409845731764`*^9}, {3.8462415426024213`*^9, 
   3.846241600241384*^9}, {3.8462416533016524`*^9, 3.8462416824345474`*^9}, {
   3.846241871443136*^9, 3.846241889026347*^9}, {3.84624196622915*^9, 
   3.846241982209696*^9}, {3.8462420839315395`*^9, 3.8462421106657743`*^9}, {
   3.8462493213059616`*^9, 3.846249371505189*^9}, {3.846249426216957*^9, 
   3.8462494677076874`*^9}, {3.846249549506504*^9, 3.8462495503135986`*^9}, {
   3.8463317012472258`*^9, 3.846331723789422*^9}, 3.846331790148814*^9, {
   3.846331841946804*^9, 3.8463318642788124`*^9}, {3.8463318999649568`*^9, 
   3.84633190085021*^9}, {3.846331970187175*^9, 3.8463319724350276`*^9}, {
   3.846332425994608*^9, 3.8463324267831564`*^9}, {3.8463324853767433`*^9, 
   3.846332505743512*^9}, {3.84633253640195*^9, 3.84633253746087*^9}, 
   3.8463325927468147`*^9, {3.846332664076268*^9, 3.84633267729871*^9}, {
   3.84633282094595*^9, 3.846332866648316*^9}, {3.846332915983061*^9, 
   3.846332964772069*^9}, {3.8463332315659857`*^9, 3.8463332589840655`*^9}, {
   3.8463333159368706`*^9, 3.8463333881232243`*^9}, {3.846333478174964*^9, 
   3.846333507307977*^9}, {3.8463337169753866`*^9, 3.846333752677167*^9}, {
   3.8463337874930525`*^9, 3.8463337938266315`*^9}, {3.84633382889653*^9, 
   3.8463338314544067`*^9}, {3.8463338661347585`*^9, 
   3.8463338671064034`*^9}, {3.8463341029946103`*^9, 3.8463341178046017`*^9}, 
   3.8463344961508446`*^9, {3.846334551477289*^9, 3.8463345669722776`*^9}, {
   3.846334647851037*^9, 3.8463346507709723`*^9}, {3.8463350072556896`*^9, 
   3.846335009531336*^9}, {3.8463350584383993`*^9, 3.8463350832915545`*^9}, 
   3.8463356730391445`*^9, {3.8463357330577507`*^9, 3.846335734677639*^9}, {
   3.8463357713912954`*^9, 3.846335784599365*^9}, {3.846335824451017*^9, 
   3.846335850541898*^9}, {3.8465148279290648`*^9, 3.846514905645626*^9}, {
   3.8465149546536207`*^9, 3.8465149557287645`*^9}, 3.8465150347627506`*^9, 
   3.8465150735123754`*^9, 3.846515133355834*^9, {3.846551496354246*^9, 
   3.8465515199215117`*^9}, {3.8465515514860935`*^9, 3.846551558453719*^9}, {
   3.8465516511605453`*^9, 3.8465516816971188`*^9}, {3.8465517493251767`*^9, 
   3.8465517819787836`*^9}, {3.846551812162984*^9, 3.84655181978378*^9}, {
   3.8469012753631597`*^9, 3.8469014245266294`*^9}, {3.846901477101201*^9, 
   3.846901480891117*^9}, 3.846901533852523*^9, {3.8469015653056993`*^9, 
   3.8469015942691755`*^9}, 3.8469016260053563`*^9, {3.846901664939994*^9, 
   3.8469016657155457`*^9}, {3.846901747509447*^9, 3.8469017503170366`*^9}, {
   3.84690191404624*^9, 3.84690193970901*^9}, 3.846901985149589*^9, {
   3.84690203255608*^9, 3.8469020373058805`*^9}, {3.8469021528510695`*^9, 
   3.84690220430954*^9}, {3.8469022448931456`*^9, 3.8469022504597807`*^9}, {
   3.846902285388745*^9, 3.846902288603936*^9}, {3.8469023384879513`*^9, 
   3.846902371933584*^9}, 3.846902765731144*^9, {3.8469028332433987`*^9, 
   3.8469028443561935`*^9}, 3.8469030843801355`*^9, 3.846903160980903*^9, {
   3.8469032059828815`*^9, 3.8469032390870132`*^9}, {3.84690342310567*^9, 
   3.846903439207902*^9}, {3.8469061580301685`*^9, 3.8469062645476227`*^9}, {
   3.8469065486448135`*^9, 3.846906561548581*^9}, {3.8469067471371455`*^9, 
   3.8469068174896765`*^9}, {3.84690686154051*^9, 3.8469068684523077`*^9}, {
   3.8497527618146653`*^9, 3.8497527676380615`*^9}, {3.8497528414079475`*^9, 
   3.849752843454638*^9}, {3.8497530625145917`*^9, 3.849753063032662*^9}, {
   3.8497530971084747`*^9, 3.8497531011988783`*^9}, {3.8497532258666143`*^9, 
   3.849753345755213*^9}, {3.849753924288494*^9, 3.849753985952464*^9}, {
   3.849754069460248*^9, 3.849754087001464*^9}, {3.849754259204835*^9, 
   3.849754268999332*^9}, {3.8497554284565487`*^9, 3.8497554930272894`*^9}, {
   3.849755685279069*^9, 3.8497556896240177`*^9}, {3.8497558773614607`*^9, 
   3.849755877843891*^9}, {3.8497559807269473`*^9, 3.8497560211165953`*^9}, 
   3.850443650520732*^9, {3.8504438404083548`*^9, 3.8504441120345283`*^9}, {
   3.850444156664489*^9, 3.850444280967318*^9}, {3.850444354744196*^9, 
   3.85044463643923*^9}, {3.8504447256702757`*^9, 3.8504447980665684`*^9}, {
   3.8505274395909743`*^9, 3.8505274411181674`*^9}, {3.8505275310510144`*^9, 
   3.8505276349685197`*^9}, {3.850527665564816*^9, 3.850527741150744*^9}, {
   3.850528010969228*^9, 3.8505280914370484`*^9}, {3.850528341539154*^9, 
   3.8505283435766478`*^9}, {3.850528399268195*^9, 3.850528452926201*^9}, {
   3.850528511901552*^9, 3.850528524032834*^9}, {3.8505286008142643`*^9, 
   3.8505286255862675`*^9}, {3.850528657292616*^9, 3.8505287485299587`*^9}, {
   3.850528791091945*^9, 3.8505287912193995`*^9}, {3.8505289892778673`*^9, 
   3.8505290093703814`*^9}, {3.8505291179397283`*^9, 3.850529246368305*^9}, {
   3.8505292847200036`*^9, 3.8505293531238484`*^9}, {3.85052942526715*^9, 
   3.8505295026053452`*^9}, {3.850529652810694*^9, 3.85052969888447*^9}, {
   3.8505297570230837`*^9, 3.8505297793908668`*^9}, {3.8505298130474796`*^9, 
   3.85052982372943*^9}, 3.850529903643921*^9, {3.8505299339680395`*^9, 
   3.850529938523468*^9}, {3.850533467746894*^9, 3.850533696587976*^9}, {
   3.8505337523084393`*^9, 3.8505340100220647`*^9}, {3.850534073301394*^9, 
   3.8505341115212436`*^9}, {3.8505341448690495`*^9, 3.850534244609003*^9}, {
   3.8505342773409953`*^9, 3.850534317485276*^9}, {3.850534376818581*^9, 
   3.8505345375059347`*^9}, 3.8505345895823593`*^9, {3.850534712936541*^9, 
   3.850534853983102*^9}, {3.85053489565536*^9, 3.85053490800423*^9}, {
   3.850535011630887*^9, 3.850535069369616*^9}, {3.8505609789941187`*^9, 
   3.8505609796472797`*^9}, {3.850561024378234*^9, 3.8505611077291512`*^9}, {
   3.8505611554662695`*^9, 3.8505611900834045`*^9}, {3.8505612604815354`*^9, 
   3.850561307036023*^9}, 3.8505614161973686`*^9, {3.850561489892841*^9, 
   3.8505614904828854`*^9}, 3.850561540476676*^9, {3.850566961415826*^9, 
   3.85056699607444*^9}, {3.8505670465401917`*^9, 3.850567067268143*^9}, {
   3.850567124561453*^9, 3.8505671481746936`*^9}, {3.8505671891195374`*^9, 
   3.850567192972233*^9}, {3.8505672404233675`*^9, 3.850567272319547*^9}, {
   3.8505673802869396`*^9, 3.850567388289441*^9}, {3.850567420051065*^9, 
   3.8505674379775977`*^9}, {3.850568113924102*^9, 3.850568121245113*^9}, {
   3.8505681786419373`*^9, 3.8505682190225987`*^9}, {3.8505682742836356`*^9, 
   3.8505682972999997`*^9}, {3.850568330443387*^9, 3.8505683415549088`*^9}, {
   3.850568377492758*^9, 3.850568403154665*^9}, {3.850568837097434*^9, 
   3.850568946787299*^9}, {3.8505691453292117`*^9, 3.850569195539899*^9}, {
   3.8505692859376397`*^9, 3.8505693669331837`*^9}, {3.8505693974289236`*^9, 
   3.8505695475039663`*^9}, {3.8505696079724298`*^9, 
   3.8505696221275873`*^9}, {3.8505697874854712`*^9, 
   3.8505698175396166`*^9}, {3.850569868969412*^9, 3.8505698726296372`*^9}, {
   3.850569905926787*^9, 3.8505699809036593`*^9}, {3.850570015920215*^9, 
   3.85057008172045*^9}, {3.850785556912866*^9, 3.850785616614393*^9}, {
   3.8507856606466494`*^9, 3.850785723209618*^9}, {3.8507857656066175`*^9, 
   3.850785880874487*^9}, {3.850785924508508*^9, 3.850785937300992*^9}, {
   3.8507859750545197`*^9, 3.8507859968100834`*^9}, {3.850786077342246*^9, 
   3.8507860848236823`*^9}, {3.8507861340867023`*^9, 3.8507861374599075`*^9}, 
   3.850786227982345*^9, {3.8507862859910107`*^9, 3.8507863008387175`*^9}, {
   3.850786368316942*^9, 3.850786374976062*^9}, {3.850786423270744*^9, 
   3.850786423425295*^9}, {3.8507865491264324`*^9, 3.850786595976322*^9}, {
   3.850786636570469*^9, 3.850786709325587*^9}, {3.850786743990263*^9, 
   3.8507868015086374`*^9}, {3.8507870134211025`*^9, 
   3.8507870176048164`*^9}, {3.850787059141889*^9, 3.8507870650224657`*^9}, {
   3.850787111878257*^9, 3.850787113157389*^9}, {3.8507887599989805`*^9, 
   3.850788841851822*^9}, {3.850788913491912*^9, 3.8507890311085014`*^9}, {
   3.8507890809695005`*^9, 3.8507890902738066`*^9}, {3.8507891921970196`*^9, 
   3.8507891973037043`*^9}, {3.8507892279462795`*^9, 3.850789249495205*^9}, {
   3.850791412876636*^9, 3.8507914130273633`*^9}, {3.8507915155633483`*^9, 
   3.8507915162424593`*^9}, {3.850827343188859*^9, 3.850827375432101*^9}, {
   3.8508274109868975`*^9, 3.8508274369062905`*^9}, {3.8508274890786314`*^9, 
   3.8508274894138756`*^9}, {3.8508275695516253`*^9, 3.850827569788695*^9}, 
   3.8508276711587315`*^9, {3.8508277166165743`*^9, 3.8508277728386536`*^9}, {
   3.8508278475513325`*^9, 3.8508278753498926`*^9}, {3.8508279408872223`*^9, 
   3.85082794118405*^9}, {3.850827981298354*^9, 3.850828056921221*^9}, {
   3.850828494113824*^9, 3.850828495039543*^9}, {3.85082856023905*^9, 
   3.850828575017256*^9}, {3.850828628892047*^9, 3.850828696248144*^9}, 
   3.8508287630158415`*^9, {3.8508293694951773`*^9, 3.850829372071825*^9}, {
   3.8508294221130056`*^9, 3.8508294474505587`*^9}, {3.8508295136154523`*^9, 
   3.850829546786518*^9}, {3.8508307551495695`*^9, 3.850830755305548*^9}, {
   3.850830846425475*^9, 3.8508308469949007`*^9}, {3.8508328226756153`*^9, 
   3.8508328956454206`*^9}, {3.8515151599360895`*^9, 
   3.8515151854097323`*^9}, {3.851515227511881*^9, 3.8515152691971846`*^9}, {
   3.8517376565999703`*^9, 3.851737660729647*^9}, {3.8517376993937993`*^9, 
   3.851737854226467*^9}, {3.8517379030659018`*^9, 3.851737963592141*^9}, {
   3.8517380004040184`*^9, 3.851738156849004*^9}, {3.8517381881441555`*^9, 
   3.8517383547150526`*^9}, {3.851738403578961*^9, 3.8517384750343685`*^9}, {
   3.8517386329884996`*^9, 3.8517387036807384`*^9}, {3.8517387496128297`*^9, 
   3.8517391066461697`*^9}, 3.851739167106615*^9, {3.851739199324179*^9, 
   3.8517392033202653`*^9}, {3.851739306865944*^9, 3.8517396012506447`*^9}, {
   3.8517396478337793`*^9, 3.851739717012961*^9}, {3.851739779861041*^9, 
   3.8517398251446857`*^9}, {3.8517401674121*^9, 3.85174023031291*^9}, {
   3.8517403822763968`*^9, 3.8517405215277195`*^9}, {3.8517405598035936`*^9, 
   3.8517405807347307`*^9}, 3.8517406111741548`*^9, {3.852771815388609*^9, 
   3.852771815826337*^9}, {3.852771938933034*^9, 3.852772015527173*^9}, {
   3.8527720455326405`*^9, 3.852772051655347*^9}, {3.852772112575083*^9, 
   3.85277216712604*^9}, {3.8527722639917727`*^9, 3.8527723193930345`*^9}, {
   3.8527723507994275`*^9, 3.8527724886441803`*^9}, 3.852772518958836*^9, {
   3.8527726690962496`*^9, 3.8527726724595623`*^9}, {3.852772785224839*^9, 
   3.852772814059412*^9}, {3.8527728536940055`*^9, 3.8527728543197746`*^9}, 
   3.8527728940919833`*^9, {3.8527729250196114`*^9, 3.8527729905347033`*^9}, {
   3.8527730490675783`*^9, 3.8527730529881525`*^9}, {3.852773399558672*^9, 
   3.852773411256092*^9}, {3.852773459331044*^9, 3.852773480723246*^9}, {
   3.8527735251577444`*^9, 3.8527735647772226`*^9}, {3.85277372440212*^9, 
   3.852773727144375*^9}, {3.8528731960002193`*^9, 3.8528733256878357`*^9}, {
   3.852873387704274*^9, 3.852873409884766*^9}, {3.8528734508562613`*^9, 
   3.8528734515817213`*^9}, {3.8528734901873713`*^9, 3.852873528186962*^9}, {
   3.8528735614708843`*^9, 3.8528735812376013`*^9}, {3.8528736531146784`*^9, 
   3.852873677620881*^9}, {3.8528801200331235`*^9, 3.852880146194016*^9}, {
   3.853140879673688*^9, 3.8531409143592653`*^9}, {3.8531409625201416`*^9, 
   3.8531410288764524`*^9}, {3.8531410590292354`*^9, 
   3.8531411087537766`*^9}, {3.906960081539485*^9, 3.9069602331152077`*^9}, {
   3.9069603433707557`*^9, 3.906960532270595*^9}, {3.9069608107416534`*^9, 
   3.906960894501176*^9}, 3.906976975428384*^9, 3.9069784461360517`*^9, {
   3.9069784939955707`*^9, 3.906978495519633*^9}, {3.906979520056976*^9, 
   3.906979527909192*^9}, {3.9070299969708767`*^9, 3.9070299973647575`*^9}, 
   3.9070302622793455`*^9, {3.907031054878291*^9, 3.907031101672268*^9}, {
   3.907031132657627*^9, 3.907031137965227*^9}, {3.907031258015709*^9, 
   3.907031258244317*^9}, 3.907060462885079*^9, {3.9070616210919228`*^9, 
   3.9070617379829817`*^9}, {3.9070618359373693`*^9, 
   3.9070618491419787`*^9}, {3.9072168098312087`*^9, 
   3.9072168879034996`*^9}, {3.9072169598535347`*^9, 
   3.9072169971857233`*^9}, {3.9072170607219973`*^9, 3.907217066892645*^9}, {
   3.9076577595519457`*^9, 3.9076578173877373`*^9}, {3.9076578614233837`*^9, 
   3.907657894347175*^9}, {3.9076579602806206`*^9, 3.9076579846181087`*^9}, {
   3.9076596607447786`*^9, 3.9076596756372747`*^9}, 3.910745605690302*^9, {
   3.91074584911373*^9, 3.9107458926127214`*^9}, 3.910745941790287*^9, {
   3.910745986223607*^9, 3.910746063719597*^9}, {3.910747810729528*^9, 
   3.9107478791523943`*^9}, {3.9107479317978497`*^9, 
   3.9107479806408787`*^9}, {3.9107480256793222`*^9, 3.910748109579584*^9}, {
   3.91086543516223*^9, 3.9108654503446293`*^9}, {3.910865504589961*^9, 
   3.9108657401174555`*^9}, {3.91086584568825*^9, 3.910865852120024*^9}, 
   3.910865926383168*^9, 3.9108659744156675`*^9, 3.91086605745315*^9, {
   3.9108661771273518`*^9, 3.9108661799860926`*^9}, {3.9108662518520503`*^9, 
   3.9108662615334487`*^9}, 3.9108663396346254`*^9, {3.910866427961111*^9, 
   3.9108664324625444`*^9}, {3.910866648483549*^9, 3.910866665466797*^9}, {
   3.9108666978412094`*^9, 3.910866759019273*^9}, 3.9108668342632604`*^9, {
   3.9108668671138697`*^9, 3.910866882442206*^9}, {3.9108669792404804`*^9, 
   3.9108671430224776`*^9}, {3.9108671931495285`*^9, 3.910867227668786*^9}, {
   3.9108672957548175`*^9, 3.9108672974319744`*^9}, {3.910867368016037*^9, 
   3.910867368944265*^9}, 3.910867400227538*^9, {3.911008255763074*^9, 
   3.911008275926586*^9}, 3.9110083690822363`*^9, {3.9110084055565042`*^9, 
   3.9110084252803555`*^9}, 3.911008491161389*^9, {3.911008696240383*^9, 
   3.911008714321493*^9}, {3.9110088966274376`*^9, 3.911008900951162*^9}, {
   3.9110089635273657`*^9, 3.9110089783297873`*^9}, {3.911009014769552*^9, 
   3.9110090198434143`*^9}, {3.9110092308436937`*^9, 3.911009360495569*^9}, {
   3.9110093990206623`*^9, 3.9110094532567844`*^9}, {3.911009498630669*^9, 
   3.9110095367569847`*^9}, {3.9110095712912645`*^9, 
   3.9110096330820303`*^9}, {3.9110096653864827`*^9, 3.911009822963343*^9}, {
   3.911009859719963*^9, 3.911009866575224*^9}, {3.911009967367282*^9, 
   3.9110099850429783`*^9}, {3.911010028843105*^9, 3.9110101503231063`*^9}, {
   3.911010193179899*^9, 3.911010257505966*^9}, 3.911010335859486*^9, {
   3.911010401075186*^9, 3.911010457367464*^9}, 3.911010499750472*^9, {
   3.9110401234863586`*^9, 3.911040300892739*^9}, {3.9110403386146345`*^9, 
   3.911040544742799*^9}, {3.9110405856611333`*^9, 3.911040600084425*^9}, {
   3.9110409430788774`*^9, 3.9110409865360575`*^9}, {3.9110412680876427`*^9, 
   3.911041429298622*^9}, {3.911041589517542*^9, 3.9110416136098943`*^9}, {
   3.9110959319146233`*^9, 3.911096010751473*^9}, {3.9110962776335144`*^9, 
   3.911096327516655*^9}, {3.9110963649569387`*^9, 3.9110963792243595`*^9}, {
   3.917832590471942*^9, 3.91783259261812*^9}, {3.9178326929319906`*^9, 
   3.9178327503678517`*^9}, 3.9178328067760944`*^9, 3.917832854468274*^9, 
   3.917832888754475*^9, {3.917833107460365*^9, 3.917833108831243*^9}, {
   3.9178331620730915`*^9, 3.9178331825416665`*^9}, {3.9178332252920213`*^9, 
   3.917833227229144*^9}, 3.917833258961728*^9, {3.9178333424246206`*^9, 
   3.9178333517396064`*^9}, {3.917833444344221*^9, 3.9178334458517885`*^9}, 
   3.9178335515004683`*^9, {3.917833599553218*^9, 3.917833650004278*^9}, {
   3.917833691644823*^9, 3.917833692505719*^9}, {3.917834112622341*^9, 
   3.9178341280855384`*^9}, 3.917834171255001*^9, 3.9178342309758744`*^9, {
   3.917834295930198*^9, 3.917834298629716*^9}, 3.9178343890259485`*^9, 
   3.9178344550738645`*^9, {3.9178345592764263`*^9, 3.9178345765383854`*^9}, {
   3.9178349428335857`*^9, 3.917834957888749*^9}, {3.917835043598898*^9, 
   3.9178350499497914`*^9}, {3.917835648701893*^9, 3.9178356700048037`*^9}, {
   3.917835827590342*^9, 3.91783583779432*^9}, {3.917844702487713*^9, 
   3.9178447470333223`*^9}, {3.9178449064646893`*^9, 
   3.9178449159801645`*^9}, {3.9178449692656164`*^9, 
   3.9178450755686426`*^9}, {3.9178451261178627`*^9, 3.917845128031886*^9}, {
   3.91784611797869*^9, 3.917846150421515*^9}, {3.9178462178470125`*^9, 
   3.9178462188160224`*^9}, {3.9178463821131353`*^9, 3.917846404318012*^9}, {
   3.9178464868957653`*^9, 3.9178464974362345`*^9}, {3.9178466391768084`*^9, 
   3.917846660518054*^9}, {3.917846705713427*^9, 3.9178467398525267`*^9}, 
   3.9178467833607264`*^9, {3.917846824928237*^9, 3.9178468336706343`*^9}, {
   3.91784692713665*^9, 3.917846948232817*^9}, {3.917846984842763*^9, 
   3.9178470161506443`*^9}, {3.9182108415687127`*^9, 3.918210908004079*^9}, {
   3.9182109498407817`*^9, 3.9182111444301233`*^9}, {3.918211191133893*^9, 
   3.918211195152011*^9}, {3.9182112453708096`*^9, 3.9182112703404927`*^9}, {
   3.9182113141345406`*^9, 3.918211343884912*^9}, {3.918211377206615*^9, 
   3.9182113996989174`*^9}, {3.9182114444718027`*^9, 
   3.9182115011709948`*^9}, {3.918211554509279*^9, 3.9182118434838734`*^9}, {
   3.9182118844163384`*^9, 3.9182119340516095`*^9}, {3.918212144079294*^9, 
   3.9182121453109922`*^9}, {3.918212191518219*^9, 3.91821223630976*^9}, {
   3.918212271191306*^9, 3.9182122977139473`*^9}, {3.9182127376792097`*^9, 
   3.9182127835214453`*^9}, 3.9182128432655125`*^9, {3.91821287824856*^9, 
   3.9182128969493885`*^9}, {3.91821294863701*^9, 3.9182129828520937`*^9}, {
   3.918213075623084*^9, 3.9182130837816334`*^9}, {3.9182131181100187`*^9, 
   3.9182131282066326`*^9}, {3.9182131764587135`*^9, 
   3.9182131872087326`*^9}, {3.9182132256185937`*^9, 3.9182132786848826`*^9}, 
   3.9182133443026752`*^9, {3.918213399710333*^9, 3.9182134517760997`*^9}, {
   3.918213670022545*^9, 3.9182136812447324`*^9}, {3.918213741389742*^9, 
   3.9182137712299156`*^9}, {3.9182142068740797`*^9, 
   3.9182142423170424`*^9}, {3.9182142843559637`*^9, 3.9182144485375614`*^9}, 
   3.9183868189038353`*^9, {3.9183869791436715`*^9, 3.9183870249341273`*^9}, {
   3.918387063255185*^9, 3.9183872154970036`*^9}, 3.918387380773491*^9, {
   3.9183874438896503`*^9, 3.9183874607967434`*^9}, {3.9183875117268324`*^9, 
   3.9183876454441814`*^9}, {3.918387699630683*^9, 3.9183877688340044`*^9}, {
   3.918387802768314*^9, 3.918387803619853*^9}, {3.918387857253932*^9, 
   3.918387971999835*^9}, {3.9183881527872243`*^9, 3.918388191866728*^9}, {
   3.918388405086855*^9, 3.918388412079358*^9}, 3.9183884763462667`*^9, {
   3.9183886687355785`*^9, 3.9183886854459133`*^9}, 3.9183887358644423`*^9, {
   3.9183887660065327`*^9, 3.918389015859414*^9}, {3.9183890536085443`*^9, 
   3.9183890784105005`*^9}, {3.918389110930525*^9, 3.918389162314743*^9}, {
   3.9183891961226373`*^9, 3.918389217394478*^9}, {3.918443518679922*^9, 
   3.9184435589437857`*^9}, {3.918468904157605*^9, 3.9184689598510747`*^9}, 
   3.918469007115903*^9, {3.9184690520839205`*^9, 3.918469056163133*^9}, 
   3.918469096557351*^9, {3.9184694377273498`*^9, 3.918469541429146*^9}, {
   3.918469577199663*^9, 3.9184695777822733`*^9}, {3.918469614204286*^9, 
   3.918469623924448*^9}, {3.9184696905745716`*^9, 3.918469792576047*^9}, {
   3.918469955107318*^9, 3.918469996692487*^9}, {3.918470389413684*^9, 
   3.9184704413501296`*^9}, {3.918470475165797*^9, 3.918470512863323*^9}, {
   3.918472688947116*^9, 3.9184728604640856`*^9}, {3.918472962106249*^9, 
   3.9184729906668854`*^9}, {3.9184730493281727`*^9, 3.9184730719081926`*^9}, 
   3.9184731023696575`*^9, {3.9184731439397993`*^9, 3.918473314049518*^9}, {
   3.9184733459570713`*^9, 3.918473427705847*^9}, {3.9184734597458005`*^9, 
   3.9184735234619155`*^9}, {3.9184735626532803`*^9, 
   3.9184736963371334`*^9}, {3.9184737660881586`*^9, 3.918473766468898*^9}, {
   3.9184737966846886`*^9, 3.9184738079610662`*^9}, {3.918473959857894*^9, 
   3.918474005320571*^9}, {3.918474510873428*^9, 3.918474679883602*^9}, {
   3.9184749428062515`*^9, 3.91847498880945*^9}, {3.9184750541107254`*^9, 
   3.918475205330573*^9}, 3.9184752631411552`*^9, {3.9184753063673215`*^9, 
   3.918475352977291*^9}, {3.9184754407677546`*^9, 3.9184754412443724`*^9}, {
   3.918475628260256*^9, 3.918475668244879*^9}, {3.9184757057135077`*^9, 
   3.9184757166736073`*^9}, {3.918475765128145*^9, 3.9184758002945547`*^9}, 
   3.918519529229628*^9, 3.9185195655228205`*^9, 3.918519662116781*^9, {
   3.918565115681335*^9, 3.9185651170475245`*^9}, {3.918565154024054*^9, 
   3.9185651551250916`*^9}, {3.918565226326087*^9, 3.9185652430753183`*^9}, {
   3.9186128300842323`*^9, 3.9186128895159025`*^9}, {3.918612924324767*^9, 
   3.9186130117795515`*^9}, {3.9186130613470125`*^9, 
   3.9186130696010437`*^9}, {3.918613107184228*^9, 3.918613128825331*^9}, {
   3.9186131616048093`*^9, 3.9186131655936213`*^9}, {3.9186132280032024`*^9, 
   3.9186132341049404`*^9}, {3.918613365472639*^9, 3.9186133702369013`*^9}, {
   3.9186134281993127`*^9, 3.9186134665894823`*^9}, {3.9186137084434156`*^9, 
   3.9186137383351555`*^9}, {3.918613772472601*^9, 3.9186137737393503`*^9}, 
   3.918887389624998*^9, {3.918887430289461*^9, 3.918887440647854*^9}, {
   3.9188875661156006`*^9, 3.9188876221459446`*^9}, {3.9188876568526077`*^9, 
   3.9188878300207043`*^9}, {3.918887884552565*^9, 3.918887884902802*^9}, {
   3.9188879314258213`*^9, 3.918888060437535*^9}, {3.9188880943771667`*^9, 
   3.9188883445272512`*^9}, {3.918888380746276*^9, 3.9188884665107403`*^9}, {
   3.9188885452028327`*^9, 3.9188888274369483`*^9}, {3.918888902333618*^9, 
   3.9188889244019113`*^9}, {3.918905751708949*^9, 3.9189058687197723`*^9}, {
   3.918905965645903*^9, 3.9189059922902803`*^9}, {3.9189060372014403`*^9, 
   3.9189060649017897`*^9}, {3.9189061066644287`*^9, 3.918906112459484*^9}, {
   3.9189061462558365`*^9, 3.9189061744639564`*^9}, {3.9189062110037365`*^9, 
   3.9189062350437818`*^9}, {3.918906269247885*^9, 3.9189065330721025`*^9}, {
   3.9189065698817983`*^9, 3.9189066003364887`*^9}, {3.9189066394099503`*^9, 
   3.9189067966545057`*^9}, {3.918906863336608*^9, 3.9189069288687477`*^9}, {
   3.9189070002860928`*^9, 3.9189070123245645`*^9}, {3.9189070458808904`*^9, 
   3.918907048311232*^9}, {3.9189071231692133`*^9, 3.9189071295405245`*^9}, {
   3.918907171511249*^9, 3.9189072278711424`*^9}, {3.91890730086036*^9, 
   3.9189073634135766`*^9}, {3.9189074193860016`*^9, 
   3.9189074230910587`*^9}, {3.9189074796380234`*^9, 3.918907508483293*^9}, {
   3.918907564976491*^9, 3.9189075655671387`*^9}, {3.9189076258403006`*^9, 
   3.9189076371183867`*^9}, {3.918907690072529*^9, 3.9189076902996416`*^9}, 
   3.9189077274782753`*^9, {3.9189077709417524`*^9, 3.918907771373406*^9}, {
   3.9189078384047637`*^9, 3.9189078685377054`*^9}, {3.918908720719207*^9, 
   3.9189088051760793`*^9}, {3.9189088686122694`*^9, 3.918908916702488*^9}, 
   3.9189089848567295`*^9, 3.918909019511362*^9, {3.918909050300413*^9, 
   3.918909108363743*^9}, {3.918909238092739*^9, 3.918909323281892*^9}, {
   3.9189093552534466`*^9, 3.9189093742367325`*^9}, {3.918957606501976*^9, 
   3.9189577490212097`*^9}, {3.9189577801386724`*^9, 3.918957832632487*^9}, {
   3.9189578719693727`*^9, 3.9189579850956335`*^9}, {3.9189581878705845`*^9, 
   3.9189582776839914`*^9}, {3.918958338497285*^9, 3.9189584515046873`*^9}, {
   3.9189584815970707`*^9, 3.9189585036481457`*^9}, {3.918958551985441*^9, 
   3.9189585568786774`*^9}, {3.9189585894370503`*^9, 
   3.9189586955009737`*^9}, {3.918958737852306*^9, 3.918958789752138*^9}, {
   3.9189588237748766`*^9, 3.9189588855097632`*^9}, {3.91895892454292*^9, 
   3.91895892482257*^9}, {3.918958968438753*^9, 3.918959031442423*^9}, {
   3.9189591089357924`*^9, 3.9189591144893084`*^9}, 3.918959905448959*^9, {
   3.9189599438302555`*^9, 3.918959960164447*^9}, {3.9189600126221313`*^9, 
   3.918960033621499*^9}, {3.918960132469606*^9, 3.9189601463349886`*^9}, {
   3.9189679305506477`*^9, 3.918967943615985*^9}, {3.9189680003268957`*^9, 
   3.9189680202944665`*^9}, {3.9189681560975103`*^9, 3.918968249254981*^9}, {
   3.9189682921333666`*^9, 3.9189683100025735`*^9}, {3.9189683533015866`*^9, 
   3.9189683842722383`*^9}, {3.9189684291201553`*^9, 
   3.9189685419301662`*^9}, {3.9189686140188465`*^9, 
   3.9189686337452974`*^9}, {3.9189688587212515`*^9, 
   3.9189689013610086`*^9}, {3.9189689425463524`*^9, 3.9189689803690157`*^9}, 
   3.918969020949246*^9, {3.9189690518770075`*^9, 3.9189691229669294`*^9}, {
   3.918969174229334*^9, 3.918969228702859*^9}, {3.918969407463099*^9, 
   3.918969480659502*^9}, {3.9189701851113462`*^9, 3.9189702242376294`*^9}, {
   3.9189702546588774`*^9, 3.9189703447377048`*^9}, {3.9189703894498096`*^9, 
   3.9189705098724074`*^9}, {3.918970558573368*^9, 3.9189705744907193`*^9}, {
   3.9189706107791433`*^9, 3.9189706137824135`*^9}, {3.918970740344365*^9, 
   3.918970822451476*^9}, {3.918970855906142*^9, 3.918971060980829*^9}, {
   3.9189711001834245`*^9, 3.918971151339526*^9}, {3.9189711911573753`*^9, 
   3.918971379415925*^9}, {3.9189714741023626`*^9, 3.9189714996869*^9}, {
   3.9189721210106916`*^9, 3.918972136808628*^9}, {3.918972168553564*^9, 
   3.9189722921657715`*^9}, 3.918972450212428*^9, {3.9189725065065937`*^9, 
   3.9189725697658787`*^9}, {3.9189726251163316`*^9, 
   3.9189726802682924`*^9}, {3.9189928182981997`*^9, 3.918993107786209*^9}, {
   3.918993266285347*^9, 3.918993292777514*^9}, {3.9189933238599977`*^9, 
   3.918993325798884*^9}, {3.918993596755426*^9, 3.9189936369607954`*^9}, {
   3.918993667831038*^9, 3.9189936776038103`*^9}, 3.9189938742245626`*^9, {
   3.91899522588418*^9, 3.9189953702163153`*^9}, {3.9189954479561405`*^9, 
   3.918995487292021*^9}, 3.9189955476180573`*^9, {3.9189955858713217`*^9, 
   3.9189955978404584`*^9}, {3.918995718191811*^9, 3.918995723691153*^9}, {
   3.9189957575294523`*^9, 3.9189957634169207`*^9}, {3.919045520262909*^9, 
   3.919045520913164*^9}, {3.9190456130722675`*^9, 3.9190456319214225`*^9}, {
   3.9190456698259068`*^9, 3.9190457100078354`*^9}, {3.9190457556601496`*^9, 
   3.9190457948876677`*^9}, {3.9190458449792013`*^9, 
   3.9190458899869757`*^9}, {3.9190461006254635`*^9, 
   3.9190461342827997`*^9}, {3.9190468881609116`*^9, 3.9190468917915297`*^9}, 
   3.9190469620780315`*^9, {3.919165183222145*^9, 3.919165214007798*^9}, {
   3.9191653359703355`*^9, 3.919165362776883*^9}, {3.9191654003593626`*^9, 
   3.919165403740011*^9}, {3.919165464531374*^9, 3.9191655406536765`*^9}, {
   3.9191655853533688`*^9, 3.919165591539585*^9}, {3.9191656301450233`*^9, 
   3.9191656362296734`*^9}, 3.919165685353161*^9, {3.919165775456656*^9, 
   3.919165796968758*^9}, {3.919165864056778*^9, 3.919165922833069*^9}, 
   3.9191659989089108`*^9, {3.9191660722623105`*^9, 3.9191660912638693`*^9}, {
   3.9191661620732465`*^9, 3.9191661936073785`*^9}, {3.919166274881313*^9, 
   3.919166288878684*^9}, {3.919166341127054*^9, 3.919166360528756*^9}}],

Cell[BoxData["0.1`"], "Output",
 CellChangeTimes->{
  3.9189932955210476`*^9, 3.9189933265856853`*^9, {3.9189936207978983`*^9, 
   3.9189936378399563`*^9}, {3.9189936689762*^9, 3.9189936784841757`*^9}, 
   3.9189938752004704`*^9, {3.918995236896613*^9, 3.9189953717697845`*^9}, {
   3.918995448402794*^9, 3.9189954880442696`*^9}, 3.9189955484914293`*^9, {
   3.918995586834073*^9, 3.9189955986817226`*^9}, {3.918995719267539*^9, 
   3.918995724358102*^9}, 3.9189957641570625`*^9, 3.919045719467263*^9, 
   3.9190457570114045`*^9, 3.9190457982558703`*^9, 3.919045848390644*^9, 
   3.919045891177925*^9, 3.919046135499894*^9, 3.9190468927573175`*^9, 
   3.919046927854157*^9, 3.9190469624583406`*^9, 3.919165406285101*^9, 
   3.9191654718272643`*^9, {3.9191655158768663`*^9, 3.91916554137982*^9}, 
   3.919165592382147*^9, {3.9191656307412305`*^9, 3.9191656369591627`*^9}, 
   3.9191656863230677`*^9, {3.9191657876247454`*^9, 3.919165797707838*^9}, 
   3.9191658677048283`*^9, {3.919165903013497*^9, 3.9191659236632724`*^9}, 
   3.919165999978963*^9, {3.919166073035132*^9, 3.9191660928951626`*^9}, {
   3.919166168192665*^9, 3.9191661944568014`*^9}, 3.919166289733592*^9, 
   3.919166361921003*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0.5, 0], AbsoluteThickness[2], LineBox[CompressedData["
1:eJw1lXs41AkXx4eZ1OxIEoqZn4aw9NJumVeq4RxMEk9vUpOo7FLKnXTBSiGM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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwlzwlQ1HUUB/C/nHIZtyYSl0Prprgqiebx/bOAYwi6EdriiMgloFwa44Lc
QiEoCiQqgYGKuIqIR6iDK4goEpCpGNl6sOc/xFADEgT//+1XvZk3bz7z3rx5
zyUiKShaj6KoQJL/1v9DgQuJPqFh2RQ9YRR9Moe488GyIkPiEYuuVVOmKODE
Bt6pz6JoxuFQsZ6eAl4Pr0SPZ1J0jxfPwdBAAe/STevKMij6aJJoselUBSRh
prc70yha0F8Tb2upwGNhqRudQtFhLd6/85wVeOiR4S2Oo+i+FZ6LjHwU+LE7
qHt7EEXP+jrU7lCkAu3L+R7KFRQ9Gr4sMytPgbkia2k+n6LVVl3RjnWknx8w
HGJP0cclB/viOxR42yRrWG1A0ZIfDDuTXyjQ+nzWb5MqHZ5nCfDATAmjvjeF
x1p1sLUrW6n6RImLPbnZr6t1iIivbTm9VomBwf0to1k6ZKcNdTgmKVHQlP86
JlyHefTL4DcHlMiWZgUU++kwcrciUnJRiT3nmzMLeDrsNcyeOP9AiQXzn0oL
pungaWBnXTmqhL7sbenuEQ47ZWGNansVPGIGRIZyDtl85aOni1Ww+Wmb15J2
DrUhNulFISr0rrAuT6vncGRlxpmBNBXE/TVpiw5zOKEpF09WqXBuZpGrbQ4H
+EYVb2tVIdwxWSHczqE+JM6/qF8Fw+5x3jExBw+B097NemqY7TY+5enHIUdm
tlbtqkZDzNHy+4s4ROk1VNwWqtFbUSWId+MQZqKL3hhN5kXVUrE1hzkdBc01
36iRmuf/pbk+BzPftoOVUjWKePtiXUdYZKc3Dg53qaFnMFzC07Boi33088Sg
GterVktb+lg4TD+74KqFBuKUU7F3O1n4pl9xnO2hwVP7ShNfGQvuqOTgUKAG
N8ziUlIvsLgveZG7PVkDPcbvzrxaFjvMy95XlGgwLfnJGL+CBT/i5VjGZQ1S
f7VoaypmcTEhPd3ykQbplvXrduSx6Fp4M58a1eBSS6m2PY3F5LWmaafstWjY
8up4YxKLiVGl88RiLW4/lr86vZWF1XDLZf2NWpyYTLjqE8qiWSrqicvQos3S
wi8hmMVCuw8Tcqq0UH0lvL4ngPwnLDuwplUL+/wNS/18WTi5C5fc7deifnmj
mXo5iw/a62KqdVoYW5tuGfqUhb2LbPpcVwa9h/fPbPBg8afnVFGckIGV3Hyu
B4/FpYZw33fEojebWqyIU92vLyn0YXByV/36vz9mYTAj0eWML4MtX9DfyYgd
JnuHB1YxkF0T+K8h9m+rLo9dwyC0KrYuzp3FmUCvJzHBDG7xnazPzmaR2FHy
yxjxPcdi4QFiTwy2F6wn+5qfSXYS3xQcO3d6A4PEXLe/PiN+bKOf9YeYAf/z
OR/1uLGYKr/nHBPK4F3A5vDXrizuBfHsxojvC0r6e4kPdeeaFGxmYGp3JOIa
sfMNz+G6MAYVac6SXGKvmu/bmXAG88dN5DbE72eMXt0VwWC6W0/WuAuLW6WB
54wiGczZu4n3jHhtHlXuHsUgv0ZTWEds+z6k8Aqxca3cex+xPOVy5qpoct+e
Si6JuGbIfGcfcWyk+81g4q3/BYOo5N3fLiX+B+2nXFY=
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwdzHs0VAkcB/AR0cpk8kjm0HokGlKp6LR2v8rqqfWotdELlWdJKoYJW5Fq
KeFMhagOu4xSdmXbqGY3apJQU1Gd8Shz53U9OrKJe2f2tt9zfud7Pn/8vvaR
+4P3TGGxWBuZ+9JR/4fA+O7Pbw44snzC9z35SsE4NVAabM049NCi69HRBGaa
F3aLHVg+/scmRmNiCLTvamRzGHuUnTkaH0eg1iNpzg07lo/2ZUNpYgKBX8rO
dQ3bsnyEfkbStGQC/MCki4LZLJ+WuVU4e4LAclnN+0Y2y8e7ovji3moCFYG1
d9cM6XDs9QPBxGMCzQ+sXz9u0SFMcuX9gIrAKSHnQHm5Duv4i9qOmygQuLP+
Qk+KDkY9Y95SNwVCFH6uKzfrIDPY694VoMCCNzxrz4U6fC8XVnolKWB2+oVF
mIkOaYLxirUFCswaUjbZDWoheW7sNOOWAtuWcvjlbVrIezctyHqpwJx47vHM
G1oU/hrUGDKmwPBoZ9r0Ii1C3VmtMisl2q5KixJTtBiKl4dbLlfCxKw2u3O7
FsVxAr7eViXig7daOPtq0e3w0HJ9uhI/luYVm/KY/fw13/heYv7lsgyhuRbG
4tT+kftK+OezNy+kaNAV70wD+pT4295R6KWgMW0DdS9CX4WxPklT7DMalaLW
0U4nFaxuPpovb6IxU9xxc8RPhVsuWocsEY0iYfZQc4wKdKy/7a7zNAiHpPp1
p1ToGbxmixM0WmPMWa7VKizm3+ZaJdNo2b+nTfxEhTwJkbpqD42zbkN2RqQK
thOjGe4hNA6InP/VM1XDxNJsSeZqGvJ+y6DQxWq011HZTV40nDtWLI0IUoN1
+bJhFo/G0XTOBdtDaiSajCwX29AQ9dtknS5SQztt8kMch8ZunWxsU70a26Lf
drQa0PDsCVA+e6XGUQUVfX2cQlfSeCTrkxpif2OedJBCviRox3trDT77uric
fEfB6kV/f/IKDUZfTT0V201h0cV5mqgwDTKMupp72ylEfG1zeHq6BjVvJq6M
NFMI37o2J/ySBrNSIj2MmyikbHHixok16BB8Wyj5nYKd6Z8ene80mGxS1ZqJ
KFwQZEqJKSScg11/8LtKwbl6/GOdE4lzBDlvXjGF7NyqsgWrSVjfMXDrLaBw
eD67fWoUCdeQOEf9XApHchwyCk6SSAxqKZRlUQguSWjoqCKRwSYLkjMozLaQ
iHZWk7h35mNeGOOeXPvyYcb/cFV53zGOy3iRY1pDok9WUGrI+FjEitCA6yTW
DXR+FKZTqHM2pNrrSHA5nvm3j1Dg1F9a2X6HRLW4cq8ujcIrt0/LdjSSuHwt
W3+AcWllIG+Isa2vZ7mEsct5ffMZd0nUsA3l5xgjLXZg430S0QfXiuYyTvBZ
lvP0AYmEzhLuhlQKS/86I9jeTCLKy167kPHEYuX+Qcbmz2MJC8YnHEu2sB+S
MFi/sqWHT6HMUI+3UULiVt+HxiTGuzPD5sgYN/+c2vITY974H2b7HpNY/dtd
qTfjBlXUZG4riUdL+FpDxkcixcM2T0h4jZBcMoXCqrfWA9cYT/ZyvZ8xnrb5
YLd3G4kqd73IBsZP276ExIRReW4J4/8ACfGEaQ==
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV0ntUTHkAB/Ca7DE95DF2rVZnN1shbeVxylT6xkmhInZoNTiVHihUkke1
m90IhUKjl5A2NK1SIhV6WNVhlGLLo+eUaF73OiTde2f253vO93zP5/+vRfCe
9aE8PT09X9KvK3vyNUoMXFLob8zQ4VHHgihfmRJDtQ4ZV9N1qHslETwlrjTr
cvlyWofyd4EBrU+VSNnpKs87pUPWhE/Dz9qUMJorPziUqkOIq7lB53MlDO++
b4g/qgMr3SXsf6NEQYBBUW28DrappkWflEq8fNHVeCpMhytG+nodk1VYYLzf
3MhZh/ewGQh0UOFQRfETq2k61NvxV3v7qSC/89IqTalFWY9k4UiMCo92uk8P
/leL3R6brwjPqmAUFVHjXaCFR0T7uaW3VRAN3Z0rS9RC6s0Z53epICiPEO8T
a9Hfv9W4dEyFqEFpVLmrFvbC6NTYH9RIL6qLLZmlhY9n9dkRFzUSlzSOjus4
jJtUWdwTq9FydYepZpBD3bkwB4/f1bDIrC6qa+awod27KT5fjTP9kubDpRz0
n/X3hNerYTC1PW5pJgcct00ok6sxU8LNOZLAwefzP5evG2gguHlrZVAYh2jr
Pi9/aw1iti/uX7+WQ4jxqrhKTw2q0qYVFztz2HMz2Kp5hwbPWzP+srfiYDJ1
QYBTmgZX/U80jE3hcMDacYZ/iQaKiVxUt5YFwypE81s16LKtGZugZOF7vMus
TKNBn5uCsXjNImvYtaJ5IgXujqG702MW3ylCswUzKciDtLEF1SziVxU3Os6j
cGXYvrhJyiKS72V3y5nCNxUpr3/NY2Ftef91rzcFx4dONi0nWTTl+MnkYgrS
I5LWhiQWH6NddMt2UWA1rOOivSz4hcv2HUikMDHp022TcBZDC2fbbTlJQRFb
VZIlZrFmtnhOXj6F+w96nK6vZZEfWRpScYPCywq3n8c8WByasXnAso7Cvayg
0U4hCzdzy8LdbRR4AaNVvfYsHv/x6FpYHwWlZMTikDUL+fJ6VRVNwdBdWlI2
iziwM06uT8OPX6NVCFjs6V3hvl1AY0XZjHiZEYvG6lM+uZY0ztO+l5bwWOio
D3lFi2kE/7ak89g4g6aU0l9MPGlUznuceOwDg7iDKbzVG2nkrpDN2qJgoG4S
mjmG0XgjTfg+d5DBhziPmIT9NMKS9QvTuxl0J+00zU2hobtwRrGsk4H70vN8
ObHXwz4/a+KCL428+cdouK3m1xgRb48x/1xN/O2kvgsd/zH4uK2t99VxGrz8
nAuhxCZejjfN0mgUvk1MPvGCgesknignncb+G9NHOjsYXGyxWzNAzLdVvKsl
5h0Vr7TJoNEzJUl5mbhZe8u1mtimpl8/klhEhVu9OkOT3+8K1SOO6JCNzsyk
Eb5OYWrTzuDp6XEqiDgz02PTZGIHnzmK68Se3JprH58xGH2Y1CuU0Niq2Ct6
QPzn7UXNm87TSHYaHhQRD8UENlwmHk8tFzkTr7Q/Wfue2CBqbsuPxKbX3pYd
zKIhuTilbqSNQXSIQFpP3Od1eHkb8fOf3P82zKbhIsxuqSR26o68uI54W4H/
hlzinOyvoSEsrxlKIv4flYWgbg==
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV0Hsw1WkYB3C3jNjaIk5JajFZpLCdTan9qmbPdLNK6VhsdRLtaRFJiSQy
3aW2JHJJDuUyaukiZ1pOWaPjViHHntVEEond32W7vb9zdt++M88885nnj2ee
56vtuwPCjQwMDPxofe65OZ/D4B+3lvd2z/UQzVo32kvt8GDAI7ZPjwtX9Ett
cxlcP8ek//GXHhnXwl7kUleOv0yO1upx+La7c95lBvErS6pVGj0inqhuFeQz
iMwbcYzq1MNr4puO4iIG4xprM02zHuqEJaZVZQx+kU4cF2r0OFr7TY2dksFN
ZmjV3ON6uGxcpQhroXMXn8G+bXpkrVmkCdIyKO5OXtjjQ/dfPbTu+lsGV0e+
WCSx1iMysN/kscDAJltrdI/VoefnPN2GySzC+9XTHrXrYNHruThtNovEsJAj
7yt1mKsYqD25gIV5yt2uyjM6tHWMJoz5sjBovmbstFuHkM1Tkr/ewOLRprjK
gQAdqhd/2ThVxmKDcmqSr7cOWckRawP3sAhQtS4+bKfDVrtem9g0FrNKL5kp
jHW4PVPh8Po8C8a1StY0IqBr/+pYixIWXH7Pb9FPBPw539zE7DaL1Q7OoUVK
AZESx54tTSwOmbOWYwoBQ7XS8YxnLGY3JeRknRXw9tTg96JhFuL/RPLoJAF1
yrUvfvhI9zd8V350p4AYSfvvWyZySDeNtK8OFFDtWdbXbMtheMIif8eVArT7
C30t3Dh4lwZtTPMS0GYbM0SWcPAwmtbe7SBgrX1Oq2QdB0vfoKeplgJuHux7
Jw/l0J7uI+o3FlDkkyh7HcWB9fixqownCJEyk61SOChvlHZKhwiEtiMGokwO
DUaNsvReApeSaK/4KxyiMjerXVoJlvXsvV5xk8OCS6JmrwYC24hA2dkGDsIm
27TRWwRHAs8Edzzh4MS8rHEtI+gsHMge6udgqEiWFxcQ3FiTaR3EcTh3etq9
qvMEceulPUXGPCJYeVzfCQKDmo/aHCseH+6MXsw7TDB9Hz/nrROPmcW/bv+4
j/qCebmNmMfBRHzaHE2gsDwQd1nC42Re8MzQcIIPY6qUdikPb1PfluFQgoVO
cx/37uQRNjV1kjSQ3lc3sA0HeFza5v8p3o+gorJOnHyCh+LdnMIICYEjifST
5/A4W9tmUg8C5/L9JTfKeWic9lg/9iawvJW/vL2OR4VFsEmuF0F8jNrHRslj
aGVG9yFqzbz34i3U918frQijLihZ7zpOHS9Sh7tTu2YbW02+z6OqOMFK5Umw
PFE+6FfP45m/MmDEgyDGV3ys7SGP5rIJIcsW0P8JslTrRh7+s+UPHai/vXcm
6SfqvbEJHmbUgufw7jHquLDs6Z3zCY45Xg6a1MQjKKN+jpy6wNTQ1a+Zh9Ub
wykX3QkMH7o7ZVFHGaoeJFHvSAm276NOeWWfKKN2/VBjGfWIR0dXzbt51HdG
IshpNY+thW7OjfMIZpSe/7eLunyXWl9GfXB7w992LTxijxtqM6lXaGcMVlKb
p4qLQqhLsiXPeWqjeo9Ty6nNNsVplrbyUFmrDjhT75py5Wk6tfjuq8hJ1G2t
n8Mjpjt/B+dG8D/ffolj
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwd0HswlXkYB/DDWZRKdlsRlaiJSblUlC6+KEZaueyii8rIyVGSwVRnyqXL
tjgu1eqUYlKslXtKybYt1kpuEe3RRW2s25IM531/et9zTvvb/c4888znj+/M
M49ZyFE/kaZAIPCi899ua/0vClyT9to7r1LD0ydh8Zw2BQLfn1t6ZaUajV12
UV7UQdX3rcat1Kh9JZvXTn3I+bY0e4Uad4eDdz9rV+D5ev9kzkKNrC+Yoc4O
BfQmlp/4xVwN0aZFQnm3An/WNmj7GqmhKj7i+P6NAhXTNzWbhWo8HD046D2u
QPKi4IX5PSoEnT8pl6kVCPFJNeLuqNAUd2hWqh6DsvGTFUlpKtS+uJPw2pTB
4WMxtj+GqXAj6ev1QlsGPm5/b7vopoJu9jPb710YnF6Xi9XmKjjNFkVU+TEQ
d/rpjAhU2CU3GPs1hMGjW9clRv1KCISmJUtiGdyfMmnVa1AiPXlLxZ5zDCa3
juxHoRIDEa5kayaDMZ2GjBnpSjRVZMUn/cSg4eNcu+poJS55z/bMr2Jw6krp
BufdSgzvkPsbP2FQ7Hj1TbOzEjrFp/KdehjkzNzl+8JSiTkhm9dtHGYgk9n1
7Z+nxA1JgO6lTwy0CwvNdVQ8FoylmNXNZOEuDC/RGOFh+puhxNOExauSqgab
bh4fxuPnnVnJ4g/JDfertTzyJBqTFzexKN8/mDOrnMdA6Bt9pRcLcUh97pNs
HnrFz2Oc9rHoNebKw1N5CHbkLbCJZLHGwzpIeYpHvG/rZ0kCi2Mu8+3/ieDR
X66/IieDxXbXpzHn9vHojizNNL7JwkjkEJrizSM9ZZmreyWLbwZ83KJdeNho
PFjjWU/7kzHJz9fyCOq5KSrsove1jDWVWvCI0i18/bafxVAYIxwy4eGVlZT5
+xSLA2E1Dm36PO4n1aVpahHYj7q2bNTiod1l0LLAgEDf+urUW45DX1y9h3Q5
wfluPnL+BIeCsym6LxwImhNXP44Y5LBmcOXcNneCeIs9tr69HLbftvjOdCdB
x20LeXcX9ZPNvdvEBGPvbzn5t3CQu5UUtEsIjv5snxlfz8HKjKnUkBIUtc4M
WFXDISxwl3DOdYKMZ40Layo52IwbZEaXEIiKRtumizi8ffdBXPGI4KWLdEQr
n0OAdW5idivBpsAHSyU5HHb3FvX09RI8nY62LJBxcBvqiNUYJ5g6Y2yefIFD
YZ4qchv16OuB4Ehq3eAV4RepNYND87+l7ug5u9fsI4FH9nHHxdRBzQ7uLhME
ezveXb+bwSG2NNvw9CRB1Se187t0DrdixDUCQhB04rH2hjQOWraX73lQ9yXu
fGVKLR6rK7tAnXNBWqlFbS0yyVsyTdCY8jCqM5VDTUC71PkTQaz/4mXh1J2O
a/cm8gS5hoEHs6Qc1rLBgU3UxmTJ2QRqWWWar76SIFXzeL6IOshqyC2XOvZw
g8KOenjhNetaFYG2bXtLcwr9/8tGyxlqggmj/tl3qMsuT5n7UN9ri/O7Qh2r
52X4F3XoEZfRA9TyZsmXlp8J2Dqxkyf1hh8KZkVRl1V9JbOlztnSpVVNXR3n
NDmfWvB/phHqPeqnSubwL33akDg=
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl0n1UzGkUB/CpU6km7XitJm+TU4dYoxq1ob4pSU6RMdbZbF4mWRtKXlrF
iJGlF+Q9KawOxYlMZbNbkkhKtAZlNkraaUNWZNbv9zwztY+z95x77vn8c++5
516JMl4eYy4QCMJZfqn/B4dDoqj8uh0mqHaXLAxgLjjcEiFhJlYx+TuZFzjF
OW5TmdA3uGGOmRmHnqY2w5TtJnQ5H91vbs5hY8j3r08kmdDoM8HZ0oKDNl9W
HLfZhOz4CG9baw6q210npbEmTG0/u264iEPR+Ns2/YtN6BmT47RbwoHPRU3G
JBMO/nbFtsGDQ57NxRK1pQn0ap7/zVkcHNLrBwo7jOiz1pfYL+IQJt2XurDS
CG1FyFrvaA6h6mPSFzlG+DWZr7q+mYOkI3LVkK1GJCD7TPceDqcVzyvlS4zI
tA0d++EYBy99eli/rxFe3vL2RQUcBif0Pt7ibMStysTOA+UcpsXYfC0WGOF4
dov71joOorseqoguCtrZqKl4xuFSXoc24T5FrRqqlm4OmTvyri8vpXBW26aF
Ew53ojMWK3IoprcVtyQIeSQ3peytUVMEHNsQG+fMo//Ns3UX1lNoi9L8aifz
eKV0LLu0hCJsbJXi00wep+U/H+eCKOQf5xWp5vOYYXckUiWlGOdSMufach4i
5Yq1PqMomotkrrXxPMbfsnvUZ0vhmP3VbOkuHmt9tr+gHMGsNsuChENs/pS3
9q+6Cbx2NYcpf+FxoVHTV6Yj0KQOeF4u4bHPRV6qrycY2RkU9UcND9/Y5R0V
FQSDzr2sC3/CI/XJXnfBZYJbN5ZsSdLzqH3xoNzlDIFS9ma1ysDDQxyYVn6Y
4KDwaXarFUFbYH1K/R6CfL9W+6EOBMWa3mqvZIKdjRV1/7oRrFfUT5wbT/C6
4lP1tG8ILNwiu7qiCXytQvvD5hJcq3b1vPYdwQiNYVsVq8Zgv0NOCwh0v97w
s44lGH1pnDg7mGC104pAAeurPxqUeG4mwY7nkXvlGQSNT+nJcC9mskGkOkXA
D5qm/OBOYJvUrjNje6g5qoYLwTLFhC5ZFcH+nhN/icQEOemZ3gEPCQwH269U
DmX7SULrzrcTaOfnFToLCYYMk+R2vidY15upCbYgSFv5uLRpgGDM/R7pExOP
/aI24cghFMaNkrzRn3lsFVsUyiTsjsH3bcQfeLQ2Tz23nTnF+nP5QC8P/yNR
uXeY3VbXxOqZLezKsxQuFJEaWdtV5izTj0mbx1PkazcYQ5gLXjbNK3OliBl6
eMRP73k0Xzj1zsudYmRqc9mzd+xu0ff+3sYckBJjqGLOHWvouM3cEJU8/Tyz
Mnt+86JJFBknPLUJzP+kmd3cNJkipO6uj5DZcv0PWaVTKMS6xj/9e3ismXg0
nTJLBUujXZkb9NWpQewP361S9gqZs5aJkx4zP6zROeje8hgV8WBl31SKRy2K
3E3MKXZk6QwPipcfj8+NZH51z+3b3cwWVmF8AHPhrJ3zhnlSrPgkXGPPLOwv
mr2UuRUj3AxveMT9rvPPZ34ffaC7lflRopXvW+bhJxOLa5hlXl+CotvhQfJF
5v8AD1mIWA==
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV0GlQU2cUBuAUbFQQmcCAIsVKAy7tBEUCsr+CKNVhkYiVhloEIzGKkdWt
FKKgUeuGCzpYrKCIUixRWWwhKMUdxdSiKOiAC1htgYDrvd+9136emTNnnl/v
Occ1abVimYVIJIqk/XHKvT4WgcyjJrP+DocztT35GdSB59v7xlB7+B+6d47a
0F+my/yLw6QQfr1cTtAb6v1KZuIwLvrqRW9vgssdv1mX3uIgWhkf5TuDQJWy
Xbz7GoebpXmaoACCjhkvhmc3clDZtf0SPosgfd2m+JIKDhMUtyJqYwmk+8/X
9eg4NP/3OIhXEdQfEsfo4jlMfWZKG8okCBiQd8/0pfmBY3tDthBkyC9Ktttz
EA9sOKIpJIhzKasqGyJIs/A5+G85waMql+LVJoKy9JY7zr8TtBc0dAQZCC4G
ZSvcrtP8BQPF6n0Eas1mO30HwU82oVuSsgjeDJxy/PMlgcfWh4XZSoKIv08u
/pUlKFKYH7qGEEwdI+rpt+Zg+XShqXYiAVOTbrD6jMPV4q1fj7IliK4JatDJ
OLTb7jqZ8paFVvLUqiyYQ15Mf9jMLhaZ144Vl0Rx4LrkH3JusBB3N6S+T+AQ
8qTg0eNqFjrFoH5SKodjXsrc/BIWW9xzugwbOYyI+UKVuJNF7MKe9f/s5TC+
71aSdgMLq2513PtSDuHSMEmWhkVES+japGoOidW52huLWGRJ/DqOX+IgnRb/
/E04C3X1SN2BNg6Zn9o7Wfmx6Kmbntzdw8EUvqArZwqLeY5r91i+5ZByu1wo
cGYRcNee6IbzUCoeVDrYsHhj3n6yciyPQbvrTzI+MChUuxQZJvPwb6+RBr9i
0Bw84uZofx4OJU0N+l4G7amjQ2fP4xGoErVLOxlUf+hnpyh5JObfCFSbGLgM
THq9fCUP7+VHzT6XGazyy/bU/cDDLNE7edYzmPtsctXgDh5h7jqXZgMDm5fm
1IBiHjr9VztXlDMoitiX5XWaR9GptDWHjzA4a7vrj82NPI6WDWvSHqCWHZ9l
aOURf9d/k89OBsGVdjbe3Tzsru0YVZHPYK8+3mn5IN13ymDpkWwGrcYLmoxP
BKw44f9Wk0Xvi81m79sJGLc4t/nFKgaz58TedpQKOBMc4OOpZmDcL35u4SXA
84S7tnMJg6ZZEswNE7C7y74xRMmgMnJGpzpWwP22MOu4WAa2Vqq7VdRzog1f
BlOnX9lz+x31otzyKDdqX7xs1i8U0Nbqfdy8gMGlacWV5d8ImHq/fvM26k57
y5zncQJq0+pdGxQMrDpaJ6gXC5CxQp1bDP1fIRlXRT29ZZHamtqkmOzwjjp5
pNR5aD69p2XjSP33AvaettlzgdrVKB86kSDAqdGlSknte7SouTdRwKv6DU0F
0QwOf3fV6JEkwNj/c906amHs67o11JrP3c8mUF8qiKwULxWgXKqqllHPzxMd
mKgScK9za9/1KAbnINutpX6ddFl8htqR+3ZbLXWCMdHtEPXDzHM/zlkmYMmD
2pRkanh2r91FbZZoD0ZSl/aNSr9HfcF60xU59bAKv5TxyQJKLIYYZ2p18scS
sGO60dOS+n+iSH6w
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVzn001XccB/CvlLZJ5fkhIbEuuk1Hsjvrfr6nxGm5V6Pl4UyTh6jIvVFr
tYaicnKUyjxO5CEpzdDlorLpGKKiy5SyHhRadl1d6/f73V+/3769z/mc93n9
8TnnvSwyMTBmDkJIQu5Dx+78EA483i9yd3JhYWzSqrmKuCtVknZMwEJEwp2P
x4ml0bf/eb6ChbBk99rYWA7eJ0sXXPyUBclR5m1cHPHcmMPLnFjwKMlO27Ob
g6kVgoXO9izwg4pi2V4O8l0zX4vNWcjbOP/BoQMcROfcrWjTYyEoA6VOnuCA
uW080DKsg//szeXu+RxsKDKZ0jXoINJybqVzNQczU+KE0BwdhCVutt6v5GB9
nI2lb4IORI7X+ou7OdghHBVo/XVQ4bmrx26Eg0VRnbu2uelguJKbF/CGA+Xd
ab7BUAdvZb9mBLMcbOurEmxXM1BY3LyxxYiH2E+0LaP9DAiWP9k0u5SHfbd8
T8uaGEgxeHxmVMiDLHWn8ngJA5FfeVg5Ag+GeeGSnHQGVk5WvlgXwIPZDey8
JYGBoxMydUMED69fgcDuGwbKfCzEw3Iemr2uzISIGbikG7qvSuMhOP9bC60L
AyLT6XK3czyopMarm8wYaMhwag0r5+FfUYFhnR4DypDfTMYaeYi+eLrg1RQN
J05a1S7p5MHqUcw7vxEa1pkWnXIb4oFBSaLCHhpSuP01ueM81B/6E8RKGqp9
4o2G3/GQJzu7pu4yDX1JJaFj+gh/RhkMGRTRkDVb35u5AOE1mYP97adouOU0
uKPIDOHULJXG+CcavNKXW4YtRVg0Hm4/lEiDmcnfU2pnhB1F5fPlkTTESKpf
aYQI5xS9r5Rvo0HX/AtfuhZh0wPSh2830TBvoPSLNjHCZuoLNX+IaUi2Ns67
5kv+swpHPdfQ4JJTayoNQPiQT0eUlwsNXyuC60ODET7iZiPcbk/2GK6Sm0Qg
PFPqVWZnTkPZQpNArziEu7zv1aoNaRiHqK0eMoSX/vzynp8+DUllTw88Pojw
9WEH7QaGgqS6Pa2aVITtfTKk7jMUKNWODo2ZCAc3shPdkxREhftVSc4iPKCv
2fL8GQVpB3+QBhUivORpjbLvEQUvO/6yMChHuGm64s3eBxTcaNug53wF4bO5
An9VLwX0C1ujJQ0IM45mysJOCg57O4putiIsnA6Pt2unQI49T/R1ILzy80Cj
gBYKLpZsTtcQL26dveBJrGJ3pJnfRligWOxlS7xWmX04nLhUc3nfpJICdvVE
4hSxQXaQfTrxyeVFIUadCDsHqSQtzRRcMNBzlXQhfFBjw7g0UXA/2nKFnDhX
62pjTDynQ+iUSzw3v0BMKSiITgmze0LM1p4+30nsSjWYJHQjfLW0OzmKWDG5
U5fVg7BhTPe8kusUTPgdoeqIRcWxezKIravOzaqIe71DBuOJf4xsV9veQbi/
RqjwJl4/Yj12lfjmwvNXHjZSkCxyf3afOFVa5/E7cWWe76iW+Pi4VXs18Udb
k4a/7EXY36H35ffEovrMwQji0XXmKd8R715cOpBOHFh3ydaPuHiv4l418Zji
6M1VxH29H4Kw9kxltAXx/7jmZoQ=
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwdzn1UzGkUB/Df88MmvTlESW+00uqgtqjUdm+2DWlUQwh5qUmrOiNq5aVU
S5QyHatCsvIySYxiKLuK9lAt0SSF2jipM2pVy5ri+c0k+9jvOffc8znfP+6d
Fr5VHMlzHCdi82U/evglHJ5/53Rt3M86yDYuHupnnnGjpDc2TQf+QSnWRo84
fJCsdlOl6qDuiXOciHm97Ffb3BQd1LTnT2z8Ys0ZC5tkHSh7N65RNXI4RA4p
PHbq4MTooZ7HTRwmX+10SZPqINLLatSzFg6DBUX/6rU6+L7jRKjsBYeJ7QG+
pi46yP3m6+arag4jHru9GjFm9+VTYy8PcPi2NtF+uF8LfsFgv+IDh3U2zxfk
3NdCRWkc/+MIhzjsKGm+qIUY18YRBz2C8RbLKlUZWkjvP275hwnBgc4Nnne2
aGGieNu6WjOCywyHp/SLtPC656eqHbYEOafB24NOWpjtmOGd60CwUyFL4cy0
0Fao15XhRPC86Gh+5ogADd5K+SwPgkPjVX8bqAVwksVmufsQ7DY9rDe/UYC/
jMRHNEsIFi5beyG+QoC+W+dvposJBrV17DErEkBqNobfv4ZghjpEOT5bALdz
R2LmRhAcWxJRNy9RgIQOx49+MQSfNeyMOiAR4OMP788aJBBc5bzEyzxYgJcv
ZsRdSCK48qJsr8pbAA+7qA1l+wm2eXWXS+cI0H68RSo5TPCUwrMh3EqAf24F
FqXnEdyunplmaSxAlJG7JvkUwfpZL+9VfKZgnxOw2a6Y4IORQ/Mq31EIvS3V
uV4h2FXkm7Com8Jjq+pyTQXBMfKb/qJWClcu7TyYeYdg+sywTzP+pPD5tU9q
Vj3BonVUE1ZFIU/sdmJBE8HUmOt1U8opnI5Z0BLynKCextTDUk7BWFnqtLiT
oOMNlVlNAYW7sxYpenoJriiwWzGYQ6Ev8N+lmnes16qyFh9g/8jrx10WCLok
iP3ckyh4llzqayI8emuelLnEU0hrGx54qM9j0uTyO8poCkaeu8fvmMBjtsRw
d9smZv8xIVkWPKa+2jW5L5TC8syq30R2PO45q4y7FEzh04dO6HHk0ef3XYG9
SyhMnTCxt9+Fx9r9pZsGF1JICdtWftqLR1vN1txKTwqrVr4ouO3L480pD6M9
51E4mlxRfD2A9Yc6ZNZzKUxqvdW8KoTHrjPms2scKBi0N9pGhfF4tmTRSQM7
Cl7uaqss5sIH88+9n05Bmq+zKGMW7meUtTE3iR0mfWQeHSBuvcCc35Cmf3A9
j+rmyBBf5unVru+LN/BYod9tv3caBfeigruvN/HYbP5Sf8iGQvRIec24cB65
1YrCDuaT6+qr5zAHmNS73GMeMR+s3MGc2vVUepT53hHR5a8ieKwZu9z8W+bA
fVyevYTHfXMmucdZU0h9NfkXf+Y3tc4mq5mvwewcKXNHa/YbYDYdDs2sYDaT
6BQmzO0JymS/SB6dw+VRZVYUDJ/c3x3NHKQu2niM+TvnzkQZc8NAS1gKc9GA
4fanzFXHuiWBzM1L7bZqmT9UV0ndmEeVesRab+bRPL4hyYbZdWzQloXMzwTj
HD3mzf+HR/28A/K3lhT+A3eJPWs=
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwd0Hk01WkYB/Dr915ZOqWkZKmkLJMhXC2a3Ocp3BqpQUOYdLQSUiJLzrHV
YEi0qEukThfNZCljMKWjRc24ytgqTRRTuaOUSvVb6Dbv9D3nOc/5/PU9zzN3
y26f7YxIJFpL5/+940sYvPahWBLfJ8D885CbTq1bZxPU1yvA06GZDWXUNW+1
SlZSB+9q1VFRZ8mLwic9EiAgxr4yJITBb0dbrRQ9AnimCaOhoQz+4TFifb9L
AMfTh1PDwxjsX9gq8VQKoL5XV7QnkkGjyL6C5HoBevdJRq3iGDxwRFo6liuA
7c2r4WuSGTRP2zpyNIL2S3/TlGUw2Jcc/tFxjQBPXvQ0vcpl0OL37iO7rQX4
zk23SEPOYOVF7yIPHQHEbSHyG2cYvPfqmer5vzzMTnesC/yZwai/1huEKXmo
eKn7cdMlem9yjLFpNQ/JqXp+Uy4zOBwQHFR9lIfbzXN7bG8wOKO0w3tJAg97
F59NNFcy+F7vTuKizTxs6/GE5k4G3yRFtTqs5qHFaoJF598M3ri1377FgYeY
8pcLcp4yKL279kC8MQ8HfaU+c4YZHPMq9c8Q86B16fSpWe8ZrB2z3dH/hoP2
5TaaLeMMfihIku3s5WBS7K28fjHB/EzwmabkIO9J9vLSSQTL9yjNmXoO4uKa
dFbMINhkW/hsSikHnY0ifvVsgmOy2Dj1cQ6iHSO11ZYEfWqMLNwOcpDhO+Q8
ZyHBvZYnR2X7OBCVdxwyXELQebFslmUIB03Wg58bgaBc0P0+0p+Ddxu089tW
EfQ+eeqJdA0HYfV+HjleBFcUSwsyXDhY5a4/d14AQVWJhrTEngN5yiMji80E
TTVv5utZcGA33O7YvZPg3Z46kwlGHCzV7N41EkXQ3MTV0mUyB+WebsqBBIJq
x0q5vpiDjc39stQ0gq8ThpL28ywcHMp6fiiLYGh8kHp8hIV30s0K92ME7TKz
BkwHWehe4f5j2CmCWR0Ne137WDCOPpGx4xxBiUncwuFuFsq6p/2iV0HQ4MVn
2fI71E9Pv55fS1DhrnwQ3czCsLnfelUj/aedy4UfGlk4kbf/YcotgrJFG6uv
1rJQe6EiNf0uwW0+/lovK1mYyep6ON8n6CJS9LaXsfBmJNbJ/zHBQofzV6LP
sPC1oReuGyRY4rzOLKaQhapI34i3rwlez65a6nScBUV06GURS3CdZfD7wsMs
3O9Iqp9PvdLrTnQatZZ9fu1qatvAdHYnddjw9ao86mtaAxOdqe23m5wz4wjm
lpmEPshh4YpfWzbyBJ1WfXplQN3p7BSUMkYwRCFZcCybBbHcI1BBreOnckik
XvQxeMOf1IZsu8tWanlNjveUcdqn77pFQr3JRuV+hjpWndPXlcXCkGmh3bVP
BLWqjIqnUxsnXrR5Ru3V26X69BMLng9vW2urCT6WNCwepK7KHzX3or4dNd5f
Rx0zea1hP3Vz7aYQf+qyiK0G4s8EAxt8u5D6gTJhqjV1yuQo16+ol2WUTdxD
ndcy1V7IZCHieaP2cWq/y/kV/1AXu3ZpNlBvm/6NbSt129khppd6zEyj5ldq
0ZeIMX6ealkR9X+b+kVo
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl0Q1QzHkYB/Cs309FRVTSusRkLyGqEW3yPIu6vZwl3a1SeSldrmLTFVeu
ycmmyEleeiOTGPbCdeylS9bVRSvL5eWoXNsLusvLbF3s/7+L7n7mnplnnvnM
M8/Md+aZGqNYFSewsLBYzvrD/L8INhgdZdsCzKCRtHu4Mf85Z2O6XmyGzOyL
ocg83y63PpjZPCqucicz/5tk70R/MwzZtgSPGEHwfarDkjo/M/QJD+8XCAh+
+nRIRHzMoJvvIaSE4Ep5xXGVhxmKFSv9RlsRTBnZ+o3YyQzbxt7ObxhHUOPg
aswwmKA5ajV95kzw39mO0kadCTLbZCe63AjGFXmKrc6ZIH13SsSeGQQDg/LP
DOaZoL+zcl6ZN8GD7Rty4hNNUB4/widKTFDYo39cucwEtVN0K14vJhiz5I9D
12abIFh56gAfQrBJ/f1q03gTTBKqDKowgs7PqvoncTysX3tla3MkQWmscoeb
ngebVrFjfSxBgd+R4SM3eBje2tcWncT2oXNVdhd4iG04oUlMJXhuR0+qYzEP
dhJlkyiToMLLvnrBdzy4Gh69qFUSrPFYVqpO5KEiZMG8y/sJ2od/tUYRzkPC
w6bymKMEWwrEfPRSHs6MXeeZUc7ytUpmxvrw4Jk+/eGiMwQn/9J5vXoKD/b2
EZUdP7K8/tI6ZzsekuSlhb2XCRqsY3zlwxzY6ixPFv1K0EbzytrwioOphl33
a7UEE1YkRy3s4qAUE0U/tRI83XmuccNdDiIas0rk7QSfbU9wH2rkIH+wwmtT
D/vPtbyFtIYDEjrwRPScoMvdgemFZzno0VfV1f9DcJXlnTf9ZRz4uKRd0pgJ
PnQY03yogAOtMkG3eSTFhpFO7jd2c3CvfLNl3hiKgamhOp8MDiR9nbE7JlAs
CXulFSdzYIzO6HaZTDG77nXEozgOXLPds0TuFKU/yCzzolieNnNg1yyKoitl
go5VHGx5rHcl8yi23hpdOCuEA7XN3KkWgexe//z6sIQD3HJ+iSqIYtonQbYZ
/syZC3I1yym+7HBf0ebNQU694eVOOcW+m07r/57BwVxPh69d1lH8uVGyOHka
B7KgYKFbPEXFYLrympCDiwWnntxTUNxTvEuldeBgb964O4PbKUZqM2fus+Pg
RnV/+19ZFL88PStGZcWB1MpA9+VSDM8JyM8VcLDIVvB5aQHF5QneH415b4Tk
ROdQDfO4q0lOQ++MUHHTS9bL/C6ve8JjZpITKfU8SNG3bIuwirllWL2wjrm7
e2z0MuYvBuKndxRSnHa4QZX/1ghJ928bJx2heDvgaux4sxHKvZ8OBTL7F5f2
mk1G+P2AeWADs/RNcdwTZp/PPn6hYr7U8ma7mplv2tnlf5Sirkx4R86cXeOr
jSiiqLfeBsd4I6gdQq5nMosu2FgomftS1jdWMKc01zZtZpbO2V/fz1yaIVsD
zHZn+6rTiyl2PYis6eWMgKPenz/OPHH83qJbzFs3TqhqYD41WvutmvmBG562
LmH5wpLDcphHZclPzmZO82tfqmCe35l0IpTZ/a1MHM68KSD7WBqz14tWXwlz
acmHoliwcq23J/N/3pc6SQ==
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVzns0lHkYB3Aj7+/N5aiWqNZldCG2UrGtGnme0mWzmkQXm9NstEykG7UM
q8YZtTQpJlsiSp0tlDqFGmrLslsYVFsSbVuJE0o54b0odn99z3nOcz7/fJ/H
KWxHYLixkZHRSjqfd86Jz2Fws2eA8ZiTIgQ/jamuoC417/VJyBXB1t7/TSs1
u6hD15kjQtbpEe9JOQwq7R6qb54QIf385hc51Bpr/91bj4ugLp/pcjKXwbAX
8dcadSJEPPijLD+P9uX7HT6bJsJc0557ZwsYHJg+rvponAhjiyKcQ4oZrPHP
KDq5WoRQri9/71UGKzMluuPu9H5Ml5eqksFjYmLdgTEiWDlY9EtrGPxhd/sB
6TsBNHEL73kaGJxaaxbieV8AL0muYfAhg6mM9qP1FQECK8K70/9hkFnMrDIc
FeCFg4+rroPBb80yDx9RCVBatjjNt5fBJLcuP1QIMMSvMQ8dZPB+8UzT2qUC
nIt8dGntMIMZ+lvy67MEyDZXx/AMQcvHZ1ou2QgwvGF+MGNJ0M3sOz8XiQCF
bQ6KKhuC3ZK4v6p6eNCn7tof6EhwS2u7cKGZB1nHg6YAF4L1uyTh9dU8mOxU
eH1yJ/jWprBJepmHRUVCjZUXQdur+400eTz8+cXtHU+QYFdH5qo5Wh4uFH/w
3r2CoG686ZIBFQ+kz2PGz6sJjgU9aqJ4OB9eIJuzgaD2Uei7nRt4uJFqty0w
jKDha+UyM38ePNtMqvyiCL6q166J8+GhP2SiR18MwcOdd0KCZvPgrJXVShIJ
2u85ElQ4hYf8nrSkKg3Bg7KExgQbHhLjl65Zd4hg6k2ltbUZDw2lliuDswg2
7d2TKoxwEOZoEsHmEbTIcP2g7Ocg2ostmPwbwd6xsSvNuzl4ui9u2LqEoN2V
8tZlzznI4K0Sysrp/0dGpk1s5kBvd2tC1e8Ef20LGBwycOAck9USf4egPFpP
9lZzMHpPvD6viaCJw39xwxUcyM/VVZ54TDBlfIooXuGgjV3+bPFzgpVGXwYU
FFHb/O0U/JpgfP58c5czHEjXpR2Y1EfQeXqL66YcDuprSizKBIKKaQMllkc5
6Pr3eVmFEYv34KVWfYgDfzefpGhTFgNa5eUl+zmYOqVYqR3H4r4Vb5Iy9nGw
yU8TmzyRxUdMl7RRxUF7QeqpqZNZDJNuGjbEcvDkXG6vhxuLdeuP90dt58CM
udqznvr2kG1kELVsc+3rROqNvjfaZdT5joMva6jvP4tot6D+MVv+OOgrFn/p
Wmh1eRsH79Mkt2NnsHhm+YoFA9EckG3KjNJZLBZEGLKTt3LgZUhKb6FWdCzI
jKKOdM06+JG6kL2WHkTd0FmV4uvOolzZoJtGrVNMUj2kvnMxvLEuigP7gMbQ
/tksSmsvjLKill96pbCdw6Jrntr7UyQHaouhEBl1y921qk7q9lrndRpqjXxk
5Dp14SK1n9VcFlMSPBdspG47dWz5N9Sr1gq6ZdTmIxeXhFBf7r723p16e2Wr
z1lqVaxTuTH16Ql9srvU349qsH+7hYMHP5H5b6j1ydsPNlMbN9vNG+PBoqP3
6I+3qD09PofFeersHYXU/wMpVTRz
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV0Asw1WkUAPDban1feYxuSbZblrKmh1Dklc6huDvltTetVFpJ0prI9Zjo
ZW/S3PIYhB7obiGzVMp2U2xdqd282tzdi95S22hjpdz//aO6+zkzZ878Zs6c
c+ZYR8ZLtn8hEAgCWE5U52UTQXDB0bHf/PU8vE8y3ryOuf5evKjhMw+Xlf9k
JDLHHW7KW8C8xONEVx3zZKsBleEnHuy8P6U6OxNUp4463h7j4augP1QuLmze
s79CvDgeBLGbAt1cCRaIS/NXD/LQfvbQTi9Pgo4pk62LHvPwi49ANbKKoMN0
p+pYJQ/juUfdZvkTXCMJfj+nkO03kqmFIQQvt93RX0/m4cK1iqwbmwkmHGto
Jut5mDOtO+Z+FMFM7/u9ja48qE85b8/dRfCgr5mPryUPAxK9zC6F4Oj3hdKT
H3WQVt99e9EBgte+zJ71tk8HAYFPbJ5mEmyr20Ad7ungeN5/5WM5BK39pNUe
tTpAg7hvh4oIytJGVlWe1MHSCkvjvDMEAy1EoVYyHRSPqIfLzhNsTU/WGO3S
gU9SvS6sluDMw9amc0N1ILExshqoJ6iVX+tL89GBZn9szL8q1n/WaYbeQQdl
U/jOwhaCO4x9U2+JdPDYJz/8QifBN/nrz6Qb6WBLzYYp0kcETyxYUpM3yoHv
6qwuk5cEM9T+xy73c6CQd9w1f0tQUUGaCx5y4K330LR+IOjl7Tytp4WD9TZK
w4Fx9l9xEb3VwMH9xLKwVwYUQ+M/YPJFDrK1V9rlxhTTporSSxUcqOZrtp6e
QfG220zV8uMcuGXMs9g4h+JYZ4538BEOzIXPB4dsKXr17YtYvJeD6ICq18P2
FJ0j0ur8d3Pwsb5Ur1hO8W3uqHQsigNDtcKjcSXFRULXKs1GDpItpxVf9KMo
Mpr9yPc7DhbmXZgeGESxfMs6gyAxBxJl6JWwUIqtnSJ+60p2j9GSBGEERTNa
aT/LhYOzpkKJawzF7OFG6d3FHPTDtpBluyk+sORtB+dzkPRzb8qTPRRX1oak
NomYa2MbhtMpVnjKZPHmHNwYsvn6VzlFq1KrLLUJB1Hh4sqAfIrFd5JlVYYc
yPakBq47RbHF7/xVLwEHr5u7Zxqeo5hcUVOZO6qFm42rJtlWU3znNrCt4IMW
xl6KTGbXUYySeVoMDWphn6eN+80Gij3n9MGm/VqQosuRjma272iOb2ufFsrL
1mYMMzemvHevY9Z83PqT+R2KnTcjl5Ywu13P2RvOvEa+3SGO+bNTf/wgc69t
b5iQWT7v9AaT3ykeejh196YXWlAYTloYcI/i1SxxybvnWlBHWdglMPcV9Zg9
YjZotp9fyBy15wd5M3P0wY1znzLbja7NLGJexNcJd7VQVBzIurSCWfkmejyr
lWLRDrNb8mda6Bfv52uZ2y5VSxOZLSsLtH8zxzQ6LQxn3hepGhK1UdwcOV7u
yOzz2PJVDXN2eUJL91MtJLk7vnjAnKEOKmlirij2ezbCbCqenljNTEMSe1a0
U3QXixcfZHa/ItdEMHclKU13Mv9oplBnMAvsqVbCXBKn/LNqwk2ez1cwd7RP
BEVvWXDHN8z/AyJMSTA=
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVz3001XccB3CZuN9f6MEqJ7tNKcdIcrJcsj4fChFjF4lIHm7qkm4dw2ms
8rCS0VGRrEZCDZW6nZuepEnN6OZpW7qSFG6jlvT93Tti+/Y+53Pe53U+f70X
Re0SS3R1dHR82X3sh60fI8D4wy8jnSVa+NG4ko4wV3l1jlXHaMHbf99Co4cC
bOwXnhIy3++0l/ky9xbV2U2L1kLDk0ITJXP02zNRzVu1IFdvDX2kFKCu1uF9
eJgWTurRofY2Aa49MHXhRIAWJC7CT/7qEqC0THvDx00La3tOhuQ9FeDMxBOx
Y0ItHP9iScflAQHyiSlzIyc14F1hFl/zWoCii7VNF3o14PENWAbyArQdScmS
12tAUSXT3T4lQFjpkmxUpoE4B+WUlQFBxcBOL9dMDWSNFH12dyZBtSj90art
GjAR7w5rmk+w5HKDxtRPA4ND395KMic43yY9eMxBA7Y2h9YctyLIf9fclCXU
QPcpg/5DKwgeDpyIlxlooGWNvMLaieBv5ftf7HzLw4q8+ByRK/s3Xx5vU/Gg
MhLnj3kRdCyRFW25z8PwzfK6LDHBFv36XLsrPCTMn66bGUpwzudRd81KeXA8
mx9nF03QqyAmaX0uD4k9NhqPOIK/zDM9J03lQeP+rmxGIsHHO74/3Sfloffp
Utm5VIKBS7/aExHKg5NFbMSlTIKzDFKuF27g4UlRV0JMLkHzhutHVrrw8Oam
X2lWAcFWUZhqx3IeYo1EY2mnCUZq67uli3iwPOKzzaKSYNPj9sk+Ex5C6hMm
HC4SvDbdT7/BgId24e3aMQXByWLh54snKFysTjmYfYdgu4d7nts/FP4bdN2f
84Cg5/5ls0tfUigQO550biPIZfpl5XZTKIlz7gp6TNA0XaU884iCsbxqxfo+
gsZfXlF63qfQaO15YUhNcHN0Ocm+RWHYb3TD2FuC47HpIqWcQkjFA67mX4L6
Q3pX6qoorD5fPdw2jcN4d1Xr8TIKB7o/vG4lHA7eeVWuLqZgtHrvrKQ5HFao
8d3fR5m9pwflLOBwYWLwsl9zKARk37rua8Fh6mi/oX8mhUm+D4ZsOAzWSw74
Oo2C2RwT9chKDne5tJQZJFPYF767tsSFw369OOt9MgrBG58W16/jEBN+LyiX
UjiWpqi86sPhz0ZrBeYSCnP/uNkRHMShtVlq0NYICjOeKM1jwznsyj467BRK
wUU0IMxhbhw5G2nBnFA4seASc8aLKpUhc5vYaq6GWXKvUPUshEJhywFycAuH
o887uB+YF992eFcZweHdGFfLzk0UnEqLGwcjObSsWeIjC6Ygnapt4KI4XDOc
D6HMp8Ie3F7OfKOud9U65inT99eSmN08PrU3Zb6X71ujH83hh6U9AQ0bKfhn
6BRYxrA9dp7i2czpz+cd9WZ+Nro5YyKIghxsjyQwq3e61w0wz/sQkq1g9uo/
ZnuDuSdRnuYh4fDN8AyPaGbjzua9UmaranmBLzPY9yXnMTs3Wb9yZC57bbjn
T+bzYZk/GTJ3brDYNc58NUMyzgdS0Ktyil+4jcP3m0zCnzOvEvjvcGM+bJ/b
2MIcu+1jOFREddgqmP8Ht6NClQ==
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwd0n1UzXccB/BbK7u+X0okD5lKD0pUkiZan49DpMluqHAwzVGhmygSq93S
g0MRatqy66EnjahNMrsmPSzdKOX2ZIucHu65KbJ+DzKxr73P+ZzPef31+ZzP
+Vh9s2ftDn2JROLH6mMPDfkYgq1GHj7dD0WwuwwnU5grn8RabmDu0U29VcDc
1nfa6OEDEbbJ68dqmaOkOLe8XoRN0S7FoaEE75+wk6fVieCX+HY4LIxgbcBs
/SU1IixQnkjYvYugrcwh+LJKhA8tN89FRhCMHjnoXnVFhM79C4ZnxxAM3qnW
wFERnKru7P7yO4IpM24vkoex+V5lhitSCW6Iu5gT4StCV3/73cGTBK+Y7jzt
4iiCbDk5p5dN8O1yH+sFxiIYNoRmV14gKHl6N8jsHwEsUlxvbioiqGlZpCtp
FaD4BRG2lhKUv0zqs/tDAEWCceCE2wRr5vc75uQJUFtt1T6vkuCdS8Px5ekC
RLlfPDxLTbBc2Wlpc1CAHe2robqZ4AqF45iiYAHUs8fYNj8hWF8pj0z2E2B/
4Ys56d0EM9vKV51aJEBygNdaiwGCnvvDaYeNANJSZc5nHME5SRn5zpMEaPJ0
NKx7R7DoiJN9vUQAowM1GV0GFHuvtyplQzycenbcM388xdx1fY/mPePhYMzd
sUvNKK6sW68e38jDY5VkxGcmRWPj9snnKniIdo2QvrejeD43JO5MKQ9HA3Qe
Fs4UR4rWDU3P40GvsCltyucU15hx4WFneaiw7/ugAopVpUfR6RgPw0HSrIaV
FP1rv766Pp6H3eWBvukyiiVfdH+qt48HH++JVtYbKZZNjd4YGsLDD4q/ptkG
UxzwVER/spkH54FHrpqdFL31A01d/XnwMNTIX+2lKDvkWalYycPl1cvVz2Mp
xs5VP9jixcOW6q4VCYkUhbaT29vdeEjWHetNO0axusCdk81l+3gF53mfoThz
SWhvpDUPLUu9k3flUPQ1+033rTkP5lHfp4bkUix+G98/OomHQs2kn42vUnR5
Ho/O45i7lS9tblDsmCNRuhjyMDgrcJ1WRXH+1BL//lEOzmYc6lDUUFxs2dFi
InJQduVqQspDisoi7eShIQ6micTXo5ViVp7c5EQ/B69fHXDb8JTiqjj31y09
HMybIsM1fRRFg4rOvc84uB4REP76JcW1+g56mg4O8qPCbktEipmVHtp6DQet
TfHlNswRJtzzMmapS9YNH+bAgrSu88y7Bu5dy2C+1B+gi2J22WGea/mGoqZz
ocMMZlVgw3EcoRjTfiZY/piDZg+3LYp/KTbmm5RMbObAINt3Ux6z1Yi37WgT
BwuFbUH3mX81WqbUMmf/ku4/4R37h7bMHBXzVket9wXmGL+kqhBm3YwfnSpG
2b1j39f+/oiD6YdLHHuYvwrfE1vAvLrjT3vpe4pdaUqnU8zXsoZnyZjf3HDL
C2GONvKb0sW8GZxUJswF4dtNDT5QnLwk/vi7Rg7a1LEm9sydNqlbtcyLUwto
JPNM23vGd5jDe1XSTGbrwaHBQuaflj02vMXsP6at8TRzw0Wd/t/Mt+r2lcUx
S/7POEzMqFKGMf8HMj1P0g==
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl0H001XccB3Dk6mHfb7QeyC2jB+luSg8eS5+PlN2p2E1xDNX0wKmLVcyQ
rpKn7caddqmbkShRFuWslDlYyTyUU+2mNs+6Mp1h/X6/62g5+3b2OedzPuf1
z+dzPm+b0Kjt+40MDAy2sX4//y+COzaovf1c9VDr8dzOmrmxOCSxxUUPick3
ZMisSIm978k8YbK/KIn5uF+2eq2zHt7QZi9DQ4IZmSaO5o560Il/OG1kRND5
wmREj4MeWp3txCJjgpnqsYqTdno4G/W504xpBDWm1Q0iCz18bdqmrDcjaGNh
mhDCC/AgOED00oKgOlay1lcrQGKHT0G3NUF5ha54erUAcaeOBKYtJ/j3gFOw
UiPAUGeR4/lVBM2U7XnrFALkhxmuDnYjWLbyVcTjUAFuf9Tqy20kOLZcJpon
FcArpThr3JvgoOe7sMUOAswXl46U+hE86doodTQXYM+uu4cfBBHsTch80mUg
AGl3m1uzl+0b3ZndPszD5GFdR4ic/bfVVdLzOw976wtqD0UTXJ4gferSwMNM
j5R7tokEm+oWc/fLebAaeTZ8O4VgfN6+3WkaHgq9XRxvnSa4KLps1DuDh4Pa
e/mhOQSjVJWvA2J5KDHdLYnPZ/kEcdQzjAdJ3FLthhKCb+x/Hc/w52HWrMCi
F9fZPWloZJsXD3J/TXbfLYLiTx2eVbnwQFunXsytIxjzUj85TcKDzcjJJ7eb
CJZXGGX2L+BBg4dsK9sJ7toytkdhxkNgg+Kc/3OCffUtj3Km8KAcK1wR3kvw
sqEywGScA2PZaL/tXwSHqmnd5DAHvV1X79T8QzA1wrfoWg8Hqy1jbtZOEJzT
2tyRruWgKeVga8QUiluEZKeJFg4e50dMzfiA4iw768pTDRx46Dr3JsymGO03
21JTzYEQEt9juYBiGpRE+lZwYJW8RGG7hOIlp5X5/5ZwoOyYcO/+hGKQuUjm
V8BB5B9dVsaOFF+0JB1Q5XJQRRxsDNwpqqyuXwYVBxhZ7lm6maJQqllWmM6c
6JJeu42iUn7mWtsJDlJrRl4n+VO8ov3ToyqeAwfJnKOWuylafbzQyCSaA5/N
XmLrMIq3LnTNmxHJwQ1Vcf/jKIrzGs8efRTGwbcZZg/HYilur5XnuYVy0Fgx
9HxQQTFjRnSLPpgD6bQR0XfpFEVrutTHAjjYQI12aFQU75ZNpJ7ZzsFXhyxk
tcx5atX048yFv63w6WN+++p1VjizcWqQVPI9xfWLhBJ35ubJqvV3mH/Z4SJ6
JeNg52jY0hfZFOuaB4+6M8uftAnz1RR91IELh305yF818MadWdEfY65lfpQ1
Mfols+V5z7n1zKu3LhsuZQ74aVScyzx+L6nbNYeiwUbFTk/m5J/XNAXmUtTu
7/wmz4flO8f7fiKzuLKhPI1Zd2RPQyHzqg99dUeYpStP1wwx6059EfoZ88wr
uoq4sxTt10tShW0sf5N35T8yv93k1NHLfHjf7Kv1zGWbBuzbmJ9a46Xp51ie
5xcPFDGbKPwv2jMPXr25KYvZuVNeIGPOse2/Es8cvi45L4Y5OrzS7ACz5tz7
olj1cOExGfN/wXs0Hg==
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV0Hs0lHkYB3BTLhXv73XpdLFSVNNmhZraxhn1PF322G6KiE1ro2jZSjsK
rUjJxjb22FKYQo6MEmkb7dJKLl1sFGPQpBsxS3e87zuli7O/vuc85zmfv57v
eRxCIn1CRxkZGa2h83krsz+HwdCWslsnigwQ8EBeV0mdqayOsKaeOGX1i/vU
/mUZjr+rDJBxesTDVsngcElqS3KhAdKKtnQpqd2uy2ZGFxgg8fKcWadOMmj7
U/+FjXkGCNPUlufmMPhtZrWzJNMA88Y+by7IZ9Be/tje4bABLM+FiQOLGTw+
pI//LtQAwYaB3IRLDEaMX5g83pPel/dL915hcPSei2qFkwFs7C24afUMqu8E
Mu0WBkiKWdQ8v5HBBa/Cvl8wJIBUdLJR0DIoX3TV/1CHAD6Voc/SHjJYcdBi
0Z4qAbrsF88+2sugyKy+c0qhAOrypanLXjGo7X3iq1EI8P6tr3mwwOBfHtbn
zWMEUIW3XfD7xKDz32365BABsswT5W9NCAYfzldPXyPAp43uASaEoN8mx/oP
7gKc7bQPqplA0NiyMZIRC1CR8nOyz1SCDbeis1fZCCDr1dxdN4tgh2l4b8Io
AYx3BUk/uhL80/u0u9EgD0vOvau3kRKcWFietb6bh+vW1yJ1SHDT8PVnphoe
zhcPeexeQTCzVbX5Yi0PpgMS533eBF3HHfuSU/NQFJovm7uRoDbyQ7iqkId/
Uux2+IQQFK0d49aRxcP8TuOalREEt1ot9KtT8MAFTpYMyAk2++3bNSeRB/ER
WYMojmCbfO7rvt085D5Pja9JIrjZpWWdSzgPcbHf+G5QEHy9vPX4zCAemtRk
TUAGQd2ZLcnLfHkImWocZpZD/1NW5z28goftUrN8x0KCJZe0drXIw4P9MZ/G
lxJ0CSrxtpTykP7W5pfyywTRarBL5MpDhV31pJqrBAdzFcZ6Me0jz7gXe5Og
8qDNwyh7Hsbsia3IuUv7NndhzwQevFT/XsnuICgJ8X9Zy/LQaeb5aOkTgjO2
HWjxHUM9odUhoI9g0866jFIRD9M2pP5qO0AwwnDWpe49B7frSy3K3xFsd3vg
ATwH/Y+flFcasdhATn0R8ZqD1U6L47ePZXFSW7fOv5+DGdOLtx2xYnHsaIVr
31MONq9MijowmUWdtjL25iMOnuan5M1wZLHpj/bbO3Uc6FQnX0mcWIxz9Ewv
1HIwzuTSc39q5bHZuenUsi0NfXHUer6yLI46d6rQXU/tPtT9yJt6a5ZXx/qv
WBy+4RE20srBm1TRtShnFm/kp4kDqE13bEtXu7A47vi0YKLhQNoYn3aPuvrM
wZ7hFg7CZ2f89oG6YE5CuJ66SV9zaJkriznTIbGK+miQ7V4t9ZuhDl0E9ZR1
d4I5NxYHLTULGpo58LrQEzRxLosSq/2DaupEi/eBMuqRvVUX86ifNog3JFH/
Z9zjHkN9dkniSpt5LBoduhMtpu7MO+G5kLptld7Lmtp8pGR5IHVUwmGnkbsc
7Lxyf3EBNRb9+LKd+vSkAdkt6rU/qFprqTXRpu4vqPtNtleVUo9qt/ualbC4
5GPFuWzq+ZLPYbG4QKFMpv4fCo5Hmg==
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwd0X001XccB/Cb6dZ15fulMibrpI1VS6nbocjnQ5JV125yC0Prgbl5SKYH
jodFdVIJd4m0oqVjTIbqUoczU9P0gNzjIQ+ptrRKqb6/302P9m3vcz7nc17/
vT/nM23DFr8wI4lEouTzYSvmfwhBwd3ql4tWBngRbxq8mvvY8MP2hdxVuvu7
v+d2l4vmFz42gOOi/M6z3KNtZddrLA3g4PEuQaEgmNfmqtBNMsAnX19pWLCA
4KqJc5p11ACSyG98XZwJVqNKaBpvgOs/p2sWuxLMGWgqsnslQpmnpEFYQtBr
4pNij24R3mTtd7FaSdBicVTgtYsiVMnT2i38Cbq5n1BLC0U4U3P64MVggq6Z
GXnWaSLYmndFtGwiqMraVDknQoT2AkVYVjTBCeO6612VIgz5jaY5bCd4POJy
9u35IiTWdjXOSiHok9ycaW8rgtK3z65/L8Ex5949Sx0rwuGcp8WvDxHMDzky
7PtMAPwoxmf4CMHkmZnL1X0CzDttbZpTSPBtzFHrPVcEyBPan58oIXg4qFoY
OCeAZ3zty8BKgoqUtJqEkwL42cmnDtUSjD98kjlnCdCRHBnxqIHgeecQ1p8i
wAnZyM3cZoJ9YdvqOqMF6PXUhpy5STA3LmhabqgAoeUBsrgeguH95vU1vgIs
9TrYOeFvfv/Tp0+aQYCijBt/Tn5M8N49umfzPAE8Rhd1XGUEo+xKNamfCaC2
00mH3hAsDWosl1oJ8GBh65cvxlA8NdDis9RUgKbEwEEvKUUzM6OVUokA67SP
KpUmFH/aVf77BJGBTWOO/IwZxdpGI6fihwxkGcOGlxYUW+++vT54m0GVvT8b
saQ46Y7W2aeDQVJfS6rKhuKRZom31zUGYzQq29CpFB2yVxmvaGRQe3DfirXT
Kf5xXJ/VcYGB9q9OWYkDxTvtM0XjKgb2vbNulc+iONY6NHlqKYP+sXkusrkU
ty4jrx4UMVCOk5XaKCjqV7caHzjK4FmhU5m1C0UsiV1XoGWgU8W6xrhRDOqe
PbLuAIMF3ef7dyLFfxKGZwzuZtC1w5z2eFGM1V8ympnCoLxiut7+K4rV937b
q9/BYFGdW8kMJcWJv37rYh/H4PHdSHn6KopJ4W80i6MYrLl98getmqI0L//+
83AGbOuhvZmBFHd+0eMkrGdw1jZnykAIxYoE9fuGYAaziwouDa6neCM8fatV
AAPv1s8bR7hH2jRmxtyh7ysbTDZQ7JXfrxheyyA7+Eq9I3fxlrzXTdyClVCz
nbsloKduG3ddjrJcupHiw8CVQ/o1DJanS3LtN1EMtt39QqtmsLH6wI8u3LvO
t0hSuZPuWmqXc9vOL7CI5K6A2Vkx3MciqnAJt/nbwAwd97h9rU3Mn0F3/Nlk
7zCKWqVHopr7+Sn3pADuyYWqBg9uE31z4mZuO5MumSO3m9OdHYe4j9d7l0i5
C5+YxnVy788tkteu5v+ekh/7L7dRxdroYu62FdO3vOYOMN7Vns1tVLYw6tNw
ilffO5RouG1uXd48l3tJdLHlGm7FeJXGk9uvIjvDk1vp3PudP7fGYWjUkTv8
//B+7roEG+7/AObhNC0=
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwdzgtUzHkUB/AaPYTy+7NNbfQiOTuIxBSzde9SwpYUITEeIdsmO2F2R2ZT
EVt62M3KivEqjZRHO9g2Haso5FExFb3Gs2lt2vn9x1bo7I/vOffc8znne869
rms3h60XmJiYBLP5uDd8CsE8z0VravcZIcCyYbuc2UK3elIIs1shZKUyTxot
tK5PN8Izvf2VAuZLbTGWTWlGWL3pjtUrZmlI9Kvne40QsXVKcXQ0wcq570IF
u40QlNxPN24kuMPDrfxrpRE8j2YmfRtD8Gn2uZn2cUZw7q6dWB3H7rdMXOe2
wAjVn43QN8UTdE1zOZTsaYTj9dZirZxgTmxBx26hEY4WOo8UJRDcdeXF9W/6
eQgP9zGdlkiw31dSNVPHw2SH6MScFIKX75IZVtU8SORBmR17CN64JfuwtoQH
U7VPydN0gtuG/9G4IJeHLjpTKskm+CZ+XF1YEg8Ztv7O83MIJuXWFJbF8rD2
3iCZfy7B0PuWdqERPCxXNYcdyCOoD2gwswvgYVjgpYC8YwQ1SwMie6fyoLNQ
1/SdYv8+mDDEyYWHzpVhLbPUBJuEzfwqGx7U6QLTWcUES19avkgYoJBRV6M5
eIGgEbsS3/xDYUL3gYSTGoJDnZq7R7VTeD1GUWdeRlAs9Os9f59Ce/eIK4sq
CJ7puar1+IvCvv2l55ZeJyjc9Z9u8u8UVgTFeF+8SfBeKorUBRReto5/cP02
QYHz2TVpv1E4YZHXV3GPoKzvcLVjFoWkQPdSroFgmvGgk3cKBYdVl5UOjQR1
S/aUZvxAQZspbVI8IejS8uU2+SYKVeHllVXtBMdC7R6LKAqx1OXajWcEbZoX
LC6OoOCtPhzk2ElwzpgK1b8hFMqnO3aJXhM8tjTVbkYghS0R4fZuPQSn2z7O
NwEKwQdOarfwBK1vylSbxRR0p3vzFb0Ee/WvR1V6UMitjzLXvieoyLnw5KY7
hcEPH23rNOGw/rhwkMqZQlHsgPylGYdxlaLYDnsKMkffwRIrDtt+Wjb+MUeh
51TymQBrDjOTo2yyhlL42b+tpYDj0F0zLGGQOYXohB4VteVQlpSoeTxgAONe
q61vP+fwl4eKiCV9Bigo8WkKcWL91lRRLjUAVxQXvGoMh2ffODTGdxugxC9y
0XJ3DjujuLGH9AaI61qpLxJxOFHqKkt/boDO2OjsUg8ORUVapVmHAUzzDJk3
mOe8rynuaTeAwx1lRiOzdJ5Y18Ic/EVO2jvm1PWJYRrmiy+u7Zo9mcPRmWXS
DcwJUgdFA7PAN8jxVpsBbBbeXUOncCjJVnnsbzXA+MRlq809ORR7VdUqmbHk
mdSO+aB8YVwM85Zh/ZESZq/tR/6czdxU474khdmnvPfHty0GOP7Vzvkjp3JY
XuFRuIK57Luh88Yx27bu3jGP+aHq10Bv5iyhZLGY2WLgrH8k82zlVWvCHFPW
7HeS+XYWp658YoAU/TpfDXP++7m555nz7Hsk1cyC2ua0I8z35RYz/mZ+6m2+
/Xvmzvz93h+YlaePytcxCx6NFg/34rDSOUseyjzKrHCaK3PKEK3Cj3ma18dw
eKIufucE5v8By8Q9RA==
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwd0n001XcYAPCbucdLTfdBhdoSbVnU6sSkZs+jO9LbSNqSdJByyaQiSbkl
Z73QlLpHL050qZOaQ6ObpKKGZuUaMvSilNyUsu/vd1F52bc95zznOZ9/nuec
53mmhG7yW28gkUiW8fxYned8DCDZ09l9rZ/o0aIpe6Gcm3m4K4O5WeyYNSu4
W4WAiV0Geryk6UzZym3idy1NHKXHmfOONxd/tFftCplEj9M8hhKcnYF2SXfF
LBkU0canpsLFBWjvjGitVhRxJDLwh7muQGNKq5NkL0TsKTvx7uh8IB8n6TNZ
jYiqp48vn0Wg0q1h/y66KOKm7DaDXDmQ/MMD5cQjIkbFvW7vWwiUfvW2e3Oc
iPZ20jrJUiDToaby8CARh17MWRriC7QjIjt8WC6iidw6sMAfqDsl7Jilk4ja
OGli4SogdfvArPzxIpZWGDkaBwHtcZO1rpGIGNghez0+BOiBYapN6GsBZ52q
d4f1QOee1L5MaxXQIerc5NAI3r/Pa0tPlYBtFnvNI34GylwS7R1QImBhY5yq
ejOQxCMExqoF1EyfnD92G1CTOv1Ey2EB41dp75ntAJr0tZkkeo+AgadVyWFJ
QM9v6SYEbxbwXVmod0wykHmff9tQqIBlbz1PN/wClLpoY7mxv4AF19pTbFOB
3hQKSr2ngKvX7t45NR3orv39JwFuAk63djVUHgVabLM9bZ6TgCUXxKz0TKDq
SgvFdlsBYxoV1amn+P7mfG+7bpyAPpaC8nE2UGViXPQ/JgLqHFMWd+UCDZdU
7lGOMMwLdDzrdR5Is2ahyXWRYYbdgcNHfgMqnFLVkdXNcF5FT1pGEZBV9S37
1KcMpdsU1t0lQFK/403WLQwPGnRr+kuBnNtrxFwtQ48v7Tp7y4HGV8WvulDD
cGJoTC5VAhle2nV39U2GhbFVW7yqgIzyqnp1VxhuyJ7VoP6T329C/dWvihg2
56gXXL7H//GGPmNuPsMEt7/kxX8DnTy54ECBmiF2m9w3agY69Oag/uEphjc2
+8SbtwGVZZr2V6oYBsPF/K2PgXQ/jkQq0hm6eF+PqugAEj7bfzX6AMPbK5vp
9gsgf7luv2UKw9hE6dlJr4DqVCsxOYlhe/x8G6e3QBdXvqKUBIY7RzvYThOA
bHIeZWtjGX57Zbpmez/Q+R6fX3WbGGrcnIN2fwCKMk10SdnIUKu4GZjBbVz8
aDCGW5e5eHUe99rrOTVB3DZ9wT/d4e7N9Ax35Vb+fmi5bJDP076r645k6O3Y
5ZnDnT+wD/24H0w6ObNiCCjI6vMz9hEMxSVfzGjgLr6jaJRxmyUWOT7ntrcY
ZTKsYEit1Q7Gw0BeU62SWrjzVIKdL/fNYW36Ie5os2UTnnCr7Dt9B8IZ7nNv
Gce4FZ/+caWTOydqnaXhCFCLf9eURu6G2gRw4O4vGhgp4Hbdd250DHd1xjfP
1nH7amabJnMHBDmELeeO7Cw3PsY92Bug+447S94oLeW2ctzx3pr78pa1hrXc
6oLw/UbcdWdeGjzkDrmUYa3fwLCrPnbUG+6svPcFHdyS/8OcNPrTnvXc/wEH
sU5t
      "]]}}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0.5, 1.8626264880202026`}, {0.5, 2.062193611736653}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0.7, 1.8206115010316573`}, {0.7, 2.0173070056304105`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0.9, 1.779201077748893}, {0.9, 1.9729824137703464`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{1.1, 1.7384041761353173`}, {1.1, 1.9292268447340994`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{1.3, 1.6982301645596998`}, {1.3, 1.8860475639455445`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{1.5, 1.6586888541250682`}, {1.5, 1.8434521085155533`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{1.7000000000000002`, 1.6197905346793906`}, {1.7000000000000002`,
      1.801448303117364}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{1.9000000000000001`, 1.581546015065359}, {1.9000000000000001`, 
     1.7600442769469964`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{2.1, 1.5439666682732964`}, {2.1, 1.719248481807008}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{2.3, 1.5070644822929486`}, {2.3, 1.679069711331394}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{2.5, 1.4708521176237055`}, {2.5, 1.6395171213365958`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{2.7, 1.4353429726079732`}, {2.7, 1.6006002512324577`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{2.9000000000000004`, 1.4005512580115584`}, {2.9000000000000004`,
      1.5623290463487456`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{3.1, 1.366492082605092}, {3.1, 1.5247138809142156`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{3.3000000000000003`, 1.3331815519251626`}, {3.3000000000000003`,
      1.4877655812460282`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{3.5, 1.3006368829456112`}, {3.5, 1.4514954484365221`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{3.7, 1.2688765381143812`}, {3.7, 1.4159152794136614`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{3.9000000000000004`, 1.2379203831753594`}, {3.9000000000000004`,
      1.3810373846244461`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{4.1, 1.2077898744936464`}, {4.1, 1.3468745996243348`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{4.300000000000001, 1.1785082833785985`}, {4.300000000000001, 
     1.3134402863489107`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{0.5, 1.8626264880202026`}, {0.5, 1.7827996385336224`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{0.7, 1.7827996385336224`}, {0.7, 1.704121436694121}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{0.9, 1.704121436694121}, {0.9, 1.6266089022855397`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{1.1, 1.6266089022855397`}, {1.1, 1.5502798348460267`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{1.3, 1.5502798348460267`}, {1.3, 1.475152875091689}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{1.5, 1.475152875091689}, {1.5, 1.4012475733354948`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{1.7000000000000002`, 1.4012475733354948`}, {1.7000000000000002`,
      1.3285844659603054`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{1.9000000000000001`, 1.3285844659603054`}, {1.9000000000000001`,
      1.2571851612076506`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.1, 1.2571851612076506`}, {2.1, 1.187072435794166}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.3, 1.187072435794166}, {2.3, 1.1182703441787878`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.5, 1.1182703441787878`}, {2.5, 1.0508043426936318`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.7, 1.0508043426936318`}, {2.7, 0.984701431243838}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.9000000000000004`, 0.984701431243838}, {2.9000000000000004`, 
     0.9199903159089632}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{3.1, 0.9199903159089632}, {3.1, 0.8567015965853138}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{3.3000000000000003`, 0.8567015965853138}, {3.3000000000000003`, 
     0.7948679848569675}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{3.5, 0.7948679848569675}, {3.5, 0.7345245586606032}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{3.7, 0.7345245586606032}, {3.7, 0.6757090621408911}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{3.9000000000000004`, 0.6757090621408911}, {3.9000000000000004`, 
     0.6184622615612564}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{4.1, 0.6184622615612564}, {4.1, 0.5628283715089811}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{4.300000000000001, 0.5628283715089811}, {4.300000000000001, 
     0.5088555703208563}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{0.5, 1.7827996385336224`}, {0.7, 1.7827996385336224`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{0.7, 1.704121436694121}, {0.9, 1.704121436694121}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{0.9, 1.6266089022855397`}, {1.1, 1.6266089022855397`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{1.1, 1.5502798348460267`}, {1.3, 1.5502798348460267`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{1.3, 1.475152875091689}, {1.5, 1.475152875091689}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{1.5, 1.4012475733354948`}, {1.7000000000000002`, 
     1.4012475733354948`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{1.7000000000000002`, 1.3285844659603054`}, {1.9000000000000001`,
      1.3285844659603054`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{1.9000000000000001`, 1.2571851612076506`}, {2.1, 
     1.2571851612076506`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.1, 1.187072435794166}, {2.3, 1.187072435794166}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.3, 1.1182703441787878`}, {2.5, 1.1182703441787878`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.5, 1.0508043426936318`}, {2.7, 1.0508043426936318`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.7, 0.984701431243838}, {2.9000000000000004`, 
     0.984701431243838}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.9000000000000004`, 0.9199903159089632}, {3.1, 
     0.9199903159089632}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{3.1, 0.8567015965853138}, {3.3000000000000003`, 
     0.8567015965853138}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{3.3000000000000003`, 0.7948679848569675}, {3.5, 
     0.7948679848569675}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{3.5, 0.7345245586606032}, {3.7, 0.7345245586606032}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{3.7, 0.6757090621408911}, {3.9000000000000004`, 
     0.6757090621408911}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{3.9000000000000004`, 0.6184622615612564}, {4.1, 
     0.6184622615612564}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{4.1, 0.5628283715089811}, {4.300000000000001, 
     0.5628283715089811}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{4.300000000000001, 0.5088555703208563}, {4.5, 
     0.5088555703208563}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0, 1.8626264880202026`}, {0.5, 1.8626264880202026`}}]}, {{
     InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         StyleBox[
          SubscriptBox["\[Tau]", "d"],
          FontSize->12], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.1",
           FontSize->12], 
          StyleBox["  ",
           FontSize->12], 
          StyleBox["ms",
           FontSize->12], " "}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[1.]], {3.3235078483690277`, 2.012427585875338}, {
      Left, Baseline},
      Alignment->{Left, Top}], InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         StyleBox[
          SubscriptBox["\[Tau]", "e"],
          FontSize->12], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.5",
           FontSize->12], 
          StyleBox["  ",
           FontSize->12], 
          StyleBox["ms",
           FontSize->12], " "}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[1.]], {3.354120093266987, 2.2589452405562587`}, {
      Left, Baseline},
      Alignment->{Left, Top}]}, InsetBox[
     StyleBox[
      TagBox[
       RowBox[{
        SubscriptBox[
         StyleBox["v",
          FontSize->12], "r"], 
        StyleBox["=",
         FontSize->12], 
        StyleBox[" ",
         FontSize->12], 
        RowBox[{
         StyleBox["0.1",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["mV",
           FontSize->12], 
          StyleBox["/",
           FontSize->12], 
          StyleBox["s",
           FontSize->12], " "}]}]}],
       "RawBoxes"],
      FontFamily->"Arial",
      FontSize->10,
      Background->GrayLevel[1.]], {3.135675825100349, 1.7570897448664817`}, {
     Left, Baseline},
     Alignment->{Left, Top}]}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{-1., 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {6, 
      FormBox["6", TraditionalForm]}, {7, 
      FormBox["7", TraditionalForm]}, {8, 
      FormBox["8", TraditionalForm]}, {9, 
      FormBox["9", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{41., 25.}, {55., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{0., 4.5}, {0., 2.5}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.91916638135858*^9, 3.9191663983329773`*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, -0.7}, {0.5, -0.6799999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.7, -0.6799999999999999}, {0.7, -0.6599999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.9, -0.6599999999999999}, {0.9, -0.6399999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{1.1, -0.6399999999999999}, {1.1, -0.62}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{1.3, -0.62}, {1.3, -0.6}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{1.5, -0.6}, {1.5, -0.58}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{1.7000000000000002`, -0.58}, {
     1.7000000000000002`, -0.5599999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{1.9000000000000001`, -0.5599999999999999}, {
     1.9000000000000001`, -0.5399999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.1, -0.5399999999999999}, {2.1, -0.52}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.3, -0.52}, {2.3, -0.49999999999999994`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.5, -0.49999999999999994`}, {2.5, -0.48}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.7, -0.48}, {2.7, -0.45999999999999996`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.9000000000000004`, -0.45999999999999996`}, {
     2.9000000000000004`, -0.43999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{3.1, -0.43999999999999995`}, {3.1, -0.41999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{3.3000000000000003`, -0.41999999999999993`}, {
     3.3000000000000003`, -0.39999999999999997`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{3.5, -0.39999999999999997`}, {3.5, -0.37999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{3.7, -0.37999999999999995`}, {3.7, -0.35999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{3.9000000000000004`, -0.35999999999999993`}, {
     3.9000000000000004`, -0.33999999999999997`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{4.1, -0.33999999999999997`}, {4.1, -0.31999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{4.300000000000001, -0.31999999999999995`}, {
     4.300000000000001, -0.29999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, -0.6799999999999999}, {0.7, -0.6799999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.7, -0.6599999999999999}, {0.9, -0.6599999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.9, -0.6399999999999999}, {1.1, -0.6399999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{1.1, -0.62}, {1.3, -0.62}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{1.3, -0.6}, {1.5, -0.6}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{1.5, -0.58}, {1.7000000000000002`, -0.58}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{1.7000000000000002`, -0.5599999999999999}, {
     1.9000000000000001`, -0.5599999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{1.9000000000000001`, -0.5399999999999999}, {
     2.1, -0.5399999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.1, -0.52}, {2.3, -0.52}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.3, -0.49999999999999994`}, {2.5, -0.49999999999999994`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.5, -0.48}, {2.7, -0.48}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.7, -0.45999999999999996`}, {
     2.9000000000000004`, -0.45999999999999996`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.9000000000000004`, -0.43999999999999995`}, {
     3.1, -0.43999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{3.1, -0.41999999999999993`}, {
     3.3000000000000003`, -0.41999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{3.3000000000000003`, -0.39999999999999997`}, {
     3.5, -0.39999999999999997`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{3.5, -0.37999999999999995`}, {3.7, -0.37999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{3.7, -0.35999999999999993`}, {
     3.9000000000000004`, -0.35999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{3.9000000000000004`, -0.33999999999999997`}, {
     4.1, -0.33999999999999997`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{4.1, -0.31999999999999995`}, {
     4.300000000000001, -0.31999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{4.300000000000001, -0.29999999999999993`}, {
     4.5, -0.29999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0, -0.7}, {0.5, -0.7}}]}},
  AspectRatio->0.2,
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"t (ms)\"", FontSize -> 16, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox["\"V (V)\"", FontSize -> 20, StripOnInput -> False], 
     TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {6, 
      FormBox["6", TraditionalForm]}, {7, 
      FormBox["7", TraditionalForm]}, {8, 
      FormBox["8", TraditionalForm]}, {9, 
      FormBox["9", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}}, {{-0.7, 
      FormBox[
       RowBox[{"-", "0.7`"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {-0.3, 
      FormBox[
       RowBox[{"-", "0.3`"}], TraditionalForm]}}, None, None},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  PlotRange->{{0, 4.5}, {-0.75, -0.2}}]], "Output",
 CellChangeTimes->{
  3.9189932955210476`*^9, 3.9189933265856853`*^9, {3.9189936207978983`*^9, 
   3.9189936378399563`*^9}, {3.9189936689762*^9, 3.9189936784841757`*^9}, 
   3.9189938752004704`*^9, {3.918995236896613*^9, 3.9189953717697845`*^9}, {
   3.918995448402794*^9, 3.9189954880442696`*^9}, 3.9189955484914293`*^9, {
   3.918995586834073*^9, 3.9189955986817226`*^9}, {3.918995719267539*^9, 
   3.918995724358102*^9}, 3.9189957641570625`*^9, 3.919045719467263*^9, 
   3.9190457570114045`*^9, 3.9190457982558703`*^9, 3.919045848390644*^9, 
   3.919045891177925*^9, 3.919046135499894*^9, 3.9190468927573175`*^9, 
   3.919046927854157*^9, 3.9190469624583406`*^9, 3.919165406285101*^9, 
   3.9191654718272643`*^9, {3.9191655158768663`*^9, 3.91916554137982*^9}, 
   3.919165592382147*^9, {3.9191656307412305`*^9, 3.9191656369591627`*^9}, 
   3.9191656863230677`*^9, {3.9191657876247454`*^9, 3.919165797707838*^9}, 
   3.9191658677048283`*^9, {3.919165903013497*^9, 3.9191659236632724`*^9}, 
   3.919165999978963*^9, {3.919166073035132*^9, 3.9191660928951626`*^9}, {
   3.919166168192665*^9, 3.9191661944568014`*^9}, 3.919166289733592*^9, 
   3.9191663622208757`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0.5, 0], AbsoluteThickness[2], LineBox[CompressedData["
1:eJw1lXs4lAkUxsdlaHJtQxcqhLBYInfOoSms2r6P1LqmoXJt1CgUcmeZtViX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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4VN8bAPBBdqkkWQpFitKioijvqISsKZKSNVlC5KsSSqVkKSGEyhIp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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk0VW8XB3Bx5xGhiCQSQqZE09lEMlQyh5CSJlIoMqSopCQkIvLLVBTK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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4FP8fAHBJl4rMzM7aypHclaNDKjVvkqQoCuVIhZIiIVQUydGlSAiJ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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk8Fd8bB3Apa5siMXNn7k2plCXV1xKZJ0koO1lSliIUISGVskaKFlFC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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4Ve8TAPAsFUUqkpLlnHMjQvtiqTOWZC3JlmTJkn1LIVIqioiUVJZE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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2XlUTV0bAHCahGhEFI3nnJuUkGadXYmkEA2kKJrTqAhJadaoqLwlURqk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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk0Vt0XB3BTQkiGIlOm6t77kEpCcjciCkmGEhmSqaikUqk3SSqiqPCS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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4Vd/XAHBTQkqZkmROpnPOTcaUs5GiUMmUFDIrs6JoJMkQSdEvSeYp
lTJEoUyhJJW+FVEkSUjnmpretb3+8Xyec8/da6+91tqeh9x+fyt3Lg4OjnpO
Dg78+/9/CLTs6/YnXKtmaEdFGY8d4CHDSZd68Rm6ytTgaSa4R2jVk7NLZ+iA
CxFphpwEMmxuebCOZ4bul59lRXIRaMzh6fW/36bpOpNJF94FBGpfoeW46+E0
fTxusEFQgEB79wy1XfKYpt/d4lbdC7ay2DAX4DJNa7+ST7oJ3pnIq2PtOE2P
Sbk4Wi6C54uu52lYTdN7S3uZREECOUXWcFoaTNMbXnSvFhEi0NKD6QuY5dP0
L/HWsytECVQ2s46jpHOKXs9WuRMAXhHCKC1/OkWHvYx91wK+rlkhEtsyRU8l
mhOHxQg0PnxB4GztFD3B19nVJU6gd09fc/aUTNFDc92r4lcQKN7C7t9Q7BTd
+WHw7l9pAulIODSpm0/RSx6a9NrIEMjhXEdNmOkUbXE1j/cmeGdx11zbpim6
zc5r9x5ZAnGMT605vXGKbur89rdSjkBSKE1iPTVFVz+eNAtUhPddDRxbRKbo
3DyO/gEVAj13rlQT+cimixZXGGmpEkhY1/3olg9s+nbIgdxosM8yls7J92y6
2qjbR0WNQJtMRfr+vmbTHR+K2X7qBCqx0VVitbPpGXG7RXMkgbaodeU5VrDp
rWdvai/VJFCbTK7+7UQ2vX1s/xUX8MhvxdPuCWza2kbidxlY7LGrj3Qcm3ZS
iHxko0Wgn5/l+K9Gs+mQOnvzq9oE0jOv7K89xqavTXPvV9KD8/BSlC45yKYn
PB0SNhgQ6LDt3KNpczbdJLzPLh6cKzaiKruNTf/voYtcD7hS4VzANjM2vUnE
uzycJtDKOuGTRSZs+kptaG81gviORWrFGrBpI7FLhJ4xgdQTA/Sestj0xcfP
n2mZEsj+dfnUxuVs2sv3ZeoZcB63xn/3xdi0gcQbl9fgbdtLRXVF2fSw7wd2
iBmBis/yJ+kvY9MbVnxfdW8rgRYx2mr7FrHpQX8BPw0LqJfNnL1LONi09iqT
JZQVgTaW6V3k/cbQY6dir54BJ9ivVCv5ytB5Q8+Ve8BiL3IFrIcZWuy2g/G5
XfB54X0Xij4zNGMUEDZgTaCL71x2BfUz9F2vq59S7Qh0wSbRz7uboVn3flRw
7CWQwoUi994Ghh6W0NlkB36we3ym8TFDZx6LeHETvKPytlvpI4ZeumXhqMM+
AoUuM7gfXcfQ42+l5MqdoP/6qjgsahi69N+WOO/9BPoofekAcZeh1bZlOHV5
Qj31LGxSyWHoIl1dJQUvAr0ozeuxyWZoZaWu0WBwunuiYWQWQyty8h4V84b6
GV/67WMmQ0tX+qbY+xDIt8Y0qvQarK+wsfXDQcjfmyNikakMPTX3XuNbIIEy
f8ydFIxn6JDhQ7P6QQRKnRg5sy+OoX++FqqPB+dzHk+/E8vQE7eNLchgAkUc
6552OMfQXz2KPQNDCFTzZ0C3Opqhe7qOpk8fJtDwreNHCk8x9KOiFbw8EQS6
FbFPBoUxtLwVO3EP+GVdomNuKENHzXauuAu24T9yYxF4s2kMsf8YgWJkA/Xf
H2Lots9T1vXHCTTaG3ciOpihu2RfZUecItDgzP86Fvkz9ODl84bsaKinSHXz
Zg+GNjHwaTc/C99H/dhhBs77bGKTAw7hvKX6zJ2hvTT/eO2KIZDy24N2b9wY
evTFgaQ75wgUyP3Gj72fodmCZn2+8QSKndjiZufE0LyR3MeGLkC8+kJ2hfYM
reNH+G1IJtB5MXmDzWCv3XZOyWDbVo72ATuIlyo2NLgI/cXZ8UIWfL7Hivdy
Cswzz8eHsmwYWlw7K9EkFebv0jKiwYqhlb6irJx0+D6fSweCLRja7pXPxTmw
3ncdUQVwTF1K1I5r8Hx6k/FLc4YeuTTs8Rtsnii1VgtcapSkZn0d5hnPmXX/
tjK0dnrfPe4sAgXNLhAvNoV8bj/esj+fQHOu6287bmJog4bfP8rAoncHRmTA
WjrhUtwF0M9B3lEDxlA/MmGB2eD23uoXB8Bc44ErBwsJVNsX3nTSiKFrz7v7
u5fAfXI7IaUGwXod5su97hAoOE5ZPHAjQ5NG7YZV4IQnetI0eHWF2UG+Mphv
DVtDFoNFMzY/KgC3l5zhK97A0JO+6MDXu9A/9zc0ftWH/SzWrPOpgPk1PCd3
aD1Dr7FY6elbA/EG5LvX60A84e+tG8FzqprvL4J7Cq4arXxAIDc92XRPcBKP
lHQruHxW4q8QeLZG6rViLYEEzndoumkzdLuqtHFPPdT/goVckloM7c8nJ7Ot
mUDXmr6OVGow9Fbtj4JZ4NjO7sGLYEW3G3MzYPmY+ysDwP/VyXXntcB8WtRo
oAI2DJVP4GqF+VX53DJjLUOLDCn8ut8O8dpxoosshq5sUHqj/IJAux7pduWS
DG1/VP/vEfDl9PxrseAZ1o7V7WDZbSIp/uD1GUeCfbsI9PDtC4714Nqwp0Jl
L2E9ibSuToKhG4kgU/1uAikpckvzgjtTH963eA/1tLg1I0GNoQMtu/ozwN5f
f1uEgoUXfFk4AdbJD5Z1Ae8KWmqb3AP7Nd5GaoG7zV0nu3sJxH0k88sHVcgn
J7+acz+BAqSHb+iChw9Ypwd9BnPzdnCrMPRuj0rVx2Bem5H3P5Sh3p0l7y8b
ItCdk1cX9IOLbfpf3wZ7uVcVPwD70QeFxr/AfOnTNggF/xSOOn1gBNbrGbf7
sYah/96/6+U2TiDV2EOmM0pwHvfEp++CU+QdTn0F95ceOcM9AfnbqPDiHfhR
Np2VBV5u+/reQ3BUQvv7/h8ESoz/HBMF5ncZsNzLwDw612oiDhblE9GynSVQ
pFcnYbYa+vVBZXQJePfztDl9cE2A439ccwRiJSf2kuD9b3PDb4GddwV/FgXf
LtJ9zPebQNkhQrMfFRl6m8W+7TV/CRSdRy89CT6dXOgty0Oi+HXFQu0KkM/N
ljWHwf/dTdhXD1b5NSn4DDxx2bOuHNzpuuH2kQUkCmbHVGSCV2k9n+riJVGU
imFoKLjqDRN5hp9E1YvkVZTB41IoY2QJiZ43aiRckmdoPgc9FX0hEqk1Cocl
gOVTNe7FgXurr/ufAdsuW92mvpREHiqBUYfAtQsEpvyWkUh06TMjW/D5sZcW
P0VIVP4hh1MSTNZ7/vklQaJEy7sLi+QY2vSPc4z5ChLReyZcs8H71zuIXAO7
rUxtSwdfvmeuYiBJooPH+isSwX8L1tqcXEkix2fX+Q+Dn134VcIjTaJzRQKx
m8AHXRMdFyuQaEPi9oRhWYb2dmgrcgMnMzI5n8AeOxfM1oCfC/xu7AE70eGX
fBRJ5Cd1UfEF2GqlZ0fLahKdGnDfXQ3WeWmATiuTSEjYOO48mMt4TGGaINGv
4OSsjeC/eipBliSJhCd63uuCf7Hc6nPBqwNNVmmCGel3jtYUiRQO6FWpgr/M
NV26wyKRQDnLQgL8tOzawoPrSPRxdcMXRoahU+UtvvXrkmi6QPnsXbDb3u5M
bT0SmZupP7wFZqU52caDS51PzxaD2xYHPdJZTyKTV7+icsC/Zy6nntcn0f06
jqFLYOfn/cYbDOB9l6CWI2DViJD0VGMS6ZpYNZqApyr+7PwODhM+escI3PAj
eqHxJhL5PH6cTYMdPa8EjYH1MlJS9cCJVrWmJptJ1KZqWUOAGWU+9qQpic7Y
ff4mDn74+qqFpSWc/+Xm6lFpht5x5ciGDDBHgbPnCHjQ0U5tDPzK98ryYbDA
oDD/+e0kik7pPD0Atp081/hsB/jO/ch34PElYfoWu0jEY1Wh2gqWM7VWMbcn
kXIp19cC8L1FGhLpYB4btX95YNPnQgtHwXfcLCVywX627YNxu0mkqB+46wa4
2s0os92BRK61haNXwLtOsZZv20uiQs4/eXHgM9WCC7buJ5G41pZVgeA5HfXK
TDAvr7mXPzigfJv3NFjAWqPCF+x4O/ZZjiuJhn4nOviANfP4Lv9zI1GmC3+T
K/jTBZ415Z6w35xeKTsw8v5tKutLoqwXX6pocMXQyl+HwbLepnYGYHU3/ZvP
wE86/kxvAEs4HV0W7kcia0s7tB7nw3rm7Wt/WD/FflQTnIEYn7ggEpVJmJSq
gn8tH42fCoX1E5Prl4N1pZ3DtoSRSHLIu1wcHKL4yjUNXKU2VCwGHmU9WL/+
CImS1BquiYA/mMUPHzsK/RjckiIEfhSuvmnBMRLZ9LQ+Wwg+23fwl8hpEu0Z
59kzuwruh8/9Q27gkLf1J2bAHKPWXeXg3xu6c6fBYTMbCu0ioZ8neabYYJ9l
i+2uRpHIykknbxJsYXyzTP4sid5vXL1pFCyS/917bTyJhicCvfrBGp7ZEufA
k+tO5PaBrdbsbukHB2i9HfgATspvVExKINHTVB+3XrBgwdW+sfMkGi9oCnkH
5ik0sym5QKLumBOdr8BTRbloTSqJwhU63dvAYgf2jB8H081+T1rBmmrLMrrB
OnyS6thBxRG/zqSR6I1R4lQLeLx4V8XgFahP9YbUJvBwCad6VjqJGpye8z8C
vy3du3xVFokOhHPfqAI/KXMhgsHd3psUsasq3I1bwYMetgWV4Mu1vv6HsuG8
xYbLKvD+Oo61PMsh0eWo9Bf3wG3fr4UezyfRvi/ymnfA1eof3vSVQL2Y90cV
gQtZn75r3SSRYUGzDHaa5hB3PNg6yLamEHx4wxilWwrxfPJlCnA+zf+eTbpF
oqNpe/3ywUUHpHUNy0i0IGLnyRzw1aJ9aVmVMB8s/cWug3foVH6ZBMvcn3uS
AeZtFNIxriJRR9mfCOyg3vrXA+BXnp5D18CmSxVEVleTiLxZXpsOZg59Sch/
QKJbP65H/Q9sbhgQWfII5uXiKefLYK6OJ12/wTLG0vLYlQ5y8haPSZRSWzBw
CSwf0lX/HTwj88kTeyZP8y/ZSKL8mdchKeBcwdmwO80kktqPMpPBf9+c8qto
J9EHB0O9RJxfaalTi5/C94lv4sQm3SsuuoHX3c9tPQ92mhypEn4G9wErcg92
vaA1t38HzOuUS5EJ4NOGSmlrXpDo0lDSYBx4YXHbo7RuEv1sff85Bpz5w+3V
OJjHM7UKW1f339DmNzA/a6/HYXs1rRNkg3tTUjSw2/rSbXe+JVF7D0fUWXC8
qP83/h4S3Qg/rBkNXnpcRCz8I4mCDC89iQT7W3C5PAVvLvXMw+6Q+lGy6hPM
G82AKOy4mo5N9eDTevKG2Lyz50IWDJLo7ADHw9PgP8EcrxKH4L6Kdq49BR7x
/p6c841EGSdOfT4BNtPr+cAGFwuEt2IX8LWrbhklkcFk5k1s9/yCx1/Bp2sD
DmP3D7pOkmNwn1ZJCGB3O73beX+CRMf+WuodBzfYtCztYMO8T0oqjwBPevE0
rpqCeN7wXceWjTAM9QVLiOfEYB/PqukVnCZRznUjR2zd8VtF22ZIlM4vuQC7
NCZtU+sciUIDePaGg/9X4x3W+I9EFyK8FY+CWzvy1EQ5KGR7rXcZ9szHgQ+u
YL9ov39HwDZ8+0y4OSmk9u/zO+ylNlbCRlwU/P2vdBE7emx9SR0Phd5ltPJh
B8oJ9lfzUyiG/9DCMHz+Y7G2ywQoJLl6aCoUnFLD/8wTHCQTPIRdYbOwWnQR
hRTZfU3Yv89xpfgJUshBnCMaO2ZyZou8EIUeVmssws5s+HzrnCiF7nFoKR8G
lyW5KfWDZZqeSmI37B1I1xajUIpk+GLsoen+cwPgoX7Jn4fA6uo9rhuXU8i8
YX8ddmVK1/IfKygkOvpzD3aHe90JexkKmYQo54SA82qSqULwfyG8/8M+vsyj
bxb8xJlJxCYfCtJXZWH/l/+FY58XdfjbKwf7be20xrZsYCJcFSm0mTTjx34m
q3rUTwU+/3QiIhicc/iPSh3YIT0jBDviaedbIVUKxR7ffRBbPSxU7w54Qnlq
D3b888aZn2oUKvjwRB/b/LhT6BGSQuHhj/8EgZ++TwmJWkehv6tOx2Kf/Vb4
5T045qZkJLbRr1qHdZoUuvumLhy7UvIr+gQ2yqN8sbN2b1yMtCnk2ZO1Azv0
zefcX7oUupPVtAJb/qX2myADCslvCr4XCO79tG1rG/iUblgpdtqk80M5mkLr
9pwtwF4sHJfdCbYdakjHntnR508aUihB694Z7I6Os3wjxhQ6vNp1N/aRtv/0
XMwolLQvbiE2j/QG0Upwu+ozLuzzgdfHBLdSaN+g+N8AnD8Jj+wq8I2RRwx2
h8dPwaXmFBLrDvmErcC9pL/WkkLTXMZ12M/0jaOlrCGeJrXj2PaJec5B4CjV
XUexP33i138C3v7n5GHsmXOd48E2FHpeP+6HLf/f3t3tthRakirhjB0aEqZ+
dDf0y+HzxthyN292vdlHoVHZ5iXYQefch9Y4UUjTqHcRdqP7qrlQ8MjoDB+2
h3SCnIQzhZweb+TGLko8GGDvQiGBot/T/vg+DVJb8taVQhUhZp+wN+sUmr3z
gv7Z/eM+dqqIy15Vbwrtqo+vxB4elwg8Cnb7pFaOHVsQkybpQ6FudOg29vMV
Xl8cDlDIpnldPrb9b6Uz730pZL1ozyVsn0c59T1BFJKYVQ/BzrDLSF0XDP1Z
LxCE3fU91S8WnCw/6o+9XjJOSjeEQjo37h/A5g8ODLt4iEKHeo+7YhcoGrC2
hlFoinVzF/bQ2TfXK49B/+kEaWNLSr84vOQ4nJ99lSa25b02C3fwhBvnOuyK
/oe/hE9QqFk1ncI+o5dj53eSQsYDP5WxFb8FCK2OpFD0xzVS2PstBU4kx1DI
IOI0D7ajr33iAJjzgSY3tl183nXNcxQ6L/CVE9u8zai+G7y4xe6fH1hrczjn
yjhY39ViDpvPYDQyO4FCygGXJ7BLiY6Ye8lQT59jP2BnH/AptL0I/T3h1YOd
VsjbNgOuvW3xDvvUanrRxksU+vFPtRvbetXthKZUCsmlaXRg/xJMTu5Op5Dg
Gbc67KSutlOHrlHowZ6bD7EV07gDRTOgvo79qsG2VDi03eo6haqc86uwM/Xs
BTtuUKj/q34ZtomHdHRTHoWu1WzNw36nZnfILR/qh+djDrbfj0Q37gIKvS8M
z56PN4LT2LAQ5knXw0zskeTBfw+KKVRPhVzFTqwrOnLvNoVUVmdcmH8+4zHu
fAfOj29PEvYmDQX3xWUUKlKUSsSeybm6w+Mu7L+zKB7bOTZ+jUQF1PPhmbPY
LBu/1+E18H602QnswZah+lcPKGTlYXhsPp71TiVELczvJ5vDsTlld0T21cP8
LQ0Lxe4aWbvWuBnqsc4/YH7/J39znmkBGwz5ze9PvKWr+QmFnE09fLEXGTmG
bG2H8xI+7TMf75Xoyp2dFOLbJ++OLUztjLn4Avqbv88Vu79x5e7XXRRalZC9
H/vYxO05+9eQb3tjZ+yKLe83Or+jkP/sf3uwvYyOz67opZC7zI3d2Cs3ypW/
7KNQcHm0HfZJDU/1LZ8p5KKWswtbgxAY5him0FW9tzvn97/mZnb1CIXShJV2
YJut+ilJTlBIezOXxXy+9q2/cX+SQmu252/DFr9+ao0JG/Kltnfr/PuySzUd
52DeK8xswb6TlYGC/8F9J/PMBJtOvqxkwsVC2Te6jbFzf2z/0sDDQtakhNF8
fnbyFxgtZKEBViTCDrz92OsRPwtlPRehsd8IRaggQRbyi2/eiN1xUKCvcBkL
XZJz0Mdubk1LEVnOQtcYVz1spbv+fbJSLJTPMaSDHZ2+WZWUYyHekBLt+Xwr
6hXmK7FQ6YNULexrxWrKcuospGRepYmtHMAldWotC/17xTvvMs23Qh+1WShq
9vC6+fjPzKQN6rOQZDD/vNO6l8sPIxZq9rylMX8+TVZ9dptZSKLZad6v7yWk
t2xjwX0tM29H1rLxdztYqMV3bC32QHGK4ZgNC3maNs/by+0337ADC4X+yJ33
mJRb50cnFhrbETfvzOAv7VvcWWhFVfC8d7b5tNz0YaHGq87z9rmpbV/pz0Jb
llnNOyqJ62t9CAuVy2yet5HpqRDnoyzEsU1/3vP/7jvJQuJXNOb9f1/Xpek=

      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4V08XAHBbtoRkq+xJRXTvlyyl7qgoRSJKUiRLyFaWrCGRECJSKkoI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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xc8Vt8fAHCb+kqoUEnIKMq498lK3dMyQiKVSJGtZCQkJGRkRFlZEUk0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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xc4lt8bAHAro68kRUJGIamsnudF0XNIysiuJLNsGZWQEJKMSkSLCkmy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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4Vd/XAHBTooRSkmQoJBWSzrlCZ6eQItEkVAoZylAJCUkiU5nJFPKT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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2XdYjt8bAPCWxDdFlBWKSgPtep639BxFGRkNpCUtDS0kWpK0tCftSFEa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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xc8l98XAHArSUJCJWUmqSTKeJ5P3ZtEQ4MWShSysiKbrMjeDSOjqIzI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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4VV0XAHBToldooIlQyFCIQjrn7t1ASIlUkqJQqKTITJKQVISMlSlk
KFORMYUGDUIyRGjg3GsqZUr1re3zj+f3nHvO2Xvttdbe97kyR06Z2vFwcXHV
cnNxkf8zf/4UfhMj1rpBZQSpXBfRUAAr1c6SfqMwgixlpY7uAh/hcvziuHIE
leizXiWB76afy61YPIKcI3xiN52n8Kvj0+/qeEdQ94pJtQsBFK5VMLAqeTiM
qnR/HOa/SGFncycNb+lhNPCBO1oFbOLA73B90TBa6jjv+V7wrQzFiGLhYeR2
VU0lA/xgd+dh5T9DSOWD09S2ILjuPnn3YfsQumXPuX4pmMKZInsdDWKHkN/l
L0+FQincwm3PbpQYQjenosy1wWFSrt6fFw6hcgfdQRvwwFHDC9xzh9Dvbeni
ZeBu+WWJdn8GkQefvYPDZQrfyZDxqe8aRC6+HOG6MAq3BYg/nkodRPanfuw/
d43Cv4uFxPdoDaKQrpShLPDFBdcFOWqDKGPH7gst4PvhGp8uKw2ib8pFOWvC
KXxUdW7foOQgsuk/+68D7Fz66PjaWYPo0OHJNO3rFN4ny65Ofz+Adu/mGvke
BfGb123f7DuAWvgPJC+NhnjfUaqf9hhA5qUPTLeAoypfta12HUCHZI4/iAJ/
zA+uT3UcQPbD7720blDYdPvSfM6+AeRzOXuWbwyF85P2b23TGEDpT/cuE4in
sIS6PN05wkEK7vmv1MCKHwK5vg5wULaSkN9+sJHdJuHRfg7Ki6juzgJr3eHr
kenhoDKr1ek7EijckHF214t3HNTwm3ttZCKFg4MihjWLOGhSI1dv+W0KdwV+
mzby5SBbwfvKemC/5X7KEl4c9KYrT9QJXNokYzzixkFpl4raK8DTnJd7M5w5
aOenMqeDSRReZ8m5bmzLQSmhL28kJlP4ak8fK8CIg7b39H1bmkbhnZ9ri1nS
HPTwIVO/GazO1HnekuQg6TBOniNY3GL9Lp5lHDSmOexVmkbiJyjTIsZBSWFj
whZ3KJwo55ea+x8H/dSapRWXTuGmPyGN4hNsdPPqiuBFdym8da/aWGYTG03g
2tebwR61xeO73rGR2eixhU5grbLVA9Nv2EjIPDe5Bqy5bkek9Us28pHRLj+d
RWGzj20r9lazkWXRju/12RRerO127+d9Nlra7nHA/x6FHzNirc3X2MgtbFlK
Nth21oEVw1fYqJFV2d8Cnr/g3y2hMDYKTeV1W3OfwnmJPUtMQtho6sTV8Hbw
nTMe5//5s1Hbv9TadfkUtuiSDR88w0axcm9VmUKI9xIdpQFzNtonIRE5r4jC
8lN6Mr772Eh8gcPYBnBrUdx+0b1sFM3FWxEKvnf12zl6Nxtd79A0XP2Awhqr
1mwq2MFGlyNu2Z56SOEnDZWxPFvYyO/PybhfJRSW/YarV6myEf2zdFryEYVD
ovc4TK1ho2n2bGs9sL3+Ic6b1Wzk3ZosHwO+G5512leJjTwK3xdql0K+e9Zq
jsix0WkH+o13GYUDVlqrKEmyke17IV6eSgoLpiWKdAqx0cK7U8/WgIe5mrjf
/cdGtT79YfvBmbffltfNYSN52RrxfHDAoXH/YgE26j/jrWRdRWFRauVQLh8b
nRRlm1Q+pvBZ1+DXnGkGuW1/luT1lMJbdLWUY4cYJC/1wC4dfNi0Lb9qkEEf
fqQoNYJjai3v9g8wSDver0ixhsKnizb0sDgMmupf/7wV3G8coTbdxyC/oLRh
zToKe69m0SU9DAquPs8afU7hed+f7ZNvYZB0sbjW8hcUfjkZUOj1nkElOdmq
BmCGba/S0Mwgdsx76dvgQ52aXn5NDDJyUuTd/hL6h9gCzf4GBokue/cspZ7C
l65FZg3VMyjWVdrE9A3Ep++XX9kTBqk5PjDwBW/RoPepgV9YGW7OBJfp71mc
Xg3jNXTV+Avetv3LzqjHDLKUeS6W9ZbCygUBNt6VML43p9q531G4N1bw85lS
BmWuqrLJb6KwSsMxrz8FDEo7/NejDWw5sUM7CpyUQF/lboZ48wTEK4NjRMpL
TMDv7Ju2WeYzKGi8ZO4P8BDlrFR7n0G2zwqK1VsoPHlCW6soB953LP2/olYK
x6nrT3JlMEgi+av0R3DBeu6TWekMWtwhq8nXRmGdg03HzMAixqnWZmDNdo/h
u3cY9Fcz6cFPMPcRAbUDaQz6yB9vtb6DwhFr9tS8T2ZQXPqVwoedFI4u6mbk
bsJ4Kk4q9YKNlDbVtCYyyLV5R/LcLgpvllCRCQPv5BG+ZguevWmj1c8EBvEc
uuo4/xOsh5VZ88t4Bp0Quybj1A3zv/Ko/2osg1iB4dfkPsN+UJKi4RTFIOUE
Z34TsCY75I0qeHHBLl8fcN0gX9P3SAb9+CR6vAl8mvkp5g7O2Bihd/4LzLfV
xTnoOqzvaMSfj19hvQqze4rDGdR7OPJ4VD+F2XPaqcNXGKReIfmvHDxbpUtS
HXxhceb1r+CajfsMeMGyb8sfaTIUXqvV6JsexiA76tvsNnDYhM6ukcsM6hff
kCbJgXo4mKYVEcqgofquj+mDFDb/83fprBCYzyoH57fgi9yyrl3BDLoWMMo7
Adb+z3JOCVhtg4CywRCFlz69MHAcfDp9rScH/GRM37cliEE//QPF1Eagn4Vu
P/fwIoN+r1fa+egHhcd9rsXcvsCgdYUHxHrA4t/NAvzBJ9SufBQYpfCU7Kab
h8EflUYczcHt3TZHZMGVUg+Dx8GxFnUyOQEM8hfcXL3+F4VPhAhr1pxnEH/n
/nUF4xRe1Xq0aaE/jN/i8u82cAvVpfP7HIPcP5Q/4Z6A/DKbftED7n8nZWIC
zjfQOnQf/KLu68kRcH3ebHMjcFje6QyVKchnIdbBK34Mmh94aWn2NIWDPPNl
lHwZRHUd2NICdsgs3roAfFRb5QT3HwobCClenfZh0KOBxop94Dlp2yPfgq33
SBzm+0thtb/xVu7ge/L3Mw7+o3D85IKXr70ZZPCieZ0oD40l3Wr0o7wYdGZl
xsGN4B2d35+eByf6egYdBdOp9KFT4JG1y1vLwes9rYYNwTfij3k78NL4W7qi
Hy/4y/Gp6id8NLYy7pDx8oR4CUsbn51N46Frqeo+Hgyam5sYdRN8cPVbdSdw
/PYl7bVgoY3D+tbgopD5duICND6tfOHhVnA/zyzvYvA97y2RwuBd40z6pCDc
n7pMM90d6re78K+vEI3PlFBbvrgxKNdPbWs6WG1U8WkrWEcy99IbsISx9J7X
YDOL9IVSc2ks4lJ87yE4pDlW6TFY0yhgfSh45LnvXh4RGjvK3fdcB67K33Yv
aB6NV0yIyUefhfVdY7enAFxTocyEgsszA6Y7wfMbMir8wSW3KwzXz6fxphrL
+BPggisafZ/B4RtCpXTBaQ5S0psW0lhxtTiedGVQqMx4xG9xGqs/zZA4CRa4
uXDDqkU03u/yscUWHLxYvdsUXG4lfdsSHChyUiULPHDebb8R2PdP70vzxTQe
ffv8zGqwc9sb3odL4PP6QyuHXRi0JyL9rLMEjTMD9Pt8weUqx3clgHcMa+1z
B694papcB3a5vbTRGTzE/6h7mSSNcZNzvw04xKd++zPw32P20Ybg0mMjMsul
aNwdKduzBCzF0nlTLwP5Y5T9suoM9LeOv5lj4G9+De6l4AGPpxdkVtC4IPfD
mgfgkkKjDe7geW93FWWBTRWt0lasBKvuUbwBDlwY6OUpS+MTL9ZkOIEZ9mv5
VatozBZcFCkHLnhFLTcGz7rQfFkG7HMvW8wdXLPwQ6gkWPTMJb5n4KMhgQli
YM3Jrb1HFWC+ii78/OCA2eU30xVpLHXfZqrvNIOWyWYtlF9N4wa75GV54C+z
lgjtBE9ZaNTngO/1BfO6gXe2Dp67C96cbfejFpxuUT6RArZXl2mwW0PjF1U9
8jfARTj28h0VmP+8ECdf8I6DQTxya+H+SS93Y7CAxI0Du8DfdicEGIGftN8p
8gYnCT26bgDWNq892gj2GX9ZvQUsu5uv/pw65M8Rawtt8LR+QGS7Bo0P2FNO
K8DZ6/xkwzVp3NL2nD3pDP1g9IpvGfjFM8OgcbB0wc2Wb2B1+xa5X+AbqhUh
tBbU06Vh5xFwgNL0ABv80/ikZh/YQtrrge4GGsumdXi8BwsKuen93gifl++8
XwRWEFErX0nB+6JlegrAevPZa43A25cgsXzyvMWHJG+Ct5wevZgLnpLV+8mi
adzoXRuSDh6gxVMCWDTeY6gnGgd+e+rhH8FNNPbyfSfoDx464+yiDi7sFLzq
BxZyU2IswL9vxS70Bev73GrOBu+6lqXgBX4cEpS9YzPUp6vOCVdwQfLe/RFb
aPxj6/BBB3B001jRYj24HvijyQycVmgSthUcFWAQsBtcFJlj4wy2eN+tbgpu
3n1k/nNwllR1vDF4fvPrU+7baBxq2BVoCL7anKbUok9jVa5dVRgc/N40KXI7
jfXPehWpkPg+yHWvAntt/Jy6BpweLWDMAY/pSkavBtftqfyz2YjGV2smfJTA
fC2KB36AV7WOH5YH+7dwiZvspPGnci+/5WDPD/cuC5vQWIy3dFDEmdR33o0N
4Mq2TDFi+46CZFuw7QtuJAw2//SwuBS816c/Wgis2Vf5+agp5M/LbWaC4B9j
bzZW7Yb8DTSexwt2FB/mnNpL4wRVU9/xUww6svj7WDz4Zdf6N2Pg/UtHuevA
7bxImlh/+fgiiX1wP2/ps59gefl/W56DddokZX+Ae9eLJErvh/sl/4kOgi32
qBq9O0BjYf7We5/BDxI6XCbBs0yOKxGL9gYnyFhCvue9Tu8F1zp1s0+DE29P
JfeA1UIiLs0/SOMQ48bkT2D+stG63YdonNdwrK4DXChdsqnFmsZm6bwJzWDh
Y7YOf8Hqz5VUiO1zRSPkD9N4Umq6ugm8XMeh2w2saRjHaQSH7l56btERGsc2
Jum9A1sH+ZSb29DYVZVv2Ruw0ADW6rCD9y+z13wONhe5+pj/KI0NFZ3ePwOn
qXcYqIPnxSw+S0x5nrW8BJ6vs/dhHfgkf9Z5rWM0lo/di2vBb6QXvIq0pzG3
4/nTT8Dhe75aGx2ncb938KYK8EcPdbY72Oyt1Gg5WCHxnEsqWFeAvkP8uHdJ
0BR4TQbPf8TfT+3MzjwB892d8rEUbBpa/IvPicZp42djSsBiVZdCK5whXxRf
2RWBa+TPq30DO7nGKRG7XvVoET5N42yXmuFCcOPBYyuswTZorTdx+PTWUp4z
NF4utPdGAYmHDhd7mwuNPx437swD8zxwM2g8S2O+Md2sXHCBhNPwFHj4VJkn
8eFAu+iVbrD/V/kaED/ebdbjCrad/sbkgH1/rPVc5E7jD89ZKsQTqoOZlh4w
f9mbNVng4SwbgT4vGqtEzJLLBAet4+kV9qbxn6h/fzLIelYmlWmCXRU0PxAb
vet0CgJzBe8LJc4a3/dezofGKX+tR9PBtluNUmx9aWx+GTXcAbd3rqN6z9G4
uf5VQSr4zLEmsTn+NL5F514nFvx+engtuPhS1Rlibb77KefBDd4eGsTRSoqC
Mudp/MRJozgFvMtdssUqAPJZP+xZMrhOlN+5MxDen98imAQ2dtfNFrhI42vF
CoO3wa2dgd80wPq82Q3ETBbvwVBwxioUSyyky22oFUTjgN5ERWJTz+mVEcHw
vOeM2S1wV8+PD1tDadz1/HF9IviYvvoCZ3DB7+Ai4pF7p3cmgFO2ut0k5vYZ
qfkOlpr/7BSxrPhQ/q3L0B8C1cWJHQ2ZyxNhNH7sPOmQAP5V8AnlXKPx1v5k
5Xhw98EXMc3g3ImFS4lfCRQOT4PfJaQKEKcdCrq9IxzqY3D+tziw2Zw1/4bA
RaLrU4iLDntVrr1O49KGI1LErqJidHEUjfsEdqyOJfVX9jfqE5h2/ixJbHS0
f2B2NI01fMJFiGXLyxLNwUOja0ZjwM3HjkxPgjeGnSkjXld1v4yKgfWw4ttF
/POkoc6TOIjfLruQGyS/fzWPDoIpk+vexPd9rXKXxNP4jvx7J2LHK67Sp8Fy
ZQl7iD/l3OKXTqBx2SUFWeKXnB+NvomQb34ytdHgJIeE4xtuQ//kpIgR+32X
k7MDH5u/7T/iA555XeFgr45pLmLxS7Um/eCYj4kDUeDLmcNaMUk0Tj2UXUPs
1reF71cyjSdkGXfi7XYDiXlpNFaOX8WOJP1SZHloB7gpdKSHuKXE2J3/Dpx3
NJ+1EVsLFZpYgvOO3HxB7FboyS+QDvO7wb5LnMQ929kqg8Z6kr9OEP+6KbNF
OAvOIyFa09fBpdt2q20Aa8tf/UXs/z1Q0hb87uvwEPEc3f7xR+CQ8809xNID
93LssmE+itLPiQ11KPGKHBovi8q/QXy7ZS9z/D6Nw4J1NxI/r1EfjQR7WG/U
JB4pEP5TBhYU27CWePO1OlGhPBqv696+ivjLNk3tHDCV83oBscIjseCBfNhP
arWGIki/SWiWPVkE5+GxvZnE7ZfyVKLBrczaNGJejzDtiiLSHxckEZuZbTWa
+4DGI9ZMDPGYUJFLLtjItCeYeKNf5JPBhzQ2FZqwJ66xNrV2egT7Ue85VeIu
5bf1ceCWV6+ViSfGtmvVgo+OySgQr76iKyxRSmPrzo/SxFGPtMtfgA9+SJhP
bDNfarFcOY0fxa0fDyf9s4bztqOSxrMfRNUQS1yz3zi7CurvYEw1sabF13R1
sO7C25XEjiNdvpfAUSEVJcSNEo3KWo9pHJ2yPpc4+WxJ8PVqGted+C+GGK+6
iAxqoL+miDsRV2jmPDsN5glvPk6so9dkHA+Om3vDgXi9nYw1BxyTutKOWCm1
wv9KLY3P3ra3JF4gNVb9rg7mtzh6O/E38WNbLV5Avb/bvZrYRv7qqwDwgVBP
JeLu9Q/MssF8aikKxB1mvHbT4Hsq07LEDddvX7z1Er6/eDZKEpcKt9b11kN9
2/CJEl/hNzA4/gby84XV2DWy/zp8fVwKDlt5bJR4xavz2nPewnk1032E+GFE
6aq74P3VhWzibonV/H0NNF6wNvoTsbqGyNMjTZAf/76+JJ6OztYpALf4ujwn
fjaxrYC7mca9IQJ1xJaV/slJYIrRrya+aPDjXNd7Gi81ly4hbrV6T1m0wvl5
XDxj5rpPoXseWM60L23mfXERBfxtNF74pzKFOKxxh0IhOObzhVvEWLdugVAH
jXP2H75BfFepmF3RSWN/iX3BxHy2LtaOXTS+oNN4gfjQTdUW8U80tqy09See
L5pZfaobzsNXXnsSe/2KjZX5DP2dvnWS+DD+6/8EHJj905FY/7KNg80X6L/J
B+yJF8mo6Nz5Cs+/st+GuMjoaYdCP8z3yRwL4oQYhZoX4Mvl7fuIA3qv5Dgy
sP9uL9lDvMvD3DeHTeN/7fEmxIOpg8vVBqGe/v40II4/0nKlC9ycw6NPrCdT
NR02BPl3RlKPOOlWeDszTOrLYzOxaZzGjdQfEH/Dyo3E2eKzXLl+wv5lnao9
E4+oFpODv+B6dv564uKrnnMXTcD3W5dNasRKqjcbLCfheb79a4hvvX0cmTJF
46/ZOcrEgaICS1X+QH59ClpFPJGn3Onyl8Yc3Xg54uMmxkmP/sF57lrtypnx
XL8hr8vDwsJaVtLEJd+N+57ysfCDkf2SxMtNBDM3z2ZhCa/EpTPPz3tiXy3I
wvwK0ouJ2SI+iliIhZ8MdokRH2VBfxdm4fBNdxcQ956Y8+nuPBa+sSdn3sz6
Jrx7dGghCxt59IoQt72IjVqwiIWPhOoJE28oPPVJWoKFg6by/iOOS9RTUpFh
YZWvEYLEsrIb7mbIs/CHhILZxHnZygoyq1k4MU6Vn1jHmUfi/FoWDtOe5iOu
Xdcm0qPJwt5zeWdccnEi9stGeP5+Xd6Z+LcsWtGPWdjF5i4P8cta00/79Fj4
hJvUjPuLriQ+287CfIP3uYlPqc0bbt/FwvdlD8x4LDtq09AeFq5KEJuxj+20
QL8FC2vGdnIRc0vaNvRYsXCS5/0ZF7j01W+zY+HY+KAZ2750fJbryMLN/nYz
9svVNC8+xcKGJkYzjgnnYR67wniStWZspH/e1dqLhX92yc74/78fsvC1t2Iz
/h+3Zogu
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwd2Xk4lU0UAHBbpAXZQrKUShQia3pnKlSWJJKUECoUoihRSGTNruwkFZKs
2SVUlEqSkHyW7r32kC3qO5N/PL/nfefOzJmZM+c+V/K08xE7FiYmpgZmJiby
/9+fD4UVZcuO2e4bQ3JR3ErSYPnO/qb3amPopJT4mcPgeBvcoic3hp4foN6m
gavq/66/LDyGXCK97u7xpfDpgz4CwROjqHfDvMJNPwpfb0++9TB9FNVoT1qz
36JwE4fgPk7uUTTyhTlWDpwmsNPlGPsoEnFY89oU7Bb+Qb1waQS5hyvIPQTL
nncwiB4ZQXJfnBb2B1B4z5bsrVNNIyjl3HBUUCCFVU7qVokHj6DrIQMvVwVT
WGbTrumMNSMoeSHGTA0cpGHpOcA5girttUdtwJXqmlJKLCPo9/4swQowj49w
8OzkMLrCds7ePoTCkfp2qiKfh5Gb9zBXYyh8fonw8aLEYXTOefL4jTsUfldW
tpS7Yxjd7skYywYfG/l700F2GD00ML7ZDm4X2/1YcdMw+iFblLs9gsKspQ9u
9wkNIxv65b9dYEdhgexqpmF0yno+Uy0KLC97+HjrEDI2Zpr4GUNhU7d3bzK9
hlA7+4l0kVgKF/kyrxr2GEJm5cVH9oHHhpSb1dyG0ClJx+IY8Np7uyKH7IfQ
ufHPnqpxFOa/yjf94NgQ8grJWeYdT+H6yi4+151DKOul6brlCRTOfPH+MN8U
A0l7PHurAI7rH49UGmegHJlV14+D72amzBwfZqD8yBe92WCOFS2sZf0MVGG5
LcsgkcICVzokatoY6MNv5h3RSRAv6WWK/aUMNK/0REcslcL/GTKv1PdjIFvO
p7I64G0VyxhyNxiopSefxwl8s94nWdCLgTKDijqrwEGfPjtOX2agQ98rnCzS
KCz60aaFbs9AGcFNcUnpFLaYf2Scd4SB9P6j/RDJpLDqccP+a1sYqKSE0bwX
7KdT3zEsxUASocP5DuC6Cc83lhsYaEZl3LMcXNw2d9N4PQOlhc5wmT+gcJ6a
RYE9HwNNqy5TvZdF4YviZZV6TAyUHL4hcO1jCje4LU+v7qajOdzwbi+YfZOO
0OVOOjKZOsvvBHY5ye8g30FHq8yepNeDtbUv3Xz6iY68JNUqL2ZD/zPind1N
dHSyyOBncw6FpTlY0n+U0ZFI55UTPnkU3jq5bzE0gY7cQ9dl5ICVr2z9XXCX
jlqpano7uG2sSKg7jo6C77O6b38K8VuoSVCNpqOF8+ERneCoo/e38oXS0de/
9xt2PqPwYaUmdrPrdHR303t5RiG0N9/FO2tLR8dERaPXFFF4aqrivwgbOhLk
s59RJ+65O7DtNB3FMrFWBYO/DsS4O1rSUVSXiu62Ygor7WM+z2JORyGRKbbO
JRS22uDyLMaQjq4vXbj36zmFfzyaMtupSUe7p8sX15fB+xyKWly76GhxiMNK
B7zHaG6JoU5H1zrSN8eD/fDLj1mqdHSl8HOhWjmFq92+5igr0dFF+90t1ypg
/6wLqn8gQ0e2n1exslRT2F1ku1qVCB3xP154tR3sKiObVipMRw1e9NDj4A6r
0YZCITraLFUv+AwcMDhAPROkI7rrNRmrGgqf4HsdU8tLRxd4hoyqayk8e7TG
SG4lxFvvVZrnSwpTFkp8Sks0tFm82C4LrHDK5qPlIg19mcyQaQUXjEXMhv2m
IbWE60Vb6ym8g8/YdWyehhboyq87wG96zb/XzNDQ9YDMcZVGCtsXVkRnTNBQ
4Atfauo1rI/fGLfZIA1JlAqqir2hMFdSSnj+AA09z82RPwiuYYRtWgEeiv8s
kUqel3yNqe2jIX2nrax6TRS+kZSso9FLQzzrPr7KaIb8gk+ct+yiobuXJIyO
tED8vm9htWulIQWH4oPeYIuUGeVvH2nojaXu3kfgo43zeqbgBd1LSn/Aa/Se
rtP7QEMnJV8LZL+nsL/sdwnUAuNrce5k/gj5u8zHz7CJhh5tqbF59gniGSou
tvwlDWVa/7nyFTz/zdEuvY6G0hJ3hzO3QbyseQx2geO5K58bgXPNPOddXtBQ
wOzz1ZNgXp+POf01NGT7qqBUsZ3Cuwfs7w9WQn9ns1YWdVC4Wdgm4mgpDYmm
D0p0g3XW8Ikwg4W6pFTYvlLY/EnCliclNMRteN/KBKzQu9DEDv6jklY8DXaw
aRatLaKhbvYES+UuCl8bWoN0C2joXlZYYck3Cl9RUDYsfQLjqbog0wdG4aHL
zoMvtRmkr+6hcM+87i5J8CEWrju24GjONMmwXBpiORXuwPudwm/Lnesccmjo
vMAdSadeaK9yLFXzMQ1R/hF3NvXDfRDxzFr5AQ3JJrqwG4HrhEO85zJh/AWH
vb3ArSucmSrBk995HD+BfT4lq2mBH+6K1PEdgPdH31oevw/rOxW51D1IYTn7
lpnYdBrqs452jKFTuHHr6yHjFBpSrFr/txKs1H1zbBP4ptCjqEGw9TqGxlwy
DUm9ryxTYVB4qWAwJxlsp/mD4yt4/TetvuEkGqILqmeuH6Ywc1czik2kobHm
nu6sUQqnWp7rFLoH89li7/IerOXLtmHqLg3d8ZtinQPTOjUevAMrqC+XPThG
4Qm+Pydvgi9m7bg6DH7BURL4M56Gpn38BRQmKHxc+KZnRxwN/VaWOVQ2CfNR
HHZviaGhnYUnBP4DH3a8LJkPPq8Q1r18isImRksLkeBumQkHM3DXmX51U3C1
eEngLPgpj9z33mga8uHc+0L5F4VF+g8H/4miIfZvx3cWzEL+fi0RdjwSxm8e
8vsreCbCLwqDPb5U1jHPQXwd4qq3gOkfxY2MwK/oA0EzEXA+GgcvTIB9zB78
iAWH5l98KLdA4T+24gFdd2iI1z9IJGeRwtkvlTt9wmlIs+fEvnZwxgndYAfw
GTW588xLsN8kv1magMtGWquOgZ1SfD2lwVZHRa3Z/lDYY+fimdYwGsrb/PSh
xV8KJ1x9TtsGPvimbScPC8JGswnTCyE05LrxocUucMRezj46OMn7asAZsM34
59F28MQOsY5K8Nz9astCcFzC2Wv2rAg3xBk8vAAecFx4UceG8LTupQRaMMSL
S8LwMgfCd7tpb8aDaGj1k6SYZPBNJVeJPnCCnnBnA7j3tn1oG7joNq+d4HKE
M38LZZaB6SzLrpWCubm7WvzBh2cZWfOcCHf3xvwSA0v0Fv7xXoVw+Uq9p9a3
aejJdQWtLHDKvKy7KVhj/ZOgFvBYXdYhPbCJeRa/+GqEzR7/VlIG3267K1ML
trgq/Y4TPPHa25SFG2EnFZ0NJYE0VPNsf17AGoQ7XB4+EAFT2+2OFoA3b6U9
5AFXPvJb/Aaea5OsYAc/T63SVeZFePcbfv6pABoqCFOi9YPd1n0OfQvOtBeX
2MOPsGb6NV8/cLDkbORvQYSPJT2onr9FQ8uT+dW3rEX4tdJAzk9woJBi7xFw
3sGuLAbYn/uCXDZYqzW24SvYe6mvyUwIYab1ZffLwS5fW1hLhBF+u3f9++vg
o5FZl11EEd5/aK0BD7hSzvFwIric3X+QE7zhrbxsI7jELe02K3iMvax33XqE
3VXSx2b8IT5ezXqvwJds21V7wOVnJyTFxBFuD+LKzwOLUxotzZII1/PYNJiC
A7r+PJoBl/laRRuBR668vCm5AeGtkpwO+uDnhfrqHmBb6Q079oKPbLXM3LAR
YYc9A1JyYH9+f8+rUgivnfaK4wAzht5t3rIF4an9+7Rrb0I832qKGYLFFLtM
K8FeeTkCHuDNAZFOz8E8rkFsr8B+p5Xy88Eq81p9Z6QRPjKgdS0d7MdRmZy1
FeHlynHS/uB1Utn8m7chfHv6VoYBeGCZ8KpD4LxTwWd0wXm0QFZ3cI93vPx+
8N4cu8kG8KmI3A8YfE5R8oPddoSzUxkGO8FF+G7IAzmET6vyyYmCDSwCWDbt
QHjXj8Qj436wvqJxJw6Dn3fMO4+A6zofFF0D+1upRDHAamYNZ1rBt07JDPaD
pYzZmm8oIixnsa6+A7x4wC+6UwnG91PV8iU4Z+d1qQgVhF1/lH5OBJ+ZCvOu
AHdkLd64B5YoSG7/AVZXUJSLB8fJV93erYqwKPfRuCiwn8ziyBD4x626mCCw
uYRnsbY6whecMrWugDlXuev83oXwRaVhbTOwNLdC5UZNhAN8TP1MwTq8Qzv0
wc2GQS9MyOcJnVqfDE6cVTpgBF6Q0pmmdiOMbki564JHdgtm+FEI9wu8OLwb
/N65ZIlzD+wPl2cDUuAxVxc3RbDLII/rRvAqdxmGOZjj8HPmDeADXiltOeCr
2R+2iINrbwfkGOxFeGZnfbgwuCDd9HjkPoTpNXn1XODYTzNFQjqwPtH2ZQu+
cP4KjUK1wKNN/c7z4KLoXBsXcItrhPQcuM34NO9rcI+Ia9ovMG/bO2eP/Qgf
tBh/PAEOb8uUaT+A8L60bAkaOPDzkbRoPYQ1Tmy69RkcV/zEowZc8kP8Whs4
K3a54TB44Uav6ydw49Hqpb36CK9peHj2I5itfeuJSbCm8G+7d2CfdiZBo0MI
69puLWwAX/2SF8JlhHCgn7ZXqS853/lx6mBNW/vHJeBzXQXptuCfmWNfisFm
30tKy8HO7PzqRWAVWnX/mSOQj92DVz4DT8607KoxRli8Q2k8G+wgOD7sbIqw
iuCDjFTwaaGfMwlgU8kXsyng4yJTzI3gD3d+GxAfEJtdK3oM4e0i9UtJ4M2b
/+57De6TcXFIAPcpcydJHEfYwD3NPRZsflRe/+MJyLcPLA6FgosTu9zmwdd+
Sr4LAfP0BSZKnoT9b5KvT9zg1Dt0ESxzcfOhYLDC7cggXgvYH6NHzW+D2Sum
Go1PwXpZlsb5gwslnu9pt0J48l14vDeY66yt/R/wac+j24nPPeGJ3GyN8L29
dS+9wGIa9r3u4Cmh4Mlr4GBjkRtrTyP86EvJMU+wVYBXpZkNwgV+j5EHeNUI
Vu2yQ5gaOXfjIokvd3gt+xl4vr9BgjhTseugInjF6ro6F7Dm1csng8Ap8XeX
E19gz/ZVPYvwJ8ukRCdwiwTf2+hzkI/WivQ4giOODlrpOyL8V1Wy5Qy4+4ri
kAeY0k72JZZOuuF2HyzElqhMXNsnHLAArpUWSrUD/3Q+lPPoPNiC+Yot+Ehw
6S82J4SLEtrxabBATVBwlQvEo3PV1lPg+s2+Cj/AByz3j1uAL4Vfaee6CPEx
/VZM3GpxdoMV2NZcWIs4YlGrnMUV5iNcZ3uSxEODaWi/G8J6jidLzMEsxe4H
Wy8jPMTLE38MXCDqNL4APsjx7Cyxtb9d7EZ3yFezSWrEtcYm/10C+00ad5mC
vSd3XF3rAfnAb4cU8Zz86KOTVxDO/a3z0gQ8nm2znOYJ7b/2KB0BB+xk6eO6
Bu1T36wmFqtOq1ABn7oxTjMC63/85hQA/iQ2nEScPXvs8yYvmP9sPCexrZZ+
hq03wgk5nqOG4M5vOzX7bkB7J/5vBmDXs58EVvggvJqnooqY8+fF8R3gK2ZR
KcRqbE8zfMHTTz9aEcfKbOWU9EVYxCSEpg8+7LG+3dIP4crK7CU9ct552F2+
+UN8Fgt0dcGGHto5y2/BfTlVLEfc8c3/hxL4Ljudl5iRzWoRDPbf19F1kMRb
m1lXNQDhkfBeZ+IjVxc3RgYiHFpmkHYA3PPf5BetYIRnT6RI7AefPaDI5wIu
/zTNSTyRd/FQIviSy8UpHTCz10T9T7CDUHcjsZTg2LOUELgPVF2ciR10GSFz
oZDv8yxeaYN/FXxHuXegfpAviNAC91q8iW8DqwVG3iB+u7xwfBH8+lWIE3Hm
qYBUgwiY7/EP+sQmK7b/HQO/VoxdQVxk7Vm9IwrhNO6h4H1k//EI7C6NQfg6
a37yXnL+Kv7EfAcLmabeIdY/Qx/hiEU49UWmL7FUZUWSGfiD2U874razpxfn
wRxvwuSJd9Y8rdCMh/nalzTuAU9f0NWou4dw/tgPVuLWX21To2BJLptZDH7q
bflEOAHh6GvTQ8QOYZckLoKznpq2En/PTWGXSERYOoY/g7hpeLLVOwnh8A/H
tInT7BMd1VOhHp3lS0Dg6z83bbIDu3HM3SE+cTW/JwIcqD96i1gwqMGIDt7M
stKVOOTRuGp8GsKKU9x6xO60fWy/0sF6W5iI9exGkvIzEX5i/OEyRfIlt1hw
F9hkqvkCcftzQw/2B/D+fJsdsdWqQqOT4E09XKbE7oVX2ZdnQX14X1yVOI2Z
w8XyIcLfccbv3WR9kyX3cWUjfEIzKYy4fL+xgno2Gc+6QGKfn/7rbcHJgVk+
xCu06bNl4HymbjdiiZG8XLscuO+oRnNiXQ1NwapccMZtGeLUdlOG41Oob1MP
f9QEv65XnIoGz9yxe0s8UcC1VAGulfV7Rbz3TiPPqnxYf+XWKuKB/SpqueB4
rbfZxNJlAoEjz6D+wGIBxAWJbVIXihD+HDGyh7gzKF8uFvxH4L/dxKxXQtWq
wKWMLnViExMt/dXFCIcdHdhBPLOqyO0JWEMebSDedT26brQE6tsUfjbieqsj
Vk5lCLMs+9u8i5w32ffN98BylTaviedm9FQbwJtDW+qJt4Vpc4mWQ343KKki
jilTq3wD3qP27imxDa+40KZKhEOW8cQSs9QPv++qRniD10MbYtE753Zx1CD8
LK7SiljFfDBLEfwttd2C2GGixzsIXHdS2Iy4VbRVVrUW4aqEDn3i9MvPA6Ne
wPcXKVVVYrzlFjpYD/1zIm7iKpXcVxfBAwMrVhNr6HwyTADPaXSuIFa2k7Qa
Bt/AN9mJZe5X+YQ1wH0t/GdJA8wnPvPiYyPcd6ejRol/CJ7VMn+DsPf4mvfE
NpvD3/qBMwX3vSPuVS42yQGbC3k0E3eZsNotgl3u0V4Rf4hKvZXSBPWawFAt
cTlXR2NfM9THshcLicPYDx50bIH6vNEhgdjMfrC2HMx72T+eeMNbX7UV78l6
P4whLoks3/IYPFjLfudf/6Lb2GkfIB82bfMnVlTifnn6E9xnKkvOxIuxORoF
4B/v7l0gfjW3v4C5DeGHL3c7Ep+s9klPAw84J54hvnVw8kbPZ4RfWOZYEHdY
ftY074D7Yd1Kg3/PvQo98sFuk3Tdf/3diyxg/4rwytF3B4hDWw2kC8GfRnO1
iLF2I9+qLoT1Yyo1iR/LlA5VfYN8KMktR8xm62bl0INw1K9UGeJTyfLtgt9h
v6Tu30LMy/PohXMvnN+1XyWIPX/dvSvZjzDb9DQ/sTX+41MHPvf+BC/xgRAb
e5sByL9vW7mJ10rKaTwYhHotZXwFcZH+yy5pOtS/qJOZODFeuv4NeH9Z6V91
sF9fWK4DA2H2SxlLxIevmHnnDkE+OpMyTzx6f1RMYRThj8+3TBInnG4P6wG/
tN8zQawjWbMYOgbfD3rPjhGnpUR0MsbhfDZ9HSI+ck8p7v4k1OslBwaIcwSX
XWKahnpmGv9HzBbTbmTxC2FmB+se4tLwq6vXzkG+quH9Siwjn/zh5DzCbVqv
24lT3tdGZyxAfaWR0Ebsz7NcRG4J8t+y8A/Ec/my39z+wPnWe9JC7GhkmFb2
F+7b7/1vibce1IvewIxxlG/UG+LuuYdT1iwYM/WkNhLfecRmks6KsZTh1Evi
vWbWRb1sGPcfCXhB/Iujml+CHeNeZuMaYsVUST9PDowzZ2WqiF1Ubo23LcfY
x1CjgjjvHf2k/AqMV167VkY8YqvfFLQS4zuejFLipK+lzjxcGO/rtikm1j+0
USCeB2P/b0aFxLxRSW3GfBhvk7z+jPjLZ4EYHkGMU13Z8olF1ZjDa4Uwnrna
kUdsnTAS6LIOY+nDg0+IO/d66U+uxzhebts/Gw+vXHNJAuOKhehc4r7Tj8dl
N2KcZbX6ny926rT0b8LYOjAth3jn3dseF6QxFmsy+OfZo00SszIYy41x/rOG
4nW2S9sx1tD6lE3sxaVIn5CH53uz/rmtbGrwviLGhyyv//N2u+J+U2WM69ac
+udy03W5XaoYJ3hr/7POAd9LVhoYnzLY8c8bM7GGwm6M7/8R++d/vx9imJ8+
zz//D22eeKE=
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk41c/3AHCirEllJyH5UsiSXWZuSRSSEEKl8pG9xZq9xb6EspbKFskW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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xc8le0bAHBCJKtCQrLyUspKSXI/z0lGRSokIRkNIyOblPGWkGSvplWS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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xc4lt8bAHArJCHfSEYZqTStkOScnldGZTRIQiWl7IaZUgiRURQiioxs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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4VV0XAHAiQwqJUjQY0vAKkSHJ3jpXaJAKSZk1kalMSWRoQJkLIZUx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      "]]}}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0.5, 1.8626264880202026`}, {0.5, 2.062193611736653}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{2.5, 1.7827996391094965`}, {2.5, 1.9794951437082497`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{4.5, 1.7041214378375824`}, {4.5, 1.897902773859036}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{6.5, 1.6266089039881795`}, {6.5, 1.8174315725869616`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{8.5, 1.5502798370993072`}, {8.5, 1.738097236485152}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{10.5, 1.475152877886938}, {10.5, 1.6599161322774232`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{12.5, 1.4012475766638997`}, {12.5, 1.582905345101873}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{14.5, 1.3285844698129048`}, {14.5, 1.507082731694542}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{16.5, 1.257185165575327}, {16.5, 1.4324669791090385`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{18.5, 1.187072440667638}, {18.5, 1.3590776697060833`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{20.5, 1.1182703495486006`}, {20.5, 1.2869353532614909`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{22.5, 1.0508043485501468`}, {22.5, 1.2160616271746314`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{24.5, 0.984701437577222}, {24.5, 1.1464792259144092`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{26.5, 0.9199903227091756}, {26.5, 1.078212121018299}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{28.5, 0.8567016038420934}, {28.5, 1.011285633162959}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{30.5, 0.7948679925598173}, {30.5, 0.9457265580507281}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{32.5, 0.7345245667987728}, {32.5, 0.881563308098053}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{34.5, 0.6757090707033578}, {34.5, 0.8188260721524445}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{36.5, 0.6184622705367038}, {36.5, 0.757546995667392}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{38.5, 0.5628283808857735}, {38.5, 0.6977603838560856}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{0.5, 1.8626264880202026`}, {0.5, 1.7827996385336224`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.5, 1.7827996385336224`}, {2.5, 1.704121436694121}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{4.5, 1.704121436694121}, {4.5, 1.6266089022855397`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{6.5, 1.6266089022855397`}, {6.5, 1.5502798348460267`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{8.5, 1.5502798348460267`}, {8.5, 1.475152875091689}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{10.5, 1.475152875091689}, {10.5, 1.4012475733354948`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{12.5, 1.4012475733354948`}, {12.5, 1.3285844659603054`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{14.5, 1.3285844659603054`}, {14.5, 1.2571851612076506`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{16.5, 1.2571851612076506`}, {16.5, 1.187072435794166}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{18.5, 1.187072435794166}, {18.5, 1.1182703441787878`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{20.5, 1.1182703441787878`}, {20.5, 1.0508043426936318`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{22.5, 1.0508043426936318`}, {22.5, 0.984701431243838}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{24.5, 0.984701431243838}, {24.5, 0.9199903159089632}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{26.5, 0.9199903159089632}, {26.5, 0.8567015965853138}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{28.5, 0.8567015965853138}, {28.5, 0.7948679848569675}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{30.5, 0.7948679848569675}, {30.5, 0.7345245586606032}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{32.5, 0.7345245586606032}, {32.5, 0.6757090621408911}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{34.5, 0.6757090621408911}, {34.5, 0.6184622615612564}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{36.5, 0.6184622615612564}, {36.5, 0.5628283715089811}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{38.5, 0.5628283715089811}, {38.5, 0.5088555703208563}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{0.5, 1.7827996385336224`}, {2.5, 1.7827996385336224`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.5, 1.704121436694121}, {4.5, 1.704121436694121}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{4.5, 1.6266089022855397`}, {6.5, 1.6266089022855397`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{6.5, 1.5502798348460267`}, {8.5, 1.5502798348460267`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{8.5, 1.475152875091689}, {10.5, 1.475152875091689}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{10.5, 1.4012475733354948`}, {12.5, 1.4012475733354948`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{12.5, 1.3285844659603054`}, {14.5, 1.3285844659603054`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{14.5, 1.2571851612076506`}, {16.5, 1.2571851612076506`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{16.5, 1.187072435794166}, {18.5, 1.187072435794166}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{18.5, 1.1182703441787878`}, {20.5, 1.1182703441787878`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{20.5, 1.0508043426936318`}, {22.5, 1.0508043426936318`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{22.5, 0.984701431243838}, {24.5, 0.984701431243838}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{24.5, 0.9199903159089632}, {26.5, 0.9199903159089632}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{26.5, 0.8567015965853138}, {28.5, 0.8567015965853138}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{28.5, 0.7948679848569675}, {30.5, 0.7948679848569675}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{30.5, 0.7345245586606032}, {32.5, 0.7345245586606032}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{32.5, 0.6757090621408911}, {34.5, 0.6757090621408911}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{34.5, 0.6184622615612564}, {36.5, 0.6184622615612564}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{36.5, 0.5628283715089811}, {38.5, 0.5628283715089811}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{38.5, 0.5088555703208563}, {40.5, 0.5088555703208563}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0, 1.8626264880202026`}, {0.5, 1.8626264880202026`}}]}, {{
     InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         StyleBox[
          SubscriptBox["\[Tau]", "d"],
          FontSize->12], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.1",
           FontSize->12], 
          StyleBox["  ",
           FontSize->12], 
          StyleBox["ms",
           FontSize->12], " "}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[1.]], {29.71334222735029, 2.0245753021046857`}, {
      Left, Baseline},
      Alignment->{Left, Top}], InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         StyleBox[
          SubscriptBox["\[Tau]", "e"],
          FontSize->12], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.5",
           FontSize->12], 
          StyleBox["  ",
           FontSize->12], 
          StyleBox["ms",
           FontSize->12], " "}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[1.]], {29.71334222735029, 2.2467975243269085`}, {
      Left, Baseline},
      Alignment->{Left, Top}]}, InsetBox[
     StyleBox[
      TagBox[
       RowBox[{
        SubscriptBox[
         StyleBox["v",
          FontSize->12], "r"], 
        StyleBox["=",
         FontSize->12], 
        StyleBox[" ",
         FontSize->12], 
        RowBox[{
         StyleBox["0.01",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["mV",
           FontSize->12], 
          StyleBox["/",
           FontSize->12], 
          StyleBox["s",
           FontSize->12], " "}]}]}],
       "RawBoxes"],
      FontFamily->"Arial",
      FontSize->10,
      Background->GrayLevel[1.]], {28.37755102040814, 1.75708974486648}, {
     Left, Baseline},
     Alignment->{Left, Top}]}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{-1., 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{0, 
      FormBox["0", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {20, 
      FormBox["20", TraditionalForm]}, {30, 
      FormBox["30", TraditionalForm]}, {40, 
      FormBox["40", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{41., 25.}, {55., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{0., 40.5}, {0., 2.5}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.9191663145825176`*^9, 3.919166319060317*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, -0.7}, {0.5, -0.6799999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.5, -0.6799999999999999}, {2.5, -0.6599999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{4.5, -0.6599999999999999}, {4.5, -0.6399999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{6.5, -0.6399999999999999}, {6.5, -0.62}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{8.5, -0.62}, {8.5, -0.6}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{10.5, -0.6}, {10.5, -0.58}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{12.5, -0.58}, {12.5, -0.5599999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{14.5, -0.5599999999999999}, {14.5, -0.5399999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{16.5, -0.5399999999999999}, {16.5, -0.52}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{18.5, -0.52}, {18.5, -0.49999999999999994`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{20.5, -0.49999999999999994`}, {20.5, -0.48}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{22.5, -0.48}, {22.5, -0.45999999999999996`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{24.5, -0.45999999999999996`}, {24.5, -0.43999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{26.5, -0.43999999999999995`}, {26.5, -0.41999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{28.5, -0.41999999999999993`}, {28.5, -0.39999999999999997`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{30.5, -0.39999999999999997`}, {30.5, -0.37999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{32.5, -0.37999999999999995`}, {32.5, -0.35999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{34.5, -0.35999999999999993`}, {34.5, -0.33999999999999997`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{36.5, -0.33999999999999997`}, {36.5, -0.31999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{38.5, -0.31999999999999995`}, {38.5, -0.29999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, -0.6799999999999999}, {2.5, -0.6799999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.5, -0.6599999999999999}, {4.5, -0.6599999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{4.5, -0.6399999999999999}, {6.5, -0.6399999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{6.5, -0.62}, {8.5, -0.62}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{8.5, -0.6}, {10.5, -0.6}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{10.5, -0.58}, {12.5, -0.58}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{12.5, -0.5599999999999999}, {14.5, -0.5599999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{14.5, -0.5399999999999999}, {16.5, -0.5399999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{16.5, -0.52}, {18.5, -0.52}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{18.5, -0.49999999999999994`}, {20.5, -0.49999999999999994`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{20.5, -0.48}, {22.5, -0.48}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{22.5, -0.45999999999999996`}, {24.5, -0.45999999999999996`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{24.5, -0.43999999999999995`}, {26.5, -0.43999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{26.5, -0.41999999999999993`}, {28.5, -0.41999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{28.5, -0.39999999999999997`}, {30.5, -0.39999999999999997`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{30.5, -0.37999999999999995`}, {32.5, -0.37999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{32.5, -0.35999999999999993`}, {34.5, -0.35999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{34.5, -0.33999999999999997`}, {36.5, -0.33999999999999997`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{36.5, -0.31999999999999995`}, {38.5, -0.31999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{38.5, -0.29999999999999993`}, {40.5, -0.29999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0, -0.7}, {0.5, -0.7}}]}},
  AspectRatio->0.2,
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"t (ms)\"", FontSize -> 16, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox["\"V (V)\"", FontSize -> 20, StripOnInput -> False], 
     TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{0, 
      FormBox["0", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {20, 
      FormBox["20", TraditionalForm]}, {30, 
      FormBox["30", TraditionalForm]}, {40, 
      FormBox["40", TraditionalForm]}}, {{-0.7, 
      FormBox[
       RowBox[{"-", "0.7`"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {-0.3, 
      FormBox[
       RowBox[{"-", "0.3`"}], TraditionalForm]}}, None, None},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  PlotRange->{{0, 40.5}, {-0.75, -0.2}}]], "Output",
 CellChangeTimes->{
  3.9189932955210476`*^9, 3.9189933265856853`*^9, {3.9189936207978983`*^9, 
   3.9189936378399563`*^9}, {3.9189936689762*^9, 3.9189936784841757`*^9}, 
   3.9189938752004704`*^9, {3.918995236896613*^9, 3.9189953717697845`*^9}, {
   3.918995448402794*^9, 3.9189954880442696`*^9}, 3.9189955484914293`*^9, {
   3.918995586834073*^9, 3.9189955986817226`*^9}, {3.918995719267539*^9, 
   3.918995724358102*^9}, 3.9189957641570625`*^9, 3.919045719467263*^9, 
   3.9190457570114045`*^9, 3.9190457982558703`*^9, 3.919045848390644*^9, 
   3.919045891177925*^9, 3.919046135499894*^9, 3.9190468927573175`*^9, 
   3.919046927854157*^9, 3.9190469624583406`*^9, 3.919165406285101*^9, 
   3.9191654718272643`*^9, {3.9191655158768663`*^9, 3.91916554137982*^9}, 
   3.919165592382147*^9, {3.9191656307412305`*^9, 3.9191656369591627`*^9}, 
   3.9191656863230677`*^9, {3.9191657876247454`*^9, 3.919165797707838*^9}, 
   3.9191658677048283`*^9, {3.919165903013497*^9, 3.9191659236632724`*^9}, 
   3.919165999978963*^9, {3.919166073035132*^9, 3.9191660928951626`*^9}, {
   3.919166168192665*^9, 3.9191661944568014`*^9}, 3.919166290964291*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0.5, 0], AbsoluteThickness[2], LineBox[CompressedData["
1:eJw1lXlU0wcSxwmXpkHBlGBBF8MpJL9olRSpBGaAqAjrqmhAUHFBuU9BBaoo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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwlxws0VAkAxvHrkVVimOzWZiWZwjiVaEdifTMp2pbEtpue0i4hj7WV9VYe
0RqV6HGSpVonr3YV6awGFUqKoiiPapgxY8bdJJqoe2f2dvZ/zne+87PcE+UX
pE0QhDezT/9/YlRFuu8MSCH4E4ZtHlpaYljQ3i0VyQRfZpafo60thlNXbdBU
EsF/6GRjNkNXDEHuDp+TiQT/bNQm3ix9MX4LmNXcGkfw7V8Vh5sai/F8Ta4V
/wDBD2gQ9NosFKNrWaLAP5TgNySmXfPli+E5rXbhbib4FQkhwbOPiMGaWwvC
luDzZHVcm3tieFXu1xvSIfjSppgPlN4g8vqP/5ncrMEdq/wHq70GEdEmWcQ7
rME3Ywuu9AoHse1kdbe/pwZyV4MTg12DULGiBacMNbhO706+OHcIdaKIi/G9
aizkcpKatwzh9Ikcl/JKNW4+X5/kUziE6APzHcUpaky87ctxeTmE/B2Pu7dv
VcPnUE+Z2FyCK3fz2Pt5avQdd7z3eo8EVn1PitLnqKFjoJ7ceUmC0hvrRXHv
aGzX53J4Cgm4CYn1sc9o9MQ27rq3VIoZ3mrLvSIaY5vvlP0TIcVEjeuLBSU0
nKqXqEyrpXCy1nd8lkPDPGnKr3NCigTr96OdcTQc7ttdVTkPw+SN8/ueIBr7
slrndycPI3z8Yk3n9zQE1V35po3DSMn+Y8p3LQ2P3W7G9boyeC6+LOxeSUMR
O/f83XUykHGLA9Ktafytu83xaIYMTxKye381o1HCVj+oaZPByJ502c2isUrI
OigwkMNhZdpqtS6Nj5mpFk6+cmwQdgQWf6AwqNrVPXxKjqzgjhCPcQpBnaUF
77rlSBPd3uaioDBv2eafIs1GYNJv8MWKQQohqnCX9TtGUBX7WM+zj8LAirEF
/QUjMDztXqb9lELKWJfOM/EIFmVXqkXtFG7N40w7WipgETat799Kwb65Z2w6
WAGHYk7h5B0Kbv0q1cJSBUSv5GF+DRSigg7N1BpRQNgdcMyijsKj6H3mG5Yq
IayXF5LXKbQrmgSTEUpsDCuy3XSNwgdJ0t7PapRI/Tww9PpfFL7zvXD2yZQS
627Ef3WwgoIz16GPcB6F0qjUvayUwpYMjvmZ5FF4ldtKX5RQYHul/3KscRQa
ZWt1zCUK4xnej9w0o8jqaLH59gIFjSB2uf9aEkY9/n5mRRTKQ42Lu9JJSMqr
jrsUUuBtb8p6m0Fisop9xJFxk1dMNDuThHaAZ4od44HlA2v8jpJwE3HizRgb
qS4Pd+aQyO7Iy/14nsL+VNh1niZxwHivh4ixa0Fk7aNSEmFqk9tg3Cq0LBor
I7FnQsJaxfiH5KeZrAoSU4dCA+0ZRwau3upzhcStc9mzLRkXW+tRHVdJFHiZ
pGkz1q0pFHTUkRh/6fOmpYDCiZJN3Nc3ScxzVYY2MDY/ozPHqJ6Eu52trJYx
Lz5U6t1IIm1mruwy4xD+15ntTST6B17r/c54csVI1L/NJNiv8k6lMj5sVeBv
eJdEDKtnSQLjc3paXO9WEpqNy3zDGVtPVbMj7pMwPrpG+TPjGkXwR2EbCY7n
m4ydjPn9X0orH5A4XMTj/Mi4/eGnSNwsNW3ZyPg/NHV82A==
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl1H001XccB/CLpFVoHtoR3SFKHnZSqWXZW7OVy7Fo1iJPKc1quulGxTzM
0bmJRLhRqc7qtpAtXHVouKvm8XooUpTNlRq5z/cnt/P7cfft7HPO53zO67/P
5/PH2yGWuyPOkMViBZF+P7sl70sGf8MzlE6sh3hYYNnTLUNKlFgpaNGjdiIm
vLdHhmn9knCvZj1K503/+6hPhvry9FTePT32bV5u9HRABm5Sk5yq14OpStgk
fSFDwFB64uIqPdxzzW5My2To0KiNz5TokcsJzmCbymG7oGhe90E9jvt7rRva
Icd1XtLiu0v1MKrjz1BFcgx4lJjndc+hpsCvraNfjnwfydHPc+dwVhVTamKj
gLuFjUTuP4eFf0yduBGmwIZLz4WvzOcg+uBZxG9XFOCGdA29HZxFVqdHIHdc
AZ6Iv/rStVnI36o4hU5KbBqcHDx8bBanhNYBdgeUaGb7dQUGzkLc8mv4giol
zonNgr91noVd0LXk6jdKcHx+d5IbziL0E1bnyEcqRNFNURmjDCYPvoqx/lQF
dprI+eV9BiUHUo8b7FbB10V3K1jIoN+x1TogTYUst5q2X04zGC3Y9plfuQp7
U3hbb/MYGItPSFUtKphk50Q2RzDQXR8z3z6qQs2k+6Ahh4FRINO8x0iN9bXs
1BAvBlcrO7V9zmpwhp0u5K9gsFjce1v1lRqKmOHpbVYMzgpOKh7Gq7GRiS+Z
Z8xA6nhExMlRgze1LHl8hsZf8ZYstwo1NI/Wx+mnaIi5cRJxlxqGb4J9bUZp
nHZX2JvI1Hi6xix95AmNHytXvTUw1yC02+OJsIvGqNQ6JMxTg6ijDV8fuk/D
sdd7/Z4QDdj1mdLMRho/pS0pXX5UAzvrBu/iWhpCqV326WINClweXHtQRSNa
PzL9jUiD6IX2EQIhDc+/t088GtSgvsBH8v0VGo+P6GJZMxpk3vm5fukFGrnt
IVEvbbRwC33n2FZMw2JAKk321qJ6m5/hhgIabmUrp/aHa9H6cEW5RR6NiI/t
khalaVEsjHRS8mns3u3PjynXQjucOBudTePILudlB8RarH3GyX6cScPW/O7a
vjEtMho4npfTaBSlZvS/NqTQunaf8EUKua9CR9U4U5CwrAptj9PIzLt52WMr
hXNFg95NSTQOrzbtMd5PoWisvP48j8YxvmP6uVMUshw+fJ2YSCPo4qE7vTcp
sEOrF5ZxaVhatVdGV1DwHatkFxIP5TlcURJH1h72yiGOSx/gm1dR8F8TcvAE
cdoe77Dt1RQ2RATowoirV81nemoo1EV+KbAlNhWVb+lpJPtYXX1+9RCNfvcZ
r6h7FOwlbVvLiMuEwa4K4jqXMlEhsfN5I0uzJgpCS6/SLGKflB/Gg1oouAg2
ZuwjTvD14nc/oCDIPd/lQryuIT818iGFHIs3MQ7E7zwnuHLiL7hPdTbEJ1dc
3GXaSiHfIGPNIuLy+QauQe0UPFgTzfIEGnszwtkjxKKKmfjXxKt1dRYJHRRi
Ry9Y/0NcP7mfzuukoN1ZmtxHnBorVtp1kf+1q1w7iLc8txm/RXzWdUj6J7FJ
KO/ZZgmFRkHwxUbi//OLwvTKnd/VEf8HqVeRUw==
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV038w1HkYB3B71PVD5DLlRDdp2rsrs7Ekv/KuaW9bG/rB1YzYcEVqKYoS
SSGJUByRpER1tIezkbnC5aKLKHR+bM6POFfUXfaXz3d3u0/PzDPPvP57nmee
Z3nQoR37PtPT0/Ok+am2t30KOWQNN9rCUnR43GV72LNdjkqnzNkmZ3Vo7M9d
9Iw6IXX6bk2SDtUTAb4dz+SYtbmApz2tw2UDxd/PO6l7iy9kx+mw19VS/89u
Oa7G1B/ujtBBUx7mNCyTo1uemVHmp4N1mlGZYlIOcZ1kPMlOh5J5LL0uYwXE
Y7zSqr+0+AerRgJsFCg+5r26ME+LJs4c4ZZtCnx0MJkn3KlF5WAu902kAnsC
T4zLTbUI5/mVOGUrMCKtNf5dpgHv4Iuc9fcUGNxAuJKbGpRv0c4v6lWgfyzB
fXGkBsPDovk/qxU4f8L75CW+BmucItKOLlXi861eQ6ZLNfDg12e/cVFiYEFg
oETBgBjWLX+wWwnBrTJpaxeDxpxgG168Eg/TriS9qmLw/YstLbFFSuR5D+RX
5TBgPR8eDGlSIk0oFmYeY4BU67jKUSUkA7k/8v0ZeKjuXr+jr4Ipa41lOZ9B
BHto8y62CmyrPueFNgz2znePlvJVeHT7/flrFgwOVQWtbA1V4fX0wyHHuQwM
TWx916WrsKeM439fRXCc7bBkV4UKzC3OnYoJAkbz1md1hwrHU0utS/oIPFN7
zSvfq9Cmd62npo3AtiMm+KKxGmccjUY0jQTWL59yv+aqUR2aO7hJSqC85JMS
tkMNsezCJKecoHdhht/+KDUupO42WHadwEMQV9uQp4ZBoeWRuZcJMtZeL2ip
VUN6c+kS5yyCidFoXWK/GnPYBfEHzxGYCBLf/EvUqIs621hzmuDpPp5fvfkM
Tv4kGi+KJbjKu+fluH4GFvHdrSlRBG59oifB/jMwlx2SCQ8TqDh1ze4JM/Dw
jg83PkgQ7ywQvCqeQUjyguLMYIK8j+nb2xtnIDrAmooNImhNPjMQMTqDb1zy
2ftFBC1NkqnH+gSlLqdOjfsSDD5MS+hkE/yq9/RU8C6ClCjLfAd3gg0Plvm4
+RB8HB5z8gwlWNXs6Jqync5nvGe3WTpB4kWrgk4vgskPRrNyKgiaQwoR60Eg
yzxiL6Z75eYXDvoLCUanzr1WvyNwuRlkv0FAcJ/VY+FgzMCpK9I3nE/7P8Ex
eUzNdYxLD6bmTafM2rmQQfX2TU0i6s7Xzu+iTBj0t86220o90VLcIF3EIH1i
8zobarMMcdBaMwYrjF41ffiOINrc4Lb9cgZLjkl7Y6hds/0Lm6kF4qKASOrP
DGuzfKwYsKfYbw9QZ2hDY46uYNAz8sUcP+qyoQ5hzUp6h+OugW7UPWVXpuxW
MUguNszSpy74SjH8iPpsdMJGDY8g4LLXS+/VDKw2Jivk1JOprIYj1rS/L932
jVMbhIVk/cJhIJF4//CE+o+xxqRNaxg80q399jfqLJF5TBf10cU3/qunttjW
HjhN797S0PR8BfVIK3tnoi2DQisz31Lq2xsThIu49O8iblgXUYfX97mVUF9a
XM3Ko7a3+xQMwjn8vkzq/wEEK3+z
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVzw9Q02UYB/AXN5FQyUYOJJp4gOgUlrgpJvi8pCCi4AKV/EcICgEmQ0Qw
4Qz/RBpZSMBwgkNl5sBJDE1nJE6Jf4MwUPEPJBx5kRKHMfXd7/fben3unnvu
c/fc97lnVnxa1I4JCKEI2m+mdOGbYsD7x/XP5kVx4Peh8p6eum9qTnaPnAOf
YG6fVMrAQMqu9Ny1HLitbW6UyRjQ3pBoutZwgFI3RwYsZqDSdY9LzkoOTGcO
JQctZcBzvZp5GsjBdkHP6ZXLGVB3Fw1MnsNB0dieKVuiGfg47gPrMRsLjulJ
iUv2UidycbYaFuSa78OaSxgI59o0vEQW5hTvqv3pCgPBE13v1Xqz4BLCKeUP
GAhJ6nba/BcDd7XGt9SEAWO66K69joHqOwHMWXcW4h53LmynuYK6hN18oHfE
RxzJCgbCwprSp3/KQv0hTfRMNwZKTt8fe5jHQovXbf3qUQvoazws8jMsnDr5
KiGrzQLbMkRfexpZuCbnLRJesIAPYyrRDrFgVkQpL+Vb4JeAOt9BPgeF+f11
5hQLfLY4LKTTh4OXIFkeEmkBzeiJQWE4B+fbNoYnSGn+1ncdpqVw4B5kJ/EQ
WaC3IFTXUMBB7QzF+b5JFmhPv/T4vYs0L+fof1fHCdxzaf3Gr4uDVQskoooB
AhlZpY3lLzjQTI61xXcR+LPgVG6DwAr2zt6iwpsE4hOirhfKrPBiS1eSsY5A
/eiyPOEGKyguV6vsNQSUsiemV5lWsMtsz8w5SaAo0L/sW6UVhsfEK8aOE9hK
DCPdV62QYi808I4QgKxxY+cjK+RnOInd9hPQ6wbfn221glGoE87dTcCsmmTn
J7KBaig1ODuFwNrwvu3/YBtE2uvmt8QTyNYNy2O22cCU9VXNvC0E/E1ao0ee
DdxVu1S+Gwjwq90vV5yl+5uGVvvJCVRBk6Tjlg3snml7J64mEFssmlf71AaV
hqn9/SH0f3nM/UoewpPeUVYpggkgPXlU5ozww2jLwM4gAq57xz2eeyE87rtm
cvIS6h8ctUIZwsUOra5mGYFzgn0ZqlCE9Y3S5oP+BF6P3DzQGYNwjDH2RaKE
gNRrdteDJITP8ddnGeYTYA2DcbAPYecTkQonMYHqGoMs9yjC/LRyqdGHgCez
MyK5DOFjQxdcLnoT8NFmVV3SIhyXerKu1JOAoL48uNOAMLcuz2yaRSBT0bZU
eB3hZv6U0Cbq3vmvZLHUO+pWlTVQV1TJxf9S/xz4cKWOWlzKc3ZqQPhwqazp
O+rgL5KHIm4gvLltAo6mVmBZfscthOceyZA89iDQzW7Lm34b4cqZx3t6qBdd
O75/K/VL/rKcDmp2wd9pI9Rfvr2p+1fqfE/VJ1N/Q1h4J1ldSV1hbyeOaEFY
ki26nERtd8vXq5i6vmjWoTjq7Qc2ifqoHU5VR2+kFr/WCz5vRbjsqZwNp74y
nMgUtCHsV96c6kc9Q1Nk7qE2bRiO8KHOiW8cdW9HOPT5MX8P6o8ezRiqoZbN
CecJqKtKQ/vHqb2cEkcdqR3WZfQGmhB+Emnt41GnTFP/cZh6xFHwOzuTQIfp
TSHslqA2mqn/B+EeVv8=
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwdzw0w1HkYB/D///8jFwoVUmrbq66NDp3Si/I8xNZy66UrImnH5dq6yJRu
ckUdCquiUpdSm7jSoaQ3lKK7wxV6odCbXnFDrtbEb9fK/brvzDPPfOY788w8
4vCNSyMEjuPkbD7v+rrP4dDT5sVBD7EevP13TBxRz6GBtCz1vUgP1Y0zo+XM
1g0F/5yYqIfKx4dHNzBvrw7q0I/Xw8VORcjdBg5L46Y/qrDSQ5bBx4779zjc
6Vuz5jtTPUQsmECamzgM2Z2nqOsfgMGCyHkvn3JoVT70d8/dASjr+qHdr4fD
wPwpuvPxAxC6e1vz4U8cphX9tfHB3AGojVtvsmckj6u2iT4maHVQ+fDCjici
HscOtaY7letAnTJmLnHi0XXvNeW1RB0YZ9912uXOowXX+lOYXAduphEbLi/l
8U2ryH65rQ6Cmy27K8J5VA8q5kg0WuCIqHBSDI+81tyDr9XCvtRFxSuTeDT7
piWqKlcLbzd49Htm8jgmt72pPUELtcVZ8Sm/8fhWPfnlsHAtHPAz9c67zONR
2Y26Si8tdPo2Lx9Xw+MZtdYoaboWjAq257m18NhrtmadsbkWRoQvnOPayaMq
VGkm1lFQxwYaH9DymOT5Qjr3DQWbbpW4ariAYy+urlLcpyC6aR3rPV7AMpMc
zYEbFN71xI9OmCFgdXLgt8eLKOTG8pr9CwR0n2lpb6Sm8HbNU3O9XMDyes20
mAwKIwsebHYLEzDhyvaSrkQKnG+ujWOUgMm3B0dlbKUQH1A3FLtDwFET+n50
jqTw+ry53fF0Aee0lXVGfk+hKaooc1yOgGGbEvwKgynsU03xkJYI6GxiK2vz
p+DIX3X2viVgXkbxFrmMQmhLTkR+o4Aa16rV190pRBvnP3n+WsAoq8Dk+a4U
5FkpmX/0Crii1EW9bDaFKylVewVDgi+f5MdFOlIY1mh5x8aS4BKp5FGwHYVX
cbeWpH1F8Frq8pzFUymcTlQZP3RhvdWfXl2TKDi3zzCrlxJ06Ht4od+Wgs/Z
actEKwhqZFNMDGyYaxY+kykJrt+6zeCEJYVmr8LTDbEEZXucjswbRcFe/LGE
T2P3icbHzozC2qBgMuIYQXNV+pEUU/Zfj2XmpkKCW9ShQR3DKTxve6csvk6w
acLi1XlGFAIdTu7MriO41v3SmV8NKYQ8+73l1TOCVk6SsypCwavjXgzfQ/Do
64NTa3gK+bmDUTJmSdu4QzeZjRV26/Yzn+qTGZUy32tJXCX+l6DbjezefObQ
2y5S9/cEs/J0XSrmmKJs6180BPcl1ob4MZ/arCzn+glaOCyye8xRMHQ6dGkJ
88qphu8eMCu7q85lMAcOBpTcYXaIGJ87iRL0r0jxrGAuD2xIQy1BZUZA8knm
+/Nmrdo5QLBQrNq1lnlWnyKoljmxID1awXy4ZG+AuZ5g9weLsGDmUPsOr5PM
C11S0Ye50/aoQ+Ugwcz5dpMdmX1aqyVffCK423NQLGE+d6j3S3/mTCvpZDFz
zEi59Qvm/Sdmfz2aufl2rIVkiKDJscezTZnnJ582iWa+1P0BDZmPL2o0LGU+
ePVn309D/cD9HwMcEMWE9TP/B/2qLU8=
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwly3swlXkcBnDHvhfRSlFLp5JaRWtKOUsK369ICCNMl+W0kSTtRoWlllwq
UaIwY2KLSocdqXTPJSqrpEQitK65du/wvq9Xsr9mn5lnnvn88Rj4BXtsU1VR
UXEl/bb/h0Kjrt6iymERouKL1yFx3yA3P0wpgshsOxdDHJuzXWL8WQTl9zUO
EgmFk3R7h098EKFPmp6sqkrhjtCyO4FDItRaGElpikKd9OA8404RMoPdzdXV
KLQbXjtdeCyCaUfObzpaFDomO+6tOC/C2zmn9OINKPy7Wt763EuElNtF6jVL
KXwgX79QT0uEsct/2dy1pVCaH76ivn4UlGq9xZqeFO6plAYfThuFhpI1O823
Ung03WNMKR8F6zpV/1uhFIZyXzdEGo3Cbsg8M3CIwmZBf7GVIMAxdSf9TxkU
BrCPasufCmBm7tHhqaDwvf079zV5AlSWhvccv0nhs6xo/9OxAujmhC2KqKZw
48S/x118BRjrqb1S8pLC1nXFYSMoQFUcRDUPUJitmaxjaCiANE490VWk8OmN
1a/kkwRY0X6pebcGjSY3ApzdPvKAGSFBu6Q0NjhHLKxo5aGhMNG6yoTGI2Nn
0pZV8eCiX+41bEXjiy9tUQXFPHh8di6McqNR2rSDM87hYe68Yofrv5J/UPfg
vhQemgplhlXBNN5b5RNrEMuDbuYU+yWxNGafFI0f7+HBtp1W7D5BY2zKp87w
AB7MYptc/HJpzH2dkOjszcOVgxPLLhbT2JfQvni2Ow8zeuzkz+7RmNk3d1OM
Aw/s2c5q10Ya65/Mkvdb8VBZtiEsspdGIeLhqI2MBz/ZUEDUCI06Di4FtSY8
pGi8yGxjGIzeaaHtbcjDOes2zWk/MHjoQdy64Tk8xNSWVHMLGLyZ8JlboMfD
YMlwxc/LGSxKmxy4UZsHS8bpq4sjgx9LW7o3afIw/crI/vJNDOYqXGt8JvHQ
cqPMWi2Iwa1OExnTaB4C9LasUtnH4GDRj2FLJDxEv/olweMog93nG21dxjmI
FkO0orIYbBHGtgyPcqAe2dEiuchgSk+j9mmOg81eRn2ycgb9j/gczFJycCrp
mDk+ZbD/TVwV9YkDPwOn6rwOBtUTxsN3vedgqrZBds8HBh0V0wdlbzlI9H1+
tW6C/K1e3jYd4iBZq11jxlQWG7Qe2ZsMcBAxk8qXGbC4seuJbkgfB21Npmf/
JDZc1KAIJLZJk2c/IC44sNfSl5iafDPVax6L1nmJ/h7EqeM7IkPns5i4cqhF
RqzorHO+ZsiiR8FlFHs5aLqQ9c5sEYta7d8Jh4kttz7s308syx94eYA4W3+k
6z5xfJlraQSxX6Zbk+dPLIY4ZCQFEb9PlNzda8LiehfJajdi+vftqVcXs3hN
Jcl0BnGgcXrSGPHyCnXLKcQ1vRUH7ZaweKFr3E6NOHXzzMjnxCdbLXzF1xzM
cn/iqzRlsV/Rfaud+MBk0XvlUhbr/mhvbCbufrhgfTzx7IbVymfE+bYxztrL
WOy+62lxn1jja6G9N/GUXMGnlHjXnRabc8TT8ulD14nrwxnLN8SHv0ReKiKW
mX0Li+7/eL1SEP8HUGdIRA==
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV0Hs0lHkYB/DBHu8FCSXpXkRlqFxSLs8T1W7OUNlho9pKMmaTJokVW2yb
ObpIbelqa7pQ7bRmQ7q4hbOyRG2oBmu6jKySy/a+M0Nt++t7zvc85/PP949n
WtS20M3GAoEgmPTz9XD/HAqPd/i23W40wO83tT/tILbLE75IaDCA66KTbUXE
osEyscufBnBa/DHFw4NCYZbX1vN1BrBfUVfl6Ulho7117KFqAwi2rAnxXkBh
QLdMuuuWARov7JX6+VConsmWn7tkgGjrlnNfBlLYfKz12ejdBpga+kB0U0yh
Q2i4U5qbAWrePvf7GE2hcWqg2z9v9OD26uH2oUQKg2Mi/K//pgcnX7vuxZkU
OqeIUuO368G0f9cv0lwKzwVt21/tq4ftxl4n3hSQ/YLDJq60Hi4nNPw14TaF
XK7xd1VPdVDllxbqUE/hLKuL2VyhDiTSfdZyNYVPVOv3zJXrgOu/alvdS+GN
zikm06J1IHp8Zd2vwxQmjdvoH7lEB27jBNp3ZjS67CkXZTvowFCSoGIn0jhH
u+aUJ6ODFSV+ZelCGjsL4l9r+3iIt3rJXvan0UuZPzuglYfE+xfzFCE0zjdb
UTe6igdTTZlMv55G92eXB7qu8ZAeOih3ktFoaTP7bP5JHjIdd3epMmhMtHih
TMrkQRymTek5SuOrhwNSyyQeWI1ktf4CjXHxOyv/lfAgaghIjiqmsdL1rV17
BA87rRaqL9XSWKFo67gbzIOkmEk/3kLjId+Rk5UBPGhL58dotDT65fuEVy/g
Icg2OceEp7Hta7YzxJUHn1abkXSKwWvTjYRdDjxwA/uvKO0YTDWSsmsn8pAr
mXRa5cxgQ1ZyLTOWhxp/unHUIgZDIhs8b1nw8EQ2KmBpEIONXhs+xVE8FH96
NzwrksE9++mzt4x4mNTv9D52C4NTOrMYkw8cbF2YNi89leydOWFkr+Ng+Svn
wsGDDJbYzNkwf4gDi94BmU8eg8/7/RXDfRycFv280/06g/E9ixc593JwwzL7
zr4KBmf/PfleWDex8FKgqolByQF9gPlLDvyV1haeGgYd6++squ3i4Kh8zfjY
QQY19s9Kmjo4aCqvlO4wYvFw0nX7QDUHueK04afWLLYUD/WVPuFg6TJxs+0M
FhVpZUPyVg7Kj5m+NnZncaXioOzgYw7uBVrB8iUsjshKr+Y84kAZvKBdImYx
ZMy79+3NHFiy0a2FxEeEuostxAl/5DTriO+OORr2gNgbemvkYSx+UqVUVRDX
zs1TFoSzKB3gixXE7TYmu1+vZrHL/Pm4WGJW3TRVso7FCA+s5JvI/3JH7AuJ
f8yor+gnfhjqPFZHXBt+v6qHOLchg5F/y2Kq44xGNfG0co+h/PUsmnt7CiqJ
vc+fruneyGLzKrNOOfGZtXXlrlEstjtmmmQQ/2f3vjSJ+FRLrMsu4tojwUrT
TSwu3xi1L4545V7B8ZnRLL5RjBKvIi4C4eF4Yk2R6lAQse2HiKybxEndRfWB
xB2JRT8s28zimHD1V17EME+TnE08tWfkgBvxhT7zhDbiliWpj5yJv7i2MG5y
DIuyE9+Mn04sifkcFr83y9k0gfh/uBlDSA==
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVxw001Xccx3HdHuT/YLO7LZQeuB2kh7sZdu3q+9WIkmnRatjSEyU3cdDD
yTxsN7Vyo3aTy0ny3A4qrbhEpgeURoQ87FpuyVKR///eGzvar/c5n/M5r0Xb
IjfsFBgZGfmSvf+w0PdRuKDzyVZpiQG0w+aVhcQubhlWk0UGCJHdMxkiHvFd
tFJdaIDAGHFpWBiFw/0upZJ8A/gmT4zv2kXhY6NJcMsxgOM5RdKecAp/mR48
b5PSAO8eXcvet5fC9eG5nR1JBsjwNG4/FEfhmKI8dyzIAP5yo8ThFArzgk3b
1KYG0C34JEp8lsKp/QOVAff1sG3OjILFxRQeTPSV2afpITDSxyK2isIigW3w
pL8eJNZlbdlNFPq2Xx+VLNRDvtPu5vm9FLb3zUw5OaKD7oKpmX4jFH45Z54l
f0MH4/vK5Zv+o9B44IpGo9SBKrvSU83S6NWk3NQq04GdTf8a3orGxMAHumAf
HSTM6kv7exmN0lDXMpulOti21tHcGmhMrr7v95TRwdLhgkE3Pxqv2FhvmfWG
h+Tn+15XhNC4uuuhl7iLh1yPT1d2R9EY9lkATtTyUDTZ2dqRRGOIOlNie5EH
iXA0z+E0jTl+c28EKHmokIuqA/NoLEw0S434mYeqzZc/0l6l0RVDz6ZG8ZBy
1Lx07h0aK9qqfozcyoObMOu4QyeNY2uk8lP+PCRMxV5UDtF4/N7XFyo9eSj2
iGC79TQKzUK2/CXhQTUkrWg0ZrCvcMnMGSt4MH+xM1NoweD98YRLLiIe4tdc
bHC2Z/Coil73ypKHvbO9ll91ZfAnR21OsRkPdqLaXo0Pg53GL7f7mPDQpFrf
MhjEoKrI6bqFgAdd1Ffv3GUM1hw/Xft8ggMq3z32QDyDv/1qqajiOBj63Hr5
D6kMniuxS5//moP11kG22ecYbE/fGJ48zMH5iPIdFWUM/ju6Ecq1HByeE/xE
dJPBgT9yYvo1HKCVKH9vK4PODd7xlb0ctCTcKQ4dYPBDpwJLfRcHT1fVv6wc
Y/BI9NJCpw7ikK64wWks0g6NzROtHERpPHGXkMVU552x9S0c3FYr1mWJWBTP
vTvrcTMH08beZBd+weKtOO3NzY0cNKWUL2NWsyjXHxnqvs3BgYMpgrXfsdh6
O6/kSgMHo3clls6hLK52EU3W1XPAxXlEH97PoutbsUlLHQeaxHDTrBQWjTd0
jyyo5WCVW8bsQWJVW0yNOXH+2waBw1EWHcsyFGbE4dFWejVx7ZsI1+nEuu2t
mp5jLCqeSy89u8GBqZfzZcsTLPbJS4VlxFJWEKBKY/F6VlXFSuKcpuXfPCHW
DkQ+dCEWHAnyXpLOon112riYuHHqqlRN7N1s6mZDHDAatrjnFIvHLmhHjIn3
tLfoLJQsHrrsWtdWw8GDkxOjW4k/NneacY9YvM72RQmxV94Jn1vEuluJGskZ
Fs8/8vvnGnHyNcfG7zNYPBn/gX028dPokD9zif17ehOVxN4rUmuGidPrpnoU
xKbFzy4dPMviqx6PM0nEUTuEv9cTJ8hC9YeIOxZigUkmizL33sAYYpf+iJxv
iYvlF27KiFWZ72MxYne1XRjx/8akUso=
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwdz31UjHkUB/Aozoya53m2Nmqo2JYNWxSLXnQvS2dVdtWekeStYiyndxmJ
WYnQi9dqHYOtbMqITDXIVg5bUUZNZXvfMrVMVsXyPDOzNW32Z7/n3HPP53zP
/ePOCosO3DHRxMRkLZmPW3bhYwQ4o95HEpJmgGl2/oOdxCvXG40OqQbIyh33
EsoE2CxWvnhx3AAnC8M1MuI21d3e6BQDJN12/uLSRQFGduXEpiUZQNz8UPnz
ZQHqUvWGZokB3Piv1b/kCbC+uVohDzfAkwSPycVyAT6aM3/lXm8DHCtfVDaj
QoAizfW8K+/1MPf7b/LDVQLU2Ka2RpXoIdt3aceGbgEeslpqGyzRw8krP/pf
GxLgGZUwHz31ECHqM2saE2CLxu6fSJ4e2n+49G8AReGB55V/lrTqwLzT1T3Z
gcLwsOrYN4U6mJPfX562gEK3Sn/7c0k6aFAPJgwjhU223WGewToIWc9InQIo
jMusGxYv1UGpO13zSSjpQ2cXV9noIFsq9hPFUThPaxdDj3KwdUbn1NhkCs9J
3u658ZyD29PzPxvIpLADfZ0Cazn4fd+aWPOrFEKNd1P6TQ66XKaY8W5TWJ8g
7bS5wEGEj2P7lkcU9mYk7i44yoG2POjNyTYKq6xXtDJ7OBhKf7F62isK+0fU
646GcvBrhZ/m2xEKV0dti1UEcBDj03h/C5/GGxalaVarOCh1lffUCWn8Ut6T
sX8JB937ctB8Po3S5IVej+dx0CCM0Ro9aLx/wv+m80wO/OwvPPXxpzHzisQp
05oDxcEe/a5NNFbeeymLt+AgzzMxdCCSRgt1gjLYlIOQoHeU1SEaec8/CByN
LIw1HDGZdprG2S5/nbHkWJh7Ncptby6Ngzx5zcRhFpa3x18rUtCYXR8x/W8t
C0KxKPTMAxoPjjGjUX0sHBGd2qhupjFkqptyqJuFZzn957V9NL7uNVUtaGfh
lu9p6w0sjXqu1jO+hQX3a0WDTRMYPGEpDwtrZOFQ59jwUz6DbeN9gaVPWDD3
TGQklgyajJ53nfiY2HeSKF3IoHbFQa+2ahYCUivvrXVk8G7txkdFD1gw6jUw
MJ/BzadUD5uqWLC1tHo1tIjBhQUHJm2qYEG6OVaR48Ugf01l2UA5C6L1PbL7
qxh8mzd9m+oOC2eldwqU/gyO6SYV9ylZsGqtaAkSkfvfyu4ZSlngdzXO3LmZ
9MNtGwJLWPBY9tIunTjL4fIaP+KIn4zCW8THeb1eq4gbA52sDcSzUp7OW0Kc
pTrMP76FwcKurz8XEs+sWvy+YCv5P7kro1/BwrJcWbU2lEFKX+Syl3j3uOLB
lDAGvfkOkVHEFzc9rnIhNst4d3Mn8bgNd1dCjOklSzYS15xde2NyOINxzse2
A/F3R0yy52xnsOOPuoVTiJP6pp7zJZ6Qoc4yJS4F59NRxJDgZBy7xcKnY8Gp
d4ijaxsa3xJ3xZdJfXYwaIxRn20ltnhWn7ib2GZ1AE9NvNxVs+8UsbzD/nAd
ce6wRVwbcYWZbH8FcYufY/QosfcEnxElsel19wh7MYNfpXgcKCZezFu3ayVx
ULXkQyGx+P8wmPNmJCWP+D9fnVG/
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwdz3tUjHkcBvDRmZgZS+/P2oiNSjQqbdpcwpnvl9VFSikmbFpZqa10JUts
l42hy5o9NkVptdomXbVJF622JFvWnIzYXI7oImNmk/edGaTN/tZzznOe8/nz
sdwZ7RdixOPxvGn/390fwqDUh0y3jTGAdQmcOErtvT4xSRdlgH71zPpiagvW
xKt5jwF27LkpHKJ+4AUCaYQBtu51rAgNZXB70U7hsd0G8Eod5cLCGEw4Lpk+
HmgAp4IfUiLCGay64XtwsacBxu9ezo+JYvCOdY5p1XwDPNr3OWezn8GROKGP
+0M9LLr2e8T6JAbrfhw9tj5PD/2SWmM3GYPH03Zl+gbrofdFT/M/JxgMrBAN
+NnowWetKH9CLoNLwpZFxet1wFeG5raeY7CrrW9e6TUdzDnqdHnbBQbLG5TV
Lad0UK4RGYKqGUwOX9doGaODpBQTKdPIYMEqPsrW6aC9zbJnUSuDRec8qzaJ
dRC3tDDRqpPBldfHFkpEOtjV4wVtKgb1/o5XrbQcdNhMnK96wGDui/ZJEhUH
exUa26x+Bo94bOwJrucgbbPEb66WwUaNu9uUQg4mVRfkmesYnDbbw24sk4Ou
VXbGHWMMWpHD2ZpvOZiScF3+hE9Q0BC3oDSUA3lvxqpfpxDsqVHmx0o52L+/
WbjalGBtRGKi2o0DVRPvrcccgn0/VzVkuXAQ7xQlGF9AMO7L2ypnew5km9Uu
cz8jKG0JSGy04ICnuJ05YxnB6pNmxf6mHDSLn71vAoIj0am9mskcsAGCbKU7
wQXlvfo3RhyE10k9s3wJHuoaLBSOsuDuOs1y3laCAYqcdaOvWMhNfmg2P5jg
M4c3ZyZrWHDQdjl1f0Nwy4Snp80HWFhu3L3nZSzBVm0kT/yYBYXX2s6nBwgm
7Qtf2tLDQmDbE7eUVILamkDvrXdYSFOnD2amEwzaIGNqlCywkuAi15MEm6/Y
2kztZKF7teuR8DyCJ8w6bpi0szAr/pRs93mCywUd22NbWSju/rjUpJxgnep0
n+oqdX/BsPUlgkbDprMvX2FBayX1H2oi6JARcvNMPQun5AfvJ18nKD9rFnur
loVLZeUpR28RvGeWvW9XDQszX4s8Xe4RZG3P9727yMLIywTnLY8Jhgw1lKgr
WbCf4YsbnhFcIWfmCCtYqIzaHPlqmKC4NNRPXMZCUXxYI+81wYcioSr9Agv3
bn9XZ02dX5Iz8D31JMfsSx7UPhbZbw9Rh2tbKuXU3U73baOpHUNmn7d4Q9Be
FFXqT31FqszAtwRjyj4yN6dWuThvT35HcF6GpLO6hAV+rue2Imr+pokLy6iX
GHYE/Emdt9gqvYg697esjcwY/Tfo559DHWQ35HqOuikoZcJhavWnZxz++Jdg
2EDgXx7UsxIv2g1QaxL4vmuove63iwXjBG/acndXUldmc1a+1I3XfnnuQL13
qveMJ9TpIc4LP6Eujvx6Ov89wTXl41enUv/deYCIqW/UCgME1CtkxZNjqCVD
j7PeKViIHGwS/EQ9cFBhr6c++8Ud43rqlpKKW8PUykK10SPqrxQjMc+peR8y
DeUV0aZ91P8Bb51Kqg==
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl0XtUzHkUAPCR6bGI+n7ZU9od1TJMx7Zk8yz3Doc6UZmlkmpLsdH7sbIh
zcqkUnmsR7V2kiJtHkmrNtMwnZCENkplexCTsGf8ftPYdMR+nb3n3HPP5597
7sMuNPa7zUYCgcCT5af6fxDskCslqg0GUEs7Z9kyr82zyMv2N0BKWqUMmSd5
NW0OWm+AEZPNxfJP/nhCJPA1gN68aeWYMQRDYnYZecgMoLU5kmNkRDC8T5Ks
czNA84JZNsZCgpk569fJnQ2QF7tm/jgzgieWNcRdtjRA0qS72RoLghGNPrl1
jUNwK9DP+LkVwVnalu6PmUOQ0uFV2GtLsMaiRzRDNgTJexP890kIXjkXo3Gz
GoLB7mLnX+cSfP/VlCUhA3pQho9xClxMMCN0bELuFT3UTGv2HlpGsDdOg4os
PaxUlBwY9iDo/vya5+lNerC2KdOVrSVIdlepmpbqIeT7q/G3AgjumLna2VWk
hwkti6eowggmHnm+XCXQw4d4bUdQFMFDfODe+f08hGkK1ZE/EtQPHtnXepuH
iVJFgziF4LiEwIGkCh5EukevahQE/XaPlx3L56HIY6FzdQ7rN3vj8AsFDxHt
DcrQYwR3RfjYuyTwUDop2GGHkt3jQv/ONRt5cEie0b60lGBtujI3eg0Plpb+
xV0XCbZ6C0ucpDxE+RYcflpNUGxivMr6Wx7Mm01PHb9OsPKQRm00kwc73Z4H
NY0EHeyakzQ2PBRgpPhSC8Hyrki/XEse/OtT8307Ce6PC121wZSHbK7IccsT
9r/i8p5fPnAglL3pF79k+9TdMbQYOHjSU16r4tm89lYXB//hwGnqtsvqEYJl
TmbbvxzgoFER0Rw9lqK4225Q1sdBqzLaNHM8xc8z3uqSuziQarvDdlKK1XZu
Asc2Dt4G7eib+gXF4dhp//bd50CUNj1VPJ3iD4XBj2R3OMjuGHHtnU3xz49y
YcNNDmIe94iEzhQ5waXUznoOqibMsRO4UlyStYB6XuMAY84vL1tB0Sjo2dHr
V5lTFmaoPSn6KhLcLtdwkK7SvZb7Urz0t2Jr6R8czHGYnDg1mGLV3tjRgUoO
vFastLENp/jitXg0q4KDyoMl/a2xFK0mbA1zvMBBVqbFPW47RY/xcdvE5zi4
WTHYOZBKUSCpBu/fOXA30xnvz6DY1iFt2n6Wg6XmRusKDlIc+26/7OkZDuIi
rWRqZqfRrPTHzEW3Hb2eMr+sf133kFmYHuDucIjiwkVt824xN32ocqllvh5t
73KO2edN+IyuwxQz7+vrkpijHtx9a32UYk1yhdycWTn3md6V2aM2WmDKfP/A
yJuNzNJdiXsEzE6rZ74qY/7Z2ydHf5qD4QZ576JjFM3/ClB3Mqddmdfof5zi
Sev67DPMVZM9bqQwBz8onXOSWZsQUl/EnBVwuz2f2f2bHNUgs32VSpLDPPGs
tiI5j+Lhk14vE5nRZPT8b8xm2veF0czxm2i5hll4tc8vnPmhLZ7+LJ+i57sV
9zYwm6T6nvqaWdJ+I3sd84LuqEIZc6nkJ08v5i1L0k5sY3ZxDLRwZy7I/xQU
S0TxbVLm/wDcRT1m
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVz3tQzWkYB/BTk5Ju+L0/lOpEHPdtdRpODud5kqYVpa22PSMbShm7WRXb
RSIOxnEbmibdSaubai2122URGY6i5NqF0GpqU+v9nXO6bDf7+s48853PPH99
54Ts8QszFIlE3uy+dEb6l3AYaxiaL/HSg7I9+m4Vs9hqaMX4N3qYabfxYytz
Qm/XvOeeeki5NLHaJoPD5M7gWSoPPZwpCH2XwRxTdmpzF+ohqWLZgqxMDh9E
/OBcs1IP4c13ynOyOZw85Bh+db4enE17m/JyORz1KSq9YKiHqUXhkqBiDp9k
9C2aXaOD7YM05+B1Dm8OJ4zlJupgZnSPLL6aQwOZv0+/hw44e3OdQx2Hvi9c
rVZY6kAVu6bJpYHDy9YT+zd0aEFmkNkw8IxDEKdLY8q04FcV9s+Z1xxOd7S7
76vSwjt7xaLkDxyqp4xVugRr4Ub5WrV7P4eDff8Jdq5aGBkKMNs+wKE2r/ih
zFoL+buel303zqFy40iU75gAaWZJ0UOTCK7ZZxgW+laA8c2uykmWBD0C62uO
3BegsM0+uHYGwWfrOt2LSwWoPBF1zE9McGe8twFeEED+obnRdwFB8S2LPcMq
AYwig2VjTgQXjmi2/B4pgFvRcB0nI7hsfeUqu20C3Jt+e08LEozKq/j1/CYB
rhZrV+9bT/DwDs+kKyiAMZUuPfAtwePpl7ubpAIUhOXKl28mGKlSWIxLBKg5
YbvbL4RgyYyJ0YHZAri0GdV6/UjQanQie2iaALogaymNJuj/2F45bCKA5JRc
Y5BAMH/2fp+tnynk9KoTa1UEW+wP/vFwkEJCnEdA4GmCS1LLfM0+UXh0w9Jb
mULQoinWLaSHQojYKNwkm2DNkZGWqvcUImQmuXOvsH9akLXoNYX2Q7HjpJTt
sek92/SSwrkhbn95BcECyTWa3Uyh0vbWrNqbBL1+SwuTPKYgiU55FXefoFNJ
ocM1DYXJv8RVZjcS9O4Sv2m9R8En/2F1+kuCoX8pGrbeodBm4vlm7VuCyUbt
hV03mWc8naPsJhihP+bYU03BIVB93IYSJJ/dTfr+pFBfV2pePkww1W1f86oK
Cj0db8urRDwucw+d0nudwsbFisQIUx4Ts+oL0q9RmOdYvPPUNB5fBBjLs8oo
bPNS7T1szWPx+aMnG0sodOaeuDhvLo8epucyRVcptORn9ksX8zj4k0XA3iIK
UyZd7/2e2V/kVBLBLA/VdCcwKz7nG4cz54gH3tcxB+hT7yqZd6T5vPRfwuPH
J1sDFcyf1Aa39y7lMe9TR58ps/HunedufMXjvbP/Nl0upCBrSDzzijlGsyEq
i3nXopSTo8zK8i6Syvyoq/aouxOPIQcfhaiZk4Nt4p8xO/Rvso5ktvN9vF33
NY+jBYfoGmafsr+DZy7n0TLQq2Ilc5L5SJCc2djD48By5k6NJFDF3PFUM3U+
c6FbkhfnzGOhq+Bvztx2MdVzJbM6buFiY2aziZJ1QcyVrWpDEfPP1a2KPOb6
4QdVugIKl2ZR+QNmhXNeWj9zc4yx60dmh2NX4ruZDV/YrrCS8vjBqXHLe2YX
6ZfwiFG2a9uZ/wf67EBz
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV0H9QzHkYB/BlaXSVqz2fT5boJLczqOH6YTfV86jbyLW5WU6iqFSXhH5T
JNId0eWKLkLWj/IrJkVC3I6tu7iEqPwo6sSI8vnubp3049zHe+aZZ15/PPPM
vKeEbVBHjBSJRCo+n7ez0+cQdNq89bd0TyMYEs2DFnOnJSvDgzyMcLHyVWYC
91jL2H0KdyM4uh1oruB+HJ0m7lMYQTZvOMXZmd/fC5DFuhhhwqK/tC4uBI/I
p0RsnGkE0doV/vI5BN1+2mWsm2CE+uM71njMJShAnF98vwHOeom0vd4Ej/7b
Kd1YboDBvbvl4/0Ixrwfq/RNNsBFs4xGyRKC3mesnmjBAOevFGdfC+L/rvR3
uZgaYJJVS1RDOMGB+dmHVE/10FjoHLF3HcGOEJks9ZweutWfMmTJBE1Hhfp6
bNdDalXLrRlbCbre8fLqCtKDyr/Vru0Xgsd9m8ML5XrYn/v+5EAOQcc9K2Sh
Uj2geP0C9jvBdauoZtywAN8WS81zjxLUwNstunYBCnob9UWnCJ6MU76LqhPA
K7HqQ2AZwcqRdStpmQBqOzPb7iqCpZq2HvtCAZrS1ka91RI8pbrmo9wpQJFp
/4P82wRNbNttIhMFeOaVF3z+AUF301EBM8IFWFm6zDT+KUGtiz3rXyyA8rvs
ZouXBJt1eYpgpQCarLu15B3BMIfshnq5APM+uTXdMRLcLB2WwEwBfrSrNOke
JNjZ7hufMEWAhoSiwE4xxT9uU8NZawF+7SuvzzKn6JnSmdNhIYDWvin00DiK
RQ7ituTRAsgzp1ovn0TR6lbiONsBBkTyoodNo/hNympd31sGkarTr/UOFGMe
6+LetTEYqjrySeNKMaA1N/Kf+wxMGjVu1Z4Ud+rVmtJaBklSq4ILPhRnjfkh
bcd1BtNzz3/lv4hiiGOg57KLDNSVAeWBARS3Od5YdPA0A62ZY5wkhKKr9NKL
1qMMjo+VqOdEUWTygsuBBxi8gdVLnGIprrTuNt+TyyDxWHty6yaKQmOPd/Vu
7rK11/XbKHbuKk/qyGRwjdl9fSmLYrV4TbRpOoPw4PklqjyKQRv2j6pJYZCx
KcV/cSHFR9EXYuYmMXita6EmJygmibYerIhlcLPae8S0cxQPe5xwaohhMPDS
xmJiBe9DcdnbZw2DLXPtFDevUxz/POPJjQgG8eiy866O4heuitGXwhicLPo+
U889sNR9uIS7aSh0O6mhKJrw8ONBbvnVnM3B3O3jL4u2cf83+82GHu5HEycr
/bizph5aZvEnxXQb21OvQhloTEZMV9VRLI59UDORuzHcWhbHfTXC1e9LbrHO
wT6fO/rYUMtI7sj05ZPbuAdqS4a6QhjM6K+QrLtNceFDn9Qq7squyMHsOxSf
eoQol3K/mZ/WX8adM9tOspBbWrKv7xF33JcOLz24t4Rpmc3fFBf8bJ03jdvr
mbSzlDsngEztW8X7V8zquM+9sKDXqou7uMDneS/3YK3l6DbuMUsSHrvXU8wf
+vihhltRntUUwj1sVvOhijvaUtOYya2W1g6Wch9eX3nvNLfmzKD4GPfd+s+h
mOoVaZnP/T+iUD1J
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV0HtUzGkYB/AuyK3ZXTHvj9Sm6ETHbUUzaT1PNmFos7MzUrkU3WgkbWjp
hm5km43qCKvWkk432WljpGizGxuZUUQXm/ZQLu9vbsqizb6+5zznOZ8/nvOc
55m2eYc0zMLMzMyX1cd+5/bHCDFyZtPUx+5GOCIoHnjFfGW/mX/DIiNI1iTb
W98R4n33ky/OLjTCn63zY3yZtyhT7bYvMML1jnybFubhfHLBfK4RVP3BgXdb
hAgOTyIXOxuhYMRAn1YjxHCvzl36iUYI87SzbG8T4pSjvqODTAb4qqsgILtb
iG66ksLnlQbInTn93sWnQryRt0khiDOA5JytopwK0fvX9K7LSwzg8w04ywaF
qNVXtwePMUBNaYxF5LAQf1RfT0jp1EOUW8uwixVBQ2FSenWFHtJeHZ/a8AnB
ulnB8rBUPdhId67/gxAMkky80h2sh2d9u67udiAIvQrXoC/1MNs1c0muC0FF
d2iR1l4Pj05Z9WbOI1iakr52uqUempeozs0SE+xxDJn0tEUH87IVWSIvgvmi
qlFLC3XQaS3NMa0k6HpyXEnlDh28rD17OU1K0HZBrvp3bx1Ek5EWqYEEwzR+
re2f68D9l5youVvYvlrbXvqOh7gu1zc+UQTPe/02NKeThzfLjGfGxRE87Gi3
K6WWh8fdM2LOJxAcvGS/k57mQewUselCKsF/l1uZB6bz0HG8LTr0B4IeVsXa
5u088LV+RWl5BLu3fieoXMdDhLXIlPgTQaeRFi5Zy3hwVq4OdyomGN92JC38
Cx4C6qPfu1USTHo41KGbxoPWrq7KVEMwML78ZvJnPFSWxWccukbQeNfiZpkF
Dx+eeaVkNRFs/96v/cUAhType4GHht1j6prh+pxCYZRHm/whQZOTZZzbYwoC
Vem8FT0Es6MaEr3bKDTOWl7R10+wxnbbHulfFF76GVaZ9AT947Zeu9FAIeBc
09jytwR9FMY9YjWFxSVlLzXmHMZYFhzruUhh/6MhensMh19/eCsSlVGwXrz3
090TODSvq6tXnmWWjJRnTeGwYmFI7/3TFL49dFXt68ShLFqhti+g8N9gD/S5
cliSeXVo8BgF2wk2/a8WcMiLc/oylBSSN+ysKvTkcGLRzaOTsyj4r+0+Ue/N
YeD7dZMlGRSOJdYUV6/mcDiWWj04SGHS/dp7/nIOjbk0KSSFwriOFoeIDRwO
hGY2RiZS8BQ9tcti9pD9PWI9c3T++ykXmK9Mr5L4MWukLpPeMM9xUP+zkDm/
ef+YjI0cLir0XGXJ7FjnZizexKFbYjl/OoGCuOhE47MQDlXLNyc82kdh23DV
9bGb2bz49co7zKfWN9XNYb7V3GLbwDzMvb60m1mm8b9dwnwjx7d81BYO7/kr
g+OZ1xw0y3MO5fCSo4+MYz7wRHhUwuzYWBk2nlkFs5XRzLL5K/aZMQuHAg7V
MCtyrVT9eyl0xakSfcI4dAlWytTMgtZbe7cxa+TyjApmmN+zJ5s5JgTrf2Y+
Q8fHPmCO7U8WHWZuXeW04x3z6ATtviTmEaVihX04+698aWMs86LRa7YuZa62
1AoimCPCP4ZDgU3CxiDm/wGpukOf
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwd0XtUjHkYB/ApDSNMufb+hEwqzpLawqqTnqfdGdFWGym2xcbqslMSxaxa
W7GJpqZEieJEmtgSUsLJrcSWU5qEYpHtMpv3nWnmTBfRan/2e85zvufz7/MV
bd2xNsSYx+P50PvcYaGfw6Cy8lx90DI92J2HjIPUhemfMsRL9dDVy1xXUsOl
kouLl+ghePuj8Wrq/KVZ2jFOegiKdbwYFsbg8ZGsA+X2evDZ/8EQHs7gwOCx
v61s9eB8WpEUIWVQXNBV5TpND6NPr+VHRzE4OHvPgNSgg1e7nQ3zZQy2/UNC
0i7rYHHtrYhvExgM8Dc+NUGmgy73Sv7KFAazFD1DfV/roONd2x1NBoNm/Z6c
SqgDP7FpvlEug+YtcvvR2j7gN4Xl1hQwWJ/x8of90j6wOuh0LegCgxt08R4N
pA8usqaDm68w+H5c6upNrVpITDILNL/JYFpctMMHhRYe3he12dcwaGJqdtTX
Xwsxy87EWzcwmJAjanSZrYWQNm+438KgyDpg+Sy1Bhrmj7VtecHgrvR2+ZHr
GthdzH6R3smgb/Q05xmpGkgOcF9rxTGY0/uq2y5YA4Irp/Nm9zOYvcLKa7qb
BlRuC/n1IwwukzWdMmE0INxTl9lhQjDVeFIWb5iDI2/kbkWTCNZsrDsw8QUH
v8jujPeYQfCFSlUmus3Bk2re8Ko5BEvu2HXPUXIQ6xQl+GRH8DviuUKk4OBQ
QK+LlQNBhyBFbcJeDoyKVWkWXxFc93BlQmMoB3cX9IxWA8G4x46HyToODOsF
2U2eBIf8E+rGiDmIqAr0Svcj2HjJLabfmYNVkimied8TlFh63JDZcnAi8SWx
3UJw7IP4diPCgQPX7NT6M0GpfcGX6RM5cOG3bu/bSdDsY+q450YcnPcWN7zd
S5BsUSpE71nYdL9jZdJ+gpnhzZOlWhaSe1O701IJtlbMLxf2sGBw33JOcpTg
lPLSispXLDz1kCRL8whejRoUHnrGgmVMTkpoIcGYNerOsc0sFLdO/cOslODJ
8QMnkuupO09rbSoIOqZF7tTUsqCxDvRXVxN85BPKrb/NwvHMuPbEOoLBV+NS
fG+wUFlSmnSwkaBLt6t8uIIFMmTq5fKMYP9OvVfRZRb0fXuWbHhN/+U56s6V
smBv4Ye+PQSbfjRPSrvAwqWogEi9lmDngLfvIiULRTHhN3lDBFV5seaSQhae
qX6rsqFWT3qcv5xa4JhdsYr6ruCw/SJqKXevLJN6X+z0jVOpHUMsC+e+J3hD
HKJ5e5aF6sAmOQ4T9MmQv0mgbnFZsinxI8Ey3bah22dYMMn1CjpHbcS/N/Eq
9dLB4PV/Ur8+4G1XTJ1bnr7GfISgooMNyaDevFAtKaCeLpxnEUzdO+vk4rv/
EhSXLEJj6pnxlxd2Uetsmo8PFrDg3f5ggeAT3btGbnhHXZZtsPajjldKqp5Q
xwp9LDqoBQN5O4qolZE/TTMZJTiytU19gvp5w97JC6h/TxJtU1C7pignRFPv
mtsaLqOO7K4WHKO2bXDVR1Cf+uYJ/zq1qez8vmDqpjO9xn9R829ZCgOoef9n
Jv7qdPTsaur/AGpoR1o=
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl0Hsw1WkYB3C5tnKdLqv3bYVEqawuIieeR00YSyWbMrmkU8M6Iq0UrcGe
WLVUrHt15NLFdNG2KpU9S1RqKJezuZTcNvX7ncM5QhuV9m32mXnmmc88fzzP
fM13RW3Zo66mpubN+sv8vwgaudMEQycVSF07F5kxw/FP/352VEGC+LoPMjsF
mDSoHFQwqb2nNInZNS89tM1eBaP6j92mTSM4evHI2dPLVTBIszPU1Ql6Sg4O
uCxWQaPDIqqlSdDPBMZrTVSQH7V5te50gvF/n10fN6KEWMOm9Fojgj99OA/j
kUp4GLBN65UJwVLb3DW3p4YhoWNjUY8ZwTkLRK81C4Yh7sh+/18WE9w50fHq
u5XDwHWX2p9aTlAYkOzZ/HwIJKHTVgQ4EZRdKM06fGQIquY3bhpbR9DNxTzu
hv0QuKWUnXjvSfDD5XHZ2IgC5tJyZbkvwRiDuhbnqwrYGXQ3+uEOgi8Eyf7q
MQrQa3aaXS0kGPtBZ60AFDAVPdgRGEEww08nVaSrAGFtkVQUQzBMYDL1+YUc
DFxT6q0SCGYNbRKVVsjBVNkur0ph/wrDn91MlUOxp6P9rQyC8xYtuScWyiH8
Wb1kVy7Bx2XZeT4ohwuGwTbxErZPyhnUs5CDTdzCZy4XCFpZ/NDcriEHY2P/
0q4KgspwkWPBGx4i/Aqz+m8RNJA+z7Rp4UG/Uackr4bgW8XeoZrbPJgrf26r
aiDYACurJed4KESR1e/NBLdU2LYE/8aD/73EAr9Ogh/Nml3mJ/OQPlJsG9ZH
sCRTrSoimgdNH9WAFU9Q71hPfE0ID30vL92pfkuw18zW4owvDyvIgT+kkwSX
deZbxLjz0JAS3rhXg+Kl4TBfLwEPrZK9OkdnUKzy2Qoddjy4DnYLD8+kWBdZ
dznImod3gfG9ZB7Fj74VFgPf8GAqtky0sqSY1Gq05e5s9k/HpHPPUorusXJZ
jj4Pkc9fmmraU2SpHsrW5qFSz85czZnde6IfJVDjASOvrC/fQLFpjot7/wQH
mOCYJvWm6ChLLYkY4yC1WqlI8qO4z143c2KYAzubWT+SYIpFgZZgyHOwcYMb
NQtl99e+/Ch7xcH1k2UDrVEUbZq195/q4+DYUaMnIwcpTtZNBk50c/DgGtf5
OpFi4fD7fVe7OPCYrtT6NY3ieMiosbCdAxd99e8LT1LcvTn/zwwZB/tEJj5S
5rRV93OTmYsf2W7sZw45vzrmALNm6g4Pm0yKslV9gkDmx1OVa+8w9y1cMrWU
easqdGFXFsUn2zd4N7VxENHW9G5uDkXT9W4zjJkly/8ZdWZ+IbYO12J+emJS
FcI8FmDaNNHKwQova3k5cyN1L+pnfl+f1LMml+Lx2oCYSmbxzZUN/nkUcz75
925nrpzleT+B+e1tLtGbeXD/znvFzFbbDi1Yx+zxbUY1x5yXlx67hNng4uC1
uHyKUs1wr6kWlr/2pytnmMX5j2aMMkfvnnmpllnRO+/pa2aZGZ77qoBit3pB
SAuzdqJfyTJmh6//snvA7NAdUeTD3L61TeMuc5hAfPoAc1CgrKuCubDgS1F8
01hzo4z5P5f+SSc=
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVzw801XcUAHDEe4zENOr9vr+nZFqxVMyf0L2oORkqyizjlPzr/3olNVmi
zBPlNJOeIVTKypZe+VMLccoierVF9E9Tfd97PE//mLB9u+fc8z2fc++5935n
Rm0LjtHT0dEJZPnhlR3/EBz63+kLcEzXQFiP5Hots8vhSj3xAQ1Y8QHqB8wS
aX7k5FQN5J6Y8BTJOOysHhNqkjWQXb7+qYxZbhDKVSdoIOXS57N/KeDQPFLP
Kj5GA7GKRnlRIYdXLXze+y7VwEIjVUdZCesvy9vRJdCA2dlYu/AKDiem7ZKU
/jgA695pi36o4tBr3GPQSzQAVhLqtqeOw5xYx8ekuh8sxCavZzRxaBgo8hwO
6Ye0RK8O51YOZygyqqom1OCmW9D69h6H/y2MMMs9q4bg2hhl9kMOXWWK3LZv
1fBUvHjO0T4Oh8qu8k0iNVyU+0h9B9j+NBejpi4VjA6vMl73lsP+wVmGuidU
cHrDX5Wrxzns+OSYIGezCvKNUyTDBgR/71h00tJdBeNr3MMMTAnGb5KnK0xU
cKZbHNlgSTDRYO247KkSajK2Hwy2Jhg2FF5ZXaMEjz5F+4rZBL/6LbU5Pk8J
+t9Fuo05snp23DXRTiV4nx1psnAjeCpuAGWhSmj+uH5bFxJMX2X972fuSvi1
4pXnzmUEW/xejMrEShBonRz2riT4s3bUtVmohPKYEo8Fawj2HqsLfaWlcCWD
bAmOInirO6g8+BEF5279Bv+NBKubk3QzWym8Dp/upJUQ1PQK6utrKdgd8mjR
TSK4sidnRFJBoUglTW5II3gtQBjiUEAhaffSVaFZBF8kOBRHZ1Nou2gaGJZL
8Ho0SDL3U4iy1o8VFhI8/JPe1gsJFDa7CUtsThGMSJSQ/Zso9OxLHJ96nmBI
Yv6bJVEUcoYtvpdfImgmGOsVfEOhhlyb1vAHwYep1RqLleweSW7n7hsEM6AL
Zi2jYJiwu6awnWBpf3DAch8KQaf/rDt+n83f4h1v7UmhW+j3yOcJ+8/l9tjB
L5gt784Me0nQeUj+aeF8CjNCpekiLUH1Sdu4QHsKt5rOm8hHCAorGodS7SjQ
x0/ktTo8Rrg0WkbbUAiYuzh5sxGPRJKpWSqmYDurIu6QOY9rQoLjrogorPVP
27F/Oo+hd1zuHrSi8Kwko9jWhsfLpaO3l0+l0HW6YMBpLo9H87w7s8wpfGRQ
pfqa+Z6x038pzB7rW14mMd+MDrRPYC6yftvbxOyvenckgjk6P+h+iD2Pwr1v
MucxD0p163c48Dh3zuovFWYUBFvici7O4/FqZWnLdGa31uTsTmabu88lpswb
5uRmvmf2nWo7cxJz2/OGA76OPB6IyJL2T6FwNFK05x7z+7E+aT0zv+L2utfz
eaxT7POLZQ6q/CfSagGPefbt88OZU0xGwz2Y1ft0xSuYn7XYhaYx02Jz/UXM
Z7xT/C0W8rjgyIWJyczdxXl+rsxZh3SFk5iNJ84tCWeWFdlbjJhS2Fr3YHEZ
81ixoesz5hPTtB43mS17aoI6mRW7BO5q5u03vDa2Mev9TVymOPFYZJQnbWR2
dvoQPJYHNJy7zPw/sCMq3A==
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVzntM02cUBmC8DOeQgihiJ99n5TKGitu0IMjmOcKmTLm4gqE4WQALoigO
WhFR1JWGUcJlgIrKrFXkMoEFgTG8xDRDQRQQUcAIKNP6awt1lYmuCso+3+Tk
5PnjTd5FMbtFsVMtLCyC2L3/whXvQ9A3o69VUGqEf2WztoQy9y0oKCFnjHCh
8alCyryxYsJ2wWkjLFt1vLeeOa2cDjmUGMFtzdt9QiHBsSUffMQvMsLHIa0a
T0+CTZnronwyjGCR8H2w90qCsmvCi8+3GqH9bMb2r3wJphYvlHzmZoTzfhaa
MX+CKYJQc2TVCIznZ3vPDyT4Qj4jWosjcMFK3m0XRvApb9wtfmgYav4sy7m0
haBh0dx03aFhILP74jslBE9fUHxiWDoM3SeFsfm7CBZ8l9tg88AARtGk3C2F
IK9FlRKWb4C0pr6/lhwkqGzfqLUOMUBQ8IDTYCbBpavTZV08Axwp+OfcmzyC
xsSbEwV9esBpiQGmYwTtLQZWHi7Tw/Iy/qyC0wR31oo2xEn1UDzWPaqqICju
dpGGBOjBT9b0X0QtwefcqVtriR5ETlYLjU0EzY2RvdJXOuhJT4gf1hCsfCz2
sOnRgWqm+c7RNoJZHpPRVfU66PcrjKy5Q/D+GtewsWM6+KFaPDP5AdvTReYG
pungm69zeq2fENw3XxsrjdKBWtlx3X6E9Ut5R7zX62DN5Kqemy8IJhTmy6cK
dbDJqdHSOE7QvVjcpRfooFOqitBOo5jhlVV8wkYHuS/r2pWzKD5McugIeMeB
xqUnumQuRbWtOV1i4sBb4eywmVAMbDC6Zg5xYG/36JnJlaKr+0CW410O4oIq
uVEPioZBc0BRKwcTTacm1V4UU2wH3K2ucGDZrV51ZTXFhkvq7YI6DvbwZxf/
vpZitWkixPk3DhYX1MwJDqG4N69G7KLmQNQYXhcRzvZt66vadpztsVqWZBdF
8YVqZEXNLxyc5dmJVsZTzBX4PpqRzYEetoat+JFim6LTZ6qCA9mZoZSBVIqj
G9r2TqQz1yZcHj1M8UnR9JzOVA4umZwEDUqKNp+Wzy6VciCJXFceVEgxc3Gs
6HUiB/LUfcGhJymac3tPvNrBAdfcN8+ylKLgcWD+WBwHV6/4T3Gtoqj0aPaU
b+XgzRNH6wX1FO8ObsqOieLggK+Tz9XLFO0qryb7RXKQjJ4/dzRTPGjJDy/c
zME51QbFKLMHz3A7k7lnIvon+2sUTxZeD9zP7H0xb38k87wYlUjC/O4L/e5n
zN/uqMjzYlY6l4itWyjmePW39EdwoLacsjjoBkVN8PRl7szdEge3JOY9XtWu
lHlas4fLUWYZT7hoDnPcoc10kNmfPnR+K+ZgibneblcbxXOaPeF3mBsNceM5
Nymuv6xISWPWr0s31zIXSpRVu5n55UUv7zHbJom1EuYDMRqT4y2K+qiN0SHM
fv18bTXzjWR5lguzzOfzv7uYvWb+0c9nLite+3CMeef2iuU2zB+GSe9/2U4x
1L9l5HU4Bz51yp4oZh/H50Em5h226m4Fc1j6vXot86+Jjbcrmbc5JJMHzB3t
70PxfElr9m3m/wEHjkEZ
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV0H9czHccB/C0fqyf1pIk3ecbuqGhX+vK0fvddKjJnZNZtSkVze6k7ZE2
k10PlYQiyjJRD5SmOiUhN2o1rlYR8pCWmPt+77qrNlzlsSj7eD0e78f78fzr
9X683eO2SzebmpiYhNN5tzs73oWHDXumRHm3G+CgffnoEHX7huzapW0GCJMo
eHadPBzu8ypfpTbArfveyeHU4Tfmb4lrMUBT7zHH29QWtWuFJ1UGqBuIjbpz
m4c/pp2Z6lVlgONmo7q7XTz0D75m25ZrgM1L3d572M3D1uzU4etSAyzvOx6Z
95iH5rWfHtnaq4eC+XPv1XI8DF0vGfn3Oz2ElbnKq4Z5aOVqdc7TSQ8r1gI/
YoyHgfIxy/grA3D5fLLp15M8XF0jCldtGQCZ3+3JeZYEN3U5bhNMH4CsoaJZ
v08lKKqW+f7cqQNH6bdf3nQm2FS9Vsgc0oFWt+O3VIagjeTOnIsSHSz03BdU
MI+gtUOzu6mrDh4VWz7b50UwYbBdEWnQQntQXdmCQII6X9sXFQ1a8MqTHwgI
JticgJrWQ1r4y06abwwleETYXDK2WQuDqrNXs6QE1zXIaoWohSRnc9PMKIKe
TWkaNdGC4Ey+bHE8QQ+H8aGItxyk9Hm+WiEj2PHY/41cw8Er0cvTNikEDQGK
pKNqDvofeySfSyMYezX74x1KDgLnJMZcyCRYODZe01vEQW9Rd1JCLkHNT4r7
IRkc/KMSl2YVEuS6QrlLyRwk2gUYd58kOE1wOutZDAf8Q6u3zCknaGZTWWIv
5iDyRtJrPyXBTLNfGwqRg7tu12uMlwl+WHqpZLYPB8rKH7JzGgmGNEY0uXhw
8FYbnH5ATbDUPbFe48JBoVRwfEkX/S/frUVpz0GJbEn3+h6CRwcX7rcx58C+
7rzXqqcEL+ReE4nfsNCyYGW1boDgn9oPvPONLAyKX3xmfE77U1ZJbYdYiCxT
W1f9R3CkQ1GUw7Lg1v1gx4AJgy3jlr7T+llokk+mas0YzIxzmAjsYWGv27L3
hVYMNiRJKmPusWBetue8yI7BkQJr1w2dLJwL6e8rd2Aw3eegQdLKQtqu5yVG
Jwa/6UjpbG1hwTrHKmXMhcGKNZGmmkYWVMqAHjGPweJfop9OqFjgVyaFx8xm
UDw5Gnf2Kr0/KHpdFJ9Bv8Pr4EQ9CxmGr/SVCxjcG3/0Yv5FFibkiYfrFjGY
+sp+fOQCC9OLX+bdpHZxMr+lp17Uvjv3IfWxXYbCfurY+QX7X1PvK94d3Er9
B9eUuXwxg2EnTqlPUO/fOHPnfeq2nKK85dQzJJ2bjF4MOn4yPFGoZMFb8UWs
uTeDgZJ5ogPUYUrNRmfqaVs/OpxOnWY7Hi2knhsm95ZRP2nlf55BPevJYClS
lwenhzn6MKjLKPYZqmahMdkm1INa3baz/m/qnpJjKwXUKleLpQ+prSerQqKp
f7rCj2im3nbtUdAZ6iW18TVF1Hv1CcvqqdcICiV51KdmPBeqqRVpspEM6q5U
i8BBahF/ysrt1PqyfMEEtcXE9dEEatMHs/yn+jLo//3MiihqV7MKP3dqG7HT
Rgm1n++7MOgJ1c4rqP8HM8M/XA==
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwd0n04FXYUB3Dj3qUp3Kge1tahFyJNDyalzmmmbqVdS5ZcTDcJI+Ql0qrp
xUpTCdVqWC5PL5oKtztJV61GRXWVRNH87r3urFZi1F1qv3ae5zzn+Tzn/HWe
r50sftkaYyMjo6W83013t3cFJAhzNil5o0eru0ULfbgLtmUsvfhajy+SR4UE
cAtpnmubQY9nFdrtSdyDDiF1FkN6nDH7UGsld3NZ/dCOZ3p0mD+c7u4O1DtY
Up3zWI+2kt9VHh5AT8wCrS2v6PFtjPSLWZ5AKpfm+Q279Pi05vCrA3OAsn7y
l5uN1WP+H53VpQg0tUn8/PiZHowvajcu8QH6uDM06GxgD8amPOkaXAiUIz+1
t9qgw0n2wmYjPyB5gWRZarkOh3Vufqv8+f2qyEcrw3Q40sdGeno50KJTjfWa
8Tq8lSLMqAgC2r/G4L2kQ4tK1Qhn01Cglqn65TWFWpR2Wz4ZtwrIMjq5Qh6j
Rdcjt+eK1gDd/dbEED9Hi46xZRNl0UBx1iF5bqO02G61bUx0HP9PXObhA0yD
FS0p+dcSgV6k57w1uqBBhdPEExapQLHBSSmRBRrcEHSryXwjkOy+rKo3VYPS
wvzMiM18P8L/t/gVGnxVIxMnZAJtbo+EUG8N1jzzLVTvBHJp3p8YZKfB0xe6
tkM2kOLhWheDqQaDw7ZumrwXaFaTh1owwNDJxlOw5QBQeVdjn1UXw6qTA0f3
HgSKejlaK2pimNASdS37CNDNGrJR1TKUWPdv6SwC+uTzG+rYcoZ65+2Le0qA
VsooW1bIUC51Ll1wHCi7LomF7mOYa79r3/5yoFF5WaXKbQxnq57uyT0DpNx4
d0lbGkNhapRNbxVQd99q41dxDHcb9yqGlPzfnyqTiiIYzp9qr31eCxQ23Wtg
SgjDD2UJJVQP9NIi/NzJAIYVyVfXL7gK1CYN9/vaj2Fkkav6WCPPw7TXhrG+
DFuLj31W3QSkHRL335nHMN3rhk/lHaBL7z9Nm+zFEHtH3hvRCtQw+QhLdWNY
lyjZMKYd6LtDm2/mzWAYLjp1IqkTSNRnYlI9jaGH+GKsqhto08EFuyRTGF4J
bKUrOqC1iervs+wYJmcISyf8BWSbED9d9RHDrg1zbKc/43lft3DRVluGm8wc
waEfqM/z15U54xl6n3dSpA0BnTzvKjhqzVDh5R669V+gf86P9rEaw/BW1CVp
LndZXWmEKbf+4OJgOfcbg/nuYRFD28HwFQ3cYqXkcQ/3lnM/fGn5GggeRNTU
coude3yLuQ0dlZPWcndM+HGGahjowY5f6ussGQ4smeKi5t4X8Ci4its844yz
hrvqq8qhE9z04Jqj6RsgXYfEO59bnt9v78+dK3Lo+4Z7nfnS8Y+5xRNnmtpy
Z81tG/uCe6N4docFd3HsamvBW6A9ga1nhdzq6+kiR+5vx12O7rNg6JlVZpbA
vdrJV9DI7a+Y+UEmd0Dk5f467hhtrWketzarQVfFfdSnRajkdtgRc7+Yu3p9
mOA6906dyb0C7uaf/zR+yN07y651D3fP7eT3/uZGqm/P5Db6v+xIo+ruTuP+
Dy+6P2I=
      "]]}}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0.5, 1.8626264880202026`}, {0.5, 2.062193611736653}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0.9, 1.787916917654498}, {0.9, 1.9846124222532513`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{1.3, 1.7142823611815718`}, {1.3, 1.9080636972030254`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{1.7000000000000002`, 1.6417387473365141`}, {1.7000000000000002`,
      1.8325614159352963`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{2.1, 1.5703027346227771`}, {2.1, 1.7581201340086219`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{2.5, 1.4999917687982804`}, {2.5, 1.6847550231887656`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{2.9000000000000004`, 1.4308241469083391`}, {2.9000000000000004`,
      1.6124819153463126`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{3.3000000000000003`, 1.3628190888564102`}, {3.3000000000000003`,
      1.5413173507380475`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{3.7, 1.2959968176934025`}, {3.7, 1.471278631227114}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{4.1, 1.230378650040542}, {4.1, 1.4023838790789873`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{4.5, 1.1659870983520229`}, {4.5, 1.3346521020649131`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{4.9, 1.1028459870885081`}, {4.9, 1.2681032657129927`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{5.300000000000001, 1.0409805853333438`}, {5.300000000000001, 
     1.202758373670531}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{5.7, 0.9804177589704317}, {5.7, 1.1386395572795553`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{6.1000000000000005`, 0.9211861462978008}, {6.1000000000000005`, 
     1.0757701756186662`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{6.5, 0.8633163619320636}, {6.5, 1.0141749274229745`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{6.9, 0.806841235148025}, {6.9, 0.9538799764473052}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{7.300000000000001, 0.7517960905119212}, {7.300000000000001, 
     0.8949130919610079}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{7.7, 0.6982190809766184}, {7.7, 0.8373038061073067}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{8.100000000000001, 0.6461515867649487}, {8.100000000000001, 
     0.7810835897352608}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{0.5, 1.8626264880202026`}, {0.5, 1.7827996385336224`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{0.9, 1.7827996385336224`}, {0.9, 1.704121436694121}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{1.3, 1.704121436694121}, {1.3, 1.6266089022855397`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{1.7000000000000002`, 1.6266089022855397`}, {1.7000000000000002`,
      1.5502798348460267`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.1, 1.5502798348460267`}, {2.1, 1.475152875091689}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.5, 1.475152875091689}, {2.5, 1.4012475733354948`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.9000000000000004`, 1.4012475733354948`}, {2.9000000000000004`,
      1.3285844659603054`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{3.3000000000000003`, 1.3285844659603054`}, {3.3000000000000003`,
      1.2571851612076506`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{3.7, 1.2571851612076506`}, {3.7, 1.187072435794166}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{4.1, 1.187072435794166}, {4.1, 1.1182703441787878`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{4.5, 1.1182703441787878`}, {4.5, 1.0508043426936318`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{4.9, 1.0508043426936318`}, {4.9, 0.984701431243838}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{5.300000000000001, 0.984701431243838}, {5.300000000000001, 
     0.9199903159089632}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{5.7, 0.9199903159089632}, {5.7, 0.8567015965853138}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{6.1000000000000005`, 0.8567015965853138}, {6.1000000000000005`, 
     0.7948679848569675}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{6.5, 0.7948679848569675}, {6.5, 0.7345245586606032}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{6.9, 0.7345245586606032}, {6.9, 0.6757090621408911}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{7.300000000000001, 0.6757090621408911}, {7.300000000000001, 
     0.6184622615612564}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{7.7, 0.6184622615612564}, {7.7, 0.5628283715089811}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{8.100000000000001, 0.5628283715089811}, {8.100000000000001, 
     0.5088555703208563}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{0.5, 1.7827996385336224`}, {0.9, 1.7827996385336224`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{0.9, 1.704121436694121}, {1.3, 1.704121436694121}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{1.3, 1.6266089022855397`}, {1.7000000000000002`, 
     1.6266089022855397`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{1.7000000000000002`, 1.5502798348460267`}, {2.1, 
     1.5502798348460267`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.1, 1.475152875091689}, {2.5, 1.475152875091689}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.5, 1.4012475733354948`}, {2.9000000000000004`, 
     1.4012475733354948`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.9000000000000004`, 1.3285844659603054`}, {3.3000000000000003`,
      1.3285844659603054`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{3.3000000000000003`, 1.2571851612076506`}, {3.7, 
     1.2571851612076506`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{3.7, 1.187072435794166}, {4.1, 1.187072435794166}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{4.1, 1.1182703441787878`}, {4.5, 1.1182703441787878`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{4.5, 1.0508043426936318`}, {4.9, 1.0508043426936318`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{4.9, 0.984701431243838}, {5.300000000000001, 
     0.984701431243838}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{5.300000000000001, 0.9199903159089632}, {5.7, 
     0.9199903159089632}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{5.7, 0.8567015965853138}, {6.1000000000000005`, 
     0.8567015965853138}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{6.1000000000000005`, 0.7948679848569675}, {6.5, 
     0.7948679848569675}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{6.5, 0.7345245586606032}, {6.9, 0.7345245586606032}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{6.9, 0.6757090621408911}, {7.300000000000001, 
     0.6757090621408911}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{7.300000000000001, 0.6184622615612564}, {7.7, 
     0.6184622615612564}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{7.7, 0.5628283715089811}, {8.100000000000001, 
     0.5628283715089811}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{8.100000000000001, 0.5088555703208563}, {8.5, 
     0.5088555703208563}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0, 1.8626264880202026`}, {0.5, 1.8626264880202026`}}]}, {{
     InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         StyleBox[
          SubscriptBox["\[Tau]", "d"],
          FontSize->12], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.1",
           FontSize->12], 
          StyleBox["  ",
           FontSize->12], 
          StyleBox["ms",
           FontSize->12], " "}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[1.]], {6.308580322588407, 2.054944592678058}, {
      Left, Baseline},
      Alignment->{Left, Top}], InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         StyleBox[
          SubscriptBox["\[Tau]", "e"],
          FontSize->12], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.5",
           FontSize->12], 
          StyleBox["  ",
           FontSize->12], 
          StyleBox["ms",
           FontSize->12], " "}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[1.]], {6.308580322588407, 2.2771668149002804`}, {
      Left, Baseline},
      Alignment->{Left, Top}]}, InsetBox[
     StyleBox[
      TagBox[
       RowBox[{
        SubscriptBox[
         StyleBox["v",
          FontSize->12], "r"], 
        StyleBox["=",
         FontSize->12], 
        StyleBox[" ",
         FontSize->12], 
        RowBox[{
         StyleBox["0.05",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["mV",
           FontSize->12], 
          StyleBox["/",
           FontSize->12], 
          StyleBox["s",
           FontSize->12], " "}]}]}],
       "RawBoxes"],
      FontFamily->"Arial",
      FontSize->10,
      Background->GrayLevel[1.]], {5.92687074829932, 1.8239021841278995`}, {
     Left, Baseline},
     Alignment->{Left, Top}]}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{-1., 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {6, 
      FormBox["6", TraditionalForm]}, {7, 
      FormBox["7", TraditionalForm]}, {8, 
      FormBox["8", TraditionalForm]}, {9, 
      FormBox["9", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{41., 25.}, {55., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{0., 8.5}, {0., 2.5}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.919166248685154*^9, 3.919166252297304*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, -0.7}, {0.5, -0.6799999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.9, -0.6799999999999999}, {0.9, -0.6599999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{1.3, -0.6599999999999999}, {1.3, -0.6399999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{1.7000000000000002`, -0.6399999999999999}, {
     1.7000000000000002`, -0.62}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.1, -0.62}, {2.1, -0.6}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.5, -0.6}, {2.5, -0.58}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.9000000000000004`, -0.58}, {
     2.9000000000000004`, -0.5599999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{3.3000000000000003`, -0.5599999999999999}, {
     3.3000000000000003`, -0.5399999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{3.7, -0.5399999999999999}, {3.7, -0.52}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{4.1, -0.52}, {4.1, -0.49999999999999994`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{4.5, -0.49999999999999994`}, {4.5, -0.48}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{4.9, -0.48}, {4.9, -0.45999999999999996`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{5.300000000000001, -0.45999999999999996`}, {
     5.300000000000001, -0.43999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{5.7, -0.43999999999999995`}, {5.7, -0.41999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{6.1000000000000005`, -0.41999999999999993`}, {
     6.1000000000000005`, -0.39999999999999997`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{6.5, -0.39999999999999997`}, {6.5, -0.37999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{6.9, -0.37999999999999995`}, {6.9, -0.35999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{7.300000000000001, -0.35999999999999993`}, {
     7.300000000000001, -0.33999999999999997`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{7.7, -0.33999999999999997`}, {7.7, -0.31999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{8.100000000000001, -0.31999999999999995`}, {
     8.100000000000001, -0.29999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, -0.6799999999999999}, {0.9, -0.6799999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.9, -0.6599999999999999}, {1.3, -0.6599999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{1.3, -0.6399999999999999}, {
     1.7000000000000002`, -0.6399999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{1.7000000000000002`, -0.62}, {2.1, -0.62}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.1, -0.6}, {2.5, -0.6}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.5, -0.58}, {2.9000000000000004`, -0.58}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.9000000000000004`, -0.5599999999999999}, {
     3.3000000000000003`, -0.5599999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{3.3000000000000003`, -0.5399999999999999}, {
     3.7, -0.5399999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{3.7, -0.52}, {4.1, -0.52}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{4.1, -0.49999999999999994`}, {4.5, -0.49999999999999994`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{4.5, -0.48}, {4.9, -0.48}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{4.9, -0.45999999999999996`}, {
     5.300000000000001, -0.45999999999999996`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{5.300000000000001, -0.43999999999999995`}, {
     5.7, -0.43999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{5.7, -0.41999999999999993`}, {
     6.1000000000000005`, -0.41999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{6.1000000000000005`, -0.39999999999999997`}, {
     6.5, -0.39999999999999997`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{6.5, -0.37999999999999995`}, {6.9, -0.37999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{6.9, -0.35999999999999993`}, {
     7.300000000000001, -0.35999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{7.300000000000001, -0.33999999999999997`}, {
     7.7, -0.33999999999999997`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{7.7, -0.31999999999999995`}, {
     8.100000000000001, -0.31999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{8.100000000000001, -0.29999999999999993`}, {
     8.5, -0.29999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0, -0.7}, {0.5, -0.7}}]}},
  AspectRatio->0.2,
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"t (ms)\"", FontSize -> 16, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox["\"V (V)\"", FontSize -> 20, StripOnInput -> False], 
     TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {6, 
      FormBox["6", TraditionalForm]}, {7, 
      FormBox["7", TraditionalForm]}, {8, 
      FormBox["8", TraditionalForm]}, {9, 
      FormBox["9", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}}, {{-0.7, 
      FormBox[
       RowBox[{"-", "0.7`"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {-0.3, 
      FormBox[
       RowBox[{"-", "0.3`"}], TraditionalForm]}}, None, None},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  PlotRange->{{0, 8.5}, {-0.75, -0.2}}]], "Output",
 CellChangeTimes->{
  3.9189932955210476`*^9, 3.9189933265856853`*^9, {3.9189936207978983`*^9, 
   3.9189936378399563`*^9}, {3.9189936689762*^9, 3.9189936784841757`*^9}, 
   3.9189938752004704`*^9, {3.918995236896613*^9, 3.9189953717697845`*^9}, {
   3.918995448402794*^9, 3.9189954880442696`*^9}, 3.9189955484914293`*^9, {
   3.918995586834073*^9, 3.9189955986817226`*^9}, {3.918995719267539*^9, 
   3.918995724358102*^9}, 3.9189957641570625`*^9, 3.919045719467263*^9, 
   3.9190457570114045`*^9, 3.9190457982558703`*^9, 3.919045848390644*^9, 
   3.919045891177925*^9, 3.919046135499894*^9, 3.9190468927573175`*^9, 
   3.919046927854157*^9, 3.9190469624583406`*^9, 3.919165406285101*^9, 
   3.9191654718272643`*^9, {3.9191655158768663`*^9, 3.91916554137982*^9}, 
   3.919165592382147*^9, {3.9191656307412305`*^9, 3.9191656369591627`*^9}, 
   3.9191656863230677`*^9, {3.9191657876247454`*^9, 3.919165797707838*^9}, 
   3.9191658677048283`*^9, {3.919165903013497*^9, 3.9191659236632724`*^9}, 
   3.919165999978963*^9, {3.919166073035132*^9, 3.9191660928951626`*^9}, {
   3.919166168192665*^9, 3.919166194761424*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4VN8bAPBBdqkkWQpFitKioijvqISsKZKSNVlC5KsSSqVkKSGEyhIp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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk0VW8XB3Bx5xGhiCQSQqZE09lEMlQyh5CSJlIoMqSopCQkIvLLVBTK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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4FP8fAHBJl4rMzM7aypHclaNDKjVvkqQoCuVIhZIiIVQUydGlSAiJ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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk8Fd8bB3Apa5siMXNn7k2plCXV1xKZJ0koO1lSliIUISGVskaKFlFC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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4Ve8TAPAsFUUqkpLlnHMjQvtiqTOWZC3JlmTJkn1LIVIqioiUVJZE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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2XlUTV0bAHCahGhEFI3nnJuUkGadXYmkEA2kKJrTqAhJadaoqLwlURqk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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk0Vt0XB3BTQkiGIlOm6t77kEpCcjciCkmGEhmSqaikUqk3SSqiqPCS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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4Vd/XAHBTQkqZkmROpnPOTcaUs5GiUMmUFDIrs6JoJMkQSdEvSeYp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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4V08XAHBbtoRkq+xJRXTvlyyl7qgoRSJKUiRLyFaWrCGRECJSKkoI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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xc8Vt8fAHCb+kqoUEnIKMq498lK3dMyQiKVSJGtZCQkJGRkRFlZEUk0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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xc4lt8bAHAro68kRUJGIamsnudF0XNIysiuJLNsGZWQEJKMSkSLCkmy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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4Vd/XAHBTooRSkmQoJBWSzrlCZ6eQItEkVAoZylAJCUkiU5nJFPKT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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2XdYjt8bAPCWxDdFlBWKSgPtep639BxFGRkNpCUtDS0kWpK0tCftSFEa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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xc8l98XAHArSUJCJWUmqSTKeJ5P3ZtEQ4MWShSysiKbrMjeDSOjqIzI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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4VV0XAHBToldooIlQyFCIQjrn7t1ASIlUkqJQqKTITJKQVISMlSlk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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwd2Xk4lU0UAHBbpAXZQrKUShQia3pnKlSWJJKUECoUoihRSGTNruwkFZKs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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk41c/3AHCirEllJyH5UsiSXWZuSRSSEEKl8pG9xZq9xb6EspbKFskW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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xc8le0bAHBCJKtCQrLyUspKSXI/z0lGRSokIRkNIyOblPGWkGSvplWS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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xc4lt8bAHArJCHfSEYZqTStkOScnldGZTRIQiWl7IaZUgiRURQiioxs
osioiJCGrEjoee1QiZDR7z5+/nF9Lu/7POfc5z73uc9FysrpwCk2FhaWalYW
FvJ74QdT+KDVecXGnQNoRW3AyuXgQ34BiwWVB9CW2/xK68FXPnfLHt8wgMzX
rD5tBNYe7n0vt2IAFelq1j8AR4YtMnD+1Y+cb3lF79pF4bH8tJbCtH7ULT0t
70tR+Pu+3xOBUv1o8vvVPVHgGCntdr+V/YivkNs6A2x0bM3ekGX9SENHJKoR
PPTfUr9K1n4Ubac6J8OgMO9/i5Qr6T5kVOBS+xocWh31dz6lD73YPXaCczeF
LTKGLg+q9iGDy3s2iYORAFVWJd+HOgsS/yiAq4zrV2bL9aF5mYPBFuCZRuvP
iWJ9SIOtoKAAHDCQpizK0oeel7twndSm8K1aWnLr215UoDqd+UIHnj94T97x
bC/Sctrv1gy2RPVv0k72osaUx7u+gwfuvJQbsehFY0JmLcK6FM7UjVkScaAX
KYw//+cA1pcu9dqv0Yuyc70OiOtROPmMrnjwsl70WI5lyn0PhZ84bx3zr+hB
tr5ZRiHgDZ/j4jeW96BNX80ePwTzhjsothb3oOzwQrM68MbYgB4qrwcVTNqW
ie2l8HD4DS27Bz2ovKrZpxzcYBby/I93D/p0ImMphz6FGz+f5Mln9KCIEtPT
ImCBnl35q3EPOiTE+WIT2P44F3uERg9qrTnubAw+98P1UtC2HtSxVbgxBbx/
G+Njyboe1D93NVrPgMKXi1s8JJf2oNkYE5kwQwpzprbxFH1hojy/VqEk8Jaz
hqvbPjPRaSdT7mfgFYURj+ebmahBy2ykE/ygoZ398EcmSvlh8WyLEeRTwTy/
RhUTGe0+tfc9uKlmMKshh4ke/bxwYekBCt+tddSfD2CiI1/GT0mBHb9auj68
zkR81S6m28Dq2hx7dX2ZyCPWbacFmF6S1v3gChMZaF/iygJ/2Pdh9WUXJpqK
9Yndd5DCL480Snw9yUT6Orcqgw9RWIJfyVCYwUSeD+jTD8H1RqoefzETpU0r
8TwDF3XWy9OaTMSR2WJEg5vaKuVL1ZmoVEC8U82Ywj91n7+PUWSiTe0pU73g
vMcVHn+kmYjXoXQzPkxhhsdjRX5OJlKvXtpgDG6VZpU342CiM6uPXbQDn+FI
X5rGxkSvG1hL7oLjJe+Y7PtHIy8VHd0RcGbLqpinUzT6/q/B6p4phX8PXX23
dJhGdbf7o8aPUDjcY6g/tYlGG/hCa7nNYPwrhjMsGml044byjDj4lfYBN6FP
NNK9es1yN9joZciK4A80qnYQk70LZjVPlA2to1GlrmG+6lEKX/c0ffPzJY1K
55/We5pDPtoyw//LoZG4p8V8KPhTRZUTRzaNLk2wyyeBBRqEp/9k0kh92Cji
LZjTJpTlWzqNituGjohbUNhc0/NeTQqNnhas6i8DJw+kvmbG0yjH1p+V9RiF
/65xEtgeTqPAQ3NMYfDiozO0ThiNjmterN4E9nS5ZmQaSiMBQatgU/CJ4tBf
l2/S6HzxTqFccL6XGktHII2UuSfWHzsO+VDJwv7tGo2Kkk8alZ2gsJnCTfG5
izQKD2tXbARr+0ceVgef8dgvNAjuHLnW6X6BRiv1UftyK6h/HtvfTJ+jkee4
qLU9uClo4xseJxppMD65iZ2E+saSkGxzlkYvu3GChzXkl+qh4nlLGt08GiwW
Bj7t9HSPNdi0pTnqEVgl3r2zzoJGv97ahn8Aa0Rbcsaa00j6WeQ12VOwvzeI
yumY0cgvZOBkA5iLLd7gnTGsl3r4ejkbCqu1MrX99Wm0vLD9kSaY7/ik4GJw
91ZZqUPgyc++uTf30chD9vlKb7D90nCzu3tplC7Qw9MM3sKfq/VEj0a8/aoj
V89Q2KFKcY+gNo0+RnTlfT4L+9O48qA5otF7ee/SYfCvjtMJc5o0qn+36g2L
LYV9JzqvJIBruCw71oMFtz+Z6NlJoxeXOjg9wI6znOmuGjTKPtl2dKUdhU2W
P7Et2A7xUGpcZGZPYZl9il4RyjQK+nhewBF8veLM/d3gQAdBMR/w8ieb1KaU
YP6p++XTwQPbbFotwZfEPpr9BT8J2ZKmoEgjW/Z3Ofcc4H0yU2PDWyE+jdVH
vjhCPolxny7cSKPyThWhX+DStOhZJ/C2oZSPnE7wvHfx3BvB0qwBOorgN5Jj
lxM30Gh2i862G+Bvr/Rq7srRKC/ojYCqM+znLXeUI9fRSJSqeXP7HIX9GG/O
f5WB/NFX800Dv6pSMUwGcx1J0ywH900mBzmAx50CCwfBPBdZxf9JQzzv6ybh
8/B3KbOotWDf6Zoro+A/yifO+kvSaDi3dtueixDfH4dcrkvQKLIz1NsSzBPc
wn8UrMF7qPY8OGXUeEQeHGLTaR4LrtqT6vRVnEZbVv32HQYfN5fz3w52Chb/
FOoC691x9uGcKI3GTjk5NrrCfipi6c8XodG9COWifrA/hSXDwdSradZZ8PiW
C+EO4Ahxvztr3CjsdNp0uRxYuTG61AV8Jq/iQeIKGrngCh4Rdwqvcez2SRCm
0ZSoUKq5B4VHvMc0ypfD+NuygpzB+nPBuxPB8tHajn7gp3vcPfzBZ4Xct2WC
TfV2WhmC2/m/VM6AadEd8sz/aFTC8bD7nieFb9ZbXxcEXxndJNp2CQYbYn8y
dBmsR1bV3DC4Man7qBv4qZ3lNxYvCstmsrofB48OhKWtB/9qcRBVAh9jjqm4
gzNWTLG2C9AIfy46uOIyhfduV9y8BcxeoRVifAXi++1x2CgfjUR+ZEnZgQ/m
B861gTeJr3h6FXw1eiqkCmziOtiZAa7MSRK6D07fECrP5g39SmBPsT7YKKK1
MRss66AsW7iURvHWtqLc1yhso9MhGMtLoye3GrMlwLodx84GgWvKNRhK4B3L
mF88wGMi/PaW4A0em5YfAe9+96SsACyCi+tFwMPb5o6f8KFw4txalftLoN5y
hac+94XP7/5SWsRDo6smBnXvwZEZR9dkgt8k847QYPHZuIQE8CGtG4pL/CCf
H/Z99Ac7XvMpOwq+6qYpZgJOnLnYOAv+49WlPLWYRjw/j/zThGS5Ob69QA9s
hESkD4Jru02OInBUaIuWDXhsPktwG3jN5oNBYWD5zcl5kmBN231C3eBm36ms
KW6o1z2aG68FQP4ZlgZlgNs+yxyuDKSwrXWuvDg4+m7+hjbwLomwv4Jg00O7
5kfBM/5CTYvBLR8sk0VvULh4c07hJBeNPlXH/D4H/tOlKt8Eri/gD5cMgnrZ
hYbDwOXhMzWXgync7tfevAx82SAoLgJcu/W0NQ8X2V8rnR+DS1Wi/7GBSwJU
VjSD716JOTrOCefHlXOnNt2k8MSPF6mt4Dz7ftYvYO6XgVcegB/pNqqrhVJ4
Sa9dnDr4cNS2NH1wUPX7AmUwT1+U0EmwePuS1i1gZ1/znyFgo1+f1GTAO8t7
k5ngoT0fnHjBLUpTAmFhFF5/J+N+9yIaca+W6O8Np/CByuCwMHCJg/ehGXCO
mUlVENix9NsrgVswntFV7P7gpiMpcTvAKW8u3vUCP4zceuAW2M64UtQWrM5D
lWnchvPt6JNQbbDDxOmIiAgKn+yyfM8BPnB6VVgq2PSCzxZWsEprc1AJuEJ+
T+QcB41YirV8mOBo4STnP+BIL+lzSpGQP0sD7QbAz9k7DRrB44efWr0Dcwoa
8/x3l8L8l9hXxYK/+/ByrgP/LUyRjgZ//F3JugPMIji68Q44pllx2gocfXDf
vjDwphiBgXzwYU/vSl/wAcn6qgNR0I+rpl13ACdsYVy7HU1hnGG/QQs8u/Tt
5jSwwC7na7vAZiMH2svAnVK/OjTByzOtlAbBj332PdwODpLz6UUxFH5UEm25
Fey65pXeCPhT7rpkMbCBKBLUjYX1qo9SmGSnUeZ0dbkFOHSRL88EeHGbgd0F
cMw+gf4x8Osoy9fx4K6AqfRRsLrQFdcJsF6IiUUfWFagrD0xDvIrQ9KmBTy7
aEfS3H04Tw6m9heBg7lEOpfFw/7m36/zDCy6eEJkLZilOuhxIViNNyfUAHyY
Ld4lH+wiKOOZALbXaNqYCR5dtWT/rgToN2RFlj4Ad6l+mfd7QOGS8L+BN8CO
24u2x4DXc+koBYLn1e9czALf68rq8geLaxoONYPzPcs0/cCmWpXNax9SeFVb
oJA3+KNRRmYNmNHDIeMCrjh7yYw3CfqZSrU0K3Bd23ptafC157buJ8Cf9FoU
1MBcO5P2HAd/k1NYbA2+IiQ6YQFmGep7VgIue/bixBF2Ui8OCNk9gvMgny3K
CPzcVu5jbTLEa4PuUUze195S0gVe9XzRaUTet8cvdQIc1X/qvCa4bUPXFakU
CotOsoVrgKeGIjd7gF2HrTrVwCp2LMHrUyns4XeiSgH8xK51d0AahbUcL6ev
AWfbm76NA19WEx6QAac7tBnlgz3eja8lTnT6cvQr+GSjZ5oU+NaFrnNKjyls
7eb0fBXY6VL//S7w2vqtIivBG4MnJ1QzKCxlcSKLD7z2pvslfXBiWSM/sXTI
NMtJcMg6gwtLyXqHzSwJBUfKH9rJS/Ir4p9UD3idjcvXxeD+e1wG4Zlwf5GJ
3rcInJS+ImUgC/bL1z1fZtlgfd6NFM+CvyvKWhPP/6x8J5BNYfe24pEZsKmq
84QaOC50KTsx3+sarRvg2A1IZRrs8dWDKZcD+WHTXDYBNhTokLTLhfP9ttue
H2AvpXxlb3BTeODAKDjdJFA3Alz8RDGAmOO+snMJmCPToHoE/Fwu5MWSPAq3
hAfvHQbLMjQtM8GpGwzPDYJnXB7EjuTD+LMnZHrAiVw6x9mfwHz7CuqZYN2Y
kTUrwffYuF2JI0vVs7XAK1hP19HgTezNL2PBJsv6PL6BzcMX9+kVUHhpvszv
TnBZ+nn5lEK4bw4Y6raDrTVWTpSAXZ6+ZiXmef+iuAGcJpxX0gY2+cXLmAO/
sx6RJx5VTTU+9JTC1IlOyc/gVVVfPNmeQTztJ4VawN5dWlWWRRR+v3rc8BP5
fgQWuQAO6M0VJd6io2EXAI7++6q3AdyZrbQsF/x6rtOLWOOKtAVrMYVV2f9k
fwT/FWeZSAInXF8n/QHsYlayZvA53O9ojV314H18z9zmwIr64ULEayry65aV
wH5tWz/0Ftwkl+6sDtZIWhdJrDgdXRoMbt5g9L0O/DPK9dCWUuina34m14Lt
mhX8LpRBvb6Yo/cGrCLKei4AzCsRsZaY7dhHi1iwCZXFTnxvwFG1ElyR71te
Da6ZyRgSLIfzYkmuCvFa6bX788HbqRfyVeBuR9FVv15AvlN39SrBmU8GeRa9
pLCbRs4mYvepokkR8LzABD8xv8/hBgyWVOZsrQBr3on0CwdzdqvYEMeW8H3f
+orCdYJRYa9IvLnZixwr4D7XfGv+BRlfSaKxH1jiX2UPcZcj9TsGXBAl9Zb4
TPO1LVVg+V8W0cQeiSzJYpUQX+tGZeI4jflbNWDxDxdcysG087SddBX0V4ef
/ldG5rcmZrEaODKqYb6UxK9VLVUf/JlNYIh4fKc77Q4OdZh4SbxoyaTpB3Cu
orkz8frk8d1e1bC+eTbNJWCHth+rW97AeaE98/Q5eV92z94hcNUn+VRiU782
t3lw2mbvKGKtrZUf1tZQ+EXBKXdi8et3vd3AzY3GO4jr5Xd2idRCv+36sKqY
7I/AoPijdVCfJL8PFZH9ZeFd5wQ2cPv9lVhE6eIf3zryfIEGYo5OC4NM8Ac1
/2fEHUoK87Pg5cYnrhPf7Gq1iH8L8UktWkM8rCIr8a0ezk87iXPPwF88h6b/
gN2iIk4R15XntPC+g/W3kTAjTtVWD1cDezjZMYitTAzZw8GdPiPCxK0uHoOa
7ylcGOvw6im4ouBdYdwHCu+MDJAhzp26fTsfPHN/myhxgoapUw34+PXfAsRe
r+n142Dda/HzhWDVpsnYvR8pHKyV3U6c+VvK5y84hRF/hzhK0dXA9BOFFXT+
Eyb25OKvcgAnLs/hIzbvSN3hC76tcZiLWNq/bX022EevfqqAPK9Ng52jkcLD
EjodxBVX2YtywEX7HZOJh9+HS3E1U/hZ4Dwifp8kFy0OtpdhUSfOc6/gUwTH
VyxRJnaVHp8xBye9xeuJWV0Pt+SDt6lLLiMWllgVbNlCYfULKT1PwLvsMsYL
W6H/+Gd9m9jEKma6FvxRqSOE2PZIwPxX8IyH2Q3i2zonuTk/Q30XsL9K3CMj
Jm4CPqVEOxL7dwQx/oAzuZfpE9fp295WaYd4tSrwEXdqmUbtAR/Z7MZDPLZD
O86ynfRrFZzEYhukU/zBASNn/+WD7Tnbi1vAZeZzP4n5Xuh9c/1C4Vs+m5uJ
D8rLyT/rgPPsovtD4u47/b314BZ12fiF788kx9Lg/oTWe8T+1dJcfF/hfiyl
H0n83Fy80xqsOO0RQCx9g/+mYCfcp9gbHYnHvk30O3RBvift3kXsrVNw3xcc
w31Hk5g36/zBGPDk9MAO4rXuP8pfg9Ws4lWIzfgG74h1w368qLmJuEK9g1EL
FtqoL0J8K6IiYQ1N4dGHF37ngY3EWphq4B9+dr+I+ZIG1+mD6bjTP4hv5gvk
uoCtDp/+TuzfYPmyGsxnF8wk9uSf6T7DpPD5GpsmYutgJemsHpjvS90iYun/
dE6/Ahdxxj8l/nbPLL0Z/HN0ooDYMv2a4jzYJiIrj/hI7QfKsBfiW7wjg9iA
y/7kL3DRzId4YlXfR4+29cN9PrIsgDiu4PxxC/CYwrLrxGx9WPw62IrfwYe4
XvdrRBM4SWbnZeLjfMK+FwYorDy74wJxUEzAibxBqKdPE44T/6gzlmgDRy+y
tyQ+NCvTxjJE4a+rkTnxqmMvjYzA162mDxM/WTONfoDFeksMiTtybFdtHob+
7oMNJlYsb9thCs7QdtYkvlGve8QXXHzAW4NYZXBtZBt4rCFXjThcmrnYfwTq
l/AxBWKtO0cnOkehv2e2yBDfS6oT5PlBYeExTWniX3nb5beBLxpnShLHv19h
Fww2a7orQTzF1dSt+pPCee/SVhBneu6rD/8F80f5vMSSkt74G3iUXZ+HOKIq
r0BhjMJyaX+4FtZXYMX9T2B2SRd2Yt2Ubw7Lx+E+slNoJhdcunc5bQ12t5SY
Jt76S9ukEFzzTGGSWFgjU9NkgsKo7/Jv4t4GV/7oPxR2PBw3TKyh8F37Bzh9
9ssQ8e3wY1e0JyH+Z9YNEmsa6o6Mg/uOdPcSR9WvfLt/GuqJx6cuYq1gNnWW
vxROpri+Ev/U+56WDf60+kQ7sd6bUv8ls5A/V7yaiX2iDM5kg2drjzUujN+m
W2//HNRLfYsGYnlujqVR83Dfn3z4jtj2853R7f8ofOlV31vipLR1HzvArot3
1S3MT29vhDQrAytPKLwhrp1K/X2CjYGXqXq+JvZK4zj0kJ2BzwuxVyzEx/RE
QTcHA2uFV78gprnKl0tyMrCkyosyYskEKR9PLgZ231VRQmypcv1HEzcDm5tP
FRPHvRsw38rDwLY25kXEbdb76m4sYeC31YNPiW+0PXMS4GPgkuC7BcTbDWSE
ogQYWGwoK594/lZc08H/GHgyez6X+HWzUKSAMAMf80zMIV6sxhr6UoSBeb6H
ZBMb3BsOcBZj4NCSrCziN5TXvjEJBv7My75g/H3JsouSDPyz2DWT+IPV4x8b
ZRh4/cO/GQvjb9d+z5Rl4BTtuwuWig50c1jPwJfn9RbcY1wnObmBgY86Llnw
WsUrHBc3M/At7rZ04rN8igM/tzLw6xs5C64o/t2bpMjA7yuDFix6qpBpso2B
H8/YLzjFRCzziyoDRx4wWbCS7rWLx9UZ+Ekh4/+ff4TV5Xcy8MsmxQX///+J
DDykI7vg/wEhSSQM
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4VV0XAHAiQwqJUjQY0vAKkSHJ3jpXaJAKSZk1kalMSWRoQJkLIZUx
SZlSiEJCSIkyxLnXmDIUypS+tX3+8fwe5zr7rLP22ms9V8La6dCJBWxsbFXs
bGzk9/wPpnDFyeRbSwz70IqaayuFwRs+v5+5vacPyUUKKG0En/9+TVFeqw8d
l1570gA8mDCdHyLXh57ratbdA9tsP3vzF28fco7wjtXSorBdweNZm4peREtO
KQTsovCfXXyHMe5Ff75f3hMDvnwi1/uCWi/iL+CxfQRe/G7qY6lCL9LQEY1p
ArOJ7H3hINGLYu1V/0pRFPbF98xNOXqRQb5bTSVYobty0rymB5Vp/7Li0qaw
Y35M6B2zHqR/aY+sODgx94TlY+Me1Jn/4PdWsIVPw693B3rQnNThEDNwvuJ7
XtldPUhjQX5+PnijhE+b24YeVFTqxm2zm8LuU0K71o53o3zVqawyHQqPapy5
rHerGzGcDno0g8/uUdn2NKwbNaU91PoOLuwYOrUuuBv9EjFtWa5LYWZ+Kf9q
3260dbzonwPYJFUn8cqZbpT91PuQuB6FGQZYgQt3o4eb2CY991B46f7rs2Zj
LGQX8NjgJliieXpCaoSFZL+aPrwPHk/gezA6yELZ4QWmteAjN1P6E1kslP/H
7qXYXgoLmaRw6HxkodI3zf6l4IRJqRu1uSz00erREs79FA5qdL9yyJOFoopN
ToqCr9NSXu2uLGQowlUmC/ZOd/txxoWFPldbOhuB9U/qbIixY6EO+eVNaeDe
IzYLFc1YqP/v5Vg9fQovXx+2xJpiodk4Y6mwAxRWm1mrfX4ZC+UEfhZJBjcu
/b0nU5CFTjqZ8BSCu7QDUnqXsNAHhulQJ3jI85vqGR4WShsxK5QzoPDVYFWZ
5L9MZKB9Ym8DeK3wZ9eOASZKGT1/fskhCm/bMOS9vZyJjraPn5AAh+VM5g+X
MRF/lZuJMvgXK9M7/SUTXYj32GkGLtIbTJF6wUT6uy9yPwa/4lr4SvspE03G
+8fvO0xhWckMN9kkJtqvE1ERYkjhNeJGcpa+TOR1j3XyPhifiXU3vMREGVNK
iwrB5s8YW/ddZCLOrBYDFvjOwvQ+bQ8mKhEU71QzgnyvO5pj5cREsm1pk71G
JD+Gu5UtmWixQ8kWfITCYguPB/3HYCL1qiUfjMDmHf8iA3Yx0em1Fq72xF8n
T3ZiJqr8wF58G8wzLXUsYScTeavo6A6BnyVm/lJTZaLv/z5Y3zGhsJym5ODo
ZiaqjeyPGT9K4fX/uXTsFGaizfyhNTymFPYZjPP+K8REQUHbZsTBeGeqcNlS
JtK97GeuDZZ25lqnK8BEVQ5i62+Dv3xw03dZxEQVugdyVY9ReKv/U4fV7PB8
c8/qvI5T+G1NVnn1CI3EvczmQsGfRH++eD1Mo4sTHArJ4JBHA/olQzRS/2EQ
9Q7MPVKr8+w7jV60Dh4VN4N8yftP/mU/jZ7lr+l/CZ5+nfJEmKbRE7ur7OwW
FL6RFrW87QONrhv+7V4ODmZFiI820shS07VKFsxewMjhBgsKWYeYgNX/yXnv
aKDRuRc7RZ6CNw8y9QtqabSNZ2KjhSWFc/VuZo1U0Oh5qo3BSysKP5EY2+dY
SKPwsDbFJrBjRb5JzjManb5wUOQbOCnpXNpEAY1W7kdtwtawv6YP//PLp5HX
+Crbs2AGb5j9wxwaaVAfPcRsoP6YJlhuzaLRKxonXbClsODfgoWiD2h041iI
WBi4qNlXyf8+jUxammNSwH2vfh0bukejn+/swt+DLQT1blcl0UiyMNpv/QkK
/24LDAhMpFHgzQGbD+B6yqZLNo5GuurhGzedovBApL/4+ggaCRe0pWiCL9+L
Sn0UTiNafr2EIbjHv2NKEXxhfdFKX/Af9uo5KoxGmYI9i5rBKrJWRk43abS4
X3Xo8mkKB2iFrhgMolFjVFfOlzMU7hw5efZUAI0aFHxLfoDnXgyG8IHr6te8
ZbOD/JJqVX/qT6NqbvOOjWBc6EHN+NGo7GIH1wVwlcSt/pjLNMq2aT220p7C
/L6epYOXIB5KTQtNz1K4dYkNx09PGgU3nhN0BM+61Xukgq87CIn5gzW0pK1N
wYHpBxUywUGfCm+98YD8Ems0nQary8fb3nenkR1H/ZM7DrCfCvm4HF0hPk1V
R9sdKax1Jyvf2JlGpZ0qIj/B/+RrzZaBlQfTGrmcKKwb3u7Z6ATxZr+mowiu
Tv7Mvg88K6ejHAQ2TXPYo+tIo5zgt4KqzhRun+tbZnSWRqt2Vb+NdKHwJS/1
gqLTkD/71QIywGmHKzQDwdxHMzRLwXklbtL64HGn6wXfwP4uA+zdpyCeibrJ
+ByFQ6VVxwXBAVPVPsPg0YGDSpdO0OjH0xrlPa4UNlOs3hZlTaPozlBfczDK
M1lmB9ZYbFhzDhww0qeoBb55qvN4PFjL3Vpp1IpGcmvGAn6AN/CUyx0EO4WI
fwx1o/AH+xvP11jS6NcJJ8cmd6hXpxr8e81odCdq2/N+cKB+55sK8K7XU+yz
YP6onZoPwFHigbekPSh8ujqu3gK8rSm2xA081p5r9vU4jdxw+SJRT8in35az
zGM0mlwlkn78AoWlOIREBExh/a2Pg53BD684jo0dpZFC7G7HQLBF3seZL+Az
Ip7KWeBezuygZHCbQHvFDNh6TWakOriY8z59x4vCpeVvJZ1NaOQzLLuq9SK8
v2f+MX+M4X08fvP3B1jz2l/EBD+zN2eyeVP4b5ww3zvw8EBYxkYwZaXFkwS2
6P6l4gnWvFkXqwvGX54fXnEJ4ltm33vfiEYc5YybRj6w/h9dH+0NaSQ68ljC
HizjN/31CFhWfMWzy+DAicRFDLCx+7fOR+An5+++FQdnbg5VWOBL4cjV52vf
H6aRQdTnpmxw5gbOyh3gu7Z2q3j8oH6o5qzefIhGeRFN2avBU2vDx1aCq0s1
KCVwZ1psDy/4l6jAWXPwWj3nFYMHaaRdn/cyH1ySpF/8CPxD+a+llT/0J3bW
zUpgde7w9KIACke9c5QzNqDRZWP92gZwyjPl33rgt6mLh1hgpTCZDzvBhowg
Rb5ACl9k43+1Huzo5//yGLhkoMDn9wEaPZhxbZoFz+YKnowHLxo9+k/zKpw/
jjvEfunD8yFRycNg4S1OSwfAMaEtjFPgXGGrFZ1g6S2Hg8PARZXih2rBmnb7
RGiwfove5WTwuR7N//yuUZjmzMg0Abd+kTpScR3OI9NDsfX7aRR7O3dzK5j2
jsuoBJsYas0Ng1PSBauLwS3vzVNXBUE/xL5xWyb4Y1XcmAuY851i6TVwXb5A
+LpgCtfmcwZqg0vDZ6ovhVA4e9Bi67t9NLqkH5wQBb77+/1kxT6yv1Y6PwSL
Z1+pKwEXX1NZ0Qxua3aMzQY/93E5IXsD6nvhZFkkOOdsP3s7WO6QlYYZOEW3
SV0tlMK2iRwnpvfS6EiMcsZ+cHrI9cxx8KK+GBEb8HWzhKlhsHPA8dGb4JoZ
hfxu8M7S3tRusLyocVw9uEVpUjAsDPazm/TyZDDP2tX9veGQX/fCzxuCix18
DWfAlZV/6g+AHUuYrwUjoN9oWKuwF/zpaFrCDrDMgA/fLvD9aPlDEeTvWHi1
Alh90a6XGpHQP1U/v7cE7DBxMioqCvbbjd8t9XtodOjkmrB0cABuOFQLVvnc
HFwM1vq35lMVmO0Fw78bfDSWt78MHO0t6aIUTeGyiRX7c8FFHJ36TeC4R9+E
YsFcQkaLlt2msNtvZ/1T4O/+i7k2gIf/dJ6xBTeOVbDvAHPerw+yAsc1K05Z
g2t/CH4+BpaNExzIBQt+dUgzIOtbV/fmUAyFb9+OEdoBTpKj/CJjKVxe4TEm
BJ5d8m5LBvirV6O5INh06FDbS/Ah2cCGJWDhLGulb+Ayqa4iHnDwJv9eFEfh
hYmxVXN6NHKXfq03BF4l/D35O1h/FRLSjYfrN0/trgZnTVWVmoGlY0wUqsC8
rfr258Fu+zRXV4IrY8wr74LfNAayvwKri/i4T4AlN5iOFYLXC75se5BAYdf9
6z0ywLMLdyT/TYTzr16qNQQcwi3aufQuhd817tAOBq/inRCVAberNeZdB6st
fhKqD6YjzGOvgN2EpLySwJmaqT6+4OE1fAe1kqCeT94oOQ/uUm2fC7wH/c6V
oB4zsOP259vjwF3VvHHHwXPqt1wfgxWPRR84BhbXPDDYDK68VVxuAjZhVDTL
3If5IHHq1WFwo8GjrGqwOJvPqj3g8jMXTRcnQ7/S+FNWDVzbunG3ZDKZF5W5
VMEf9Vq2qoHbRVyYymDmpq28tmAx5bJEJTDbYF9hMXhgpfkWeT1SLw6J2KfA
+0r9lCoDLrLb1FiTCu/DX65vOblfW0txF5i3UHNShNxvT2D6BHjbol4+4tbN
XT4SaRTesuOb6jLw5GD0lgvgzaJXHgiAVezZQjamw7zBXlnGA86z/6x9LQPm
V1E+3lld6F/OmrxLAO9+77JvBpzp0GqQC35xWzhiGvzAqf3YV/AyYa41U+CI
810uSg+hfuZa7P4NdrrYn9gFbmbJvx8F/xfyZ0L1EfTjO9nz+8AyNzwv7ge3
0hvEiCVvTrHZgM8/0g/oBa8Km+ELBS/nvG3cA+aN+ifRA7b1/crDAvff4dYP
z6Jwi2ffna/g5MwVaQOP4fyQkbBrBjfWD72YBe9RCP79CTw3WlEvmE3hj9Pp
AcQmqs4TauD9dn+TmsD8ldWMIHD5tp/0B/CFrxe6Nz2B6/n4AxrABwQ71tk/
hf3uOYerwd5Kudt8wWwLZ5lvSXyMr+tGgUWkQwOIORO3OReD7104W10FLtp0
s4wvh8Isl0mTN+D1lKZ5FtjiblB0OXjG7V78UC6chwKFTi9JfLl1LDnyoL4q
LRUj1o0bkl4J/tI4XVUCji5Rz2aAjz/1XEcsy9H8Kh7s946zrQh8PJy3Ty8f
9sNoxMnn4JeZ5xTSCij8o8WuKw9sq7Fyohgc/WX6DvGihrIXH8BpbXPGxMY/
F1N/wZ0NFo254GHVdCPDZ/D/dJyrc8Br3rR7LSik8BIpmfonYN8uxhvz55BP
UdNSWeTzUVj0PNjKXX/0EVhOR8P+Gnij9HgJcWe20tKnYJt2xSPEGj6SZuwv
YH567RSWCZ4WZ5tIBpdSXvwPwW6mxdLfiigcQ4VTaeB9/IUef8E7/bauJJYu
z61dWkxh40aRkVTwp02Zzupg1nRqPLHiVGxJCHh0SeufFPBojLuhXAmFix8q
lCSD7Zu3Bp5/CfPz5JTLfbDKKnaXa+Ckf98OEC+waDSLB7N388sR3xlwVK0A
a0xODN4DV888GhQqhfj5K5wilpGUOZgLPt219EwSmHZcteZnGdQLH9fwRHBW
3rdFC1/BeWht50rsOfn8jyi4oTbEhFjA/8gHDN660kCCWPNWdGA4eJnt5/wE
cHwx/3f517C+wvTueBJvHo7njuWQn0/ize+Q9RU/MAoE84hEaRN3Oe4aiwNf
SsyXJT7d7Cf3Buw94zoTR/L9AVuqWAU8j073HeIEjbmIavCwmzozFsxynrKX
fAPre784OIY8n3Qcrxr4YsVbN2L7z2rp+8EqzSlWxOM7PVme4MsOlduJF/L9
MXkPltSK+n4bvDF1XNu7isJCG5ARsUPryNqWtzCvcVqiW+R+2T17B8HOFL8C
sUlgq8cceHfUp3XEDPmK9zLVUP8aMxYQi1+57esBznto/zYaXKews0u0hsL9
U+pGxLLXg+8eq4X9Y77YL4rsLzPfWidwWpOHK7GokuvvAPB/i/+cIubsNNPP
Ah/ep3CAuENp69wsOPFJ8BriG12fze6+o7Dox8pXkeAfKutXM+so/P7MVSHi
dq/Bqd9g3beG3MS1pU9aFtfD8ymqzEaA03erh6uBz+Zt7SO2Nj7AEQ4ebuUu
Jv7sduGbZgPUOw+R08Tl+fUFCe+hHzHuawgHP52MjMwFn0xsf0OcpGHiVA2G
vVdC7F3J2jgOfmmz4hGx6qc/8Xsbof9t3X6dOGtMwn8aXPFiuzZxjKK7vslH
mF8TL9WEgb24Bd44gKnBg+XExzvSdwSAPykqFhNLXm3dmA1WOr38MXFWqwYH
ZxP0RzvsI4jLL3M8fwKWzVA+TvyjIVyCuxnO+231U6HghuRNseLgI0mzY8Q5
nuX8iuAN5crDxO6S4zPHwU+HK1nE7O5HWnLBmlJGdcTLV68JMW+h8OMD8veJ
tewfjRd8pvDKW9YHiY2t46ZqwEyX2X3EdkevzX0FR21O1CWO1LHh4foC8zHn
GCLukRITNwbHqIzIEV/tCKZ+g0WvreMnrt1vF6nSBvNVr8SHm6R+MUxi9oBz
SgLqiX/t2J1gDvZV/V5DLLZZMu0qeO/v2nLis1xtL1rA+al1+cT8ZXpM93aI
r+WHOOLDCpsUCjtgf9xIP0VM3+rvrQPfLnGwnf/8TGo8C7zEarsV8dUqSW7+
rxTewaRNiYuOi3fagvErJ31iySCBG0KdUB/VrqjMr4850e/QBfMXl+EiYl+d
/MQA8PfpQm7ixY/PHY4D95isW0gs4zlSWglmU5r7dwNsyv/tlhhNYYXIoQni
cvUOqgbc+SyaRRwRVZ4kzYL1f/5USmwg1tKtBn6g1VFCzJ/8bcN+cER1XxHx
jVzBp25gcdGFhcRXP5i/qgIbqJx8QuwlMEOf7ob82vvsHrFtiJLk4x44D7Y5
XiGWXKZz8jVYdHtjADHzjmlmM5hZu82f2DzTT3EO/ODqQl/iozXvdx3ohflp
pNKTWJ/7rM1PMI/k87PEqgEpKcr90C8JGxsTJ+SfszQDi0iUHiZe0IfFr4Aj
5eQOEtfpfo36BG4cWL+P2JJ/ecD5AagP2112EQfHXbPK+UbhaiUbBeKRWqPV
reCTR7AcseGsVCvbIPR3QtKyxGssXhkYgNn+zm0gzpOeQiPgwIts64g7ntit
2fID7hcmsZRYsbR1hwk4S2C7AHFQne7RALDiL+MlxCrfZKJbwUuCU3mJwyW7
ea8OQb/5KmQBMePWsYnOYajPs3YTIeS8SK4VWjRC4T61rjHinznbFZTByfdN
fhHfbVhhHwJel2c6QjzJ/YlWHaXwtX9x34izvPbVhf+kMMfOP53E69b5YiZ4
1iClgzjqTU7+1l8Qj48WbcRegisSP4KzitlaiHXTmA7C4zCvddD1xCV7hVm2
4AM8k++I5X/uNi4ARwiI1RIv18jSNJ6Aeh8cUEXc+8FdIPY31MvoljJija3f
d4+A7yVIlRJHhlv47P5D4ZtLvUuINQ/oDo2DVQT1XxDH1K18d3CKwgLujnnE
jJAF6mzTFN5+5/lT4lG97xnZ4LJnMtnEem9LrvLNwvzjfeohsX+M/ulssP4P
0/T59Z+i9Q7+pbBl3alUYgUeziUxczAfzVbfJ7b7cmt4+z/I/wVi94iTMzY0
doD9mH53559Pb2+UJDsDF8kFxxPXTKaPWS1g4ECV/lhi7wxOw/scDDzxw//2
fHxMrPJpTgZu8z0STcziLhVex8XANukWkfPvI0nC34ubgUd7XMKJzVWujHzi
YeDKRwWhxAn1A8flFzHwXQ6Zm8Sttvtqg/gYuPd8aQhxUGuhkyA/A/vMeQcR
b9eXEokRhPWNPbhGPBeR8OnwMgZ+Fst2lbiyWSRacDkDP6jJDiTmVWMPfSXK
wAreDwKI9e/8uOYsxsC756r9id/u8t73azUDbzktNW/8nW+p6zoG/qwd70f8
3vrhyH9SDBzLlJy3edvuhu71DCx99fVlYonY6x4OGxmY74rHvHuMatf92czA
4k3q85ZR9OF03cLAwcO88z7DrzgwKs/AA1lMX+LyF2O9yYoMzMVWOu9VJwq6
jZUh3mL3551mLJbVrsrAKWtD5q2k6+dqqc7APEsv/P/6FKyusJOBV+Scnvf/
v09k4KaQY/P+H52Ad/g=
      "]]}}, {{}, {}, 
    {RGBColor[1, 0.5, 0], AbsoluteThickness[2], LineBox[CompressedData["
1:eJw1lXs4lAkUxsdlaHJtQxcqhLBYInfOoSms2r6P1LqmoXJt1CgUcmeZtViX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      "]]}}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0.5, 1.8626264880202026`}, {0.5, 2.062193611736653}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{2.5, 1.7827996391094965`}, {2.5, 1.9794951437082497`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{4.5, 1.7041214378375824`}, {4.5, 1.897902773859036}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{6.5, 1.6266089039881795`}, {6.5, 1.8174315725869616`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{8.5, 1.5502798370993072`}, {8.5, 1.738097236485152}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{10.5, 1.475152877886938}, {10.5, 1.6599161322774232`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{12.5, 1.4012475766638997`}, {12.5, 1.582905345101873}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{14.5, 1.3285844698129048`}, {14.5, 1.507082731694542}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{16.5, 1.257185165575327}, {16.5, 1.4324669791090385`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{18.5, 1.187072440667638}, {18.5, 1.3590776697060833`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{20.5, 1.1182703495486006`}, {20.5, 1.2869353532614909`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{22.5, 1.0508043485501468`}, {22.5, 1.2160616271746314`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{24.5, 0.984701437577222}, {24.5, 1.1464792259144092`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{26.5, 0.9199903227091756}, {26.5, 1.078212121018299}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{28.5, 0.8567016038420934}, {28.5, 1.011285633162959}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{30.5, 0.7948679925598173}, {30.5, 0.9457265580507281}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{32.5, 0.7345245667987728}, {32.5, 0.881563308098053}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{34.5, 0.6757090707033578}, {34.5, 0.8188260721524445}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{36.5, 0.6184622705367038}, {36.5, 0.757546995667392}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{38.5, 0.5628283808857735}, {38.5, 0.6977603838560856}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{0.5, 1.8626264880202026`}, {0.5, 1.7827996385336224`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.5, 1.7827996385336224`}, {2.5, 1.704121436694121}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{4.5, 1.704121436694121}, {4.5, 1.6266089022855397`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{6.5, 1.6266089022855397`}, {6.5, 1.5502798348460267`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{8.5, 1.5502798348460267`}, {8.5, 1.475152875091689}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{10.5, 1.475152875091689}, {10.5, 1.4012475733354948`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{12.5, 1.4012475733354948`}, {12.5, 1.3285844659603054`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{14.5, 1.3285844659603054`}, {14.5, 1.2571851612076506`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{16.5, 1.2571851612076506`}, {16.5, 1.187072435794166}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{18.5, 1.187072435794166}, {18.5, 1.1182703441787878`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{20.5, 1.1182703441787878`}, {20.5, 1.0508043426936318`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{22.5, 1.0508043426936318`}, {22.5, 0.984701431243838}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{24.5, 0.984701431243838}, {24.5, 0.9199903159089632}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{26.5, 0.9199903159089632}, {26.5, 0.8567015965853138}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{28.5, 0.8567015965853138}, {28.5, 0.7948679848569675}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{30.5, 0.7948679848569675}, {30.5, 0.7345245586606032}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{32.5, 0.7345245586606032}, {32.5, 0.6757090621408911}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{34.5, 0.6757090621408911}, {34.5, 0.6184622615612564}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{36.5, 0.6184622615612564}, {36.5, 0.5628283715089811}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{38.5, 0.5628283715089811}, {38.5, 0.5088555703208563}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{0.5, 1.7827996385336224`}, {2.5, 1.7827996385336224`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{2.5, 1.704121436694121}, {4.5, 1.704121436694121}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{4.5, 1.6266089022855397`}, {6.5, 1.6266089022855397`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{6.5, 1.5502798348460267`}, {8.5, 1.5502798348460267`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{8.5, 1.475152875091689}, {10.5, 1.475152875091689}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{10.5, 1.4012475733354948`}, {12.5, 1.4012475733354948`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{12.5, 1.3285844659603054`}, {14.5, 1.3285844659603054`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{14.5, 1.2571851612076506`}, {16.5, 1.2571851612076506`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{16.5, 1.187072435794166}, {18.5, 1.187072435794166}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{18.5, 1.1182703441787878`}, {20.5, 1.1182703441787878`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{20.5, 1.0508043426936318`}, {22.5, 1.0508043426936318`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{22.5, 0.984701431243838}, {24.5, 0.984701431243838}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{24.5, 0.9199903159089632}, {26.5, 0.9199903159089632}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{26.5, 0.8567015965853138}, {28.5, 0.8567015965853138}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{28.5, 0.7948679848569675}, {30.5, 0.7948679848569675}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{30.5, 0.7345245586606032}, {32.5, 0.7345245586606032}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{32.5, 0.6757090621408911}, {34.5, 0.6757090621408911}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{34.5, 0.6184622615612564}, {36.5, 0.6184622615612564}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{36.5, 0.5628283715089811}, {38.5, 0.5628283715089811}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], 
    LineBox[{{38.5, 0.5088555703208563}, {40.5, 0.5088555703208563}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0, 1.8626264880202026`}, {0.5, 1.8626264880202026`}}]}, {{
     InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         StyleBox[
          SubscriptBox["\[Tau]", "d"],
          FontSize->12], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.1",
           FontSize->12], 
          StyleBox["  ",
           FontSize->12], 
          StyleBox["ms",
           FontSize->12], " "}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[
        1.]], {29.437832023268676`, 2.0245753021046884`}, {Left, Baseline},
      Alignment->{Left, Top}], InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         StyleBox[
          SubscriptBox["\[Tau]", "e"],
          FontSize->12], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.5",
           FontSize->12], 
          StyleBox["  ",
           FontSize->12], 
          StyleBox["ms",
           FontSize->12], " "}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[1.]], {29.437832023268676`, 2.246797524326911}, {
      Left, Baseline},
      Alignment->{Left, Top}]}, InsetBox[
     StyleBox[
      TagBox[
       RowBox[{
        SubscriptBox[
         StyleBox["v",
          FontSize->12], "r"], 
        StyleBox["=",
         FontSize->12], 
        StyleBox[" ",
         FontSize->12], 
        RowBox[{
         StyleBox["0.01",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["mV",
           FontSize->12], 
          StyleBox["/",
           FontSize->12], 
          StyleBox["s",
           FontSize->12], " "}]}]}],
       "RawBoxes"],
      FontFamily->"Arial",
      FontSize->10,
      Background->GrayLevel[1.]], {28.10204081632653, 1.7570897448664826`}, {
     Left, Baseline},
     Alignment->{Left, Top}]}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"t (ms)\"", FontSize -> 20, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{0, 
      FormBox["0", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {20, 
      FormBox["20", TraditionalForm]}, {30, 
      FormBox["30", TraditionalForm]}, {40, 
      FormBox["40", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{41., 25.}, {51., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{0., 40.5}, {0., 2.5}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.919165940743478*^9, 3.9191659439377446`*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, -0.7}, {0.5, -0.6799999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.5, -0.6799999999999999}, {2.5, -0.6599999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{4.5, -0.6599999999999999}, {4.5, -0.6399999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{6.5, -0.6399999999999999}, {6.5, -0.62}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{8.5, -0.62}, {8.5, -0.6}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{10.5, -0.6}, {10.5, -0.58}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{12.5, -0.58}, {12.5, -0.5599999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{14.5, -0.5599999999999999}, {14.5, -0.5399999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{16.5, -0.5399999999999999}, {16.5, -0.52}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{18.5, -0.52}, {18.5, -0.49999999999999994`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{20.5, -0.49999999999999994`}, {20.5, -0.48}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{22.5, -0.48}, {22.5, -0.45999999999999996`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{24.5, -0.45999999999999996`}, {24.5, -0.43999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{26.5, -0.43999999999999995`}, {26.5, -0.41999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{28.5, -0.41999999999999993`}, {28.5, -0.39999999999999997`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{30.5, -0.39999999999999997`}, {30.5, -0.37999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{32.5, -0.37999999999999995`}, {32.5, -0.35999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{34.5, -0.35999999999999993`}, {34.5, -0.33999999999999997`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{36.5, -0.33999999999999997`}, {36.5, -0.31999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{38.5, -0.31999999999999995`}, {38.5, -0.29999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0.5, -0.6799999999999999}, {2.5, -0.6799999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{2.5, -0.6599999999999999}, {4.5, -0.6599999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{4.5, -0.6399999999999999}, {6.5, -0.6399999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{6.5, -0.62}, {8.5, -0.62}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{8.5, -0.6}, {10.5, -0.6}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{10.5, -0.58}, {12.5, -0.58}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{12.5, -0.5599999999999999}, {14.5, -0.5599999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{14.5, -0.5399999999999999}, {16.5, -0.5399999999999999}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{16.5, -0.52}, {18.5, -0.52}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{18.5, -0.49999999999999994`}, {20.5, -0.49999999999999994`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{20.5, -0.48}, {22.5, -0.48}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{22.5, -0.45999999999999996`}, {24.5, -0.45999999999999996`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{24.5, -0.43999999999999995`}, {26.5, -0.43999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{26.5, -0.41999999999999993`}, {28.5, -0.41999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{28.5, -0.39999999999999997`}, {30.5, -0.39999999999999997`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{30.5, -0.37999999999999995`}, {32.5, -0.37999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{32.5, -0.35999999999999993`}, {34.5, -0.35999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{34.5, -0.33999999999999997`}, {36.5, -0.33999999999999997`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{36.5, -0.31999999999999995`}, {38.5, -0.31999999999999995`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{38.5, -0.29999999999999993`}, {40.5, -0.29999999999999993`}}]}, 
   {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[1], 
    LineBox[{{0, -0.7}, {0.5, -0.7}}]}},
  AspectRatio->0.2,
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"t (ms)\"", FontSize -> 16, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox["\"V (V)\"", FontSize -> 20, StripOnInput -> False], 
     TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{0, 
      FormBox["0", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {20, 
      FormBox["20", TraditionalForm]}, {30, 
      FormBox["30", TraditionalForm]}, {40, 
      FormBox["40", TraditionalForm]}}, {{-0.7, 
      FormBox[
       RowBox[{"-", "0.7`"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {-0.3, 
      FormBox[
       RowBox[{"-", "0.3`"}], TraditionalForm]}}, None, None},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  PlotRange->{{0, 40.5}, {-0.75, -0.2}}]], "Output",
 CellChangeTimes->{
  3.9189932955210476`*^9, 3.9189933265856853`*^9, {3.9189936207978983`*^9, 
   3.9189936378399563`*^9}, {3.9189936689762*^9, 3.9189936784841757`*^9}, 
   3.9189938752004704`*^9, {3.918995236896613*^9, 3.9189953717697845`*^9}, {
   3.918995448402794*^9, 3.9189954880442696`*^9}, 3.9189955484914293`*^9, {
   3.918995586834073*^9, 3.9189955986817226`*^9}, {3.918995719267539*^9, 
   3.918995724358102*^9}, 3.9189957641570625`*^9, 3.919045719467263*^9, 
   3.9190457570114045`*^9, 3.9190457982558703`*^9, 3.919045848390644*^9, 
   3.919045891177925*^9, 3.919046135499894*^9, 3.9190468927573175`*^9, 
   3.919046927854157*^9, 3.9190469624583406`*^9, 3.919165406285101*^9, 
   3.9191654718272643`*^9, {3.9191655158768663`*^9, 3.91916554137982*^9}, 
   3.919165592382147*^9, {3.9191656307412305`*^9, 3.9191656369591627`*^9}, 
   3.9191656863230677`*^9, {3.9191657876247454`*^9, 3.919165797707838*^9}, 
   3.9191658677048283`*^9, {3.919165903013497*^9, 3.919165924906167*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4VN8bAPBBdqkkWQpFitKioijvqISsKZKSNVlC5KsSSqVkKSGEyhIp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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk0VW8XB3Bx5xGhiCQSQqZE09lEMlQyh5CSJlIoMqSopCQkIvLLVBTK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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4FP8fAHBJl4rMzM7aypHclaNDKjVvkqQoCuVIhZIiIVQUydGlSAiJ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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk8Fd8bB3Apa5siMXNn7k2plCXV1xKZJ0koO1lSliIUISGVskaKFlFC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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4Ve8TAPAsFUUqkpLlnHMjQvtiqTOWZC3JlmTJkn1LIVIqioiUVJZE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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2XlUTV0bAHCahGhEFI3nnJuUkGadXYmkEA2kKJrTqAhJadaoqLwlURqk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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk0Vt0XB3BTQkiGIlOm6t77kEpCcjciCkmGEhmSqaikUqk3SSqiqPCS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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4Vd/XAHBTQkqZkmROpnPOTcaUs5GiUMmUFDIrs6JoJMkQSdEvSeYp
lTJEoUyhJJW+FVEkSUjnmpretb3+8Xyec8/da6+91tqeh9x+fyt3Lg4OjnpO
Dg78+/9/CLTs6/YnXKtmaEdFGY8d4CHDSZd68Rm6ytTgaSa4R2jVk7NLZ+iA
CxFphpwEMmxuebCOZ4bul59lRXIRaMzh6fW/36bpOpNJF94FBGpfoeW46+E0
fTxusEFQgEB79wy1XfKYpt/d4lbdC7ay2DAX4DJNa7+ST7oJ3pnIq2PtOE2P
Sbk4Wi6C54uu52lYTdN7S3uZREECOUXWcFoaTNMbXnSvFhEi0NKD6QuY5dP0
L/HWsytECVQ2s46jpHOKXs9WuRMAXhHCKC1/OkWHvYx91wK+rlkhEtsyRU8l
mhOHxQg0PnxB4GztFD3B19nVJU6gd09fc/aUTNFDc92r4lcQKN7C7t9Q7BTd
+WHw7l9pAulIODSpm0/RSx6a9NrIEMjhXEdNmOkUbXE1j/cmeGdx11zbpim6
zc5r9x5ZAnGMT605vXGKbur89rdSjkBSKE1iPTVFVz+eNAtUhPddDRxbRKbo
3DyO/gEVAj13rlQT+cimixZXGGmpEkhY1/3olg9s+nbIgdxosM8yls7J92y6
2qjbR0WNQJtMRfr+vmbTHR+K2X7qBCqx0VVitbPpGXG7RXMkgbaodeU5VrDp
rWdvai/VJFCbTK7+7UQ2vX1s/xUX8MhvxdPuCWza2kbidxlY7LGrj3Qcm3ZS
iHxko0Wgn5/l+K9Gs+mQOnvzq9oE0jOv7K89xqavTXPvV9KD8/BSlC45yKYn
PB0SNhgQ6LDt3KNpczbdJLzPLh6cKzaiKruNTf/voYtcD7hS4VzANjM2vUnE
uzycJtDKOuGTRSZs+kptaG81gviORWrFGrBpI7FLhJ4xgdQTA/Sestj0xcfP
n2mZEsj+dfnUxuVs2sv3ZeoZcB63xn/3xdi0gcQbl9fgbdtLRXVF2fSw7wd2
iBmBis/yJ+kvY9MbVnxfdW8rgRYx2mr7FrHpQX8BPw0LqJfNnL1LONi09iqT
JZQVgTaW6V3k/cbQY6dir54BJ9ivVCv5ytB5Q8+Ve8BiL3IFrIcZWuy2g/G5
XfB54X0Xij4zNGMUEDZgTaCL71x2BfUz9F2vq59S7Qh0wSbRz7uboVn3flRw
7CWQwoUi994Ghh6W0NlkB36we3ym8TFDZx6LeHETvKPytlvpI4ZeumXhqMM+
AoUuM7gfXcfQ42+l5MqdoP/6qjgsahi69N+WOO/9BPoofekAcZeh1bZlOHV5
Qj31LGxSyWHoIl1dJQUvAr0ozeuxyWZoZaWu0WBwunuiYWQWQyty8h4V84b6
GV/67WMmQ0tX+qbY+xDIt8Y0qvQarK+wsfXDQcjfmyNikakMPTX3XuNbIIEy
f8ydFIxn6JDhQ7P6QQRKnRg5sy+OoX++FqqPB+dzHk+/E8vQE7eNLchgAkUc
6552OMfQXz2KPQNDCFTzZ0C3Opqhe7qOpk8fJtDwreNHCk8x9KOiFbw8EQS6
FbFPBoUxtLwVO3EP+GVdomNuKENHzXauuAu24T9yYxF4s2kMsf8YgWJkA/Xf
H2Lots9T1vXHCTTaG3ciOpihu2RfZUecItDgzP86Fvkz9ODl84bsaKinSHXz
Zg+GNjHwaTc/C99H/dhhBs77bGKTAw7hvKX6zJ2hvTT/eO2KIZDy24N2b9wY
evTFgaQ75wgUyP3Gj72fodmCZn2+8QSKndjiZufE0LyR3MeGLkC8+kJ2hfYM
reNH+G1IJtB5MXmDzWCv3XZOyWDbVo72ATuIlyo2NLgI/cXZ8UIWfL7Hivdy
Cswzz8eHsmwYWlw7K9EkFebv0jKiwYqhlb6irJx0+D6fSweCLRja7pXPxTmw
3ncdUQVwTF1K1I5r8Hx6k/FLc4YeuTTs8Rtsnii1VgtcapSkZn0d5hnPmXX/
tjK0dnrfPe4sAgXNLhAvNoV8bj/esj+fQHOu6287bmJog4bfP8rAoncHRmTA
WjrhUtwF0M9B3lEDxlA/MmGB2eD23uoXB8Bc44ErBwsJVNsX3nTSiKFrz7v7
u5fAfXI7IaUGwXod5su97hAoOE5ZPHAjQ5NG7YZV4IQnetI0eHWF2UG+Mphv
DVtDFoNFMzY/KgC3l5zhK97A0JO+6MDXu9A/9zc0ftWH/SzWrPOpgPk1PCd3
aD1Dr7FY6elbA/EG5LvX60A84e+tG8FzqprvL4J7Cq4arXxAIDc92XRPcBKP
lHQruHxW4q8QeLZG6rViLYEEzndoumkzdLuqtHFPPdT/goVckloM7c8nJ7Ot
mUDXmr6OVGow9Fbtj4JZ4NjO7sGLYEW3G3MzYPmY+ysDwP/VyXXntcB8WtRo
oAI2DJVP4GqF+VX53DJjLUOLDCn8ut8O8dpxoosshq5sUHqj/IJAux7pduWS
DG1/VP/vEfDl9PxrseAZ1o7V7WDZbSIp/uD1GUeCfbsI9PDtC4714Nqwp0Jl
L2E9ibSuToKhG4kgU/1uAikpckvzgjtTH963eA/1tLg1I0GNoQMtu/ozwN5f
f1uEgoUXfFk4AdbJD5Z1Ae8KWmqb3AP7Nd5GaoG7zV0nu3sJxH0k88sHVcgn
J7+acz+BAqSHb+iChw9Ypwd9BnPzdnCrMPRuj0rVx2Bem5H3P5Sh3p0l7y8b
ItCdk1cX9IOLbfpf3wZ7uVcVPwD70QeFxr/AfOnTNggF/xSOOn1gBNbrGbf7
sYah/96/6+U2TiDV2EOmM0pwHvfEp++CU+QdTn0F95ceOcM9AfnbqPDiHfhR
Np2VBV5u+/reQ3BUQvv7/h8ESoz/HBMF5ncZsNzLwDw612oiDhblE9GynSVQ
pFcnYbYa+vVBZXQJePfztDl9cE2A439ccwRiJSf2kuD9b3PDb4GddwV/FgXf
LtJ9zPebQNkhQrMfFRl6m8W+7TV/CRSdRy89CT6dXOgty0Oi+HXFQu0KkM/N
ljWHwf/dTdhXD1b5NSn4DDxx2bOuHNzpuuH2kQUkCmbHVGSCV2k9n+riJVGU
imFoKLjqDRN5hp9E1YvkVZTB41IoY2QJiZ43aiRckmdoPgc9FX0hEqk1Cocl
gOVTNe7FgXurr/ufAdsuW92mvpREHiqBUYfAtQsEpvyWkUh06TMjW/D5sZcW
P0VIVP4hh1MSTNZ7/vklQaJEy7sLi+QY2vSPc4z5ChLReyZcs8H71zuIXAO7
rUxtSwdfvmeuYiBJooPH+isSwX8L1tqcXEkix2fX+Q+Dn134VcIjTaJzRQKx
m8AHXRMdFyuQaEPi9oRhWYb2dmgrcgMnMzI5n8AeOxfM1oCfC/xu7AE70eGX
fBRJ5Cd1UfEF2GqlZ0fLahKdGnDfXQ3WeWmATiuTSEjYOO48mMt4TGGaINGv
4OSsjeC/eipBliSJhCd63uuCf7Hc6nPBqwNNVmmCGel3jtYUiRQO6FWpgr/M
NV26wyKRQDnLQgL8tOzawoPrSPRxdcMXRoahU+UtvvXrkmi6QPnsXbDb3u5M
bT0SmZupP7wFZqU52caDS51PzxaD2xYHPdJZTyKTV7+icsC/Zy6nntcn0f06
jqFLYOfn/cYbDOB9l6CWI2DViJD0VGMS6ZpYNZqApyr+7PwODhM+escI3PAj
eqHxJhL5PH6cTYMdPa8EjYH1MlJS9cCJVrWmJptJ1KZqWUOAGWU+9qQpic7Y
ff4mDn74+qqFpSWc/+Xm6lFpht5x5ciGDDBHgbPnCHjQ0U5tDPzK98ryYbDA
oDD/+e0kik7pPD0Atp081/hsB/jO/ch34PElYfoWu0jEY1Wh2gqWM7VWMbcn
kXIp19cC8L1FGhLpYB4btX95YNPnQgtHwXfcLCVywX627YNxu0mkqB+46wa4
2s0os92BRK61haNXwLtOsZZv20uiQs4/eXHgM9WCC7buJ5G41pZVgeA5HfXK
TDAvr7mXPzigfJv3NFjAWqPCF+x4O/ZZjiuJhn4nOviANfP4Lv9zI1GmC3+T
K/jTBZ415Z6w35xeKTsw8v5tKutLoqwXX6pocMXQyl+HwbLepnYGYHU3/ZvP
wE86/kxvAEs4HV0W7kcia0s7tB7nw3rm7Wt/WD/FflQTnIEYn7ggEpVJmJSq
gn8tH42fCoX1E5Prl4N1pZ3DtoSRSHLIu1wcHKL4yjUNXKU2VCwGHmU9WL/+
CImS1BquiYA/mMUPHzsK/RjckiIEfhSuvmnBMRLZ9LQ+Wwg+23fwl8hpEu0Z
59kzuwruh8/9Q27gkLf1J2bAHKPWXeXg3xu6c6fBYTMbCu0ioZ8neabYYJ9l
i+2uRpHIykknbxJsYXyzTP4sid5vXL1pFCyS/917bTyJhicCvfrBGp7ZEufA
k+tO5PaBrdbsbukHB2i9HfgATspvVExKINHTVB+3XrBgwdW+sfMkGi9oCnkH
5ik0sym5QKLumBOdr8BTRbloTSqJwhU63dvAYgf2jB8H081+T1rBmmrLMrrB
OnyS6thBxRG/zqSR6I1R4lQLeLx4V8XgFahP9YbUJvBwCad6VjqJGpye8z8C
vy3du3xVFokOhHPfqAI/KXMhgsHd3psUsasq3I1bwYMetgWV4Mu1vv6HsuG8
xYbLKvD+Oo61PMsh0eWo9Bf3wG3fr4UezyfRvi/ymnfA1eof3vSVQL2Y90cV
gQtZn75r3SSRYUGzDHaa5hB3PNg6yLamEHx4wxilWwrxfPJlCnA+zf+eTbpF
oqNpe/3ywUUHpHUNy0i0IGLnyRzw1aJ9aVmVMB8s/cWug3foVH6ZBMvcn3uS
AeZtFNIxriJRR9mfCOyg3vrXA+BXnp5D18CmSxVEVleTiLxZXpsOZg59Sch/
QKJbP65H/Q9sbhgQWfII5uXiKefLYK6OJ12/wTLG0vLYlQ5y8haPSZRSWzBw
CSwf0lX/HTwj88kTeyZP8y/ZSKL8mdchKeBcwdmwO80kktqPMpPBf9+c8qto
J9EHB0O9RJxfaalTi5/C94lv4sQm3SsuuoHX3c9tPQ92mhypEn4G9wErcg92
vaA1t38HzOuUS5EJ4NOGSmlrXpDo0lDSYBx4YXHbo7RuEv1sff85Bpz5w+3V
OJjHM7UKW1f339DmNzA/a6/HYXs1rRNkg3tTUjSw2/rSbXe+JVF7D0fUWXC8
qP83/h4S3Qg/rBkNXnpcRCz8I4mCDC89iQT7W3C5PAVvLvXMw+6Q+lGy6hPM
G82AKOy4mo5N9eDTevKG2Lyz50IWDJLo7ADHw9PgP8EcrxKH4L6Kdq49BR7x
/p6c841EGSdOfT4BNtPr+cAGFwuEt2IX8LWrbhklkcFk5k1s9/yCx1/Bp2sD
DmP3D7pOkmNwn1ZJCGB3O73beX+CRMf+WuodBzfYtCztYMO8T0oqjwBPevE0
rpqCeN7wXceWjTAM9QVLiOfEYB/PqukVnCZRznUjR2zd8VtF22ZIlM4vuQC7
NCZtU+sciUIDePaGg/9X4x3W+I9EFyK8FY+CWzvy1EQ5KGR7rXcZ9szHgQ+u
YL9ov39HwDZ8+0y4OSmk9u/zO+ylNlbCRlwU/P2vdBE7emx9SR0Phd5ltPJh
B8oJ9lfzUyiG/9DCMHz+Y7G2ywQoJLl6aCoUnFLD/8wTHCQTPIRdYbOwWnQR
hRTZfU3Yv89xpfgJUshBnCMaO2ZyZou8EIUeVmssws5s+HzrnCiF7nFoKR8G
lyW5KfWDZZqeSmI37B1I1xajUIpk+GLsoen+cwPgoX7Jn4fA6uo9rhuXU8i8
YX8ddmVK1/IfKygkOvpzD3aHe90JexkKmYQo54SA82qSqULwfyG8/8M+vsyj
bxb8xJlJxCYfCtJXZWH/l/+FY58XdfjbKwf7be20xrZsYCJcFSm0mTTjx34m
q3rUTwU+/3QiIhicc/iPSh3YIT0jBDviaedbIVUKxR7ffRBbPSxU7w54Qnlq
D3b888aZn2oUKvjwRB/b/LhT6BGSQuHhj/8EgZ++TwmJWkehv6tOx2Kf/Vb4
5T045qZkJLbRr1qHdZoUuvumLhy7UvIr+gQ2yqN8sbN2b1yMtCnk2ZO1Azv0
zefcX7oUupPVtAJb/qX2myADCslvCr4XCO79tG1rG/iUblgpdtqk80M5mkLr
9pwtwF4sHJfdCbYdakjHntnR508aUihB694Z7I6Os3wjxhQ6vNp1N/aRtv/0
XMwolLQvbiE2j/QG0Upwu+ozLuzzgdfHBLdSaN+g+N8AnD8Jj+wq8I2RRwx2
h8dPwaXmFBLrDvmErcC9pL/WkkLTXMZ12M/0jaOlrCGeJrXj2PaJec5B4CjV
XUexP33i138C3v7n5GHsmXOd48E2FHpeP+6HLf/f3t3tthRakirhjB0aEqZ+
dDf0y+HzxthyN292vdlHoVHZ5iXYQefch9Y4UUjTqHcRdqP7qrlQ8MjoDB+2
h3SCnIQzhZweb+TGLko8GGDvQiGBot/T/vg+DVJb8taVQhUhZp+wN+sUmr3z
gv7Z/eM+dqqIy15Vbwrtqo+vxB4elwg8Cnb7pFaOHVsQkybpQ6FudOg29vMV
Xl8cDlDIpnldPrb9b6Uz730pZL1ozyVsn0c59T1BFJKYVQ/BzrDLSF0XDP1Z
LxCE3fU91S8WnCw/6o+9XjJOSjeEQjo37h/A5g8ODLt4iEKHeo+7YhcoGrC2
hlFoinVzF/bQ2TfXK49B/+kEaWNLSr84vOQ4nJ99lSa25b02C3fwhBvnOuyK
/oe/hE9QqFk1ncI+o5dj53eSQsYDP5WxFb8FCK2OpFD0xzVS2PstBU4kx1DI
IOI0D7ajr33iAJjzgSY3tl183nXNcxQ6L/CVE9u8zai+G7y4xe6fH1hrczjn
yjhY39ViDpvPYDQyO4FCygGXJ7BLiY6Ye8lQT59jP2BnH/AptL0I/T3h1YOd
VsjbNgOuvW3xDvvUanrRxksU+vFPtRvbetXthKZUCsmlaXRg/xJMTu5Op5Dg
Gbc67KSutlOHrlHowZ6bD7EV07gDRTOgvo79qsG2VDi03eo6haqc86uwM/Xs
BTtuUKj/q34ZtomHdHRTHoWu1WzNw36nZnfILR/qh+djDrbfj0Q37gIKvS8M
z56PN4LT2LAQ5knXw0zskeTBfw+KKVRPhVzFTqwrOnLvNoVUVmdcmH8+4zHu
fAfOj29PEvYmDQX3xWUUKlKUSsSeybm6w+Mu7L+zKB7bOTZ+jUQF1PPhmbPY
LBu/1+E18H602QnswZah+lcPKGTlYXhsPp71TiVELczvJ5vDsTlld0T21cP8
LQ0Lxe4aWbvWuBnqsc4/YH7/J39znmkBGwz5ze9PvKWr+QmFnE09fLEXGTmG
bG2H8xI+7TMf75Xoyp2dFOLbJ++OLUztjLn4Avqbv88Vu79x5e7XXRRalZC9
H/vYxO05+9eQb3tjZ+yKLe83Or+jkP/sf3uwvYyOz67opZC7zI3d2Cs3ypW/
7KNQcHm0HfZJDU/1LZ8p5KKWswtbgxAY5him0FW9tzvn97/mZnb1CIXShJV2
YJut+ilJTlBIezOXxXy+9q2/cX+SQmu252/DFr9+ao0JG/Kltnfr/PuySzUd
52DeK8xswb6TlYGC/8F9J/PMBJtOvqxkwsVC2Te6jbFzf2z/0sDDQtakhNF8
fnbyFxgtZKEBViTCDrz92OsRPwtlPRehsd8IRaggQRbyi2/eiN1xUKCvcBkL
XZJz0Mdubk1LEVnOQtcYVz1spbv+fbJSLJTPMaSDHZ2+WZWUYyHekBLt+Xwr
6hXmK7FQ6YNULexrxWrKcuospGRepYmtHMAldWotC/17xTvvMs23Qh+1WShq
9vC6+fjPzKQN6rOQZDD/vNO6l8sPIxZq9rylMX8+TVZ9dptZSKLZad6v7yWk
t2xjwX0tM29H1rLxdztYqMV3bC32QHGK4ZgNC3maNs/by+0337ADC4X+yJ33
mJRb50cnFhrbETfvzOAv7VvcWWhFVfC8d7b5tNz0YaHGq87z9rmpbV/pz0Jb
llnNOyqJ62t9CAuVy2yet5HpqRDnoyzEsU1/3vP/7jvJQuJXNOb9f1/Xpek=

      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4V08XAHBbtoRkq+xJRXTvlyyl7qgoRSJKUiRLyFaWrCGRECJSKkoI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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xc8Vt8fAHCb+kqoUEnIKMq498lK3dMyQiKVSJGtZCQkJGRkRFlZEUk0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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xc4lt8bAHAro68kRUJGIamsnudF0XNIysiuJLNsGZWQEJKMSkSLCkmy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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4Vd/XAHBTooRSkmQoJBWSzrlCZ6eQItEkVAoZylAJCUkiU5nJFPKT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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2XdYjt8bAPCWxDdFlBWKSgPtep639BxFGRkNpCUtDS0kWpK0tCftSFEa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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xc8l98XAHArSUJCJWUmqSTKeJ5P3ZtEQ4MWShSysiKbrMjeDSOjqIzI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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwl2Xk4VV0XAHBToldooIlQyFCIQjrn7t1ASIlUkqJQqKTITJKQVISMlSlk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